/*
 * Decompiled with CFR 0.152.
 */
package com.github.ideauniverse.pagination;

import com.github.ideauniverse.pagination.Pagination;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class PaginationInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        Pagination pagination;
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        MetaObject metaObject = MetaObject.forObject((Object)statementHandler, (ObjectFactory)SystemMetaObject.DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)SystemMetaObject.DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)new DefaultReflectorFactory());
        BoundSql boundSql = statementHandler.getBoundSql();
        Map parameter = (Map)boundSql.getParameterObject();
        if (parameter != null && parameter.containsKey("pagination") && (pagination = (Pagination)parameter.get("pagination")) != null) {
            String sql = boundSql.getSql();
            Connection connection = (Connection)invocation.getArgs()[0];
            String keyColumn = pagination.getKeyColumn();
            String countSql = "";
            String paginationSql = "";
            if (keyColumn == null) {
                countSql = "select count(*) from (" + sql + ") t";
                paginationSql = sql + " limit " + pagination.getStart() + ", " + pagination.getSize();
            } else {
                countSql = "select count(total) from (select count(*) total from (" + sql.replace(pagination.getLimitTag(), "") + ") t group by t." + keyColumn + ") t1";
                paginationSql = sql.replace(pagination.getLimitTag(), " limit " + pagination.getStart() + ", " + pagination.getSize());
            }
            PreparedStatement countStatement = connection.prepareStatement(countSql);
            ParameterHandler parameterHandler = (ParameterHandler)metaObject.getValue("delegate.parameterHandler");
            parameterHandler.setParameters(countStatement);
            ResultSet rs = countStatement.executeQuery();
            if (rs.next()) {
                pagination.setTotal(rs.getInt(1));
            }
            metaObject.setValue("delegate.boundSql.sql", (Object)paginationSql);
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

