/*
 * Decompiled with CFR 0.152.
 */
package com.lq;

import com.lq.entity.JdbcConfigEntity;
import com.lq.entity.TableInfo;
import com.lq.interceptor.MapperJavaInterceptor;
import com.lq.interceptor.MapperXmlInterceptor;
import com.lq.interceptor.MybatisInterceptor;
import com.lq.interceptor.ServiceJavaInterceptor;
import com.lq.task.CreateApplicationXmlTask;
import com.lq.task.CreatePomXmlTask;
import com.lq.task.CreateTemplateTask;
import com.lq.task.mybatis.CreateControllerTask;
import com.lq.task.mybatis.CreateJavaBeanTask;
import com.lq.task.mybatis.CreateMapperTask;
import com.lq.task.mybatis.CreateMapperXmlTask;
import com.lq.task.mybatis.CreateRedisConfigTask;
import com.lq.task.mybatis.CreateServiceTask;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class SpringBootCli {
    private JdbcConfigEntity jdbcConfigEntity;
    private String springBootVersion;
    private String mybatisVersion;
    private String mysqlConnectorVersion;
    private String druidVersion;
    private String fastJsonVersion;
    private String filterTableNameStr;
    private boolean generateController;
    private boolean useRedis;
    private boolean forceCover;
    private String projectPath;
    private String packageName;
    private String rootPackagePath;

    public SpringBootCli(Builder builder) {
        this.jdbcConfigEntity = builder.jdbcConfigEntity;
        this.springBootVersion = builder.springBootVersion;
        this.mybatisVersion = builder.mybatisVersion;
        this.mysqlConnectorVersion = builder.mysqlConnectorVersion;
        this.druidVersion = builder.druidVersion;
        this.fastJsonVersion = builder.fastJsonVersion;
        this.filterTableNameStr = builder.filterTableNameStr;
        this.generateController = builder.generateController;
        this.useRedis = builder.useRedis;
        this.forceCover = builder.forceCover;
        String path = new File(builder.aClass.getResource("").getPath()).getPath();
        this.projectPath = path.substring(0, path.indexOf(File.separator + "target" + File.separator));
        this.packageName = builder.aClass.getPackage().getName();
        String filePath = this.projectPath + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + new File(builder.aClass.getName()).getPath().replace(".", File.separator) + ".java";
        this.rootPackagePath = filePath.replace(builder.aClass.getSimpleName() + ".java", "");
    }

    public void initSpringBoot(String ... filterTableNames) throws Exception {
        new CreatePomXmlTask(this).execute();
        new CreateApplicationXmlTask(this).execute();
        new CreateTemplateTask(this).execute();
        this.createMybatis((List<MybatisInterceptor>)null, filterTableNames);
    }

    public void createMybatis(String ... filterTableNames) throws Exception {
        this.createMybatis((List<MybatisInterceptor>)null, filterTableNames);
    }

    public void createMybatis(List<MybatisInterceptor> mybatisInterceptors, String ... filterTableNames) throws Exception {
        Object tableInfos = new CreateJavaBeanTask(this, filterTableNames).execute();
        Optional.ofNullable(mybatisInterceptors).orElse(Collections.emptyList()).stream().filter(mybatisInterceptor -> mybatisInterceptor instanceof MapperJavaInterceptor).findFirst().ifPresent(arg_0 -> this.lambda$createMybatis$1((List)tableInfos, arg_0));
        new CreateMapperTask(this, (List<TableInfo>)tableInfos).execute();
        Optional.ofNullable(mybatisInterceptors).orElse(Collections.emptyList()).stream().filter(mybatisInterceptor -> mybatisInterceptor instanceof MapperXmlInterceptor).findFirst().ifPresent(arg_0 -> this.lambda$createMybatis$3((List)tableInfos, arg_0));
        new CreateMapperXmlTask(this, (List<TableInfo>)tableInfos).execute();
        Optional.ofNullable(mybatisInterceptors).orElse(Collections.emptyList()).stream().filter(mybatisInterceptor -> mybatisInterceptor instanceof ServiceJavaInterceptor).findFirst().ifPresent(arg_0 -> this.lambda$createMybatis$5((List)tableInfos, arg_0));
        new CreateServiceTask(this, (List<TableInfo>)tableInfos).execute();
        if (this.useRedis) {
            new CreateRedisConfigTask(this, (List<TableInfo>)tableInfos).execute();
        }
        if (this.generateController) {
            new CreateControllerTask(this, (List<TableInfo>)tableInfos).execute();
        }
    }

    public JdbcConfigEntity getJdbcConfigEntity() {
        return this.jdbcConfigEntity;
    }

    public String getSpringBootVersion() {
        return this.springBootVersion;
    }

    public String getMybatisVersion() {
        return this.mybatisVersion;
    }

    public String getMysqlConnectorVersion() {
        return this.mysqlConnectorVersion;
    }

    public String getDruidVersion() {
        return this.druidVersion;
    }

    public String getFastJsonVersion() {
        return this.fastJsonVersion;
    }

    public String getFilterTableNameStr() {
        return this.filterTableNameStr;
    }

    public boolean isGenerateController() {
        return this.generateController;
    }

    public boolean isUseRedis() {
        return this.useRedis;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getRootPackagePath() {
        return this.rootPackagePath;
    }

    public boolean isForceCover() {
        return this.forceCover;
    }

    public void setGenerateController(boolean generateController) {
        this.generateController = generateController;
    }

    public void setUseRedis(boolean useRedis) {
        this.useRedis = useRedis;
    }

    public void setForceCover(boolean forceCover) {
        this.forceCover = forceCover;
    }

    private /* synthetic */ void lambda$createMybatis$5(List tableInfos, MybatisInterceptor serviceJavaInterceptor) {
        serviceJavaInterceptor.handle(this, tableInfos);
    }

    private /* synthetic */ void lambda$createMybatis$3(List tableInfos, MybatisInterceptor mapperXmlInterceptor) {
        mapperXmlInterceptor.handle(this, tableInfos);
    }

    private /* synthetic */ void lambda$createMybatis$1(List tableInfos, MybatisInterceptor mapperJavaInterceptor) {
        mapperJavaInterceptor.handle(this, tableInfos);
    }

    public static class Builder {
        private Class<?> aClass;
        private JdbcConfigEntity jdbcConfigEntity;
        private String springBootVersion = "2.2.4.RELEASE";
        private String mybatisVersion = "2.1.2";
        private String mysqlConnectorVersion = "5.1.49";
        private String druidVersion = "1.1.22";
        private String fastJsonVersion = "1.2.47";
        private String filterTableNameStr;
        private boolean generateController;
        private boolean useRedis;
        private boolean forceCover;

        public Builder(Class<?> aClass, JdbcConfigEntity jdbcConfigEntity) {
            this.jdbcConfigEntity = jdbcConfigEntity;
            this.aClass = aClass;
        }

        public Builder springBootVersion(String springBootVersion) {
            this.springBootVersion = springBootVersion;
            return this;
        }

        public Builder mybatisVersion(String mybatisVersion) {
            this.mybatisVersion = mybatisVersion;
            return this;
        }

        public Builder mysqlConnectorVersion(String mysqlConnectorVersion) {
            this.mysqlConnectorVersion = mysqlConnectorVersion;
            return this;
        }

        public Builder druidVersion(String druidVersion) {
            this.druidVersion = druidVersion;
            return this;
        }

        public Builder fastJsonVersion(String fastJsonVersion) {
            this.fastJsonVersion = fastJsonVersion;
            return this;
        }

        public Builder generateController(boolean generateController) {
            this.generateController = generateController;
            return this;
        }

        public Builder useRedis(boolean useRedis) {
            this.useRedis = useRedis;
            return this;
        }

        public Builder setFilterTableNameStr(String filterTableNameStr) {
            this.filterTableNameStr = filterTableNameStr;
            return this;
        }

        public Builder setForceCover(boolean forceCover) {
            this.forceCover = forceCover;
            return this;
        }

        public SpringBootCli build() {
            return new SpringBootCli(this);
        }
    }
}

