/*
 * Decompiled with CFR 0.152.
 */
package com.lq.task;

import com.lq.SpringBootCli;
import com.lq.util.FileUtil;
import java.io.File;
import java.io.IOException;

public final class CreateTemplateTask {
    private SpringBootCli springBootCli;

    public CreateTemplateTask(SpringBootCli springBootCli) {
        this.springBootCli = springBootCli;
    }

    public void execute() throws IOException {
        this.createLog4j();
        this.createSpringBootApplication();
        this.createCorsConfigClass();
        this.createGlobExceptionHandler();
        this.createWebCommentResponse();
    }

    private void createSpringBootApplication() throws IOException {
        File file = new File(this.springBootCli.getRootPackagePath() + "Application.java");
        if (!file.exists() && file.createNewFile()) {
            String sb = "package " + this.springBootCli.getPackageName() + ";\n\nimport org.mybatis.spring.annotation.MapperScan;\nimport org.springframework.boot.SpringApplication;\nimport org.springframework.boot.autoconfigure.SpringBootApplication;\n\n";
            sb = sb + "@MapperScan(\"" + this.springBootCli.getPackageName() + ".mapper\")\n";
            sb = sb + "@SpringBootApplication\npublic class Application {\n\n\tpublic static void main(String[] args){\n\t\tSpringApplication.run(Application.class, args);\n\t}\n}";
            FileUtil.createWriteFile(file, sb);
        }
    }

    private void createCorsConfigClass() throws IOException {
        String configDirPath = this.springBootCli.getRootPackagePath() + "config" + File.separator;
        File configDir = new File(configDirPath);
        if (!configDir.exists() && !configDir.mkdir()) {
            return;
        }
        File file = new File(configDirPath + "CorsConfig.java");
        if (!file.exists() && file.createNewFile()) {
            String corsConfig = "package " + this.springBootCli.getPackageName() + ".config;\n\nimport org.springframework.context.annotation.Bean;\nimport org.springframework.context.annotation.Configuration;\nimport org.springframework.web.cors.CorsConfiguration;\nimport org.springframework.web.cors.UrlBasedCorsConfigurationSource;\nimport org.springframework.web.filter.CorsFilter;\n\n@Configuration\npublic class CorsConfig {\n\n\tprivate CorsConfiguration buildConfig() {\n\t\tCorsConfiguration corsConfiguration = new CorsConfiguration();\n\t\tcorsConfiguration.addAllowedOrigin(\"*\");\n\t\tcorsConfiguration.addAllowedHeader(\"*\");\n\t\tcorsConfiguration.addAllowedMethod(\"*\");\n\t\treturn corsConfiguration;\n\t}\n\n\t@Bean\n\tpublic CorsFilter corsFilter() {\n\t\tUrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();\n\t\tsource.registerCorsConfiguration(\"/**\", buildConfig());\n\t\treturn new CorsFilter(source);\n\t}\n\n}";
            FileUtil.createWriteFile(file, corsConfig);
        }
    }

    private void createGlobExceptionHandler() throws IOException {
        String exceptionDirPath = this.springBootCli.getRootPackagePath() + "exception" + File.separator;
        File exceptionDir = new File(exceptionDirPath);
        if (!exceptionDir.exists() && !exceptionDir.mkdir()) {
            return;
        }
        File globExceptionHandlerFile = new File(exceptionDirPath + "GlobExceptionHandler.java");
        if (!globExceptionHandlerFile.exists() && globExceptionHandlerFile.createNewFile()) {
            String globExceptionHandler = "package " + this.springBootCli.getPackageName() + ".exception;\n\n";
            globExceptionHandler = globExceptionHandler + "import com.alibaba.fastjson.support.spring.FastJsonJsonView;\nimport org.springframework.stereotype.Component;\nimport org.springframework.web.servlet.HandlerExceptionResolver;\nimport org.springframework.web.servlet.ModelAndView;\n\nimport javax.servlet.http.HttpServletRequest;\nimport javax.servlet.http.HttpServletResponse;\nimport java.util.HashMap;\nimport java.util.Map;\n\n@Component\npublic class GlobExceptionHandler implements HandlerExceptionResolver {\n\n    @Override\n    public ModelAndView resolveException(HttpServletRequest httpServletRequest, HttpServletResponse response, Object handler, Exception ex) {\n        ModelAndView mv = new ModelAndView();\n        FastJsonJsonView view = new FastJsonJsonView();\n        Map<String, Object> attributes = new HashMap<>();\n        attributes.put(\"data\", null);\n        attributes.put(\"errorInfo\", ex.getMessage());\n        attributes.put(\"status\", 240);\n        view.setAttributesMap(attributes);\n        mv.setView(view);\n        return mv;\n    }\n\n}\n";
            FileUtil.createWriteFile(globExceptionHandlerFile, globExceptionHandler);
        }
    }

    private void createWebCommentResponse() throws IOException {
        File webUtilFile;
        File jacksonUtilFile;
        File commentPageResponseFile;
        String utilDirPath = this.springBootCli.getRootPackagePath() + "util" + File.separator;
        File utilDir = new File(utilDirPath);
        if (!utilDir.exists() && !utilDir.mkdir()) {
            return;
        }
        File commentResponseFile = new File(utilDirPath + "CommentResponse.java");
        if (!commentResponseFile.exists()) {
            if (!commentResponseFile.createNewFile()) {
                return;
            }
            String commentResponse = "package " + this.springBootCli.getPackageName() + ".util;\n\n";
            commentResponse = commentResponse + "import java.net.HttpURLConnection;\n\npublic class CommentResponse<T> {\n\n    private static final String SUCCESS_MSG = \"success\";\n    static final String FAIL_MSG = \"fail\";\n    static final int FAIL_CODE = 240;\n    private static final CommentResponse FAIL_COMMENT_RESPONSE = new CommentResponse<>(FAIL_CODE, null, FAIL_MSG);\n    private static final CommentResponse SUCCESS_COMMENT_RESPONSE = new CommentResponse<>(HttpURLConnection.HTTP_OK,SUCCESS_MSG,null );\n\n    private int status;\n\n    private T data;\n\n    private String errorInfo;\n\n    CommentResponse(int status, T data, String errorInfo) {\n        this.status = status;\n        this.data = data;\n        this.errorInfo = errorInfo;\n    }\n\n    public int getStatus() {\n        return status;\n    }\n\n    public void setStatus(int status) {\n        this.status = status;\n    }\n\n    public T getData() {\n        return data;\n    }\n\n    public void setData(T data) {\n        this.data = data;\n    }\n\n    public String getErrorInfo() {\n        return errorInfo;\n    }\n\n    public void setErrorInfo(String errorInfo) {\n        this.errorInfo = errorInfo;\n    }\n\n    public static <T> CommentResponse<T> success(T t) {\n        return new CommentResponse<>(HttpURLConnection.HTTP_OK, t, null);\n    }\n\n    public static CommentResponse success() {\n        return SUCCESS_COMMENT_RESPONSE;\n    }\n\n    public static CommentResponse fail() {\n        return FAIL_COMMENT_RESPONSE;\n    }\n\n    public static <T> CommentResponse<T> fail(String msg) {\n        return new CommentResponse<>(FAIL_CODE, null, msg);\n    }\n}";
            FileUtil.createWriteFile(commentResponseFile, commentResponse);
        }
        if (!(commentPageResponseFile = new File(utilDirPath + "CommentPageResponse.java")).exists() && commentPageResponseFile.createNewFile()) {
            String commentPageResponse = "package " + this.springBootCli.getPackageName() + ".util;\n\n";
            commentPageResponse = commentPageResponse + "import java.net.HttpURLConnection;\n\npublic class CommentPageResponse<T> extends CommentResponse<T> {\n\n    private static final CommentPageResponse FAIL_COMMENT_RESPONSE =  new CommentPageResponse<>(FAIL_CODE, null, FAIL_MSG);\n\n    private Integer totalPage;\n    private Integer totalSize;\n    private Integer page;\n    private Integer pageSize;\n\n    private CommentPageResponse(int status, T data, String errorInfo) {\n        super(status, data, errorInfo);\n    }\n\n    private CommentPageResponse(int status, T data, String errorInfo, Integer totalPage, Integer totalSize, Integer page, Integer pageSize) {\n        super(status, data, errorInfo);\n        this.totalPage = totalPage;\n        this.totalSize = totalSize;\n        this.page = page;\n        this.pageSize = pageSize;\n    }\n\n    public Integer getTotalPage() {\n        return totalPage;\n    }\n\n    public void setTotalPage(Integer totalPage) {\n        this.totalPage = totalPage;\n    }\n\n    public Integer getTotalSize() {\n        return totalSize;\n    }\n\n    public void setTotalSize(Integer totalSize) {\n        this.totalSize = totalSize;\n    }\n\n    public Integer getPage() {\n        return page;\n    }\n\n    public void setPage(Integer page) {\n        this.page = page;\n    }\n\n    public Integer getPageSize() {\n        return pageSize;\n    }\n\n    public void setPageSize(Integer pageSize) {\n        this.pageSize = pageSize;\n    }\n\n    public static <T> CommentPageResponse<T> success(T t,Integer totalPage, Integer totalSize, Integer page, Integer pageSize) {\n        return new CommentPageResponse<>(HttpURLConnection.HTTP_OK, t, null,totalPage,totalSize,page,pageSize);\n    }\n\n    public static <T> CommentPageResponse<T> fail(String msg) {\n        return new CommentPageResponse<>(FAIL_CODE, null, msg);\n    }\n\n    public static <T> CommentPageResponse<T> selfFail() {\n        return  FAIL_COMMENT_RESPONSE;\n    }\n}";
            FileUtil.createWriteFile(commentPageResponseFile, commentPageResponse);
        }
        if (!(jacksonUtilFile = new File(utilDirPath + "JacksonUtil.java")).exists() && jacksonUtilFile.createNewFile()) {
            String jacksonUtil = "package " + this.springBootCli.getPackageName() + ".util;\n\n";
            jacksonUtil = jacksonUtil + "import com.fasterxml.jackson.core.JsonProcessingException;\nimport com.fasterxml.jackson.databind.JavaType;\nimport com.fasterxml.jackson.databind.ObjectMapper;\nimport javax.annotation.Resource;\nimport org.springframework.stereotype.Component;\n\nimport java.util.List;\n\n@Component\npublic class JacksonUtil{\n\n    @Resource\n    private ObjectMapper objectMapper;\n\n    public String objectToJson(Object data) {\n        try {\n            return objectMapper.writeValueAsString(data);\n        } catch (JsonProcessingException e) {\n            System.err.println(e.toString());\n        }\n        return null;\n    }\n\n    public <T> T jsonToPojo(String jsonData, Class<T> beanType) {\n        try {\n            return objectMapper.readValue(jsonData, beanType);\n        } catch (Exception e) {\n            System.err.println(e.toString());\n        }\n        return null;\n    }\n\n    public <T> List<T> jsonToList(String jsonData, Class<T> beanType) {\n        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(List.class, beanType);\n        try {\n            return objectMapper.readValue(jsonData, javaType);\n        } catch (Exception e) {\n            System.err.println(e.toString());\n        }\n        return null;\n    }\n\n}\n";
            FileUtil.createWriteFile(jacksonUtilFile, jacksonUtil);
        }
        if (!(webUtilFile = new File(utilDirPath + "WebUtil.java")).exists() && webUtilFile.createNewFile()) {
            String webUtil = "package " + this.springBootCli.getPackageName() + ".util;\n\n";
            webUtil = webUtil + "import org.springframework.validation.BindingResult;\nimport org.springframework.validation.FieldError;\nimport java.time.format.DateTimeFormatter;\n\npublic class WebUtil {\n\n    private WebUtil(){}\n\n    public static final DateTimeFormatter DTF = DateTimeFormatter.ofPattern(\"yyyy-MM-dd HH:mm:ss\");\n\n    public static CommentResponse bindingResult(BindingResult result){\n        StringBuilder sb = new StringBuilder();\n        for (FieldError fieldError : result.getFieldErrors()) {\n            sb.append(fieldError.getDefaultMessage()).append(\";\");\n        }\n        String errorInfo = sb.toString();\n        return CommentResponse.fail(errorInfo);\n    }\n\n}";
            FileUtil.createWriteFile(webUtilFile, webUtil);
        }
    }

    private void createLog4j() throws IOException {
        String log4j2Path = this.springBootCli.getProjectPath() + File.separator + "src" + File.separator + "main" + File.separator + "resources" + File.separator + "log4j2-spring.xml";
        File log4j2File = new File(log4j2Path);
        if (!log4j2File.exists() && log4j2File.createNewFile()) {
            String log4j = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<configuration status=\"warn\" monitorInterval=\"30\">\n    <Properties>\n        <property name=\"LOG_PATTERN\" value=\"%date{HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n\" />\n        <property name=\"FILE_PATH\" value=\"log\" />\n    </Properties>\n\n    <appenders>\n        <console name=\"Console\" target=\"SYSTEM_OUT\">\n            <PatternLayout pattern=\"${LOG_PATTERN}\"/>\n            <ThresholdFilter level=\"info\" onMatch=\"ACCEPT\" onMismatch=\"DENY\"/>\n            <PatternLayout pattern=\"${LOG_PATTERN}\"/>\n        </console>\n\n        <RollingFile name=\"RollingFileInfo\" fileName=\"${sys:user.home}/logs/info.log\"\n                     filePattern=\"${sys:user.home}/logs/$${date:yyyy-MM}/info-%d{yyyy-MM-dd}-%i.log\">\n            <Filters>\n                <ThresholdFilter level=\"INFO\" onMatch=\"ACCEPT\" onMismatch=\"DENY\"/>\n                <ThresholdFilter level=\"WARN\" onMatch=\"DENY\" onMismatch=\"NEUTRAL\"/>\n            </Filters>\n            <PatternLayout pattern=\"${LOG_PATTERN}\"/>\n            <Policies>\n                <TimeBasedTriggeringPolicy/>\n                <SizeBasedTriggeringPolicy size=\"50 MB\"/>\n            </Policies>\n        </RollingFile>\n\n        <RollingFile name=\"RollingFileWarn\" fileName=\"${sys:user.home}/logs/warn.log\"\n                     filePattern=\"${sys:user.home}/logs/$${date:yyyy-MM}/warn-%d{yyyy-MM-dd}-%i.log\">\n            <Filters>\n                <ThresholdFilter level=\"WARN\" onMatch=\"ACCEPT\" onMismatch=\"DENY\"/>\n                <ThresholdFilter level=\"ERROR\" onMatch=\"DENY\" onMismatch=\"NEUTRAL\"/>\n            </Filters>\n            <PatternLayout pattern=\"${LOG_PATTERN}\"/>\n            <Policies>\n                <TimeBasedTriggeringPolicy/>\n                <SizeBasedTriggeringPolicy size=\"50 MB\"/>\n            </Policies>\n            <DefaultRolloverStrategy max=\"20\"/>\n        </RollingFile>\n\n        <RollingFile name=\"RollingFileError\" fileName=\"${sys:user.home}/logs/error.log\"\n                     filePattern=\"${sys:user.home}/logs/$${date:yyyy-MM}/error-%d{yyyy-MM-dd}-%i.log\">\n            <ThresholdFilter level=\"ERROR\"/>\n            <PatternLayout pattern=\"${LOG_PATTERN}\"/>\n            <Policies>\n                <TimeBasedTriggeringPolicy/>\n                <SizeBasedTriggeringPolicy size=\"50 MB\"/>\n            </Policies>\n        </RollingFile>\n    </appenders>\n\n\n    <loggers>\n        <logger name=\"org.springframework\" level=\"INFO\" additivity=\"false\">\n        </logger>\n        <logger name=\"org.hibernate\" level=\"INFO\" additivity=\"false\">\n        </logger>\n        <logger name=\"org.thymeleaf\" level=\"TRACE\" additivity=\"false\">\n        </logger>\n        <root level=\"all\">\n            <appender-ref ref=\"Console\"/>\n            <appender-ref ref=\"RollingFileInfo\"/>\n            <appender-ref ref=\"RollingFileWarn\"/>\n            <appender-ref ref=\"RollingFileError\"/>\n        </root>\n    </loggers>\n\n\n</configuration>";
            FileUtil.createWriteFile(log4j2File, log4j);
        }
    }
}

