/*
 * Decompiled with CFR 0.152.
 */
package com.lq.task.mybatis;

import com.lq.SpringBootCli;
import com.lq.entity.TableFiledEntity;
import com.lq.entity.TableInfo;
import com.lq.task.mybatis.BaseTask;
import com.lq.util.FileUtil;
import com.lq.util.StringUtil;
import java.io.File;
import java.util.List;

public final class CreateMapperXmlTask
extends BaseTask<Boolean> {
    private List<TableInfo> tableInfos;

    public CreateMapperXmlTask(SpringBootCli springBootCli, List<TableInfo> tableInfos) {
        super(springBootCli);
        this.tableInfos = tableInfos;
    }

    @Override
    public Boolean execute() throws Exception {
        boolean mkdirs;
        String mapperResourcesPath = this.springBootCli.getProjectPath() + File.separator + "src" + File.separator + "main" + File.separator + this.getPackageName();
        File mapperDir = new File(mapperResourcesPath);
        if (!mapperDir.exists() && !(mkdirs = mapperDir.mkdirs())) {
            return false;
        }
        for (TableInfo tableInfo : this.tableInfos) {
            String mapperXml = this.tableInfo2MapperXml(tableInfo);
            File file = new File(mapperResourcesPath + tableInfo.getTransformTableInfo().getTableName() + "Mapper.xml");
            if (file.exists() && !this.springBootCli.isForceCover()) continue;
            FileUtil.createWriteFile(file, mapperXml);
        }
        return true;
    }

    @Override
    String getPackageName() {
        return "resources" + File.separator + "mapper" + File.separator;
    }

    /*
     * WARNING - void declaration
     */
    private String tableInfo2MapperXml(TableInfo tableInfo) {
        void var8_11;
        TableInfo transformTableInfo = tableInfo.getTransformTableInfo();
        String mapperXmlHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!DOCTYPE mapper\n        PUBLIC \"-//mybatis.org//DTD Mapper 3.0//EN\"\n        \"http://mybatis.org/dtd/mybatis-3-mapper.dtd\">\n<mapper namespace=\"";
        StringBuilder sb = new StringBuilder(mapperXmlHeader);
        sb.append(this.springBootCli.getPackageName()).append(".mapper.").append(transformTableInfo.getTableName()).append("Mapper").append("\">\n\n").append("\t<insert id=\"insert").append(transformTableInfo.getTableName()).append("\">\n\t\tinsert into ").append(tableInfo.getTableName()).append("(");
        List<TableFiledEntity> filedEntities = tableInfo.getFiledEntities();
        StringBuilder sqlField = new StringBuilder();
        for (TableFiledEntity tableFiledEntity : filedEntities) {
            sqlField.append(tableFiledEntity.getName()).append(",");
        }
        sb.append((CharSequence)sqlField).deleteCharAt(sb.length() - 1).append(")\n\t\tvalues(");
        List<TableFiledEntity> filedEntities2 = transformTableInfo.getFiledEntities();
        for (TableFiledEntity filedEntity : filedEntities2) {
            String fieldName = StringUtil.firstIsUpperCase(filedEntity.getName()) ? StringUtil.firstToLowerCase(filedEntity.getName()) : filedEntity.getName();
            sb.append("#{").append(fieldName).append("},");
        }
        sb.deleteCharAt(sb.length() - 1).append(")\n\t</insert>");
        boolean bl = false;
        while (var8_11 < filedEntities2.size()) {
            TableFiledEntity priKey = filedEntities2.get((int)var8_11);
            if (priKey.getKey().equals("PRI")) {
                int x;
                sb.append("\n\n\t <resultMap id=\"BaseResultMap\" type=\"").append(this.springBootCli.getPackageName()).append(".entity.").append(transformTableInfo.getTableName()).append("\">\n\t\t<id column=\"").append(filedEntities.get((int)var8_11).getName()).append("\" property=\"").append(priKey.getName()).append("\"/>");
                for (x = 1; x < filedEntities.size(); ++x) {
                    sb.append("\n\t\t<result column=\"").append(filedEntities.get(x).getName()).append("\" property=\"").append(filedEntities2.get(x).getName()).append("\"/>");
                }
                sb.append("\n\t</resultMap>").append("\n\n\t<select id=\"query").append(transformTableInfo.getTableName()).append("By").append(StringUtil.firstToUpperCase(priKey.getName())).append("\" resultMap=\"BaseResultMap\">\n\t\tselect ").append((CharSequence)sqlField.deleteCharAt(sqlField.length() - 1)).append("\n\t\tfrom ").append(tableInfo.getTableName()).append("\n\t\twhere ").append(filedEntities.get((int)var8_11).getName()).append("=#{").append(priKey.getName()).append("}\n\t</select>\n\n\t<delete id=\"delete").append(transformTableInfo.getTableName()).append("By").append(StringUtil.firstToUpperCase(priKey.getName())).append("\">\n\t\tdelete from ").append(tableInfo.getTableName()).append(" where ").append(filedEntities.get((int)var8_11).getName()).append("=#{").append(priKey.getName()).append("}\n\t</delete>\n\n\t<update id=\"update").append(transformTableInfo.getTableName()).append("\">\n\t\tupdate ").append(tableInfo.getTableName()).append("\n\t\t<trim prefix=\"set\" suffixOverrides=\",\"> \n\t\t\t");
                for (x = 0; x < filedEntities2.size(); ++x) {
                    TableFiledEntity filedEntity = filedEntities.get(x);
                    TableFiledEntity filedEntity1 = filedEntities2.get(x);
                    if (filedEntity.getName().equals(priKey.getName())) continue;
                    if (filedEntity1.getType().equals("String")) {
                        sb.append("<if test=\"").append(filedEntity1.getName()).append(" != null and  ").append(filedEntity1.getName()).append(" != ''\">").append(filedEntity.getName()).append("=#{").append(filedEntity1.getName());
                    } else {
                        sb.append("<if test=\" ").append(filedEntity1.getName()).append(" != null\">").append(filedEntity.getName()).append("=#{").append(filedEntity1.getName());
                    }
                    if (x == filedEntities2.size() - 1) {
                        sb.append("},</if>\n\t\t");
                        continue;
                    }
                    sb.append("},</if>\n\t\t\t");
                }
                sb.append("</trim>").append("\n\t\twhere ").append(filedEntities.get((int)var8_11).getName()).append("=#{").append(priKey.getName()).append("}\n\t</update>");
                break;
            }
            ++var8_11;
        }
        sb.append("\n\n</mapper>");
        return sb.toString();
    }
}

