/*
 * Decompiled with CFR 0.152.
 */
package xdean.annotation.processor.toolkit;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.function.Function;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

public class ElementUtil {
    public static <T extends Annotation> TypeMirror getAnnotationClassValue(Elements elements, T anno, Function<T, Class<?>> func) {
        try {
            return elements.getTypeElement(func.apply(anno).getCanonicalName()).asType();
        }
        catch (MirroredTypeException e) {
            return e.getTypeMirror();
        }
    }

    public static Optional<AnnotationMirror> getAnnotationMirror(Element element, Class<? extends Annotation> annotationClass) {
        return ElementUtil.getAnnotationMirror(element, annotationClass.getCanonicalName());
    }

    public static Optional<AnnotationMirror> getAnnotationMirror(Element element, TypeMirror annotationType) {
        return ElementUtil.getAnnotationMirror(element, annotationType.toString());
    }

    public static Optional<AnnotationMirror> getAnnotationMirror(Element element, String annoClzCanonicalName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            TypeElement annotationTypeElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!annotationTypeElement.getQualifiedName().contentEquals(annoClzCanonicalName)) continue;
            return Optional.of(annotationMirror);
        }
        return Optional.empty();
    }
}

