/*
 * Decompiled with CFR 0.152.
 */
package xdean.annotation.processor.toolkit;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public interface ElementUtil {
    public static <T extends Annotation> TypeMirror getAnnotationClassValue(Elements elements, T anno, Function<T, Class<?>> func) {
        try {
            return elements.getTypeElement(func.apply(anno).getCanonicalName()).asType();
        }
        catch (MirroredTypeException e) {
            return e.getTypeMirror();
        }
    }

    public static <T extends Annotation> List<TypeMirror> getAnnotationClassArray(Elements elements, T anno, Function<T, Class<?>[]> func) {
        try {
            return Arrays.stream((Object[])func.apply(anno)).map(c -> elements.getTypeElement(c.getCanonicalName()).asType()).collect(Collectors.toList());
        }
        catch (MirroredTypesException e) {
            return e.getTypeMirrors();
        }
    }

    public static Optional<AnnotationMirror> getAnnotationMirror(Element element, Class<? extends Annotation> annotationClass) {
        return ElementUtil.getAnnotationMirror(element, annotationClass.getCanonicalName());
    }

    public static Optional<AnnotationMirror> getAnnotationMirror(Element element, TypeMirror annotationType) {
        return ElementUtil.getAnnotationMirror(element, annotationType.toString());
    }

    public static Optional<AnnotationMirror> getAnnotationMirror(Element element, String annoClzCanonicalName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            TypeElement annotationTypeElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!annotationTypeElement.getQualifiedName().contentEquals(annoClzCanonicalName)) continue;
            return Optional.of(annotationMirror);
        }
        return Optional.empty();
    }

    public static List<? extends AnnotationMirror> getInheritAnnotationMirrors(TypeElement element) {
        if (element.getKind() != ElementKind.CLASS || element.getSuperclass() instanceof NoType) {
            return element.getAnnotationMirrors();
        }
        TypeElement sup = (TypeElement)((DeclaredType)element.getSuperclass()).asElement();
        ArrayList<? extends AnnotationMirror> list = new ArrayList<AnnotationMirror>(element.getAnnotationMirrors());
        List collect = ElementUtil.getInheritAnnotationMirrors(sup).stream().filter(a -> ElementUtil.isInherit(a.getAnnotationType())).filter(a -> !list.stream().anyMatch(t -> Objects.equals(t.getAnnotationType(), a.getAnnotationType()))).collect(Collectors.toList());
        list.addAll(collect);
        return list;
    }

    public static boolean isInherit(DeclaredType annoType) {
        return ElementUtil.getAnnotationMirror(annoType.asElement(), Inherited.class).isPresent();
    }

    public static Stream<TypeElement> getAllSubClasses(Types types, RoundEnvironment env, TypeMirror type) {
        return env.getRootElements().stream().flatMap(e -> ElementUtil.getAllSubClasses(types, e, type));
    }

    public static Stream<TypeElement> getAllSubClasses(Types types, Element root, TypeMirror type) {
        List<ElementKind> list = Arrays.asList(ElementKind.CLASS, ElementKind.ENUM, ElementKind.INTERFACE);
        return Stream.concat(Stream.of(root).filter(e -> list.contains((Object)e.getKind())).map(e -> (TypeElement)e).filter(e -> types.isAssignable(types.erasure(e.asType()), type)), root.getEnclosedElements().stream().flatMap(e -> ElementUtil.getAllSubClasses(types, e, type)));
    }
}

