/*
 * Decompiled with CFR 0.152.
 */
package xdean.annotation.processor.toolkit;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import xdean.annotation.processor.toolkit.AssertException;
import xdean.annotation.processor.toolkit.CommonUtil;
import xdean.annotation.processor.toolkit.ElementUtil;
import xdean.annotation.processor.toolkit.annotation.SupportedAnnotation;
import xdean.annotation.processor.toolkit.annotation.SupportedAnnotations;

public abstract class XAbstractProcessor
extends AbstractProcessor
implements CommonUtil {
    protected Types types;
    protected Elements elements;
    protected Messager messager;
    protected Filer filer;
    protected boolean isDebug;
    private Log error;
    private Log warning;
    private Log debug;
    private Log noLog = new Log(Diagnostic.Kind.OTHER, false);

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.types = processingEnv.getTypeUtils();
        this.elements = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        this.isDebug = processingEnv.getOptions().containsKey("debug");
        this.error = new Log(Diagnostic.Kind.ERROR, true);
        this.warning = new Log(Diagnostic.Kind.WARNING, true);
        this.debug = new Log(Diagnostic.Kind.NOTE, this.isDebug);
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.handleAssert(() -> this.processActual(annotations, roundEnv));
        return false;
    }

    public abstract boolean processActual(Set<? extends TypeElement> var1, RoundEnvironment var2) throws AssertException;

    protected void handleAssert(Runnable task) {
        block2: {
            try {
                task.run();
            }
            catch (AssertException e) {
                if (e.getMessage() == null || e.getMessage().isEmpty()) break block2;
                this.error().log(e.getMessage());
            }
        }
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        SupportedAnnotations sas;
        HashSet<String> set = new HashSet<String>();
        SupportedAnnotationTypes sat = this.getClass().getAnnotation(SupportedAnnotationTypes.class);
        if (sat != null) {
            Arrays.stream(sat.value()).forEach(set::add);
        }
        if ((sas = this.getClass().getAnnotation(SupportedAnnotations.class)) == null) {
            SupportedAnnotation sa2 = this.getClass().getAnnotation(SupportedAnnotation.class);
            if (sa2 != null) {
                set.add(sa2.value().getCanonicalName());
            }
        } else {
            Arrays.stream(sas.value()).map(sa -> sa.value().getCanonicalName()).forEach(set::add);
        }
        if (set.isEmpty() && this.isInitialized()) {
            this.debug().log("No SupportedAnnotationTypes annotation found on " + this.getClass().getName() + ", returning an empty set.");
        }
        return Collections.unmodifiableSet(set);
    }

    protected <T> Assert<T> assertThat(T t, Predicate<T> b) {
        return new Assert<T>(t, b.test(t));
    }

    protected <T> Assert<T> assertThat(T t, boolean b) {
        return new Assert<T>(t, b);
    }

    protected Assert<Void> assertThat(boolean b) {
        return new Assert<Void>(b);
    }

    protected <T> Assert<T> assertType(Object o, Class<T> clz) {
        return new Assert<Object>(o, clz.isInstance(o));
    }

    protected <T> Assert<T> assertNonNull(T t) {
        return new Assert<T>(t, t != null);
    }

    protected <T> Assert<T> assertDo(Callable<T> task) {
        try {
            return new Assert<T>(task.call(), true);
        }
        catch (Exception e) {
            return new Assert(false);
        }
    }

    protected Assert<Void> assertDo(CommonUtil.ActionE0<?> task) {
        try {
            task.call();
            return new Assert<Object>(null, true);
        }
        catch (Exception e) {
            return new Assert<Void>(false);
        }
    }

    protected Log debug() {
        return this.isInitialized() ? this.debug : this.noLog;
    }

    protected Log warning() {
        return this.isInitialized() ? this.warning : this.noLog;
    }

    protected Log error() {
        return this.isInitialized() ? this.error : this.noLog;
    }

    protected class Log {
        Diagnostic.Kind kind;
        boolean enable;

        public Log(Diagnostic.Kind kind, boolean enable) {
            this.kind = kind;
            this.enable = enable;
        }

        public void log(String msg) {
            if (this.enable) {
                XAbstractProcessor.this.messager.printMessage(this.kind, msg);
            }
        }

        public void log(String msg, Element element) {
            if (this.enable) {
                XAbstractProcessor.this.messager.printMessage(this.kind, msg, element);
            }
        }

        public void log(String msg, Element element, Class<? extends Annotation> annotation) {
            if (this.enable) {
                Optional<AnnotationMirror> am = ElementUtil.getAnnotationMirror(element, annotation);
                if (am.isPresent()) {
                    this.log(msg, element, am.get());
                } else {
                    XAbstractProcessor.this.messager.printMessage(this.kind, msg, element);
                }
            }
        }

        public void log(String msg, Element element, AnnotationMirror annotation) {
            if (this.enable) {
                XAbstractProcessor.this.messager.printMessage(this.kind, msg, element, annotation);
            }
        }

        public void log(String msg, Element element, Class<? extends Annotation> annotation, AnnotationValue av) {
            if (this.enable) {
                Optional<AnnotationMirror> am = ElementUtil.getAnnotationMirror(element, annotation);
                if (am.isPresent()) {
                    this.log(msg, element, am.get(), av);
                } else {
                    XAbstractProcessor.this.messager.printMessage(this.kind, msg, element);
                }
            }
        }

        public void log(String msg, Element element, AnnotationMirror annotation, AnnotationValue av) {
            if (this.enable) {
                XAbstractProcessor.this.messager.printMessage(this.kind, msg, element, annotation, av);
            }
        }
    }

    protected static class Assert<T> {
        boolean fail;
        T value;

        public Assert(boolean assertion) {
            this(null, assertion);
        }

        public Assert(T value, boolean assertion) {
            this.value = value;
            this.fail = !assertion;
        }

        public T message(String msg) {
            if (this.fail) {
                throw new AssertException(msg);
            }
            return this.value;
        }

        public T todo(Runnable task) {
            if (this.fail) {
                task.run();
                throw new AssertException();
            }
            return this.value;
        }

        public T doNoThing() {
            return this.todo(() -> {});
        }
    }
}

