/*
 * Decompiled with CFR 0.152.
 */
package xdean.annotation.processor.toolkit.test;

import com.google.testing.compile.Compilation;
import com.google.testing.compile.Compiler;
import com.google.testing.compile.JavaFileObjects;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.tools.JavaFileObject;
import org.junit.Test;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.springframework.core.annotation.AnnotationUtils;
import xdean.annotation.processor.toolkit.CommonUtil;
import xdean.annotation.processor.toolkit.test.Compile;
import xdean.annotation.processor.toolkit.test.CompileTest;
import xdean.annotation.processor.toolkit.test.Compiled;

public class CompileTestRunner
extends BlockJUnit4ClassRunner {
    public CompileTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected void collectInitializationErrors(List<Throwable> errors) {
        super.collectInitializationErrors(errors);
        if (!CompileTest.class.isAssignableFrom(this.getTestClass().getJavaClass())) {
            errors.add(new Exception("CompileTestRunner must run with CompileTest"));
        }
    }

    protected void validateTestMethods(List<Throwable> errors) {
        this.validatePublicVoidNoArgMethods(Test.class, false, errors);
    }

    protected Statement methodInvoker(final FrameworkMethod method, Object test) {
        Class<?> paramType = method.getMethod().getParameterTypes()[0];
        final CompileTest ct = (CompileTest)test;
        if (paramType == RoundEnvironment.class) {
            ct.setMethod(method);
            return new Statement(){

                public void evaluate() throws Throwable {
                    Compile compile = (Compile)AnnotationUtils.getAnnotation((Method)method.getMethod(), Compile.class);
                    Class clz = CompileTestRunner.this.getTestClass().getJavaClass();
                    Compiler.javac().withProcessors(new Processor[]{ct}).compile((JavaFileObject[])Arrays.stream(compile.sources()).map(s -> clz.getResource((String)s)).map(u -> JavaFileObjects.forResource((URL)u)).toArray(JavaFileObject[]::new));
                    if (ct.getError() != null) {
                        throw ct.getError();
                    }
                }
            };
        }
        if (paramType == Compilation.class) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    Compiled compiled = (Compiled)AnnotationUtils.getAnnotation((Method)method.getMethod(), Compiled.class);
                    Class clz = CompileTestRunner.this.getTestClass().getJavaClass();
                    Compilation compilation = Compiler.javac().withProcessors((Processor[])Arrays.stream(compiled.processors()).map(c -> CommonUtil.uncheck(() -> (Processor)c.newInstance())).toArray(Processor[]::new)).withOptions((Object[])Arrays.stream(compiled.options()).toArray(Object[]::new)).compile((JavaFileObject[])Arrays.stream(compiled.sources()).map(s -> clz.getResource((String)s)).map(u -> JavaFileObjects.forResource((URL)u)).toArray(JavaFileObject[]::new));
                    method.invokeExplosively((Object)ct, new Object[]{compilation});
                }
            };
        }
        return super.methodInvoker(method, test);
    }

    protected void validatePublicVoidNoArgMethods(Class<? extends Annotation> annotation, boolean isStatic, List<Throwable> errors) {
        List methods = this.getTestClass().getAnnotatedMethods(annotation);
        for (FrameworkMethod method : methods) {
            method.validatePublicVoid(isStatic, errors);
            int pc = method.getMethod().getParameterCount();
            if (pc > 1) {
                errors.add(new Exception("Method " + method.getName() + "() should have 0 or 1 parameter"));
                continue;
            }
            if (pc == 1) {
                Class<?> paramType = method.getMethod().getParameterTypes()[0];
                if (paramType == RoundEnvironment.class) {
                    if (method.getMethod().isAnnotationPresent(Compile.class)) continue;
                    errors.add(new Exception("Method " + method.getName() + "() should annotated @Compile."));
                    continue;
                }
                if (paramType == Compilation.class) {
                    if (method.getMethod().isAnnotationPresent(Compiled.class)) continue;
                    errors.add(new Exception("Method " + method.getName() + "() should annotated @Compiled."));
                    continue;
                }
                errors.add(new Exception("Method " + method.getName() + "()'s parameter only can be RoundEnvironment or Compilation."));
                continue;
            }
            method.validatePublicVoidNoArg(isStatic, errors);
        }
    }
}

