/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.mp.config;

import com.binarywang.spring.starter.wxjava.mp.properties.WxMpProperties;
import java.util.HashMap;
import java.util.List;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import me.chanjar.weixin.mp.config.impl.WxMpDefaultConfigImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WxMpServiceAutoConfiguration {
    private final WxMpProperties properties;
    @Autowired
    private ApplicationContext ctx;

    @Bean
    @ConditionalOnMissingBean
    public WxMpService wxMpService() {
        List<WxMpProperties.MpConfig> configs = this.properties.getConfigs();
        if (configs == null) {
            throw new RuntimeException("\u5fc5\u987b\u6dfb\u52a0\u76f8\u5173\u914d\u7f6e\uff08wx.mp.configs\uff09\uff0c\u6ce8\u610f\u522b\u914d\u9519\u4e86\uff01");
        }
        WxMpServiceImpl service = new WxMpServiceImpl();
        HashMap<String, WxMpDefaultConfigImpl> configStorages = new HashMap<String, WxMpDefaultConfigImpl>();
        for (WxMpProperties.MpConfig config : configs) {
            WxMpDefaultConfigImpl configStorage = new WxMpDefaultConfigImpl();
            configStorage.setAppId(config.getAppId());
            configStorage.setSecret(config.getSecret());
            configStorage.setToken(config.getToken());
            configStorage.setAesKey(config.getAesKey());
            configStorages.put(config.getAppId(), configStorage);
        }
        service.setMultiConfigStorages(configStorages);
        return service;
    }

    @ConditionalOnBean(value={WxMpService.class})
    public Object registerWxMpSubService(WxMpService wxMpService) {
        ConfigurableListableBeanFactory factory = (ConfigurableListableBeanFactory)this.ctx.getAutowireCapableBeanFactory();
        factory.registerSingleton("wxMpKefuService", (Object)wxMpService.getKefuService());
        factory.registerSingleton("wxMpMaterialService", (Object)wxMpService.getMaterialService());
        factory.registerSingleton("wxMpMenuService", (Object)wxMpService.getMenuService());
        factory.registerSingleton("wxMpUserService", (Object)wxMpService.getUserService());
        factory.registerSingleton("wxMpUserTagService", (Object)wxMpService.getUserTagService());
        factory.registerSingleton("wxMpQrcodeService", (Object)wxMpService.getQrcodeService());
        factory.registerSingleton("wxMpCardService", (Object)wxMpService.getCardService());
        factory.registerSingleton("wxMpDataCubeService", (Object)wxMpService.getDataCubeService());
        factory.registerSingleton("wxMpUserBlacklistService", (Object)wxMpService.getBlackListService());
        factory.registerSingleton("wxMpStoreService", (Object)wxMpService.getStoreService());
        factory.registerSingleton("wxMpTemplateMsgService", (Object)wxMpService.getTemplateMsgService());
        factory.registerSingleton("wxMpSubscribeMsgService", (Object)wxMpService.getSubscribeMsgService());
        factory.registerSingleton("wxMpDeviceService", (Object)wxMpService.getDeviceService());
        factory.registerSingleton("wxMpShakeService", (Object)wxMpService.getShakeService());
        factory.registerSingleton("wxMpMemberCardService", (Object)wxMpService.getMemberCardService());
        factory.registerSingleton("wxMpMassMessageService", (Object)wxMpService.getMassMessageService());
        return Boolean.TRUE;
    }

    public WxMpServiceAutoConfiguration(WxMpProperties properties) {
        this.properties = properties;
    }
}

