/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.mp.config;

import com.binarywang.spring.starter.wxjava.mp.properties.RedisProperties;
import com.binarywang.spring.starter.wxjava.mp.properties.WxMpProperties;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import me.chanjar.weixin.mp.config.impl.WxMpDefaultConfigImpl;
import me.chanjar.weixin.mp.config.impl.WxMpRedisConfigImpl;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class WxMpStorageAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(WxMpStorageAutoConfiguration.class);
    private final WxMpProperties properties;
    @Autowired(required=false)
    private JedisPool jedisPool;

    @Bean
    @ConditionalOnMissingBean(value={WxMpConfigStorage.class})
    public WxMpConfigStorage wxMpInMemoryConfigStorage() {
        log.info("properties\uff1a{}", (Object)this.properties);
        WxMpProperties.ConfigStorage storage = this.properties.getConfigStorage();
        WxMpProperties.StorageType type = storage.getType();
        if (type == WxMpProperties.StorageType.redis) {
            return this.getWxMpInRedisConfigStorage();
        }
        return this.getWxMpInMemoryConfigStorage();
    }

    private WxMpDefaultConfigImpl getWxMpInMemoryConfigStorage() {
        WxMpDefaultConfigImpl config = new WxMpDefaultConfigImpl();
        this.setWxMpInfo(config);
        return config;
    }

    private WxMpRedisConfigImpl getWxMpInRedisConfigStorage() {
        JedisPool poolToUse = this.jedisPool;
        if (poolToUse == null) {
            poolToUse = this.getJedisPool();
        }
        WxMpRedisConfigImpl config = new WxMpRedisConfigImpl(poolToUse);
        this.setWxMpInfo((WxMpDefaultConfigImpl)config);
        return config;
    }

    private void setWxMpInfo(WxMpDefaultConfigImpl config) {
        if (CollectionUtils.isEmpty(this.properties.getConfigs())) {
            throw new RuntimeException("\u5fc5\u987b\u6dfb\u52a0\u76f8\u5173\u914d\u7f6e\uff08wx.mp.configs\uff09\uff0c\u6ce8\u610f\u522b\u914d\u9519\u4e86\uff01");
        }
        config.setAppId(this.properties.getConfigs().get(0).getAppId());
        config.setSecret(this.properties.getConfigs().get(0).getSecret());
        config.setToken(this.properties.getConfigs().get(0).getToken());
        config.setAesKey(this.properties.getConfigs().get(0).getAesKey());
    }

    private JedisPool getJedisPool() {
        WxMpProperties.ConfigStorage storage = this.properties.getConfigStorage();
        RedisProperties redis = storage.getRedis();
        JedisPoolConfig config = new JedisPoolConfig();
        if (redis.getMaxActive() != null) {
            config.setMaxTotal(redis.getMaxActive().intValue());
        }
        if (redis.getMaxIdle() != null) {
            config.setMaxIdle(redis.getMaxIdle().intValue());
        }
        if (redis.getMaxWaitMillis() != null) {
            config.setMaxWaitMillis((long)redis.getMaxWaitMillis().intValue());
        }
        if (redis.getMinIdle() != null) {
            config.setMinIdle(redis.getMinIdle().intValue());
        }
        config.setTestOnBorrow(true);
        config.setTestWhileIdle(true);
        JedisPool pool = new JedisPool((GenericObjectPoolConfig)config, redis.getHost(), redis.getPort(), redis.getTimeout(), redis.getPassword(), redis.getDatabase());
        return pool;
    }

    public WxMpStorageAutoConfiguration(WxMpProperties properties) {
        this.properties = properties;
    }
}

