/*
 * Decompiled with CFR 0.152.
 */
package com.github.alanger.commonjs;

import com.github.alanger.commonjs.Folder;
import com.github.alanger.commonjs.ModuleCache;
import com.github.alanger.commonjs.ModuleException;
import com.github.alanger.commonjs.Paths;
import com.github.alanger.commonjs.RequireFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public abstract class AbstractModule
extends SimpleBindings
implements RequireFunction {
    protected ScriptEngine engine;
    protected Object jsonConstructor;
    protected Folder folder;
    protected ModuleCache cache;
    protected AbstractModule mainModule;
    public Object main;
    protected Object exports;
    protected Object module;
    protected List<Object> children = new ArrayList<Object>();
    protected static ThreadLocal<Map<String, Object>> refCache = new ThreadLocal();

    public AbstractModule(ScriptEngine engine, Folder folder, ModuleCache cache, String filename, Object module, Object exports, AbstractModule parent, AbstractModule root) throws ScriptException {
        super(new LinkedHashMap<String, Object>());
        this.engine = engine;
        this.jsonConstructor = parent != null ? parent.jsonConstructor : engine.eval("JSON");
        this.folder = folder;
        this.cache = cache;
        this.mainModule = root != null ? root : this;
        this.module = module;
        this.exports = exports;
        this.main = this.mainModule.module;
        this.init(cache, filename, module, exports, parent, root);
    }

    protected void init(ModuleCache cache, String filename, Object module, Object exports, AbstractModule parent, AbstractModule root) throws ScriptException {
        this.putObject(module, "exports", exports);
        this.putObject(module, "children", this.children);
        this.putObject(module, "filename", filename);
        this.putObject(module, "id", filename);
        this.putObject(module, "loaded", false);
        this.putObject(module, "exports", exports);
        this.putObject(module, "parent", parent != null ? parent.module : null);
    }

    public ScriptEngine getScriptEngine() {
        return this.engine;
    }

    public Object getModule() {
        return this.module;
    }

    protected void setLoaded() throws ScriptException {
        this.putObject(this.module, "loaded", true);
    }

    protected abstract AbstractModule compileJsonModule(Folder var1, String var2, String var3) throws ScriptException;

    protected abstract AbstractModule compileJavaScriptModule(Folder var1, String var2, String var3) throws ScriptException;

    protected abstract Object getNativeModule() throws ScriptException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object require(String module) throws ScriptException {
        String[] parts;
        if (module == null) {
            this.throwModuleNotFoundException("<null>");
        }
        if ((parts = Paths.splitPath(module)).length == 0) {
            this.throwModuleNotFoundException(module);
        }
        String[] folderParts = Arrays.copyOfRange(parts, 0, parts.length - 1);
        String filename = parts[parts.length - 1];
        AbstractModule found = null;
        Folder resolvedFolder = AbstractModule.resolveFolder(this.folder, folderParts);
        if (refCache.get() == null) {
            refCache.set(new HashMap());
        }
        String requestedFullPath = null;
        if (resolvedFolder != null) {
            requestedFullPath = resolvedFolder.getPath() + filename;
            Object cachedExports = refCache.get().get(requestedFullPath);
            if (cachedExports != null) {
                return cachedExports;
            }
            refCache.get().put(requestedFullPath, this.createSafeBindings());
        }
        try {
            if (AbstractModule.isPrefixedModuleName(module)) {
                found = this.attemptToLoadFromThisFolder(resolvedFolder, filename);
            }
            if (found == null) {
                found = this.searchForModuleInNodeModules(this.folder, folderParts, filename);
            }
            if (found == null) {
                this.throwModuleNotFoundException(module);
            }
            assert (found != null);
            this.children.add(found.module);
            Object object = found.exports;
            return object;
        }
        finally {
            if (requestedFullPath != null) {
                refCache.get().remove(requestedFullPath);
            }
        }
    }

    protected AbstractModule searchForModuleInNodeModules(Folder resolvedFolder, String[] folderParts, String filename) throws ScriptException {
        for (Folder current = resolvedFolder; current != null; current = current.getParent()) {
            AbstractModule found;
            Folder nodeModules = current.getFolder("node_modules");
            if (nodeModules == null || (found = this.attemptToLoadFromThisFolder(AbstractModule.resolveFolder(nodeModules, folderParts), filename)) == null) continue;
            return found;
        }
        return null;
    }

    protected AbstractModule attemptToLoadFromThisFolder(Folder resolvedFolder, String filename) throws ScriptException {
        if (resolvedFolder == null) {
            return null;
        }
        String requestedFullPath = resolvedFolder.getPath() + filename;
        Object found = this.cache.get(requestedFullPath);
        if (found != null) {
            return found;
        }
        found = this.loadModuleAsFile(resolvedFolder, filename);
        if (found == null) {
            found = this.loadModuleAsFolder(resolvedFolder, filename);
        }
        if (found != null) {
            this.cache.put(requestedFullPath, (AbstractModule)found);
        }
        return found;
    }

    private AbstractModule loadModuleAsFile(Folder parent, String filename) throws ScriptException {
        String[] filenamesToAttempt;
        for (String tentativeFilename : filenamesToAttempt = AbstractModule.getFilenamesToAttempt(filename)) {
            String code = parent.getFile(tentativeFilename);
            if (code == null) continue;
            String fullPath = parent.getPath() + tentativeFilename;
            return this.compileModuleAndPutInCache(parent, fullPath, code);
        }
        return null;
    }

    private AbstractModule loadModuleAsFolder(Folder parent, String name) throws ScriptException {
        Folder fileAsFolder = parent.getFolder(name);
        if (fileAsFolder == null) {
            return null;
        }
        AbstractModule found = this.loadModuleThroughPackageJson(fileAsFolder);
        if (found == null) {
            found = this.loadModuleThroughIndexJs(fileAsFolder);
        }
        if (found == null) {
            found = this.loadModuleThroughIndexJson(fileAsFolder);
        }
        return found;
    }

    private AbstractModule loadModuleThroughPackageJson(Folder parent) throws ScriptException {
        String packageJson = parent.getFile("package.json");
        if (packageJson == null) {
            return null;
        }
        String mainFile = this.getMainFileFromPackageJson(packageJson);
        if (mainFile == null) {
            return null;
        }
        String[] parts = Paths.splitPath(mainFile);
        String[] folders = Arrays.copyOfRange(parts, 0, parts.length - 1);
        String filename = parts[parts.length - 1];
        Folder folder = AbstractModule.resolveFolder(parent, folders);
        if (folder == null) {
            return null;
        }
        AbstractModule module = this.loadModuleAsFile(folder, filename);
        if (module == null && (folder = AbstractModule.resolveFolder(parent, parts)) != null) {
            module = this.loadModuleThroughIndexJs(folder);
        }
        return module;
    }

    private AbstractModule loadModuleThroughIndexJs(Folder parent) throws ScriptException {
        String code = parent.getFile("index.js");
        if (code == null) {
            return null;
        }
        return this.compileModuleAndPutInCache(parent, parent.getPath() + "index.js", code);
    }

    private AbstractModule loadModuleThroughIndexJson(Folder parent) throws ScriptException {
        String code = parent.getFile("index.json");
        if (code == null) {
            return null;
        }
        return this.compileModuleAndPutInCache(parent, parent.getPath() + "index.json", code);
    }

    private AbstractModule compileModuleAndPutInCache(Folder parent, String fullPath, String code) throws ScriptException {
        AbstractModule created;
        String lowercaseFullPath = fullPath.toLowerCase();
        if (lowercaseFullPath.endsWith(".js")) {
            created = this.compileJavaScriptModule(parent, fullPath, code);
        } else if (lowercaseFullPath.endsWith(".json")) {
            created = this.compileJsonModule(parent, fullPath, code);
        } else {
            return null;
        }
        this.cache.put(fullPath, created);
        return created;
    }

    protected String getMainFileFromPackageJson(String packageJson) throws ScriptException {
        Object jsonObject = this.parseJson(packageJson);
        return (String)this.getObject(jsonObject, "main");
    }

    protected Object parseJson(String json) throws ScriptException {
        try {
            Invocable invocable = (Invocable)((Object)this.engine);
            return invocable.invokeMethod(this.jsonConstructor, "parse", json);
        }
        catch (NoSuchMethodException e) {
            throw new ScriptException(e);
        }
    }

    protected String stringifyObject(Object json) throws ScriptException {
        try {
            Invocable invocable = (Invocable)((Object)this.engine);
            return (String)invocable.invokeMethod(this.jsonConstructor, "stringify", json);
        }
        catch (NoSuchMethodException e) {
            throw new ScriptException(e);
        }
    }

    protected void throwModuleNotFoundException(String module) throws ScriptException {
        throw new ModuleException("Module not found: " + module, "MODULE_NOT_FOUND");
    }

    protected static Folder resolveFolder(Folder from, String[] folders) {
        Folder current = from;
        String[] stringArray = folders;
        int n = stringArray.length;
        block10: for (int i = 0; i < n; ++i) {
            String name;
            switch (name = stringArray[i]) {
                case "": {
                    throw new IllegalArgumentException();
                }
                case ".": {
                    continue block10;
                }
                case "..": {
                    current = current.getParent();
                    break;
                }
                default: {
                    current = current.getFolder(name);
                }
            }
            if (current != null) continue;
            return null;
        }
        return current;
    }

    protected Object createSafeBindings() throws ScriptException {
        return this.engine.eval("({})");
    }

    protected static boolean isPrefixedModuleName(String module) {
        return module.startsWith("/") || module.startsWith("../") || module.startsWith("./");
    }

    protected static String[] getFilenamesToAttempt(String filename) {
        return new String[]{filename, filename + ".js", filename + ".json"};
    }

    protected Object getObject(Object thizz, String key) throws ScriptException {
        Map m = (Map)thizz;
        return m.get(key);
    }

    protected Object putObject(Object thizz, String key, Object value) throws ScriptException {
        Map m = (Map)thizz;
        return m.put(key, value);
    }
}

