/*
 * Decompiled with CFR 0.152.
 */
package com.github.alanger.commonjs;

import com.github.alanger.commonjs.AbstractModule;
import com.github.alanger.commonjs.Folder;
import com.github.alanger.commonjs.ModuleCache;
import com.github.alanger.commonjs.graalvm.GraalModule;
import com.github.alanger.commonjs.nashorn.NashornModule;
import com.github.alanger.commonjs.pure.Jsr223Module;
import com.github.alanger.commonjs.rhino.RhinoModule;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public class Require {
    public static final String GRAALJS = "graal.js";
    public static final String GRAALJS_NAME = "Graal.js";
    public static final String RHINO = "rhino";
    public static final String RHINO_NAME = "Mozilla Rhino";
    public static final String NASHORN = "nashorn";
    public static final String NASHORN_NAME = "Oracle Nashorn";

    public static AbstractModule enable(ScriptEngine engine, Folder folder) throws ScriptException {
        Bindings global = engine.getBindings(100);
        return Require.enable(engine, folder, global);
    }

    public static AbstractModule enable(ScriptEngine engine, Folder folder, Bindings bindings) throws ScriptException {
        AbstractModule created = null;
        Object module = engine.eval("({})");
        Object exports = engine.eval("({})");
        String name = engine.getFactory().getEngineName();
        String className = engine.getClass().getCanonicalName();
        created = NASHORN_NAME.equals(name) || NASHORN.equals(System.getProperty(className)) ? new NashornModule(engine, folder, new ModuleCache(), "<main>", module, exports, null, null) : (RHINO_NAME.equals(name) || RHINO.equals(System.getProperty(className)) ? new RhinoModule(engine, folder, new ModuleCache(), "<main>", module, exports, null, null) : (GRAALJS_NAME.equals(name) || GRAALJS.equals(System.getProperty(className)) ? new GraalModule(engine, folder, new ModuleCache(), "<main>", module, exports, null, null) : new Jsr223Module(engine, folder, new ModuleCache(), "<main>", module, exports, null, null)));
        created.setLoaded();
        bindings.put("require", ((AbstractModule)created).getNativeModule());
        bindings.put("module", module);
        bindings.put("exports", exports);
        return created;
    }
}

