/*
 * Decompiled with CFR 0.152.
 */
package com.github.alanger.commonjs.graalvm;

import com.github.alanger.commonjs.AbstractModule;
import com.github.alanger.commonjs.Folder;
import com.github.alanger.commonjs.ModuleCache;
import com.github.alanger.commonjs.Paths;
import com.oracle.truffle.js.scriptengine.GraalJSScriptEngine;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

public class GraalModule
extends AbstractModule {
    private Context context;

    public GraalModule(ScriptEngine engine, Folder folder, ModuleCache cache, String filename, Object module, Object exports, AbstractModule parent, AbstractModule root) throws ScriptException {
        super(engine, folder, cache, filename, module, exports, parent, root);
        GraalJSScriptEngine gjse = (GraalJSScriptEngine)engine;
        this.context = gjse.getPolyglotContext();
    }

    @Override
    protected GraalModule compileJsonModule(Folder parent, String fullPath, String code) throws ScriptException {
        Object module = this.createSafeBindings();
        Object exports = this.createSafeBindings();
        GraalModule created = new GraalModule(this.engine, parent, this.cache, fullPath, module, exports, this, this.mainModule);
        created.exports = this.parseJson(code);
        created.setLoaded();
        return created;
    }

    @Override
    protected GraalModule compileJavaScriptModule(Folder parent, String fullPath, String code) throws ScriptException {
        Bindings engineScope = this.engine.getBindings(100);
        Object module = this.createSafeBindings();
        for (String key : engineScope.keySet()) {
            this.putObject(module, key, engineScope.get(key));
        }
        Object exports = ((Map)refCache.get()).get(fullPath);
        if (exports == null) {
            exports = this.createSafeBindings();
        }
        GraalModule created = new GraalModule(this.engine, parent, this.cache, fullPath, module, exports, this, this.mainModule);
        String[] split = Paths.splitPath(fullPath);
        String filename = split[split.length - 1];
        String dirname = fullPath.substring(0, Math.max(fullPath.length() - filename.length() - 1, 0));
        Source source = Source.newBuilder((String)"js", (CharSequence)("(function (exports, require, module, __filename, __dirname) {" + code + "\n})"), (String)fullPath).buildLiteral();
        Value function = this.context.eval(source);
        function.execute(new Object[]{created.exports, created, created.module, filename, dirname});
        created.exports = this.getObject(created.module, "exports");
        created.setLoaded();
        return created;
    }

    @Override
    protected Object getNativeModule() throws ScriptException {
        return this;
    }
}

