/*
 * Decompiled with CFR 0.152.
 */
package com.github.alanger.commonjs.nashorn;

import com.github.alanger.commonjs.AbstractModule;
import com.github.alanger.commonjs.Folder;
import com.github.alanger.commonjs.ModuleCache;
import com.github.alanger.commonjs.Paths;
import java.lang.reflect.Method;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public class NashornModule
extends AbstractModule {
    public NashornModule(ScriptEngine engine, Folder folder, ModuleCache cache, String filename, Object module, Object exports, AbstractModule parent, AbstractModule root) throws ScriptException {
        super(engine, folder, cache, filename, module, exports, parent, root);
        this.put("main", this.mainModule.getModule());
    }

    @Override
    protected NashornModule compileJsonModule(Folder parent, String fullPath, String code) throws ScriptException {
        Object module = this.createSafeBindings();
        Object exports = this.createSafeBindings();
        NashornModule created = new NashornModule(this.engine, parent, this.cache, fullPath, module, exports, this, this.mainModule);
        created.exports = this.parseJson(code);
        created.setLoaded();
        return created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected NashornModule compileJavaScriptModule(Folder parent, String fullPath, String code) throws ScriptException {
        Bindings engineScope = this.engine.getBindings(100);
        Object module = this.createSafeBindings();
        for (String key : engineScope.keySet()) {
            this.putObject(module, key, engineScope.get(key));
        }
        Object exports = ((Map)refCache.get()).get(fullPath);
        if (exports == null) {
            exports = this.createSafeBindings();
        }
        NashornModule created = new NashornModule(this.engine, parent, this.cache, fullPath, module, exports, this, this.mainModule);
        String[] split = Paths.splitPath(fullPath);
        String filename = split[split.length - 1];
        String dirname = fullPath.substring(0, Math.max(fullPath.length() - filename.length() - 1, 0));
        String previousFilename = (String)this.engine.get("javax.script.filename");
        this.engine.put("javax.script.filename", fullPath);
        try {
            Object function = this.engine.eval("(function (exports, require, module, __filename, __dirname) {" + code + "\n})");
            Object[] args = new Object[]{created.exports, created, created.module, filename, dirname};
            try {
                Class<?> scriptObjectClass = Class.forName("jdk.nashorn.api.scripting.ScriptObjectMirror");
                Method call = scriptObjectClass.getMethod("call", Object.class, Object[].class);
                call.invoke(function, created, args);
            }
            catch (Exception e) {
                throw new ScriptException(e);
            }
        }
        finally {
            this.engine.put("javax.script.filename", previousFilename);
        }
        created.exports = this.getObject(created.module, "exports");
        created.setLoaded();
        return created;
    }

    @Override
    protected Object getNativeModule() throws ScriptException {
        return this;
    }
}

