/*
 * Decompiled with CFR 0.152.
 */
package kafkareactive.sink.batch;

import com.typesafe.config.Config;
import eie.io.package$;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.zip.ZipOutputStream;
import kafkareactive.sink.batch.BatchEventHandler;
import kafkareactive.sink.batch.ZipStreamWrapper;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;

public final class BatchEventHandler$ {
    public static BatchEventHandler$ MODULE$;

    static {
        new BatchEventHandler$();
    }

    public String timestamp(ZonedDateTime time) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(time))).replaceAllLiterally(":", "_"))).replaceAllLiterally(".", "_");
    }

    public ZonedDateTime timestamp$default$1() {
        return ZonedDateTime.now();
    }

    public Function1<TopicPartition, BatchEventHandler> fromRootConfig(Config rootConfig) {
        return this.apply(rootConfig.getConfig("batch"));
    }

    public Function1<TopicPartition, BatchEventHandler> apply(Config config) {
        Function1 & Serializable & scala.Serializable intersect;
        Long maxSize = config.getBytes("maxSize");
        String string = config.getString("dir");
        if ("".equals(string)) {
            long l = Predef$.MODULE$.Long2long(maxSize);
            intersect = (Function1 & Serializable & scala.Serializable)topicPartition -> MODULE$.inMemory(l, (TopicPartition)topicPartition);
        } else {
            long l = Predef$.MODULE$.Long2long(maxSize);
            Path path = package$.MODULE$.RichPathString(string).asPath();
            intersect = (Function1 & Serializable & scala.Serializable)topicPartition -> MODULE$.persisted(l, path, (TopicPartition)topicPartition);
        }
        return intersect;
    }

    public BatchEventHandler persisted(long maxSize, Path dir, TopicPartition topicPartition) {
        return new BatchEventHandler.Instance(topicPartition, maxSize, (Function0 & Serializable & scala.Serializable)() -> BatchEventHandler$.createStream$1(dir, topicPartition));
    }

    public BatchEventHandler inMemory(long maxSize, TopicPartition topicPartition) {
        return new BatchEventHandler.Instance(topicPartition, maxSize, (Function0 & Serializable & scala.Serializable)() -> BatchEventHandler$.createStream$2());
    }

    private static final ZipStreamWrapper createStream$1(Path dir$1, TopicPartition topicPartition$1) {
        Path zipFile = package$.MODULE$.asRichPath(dir$1).mkDirs((Seq)Nil$.MODULE$).resolve(new StringBuilder(5).append(topicPartition$1).append("-").append(MODULE$.timestamp(MODULE$.timestamp$default$1())).append(".zip").toString());
        ZipOutputStream output = new ZipOutputStream(new FileOutputStream(zipFile.toFile()));
        return new ZipStreamWrapper<Path>(zipFile, output);
    }

    private static final ZipStreamWrapper createStream$2() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream output = new ZipOutputStream(baos);
        return new ZipStreamWrapper<ByteArrayOutputStream>(baos, output);
    }

    private BatchEventHandler$() {
        MODULE$ = this;
    }
}

