/*
 * Decompiled with CFR 0.152.
 */
package migration;

import eie.io.package$;
import geny.Bytes;
import java.io.Serializable;
import java.nio.file.Path;
import javax.net.ssl.SSLContext;
import migration.Download;
import migration.HttpRequestSettings;
import requests.Cert;
import requests.Compress;
import requests.RequestAuth;
import requests.RequestBlob;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;
import zio.Has;
import zio.Task$;
import zio.ZIO;
import zio.ZIO$;
import zio.console.package;

public final class Download$ {
    public static final Download$ MODULE$ = new Download$();

    public ZIO<Has<package.Console.Service>, Throwable, List<String>> indexFile(String url, Path dest, HttpRequestSettings settings) {
        return this.toFile(url, dest, settings).flatMap((Function1 & Serializable)x$3 -> {
            Path path = x$3;
            ZIO zIO = Task$.MODULE$.effect((Function0 & Serializable)() -> StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(package$.MODULE$.asRichPath(dest).text())).map((Function1 & Serializable)x$1 -> x$1.trim()).filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty())).toList()).map((Function1 & Serializable)fileList -> fileList);
            return zIO;
        });
    }

    public ZIO<Has<package.Console.Service>, Throwable, Path> toFile(String url, Path dest, HttpRequestSettings settings) {
        return this.plan(new Download.Download(url, dest, settings)).flatMap((Function1 & Serializable)actions -> ZIO$.MODULE$.foreach((Iterable)actions, (Function1 & Serializable)action -> MODULE$.eval((Download.Action)action), BuildFrom$.MODULE$.buildFromIterableOps())).map((Function1 & Serializable)x$4 -> dest);
    }

    private ZIO<Has<package.Console.Service>, Throwable, Object> eval(Download.Action action) {
        ZIO<Object, Throwable, Path> zIO;
        Download.Action action2 = action;
        if (action2 instanceof Download.MkDir) {
            Download.MkDir mkDir = (Download.MkDir)action2;
            Path dir = mkDir.dest();
            zIO = zio.console.package$.MODULE$.putStrLn((Function0 & Serializable)() -> new StringBuilder(9).append("mkdir -p ").append(dir).toString()).$times$greater((Function0 & Serializable)() -> Task$.MODULE$.effect((Function0 & Serializable)() -> package$.MODULE$.asRichPath(dir).mkDirs((Seq)Nil$.MODULE$)));
        } else if (action2 instanceof Download.Fail) {
            Download.Fail fail = (Download.Fail)action2;
            zIO = zio.console.package$.MODULE$.putStrLn((Function0 & Serializable)() -> new StringBuilder(22).append("download failed with: ").append(fail.msg()).toString()).$times$greater((Function0 & Serializable)() -> Task$.MODULE$.fail((Function0 & Serializable)() -> fail));
        } else if (action2 instanceof Download.Log) {
            Download.Log log = (Download.Log)action2;
            String msg = log.message();
            zIO = zio.console.package$.MODULE$.putStrLn((Function0 & Serializable)() -> msg);
        } else if (action2 instanceof Download.Download) {
            Download.Download download = (Download.Download)action2;
            zIO = this.asTask(download);
        } else {
            throw new MatchError((Object)action2);
        }
        return zIO;
    }

    private ZIO<Object, Throwable, Path> write(Bytes data, Path dest) {
        byte[] array = data.array();
        return ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.byteArrayOps(array)) ? Task$.MODULE$.fail((Function0 & Serializable)() -> new IllegalStateException(new StringBuilder(28).append("No data read, won't save to ").append(dest).toString())) : Task$.MODULE$.effect((Function0 & Serializable)() -> package$.MODULE$.asRichPath(dest).bytes_$eq(array));
    }

    private ZIO<Object, Throwable, Path> asTask(Download.Download download) {
        return Task$.MODULE$.effect((Function0 & Serializable)() -> {
            String x$2 = download.url();
            int x$3 = (int)download.settings().readTimeout().toMillis();
            int x$4 = (int)download.settings().connectionTimeout().toMillis();
            RequestAuth x$5 = requests.package$.MODULE$.get().apply$default$2();
            Iterable x$6 = requests.package$.MODULE$.get().apply$default$3();
            Iterable x$7 = requests.package$.MODULE$.get().apply$default$4();
            RequestBlob x$8 = requests.package$.MODULE$.get().apply$default$5();
            Tuple2 x$9 = requests.package$.MODULE$.get().apply$default$8();
            Cert x$10 = requests.package$.MODULE$.get().apply$default$9();
            SSLContext x$11 = requests.package$.MODULE$.get().apply$default$10();
            Map x$12 = requests.package$.MODULE$.get().apply$default$11();
            Map x$13 = requests.package$.MODULE$.get().apply$default$12();
            int x$14 = requests.package$.MODULE$.get().apply$default$13();
            boolean x$15 = requests.package$.MODULE$.get().apply$default$14();
            boolean x$16 = requests.package$.MODULE$.get().apply$default$15();
            Compress x$17 = requests.package$.MODULE$.get().apply$default$16();
            boolean x$18 = requests.package$.MODULE$.get().apply$default$17();
            boolean x$19 = requests.package$.MODULE$.get().apply$default$18();
            boolean x$20 = requests.package$.MODULE$.get().apply$default$19();
            return requests.package$.MODULE$.get().apply(x$2, x$5, x$6, x$7, x$8, x$3, x$4, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        }).flatMap((Function1 & Serializable)r -> {
            ZIO zIO;
            if (download.settings().acceptableStatuses().isEmpty() || download.settings().acceptableStatuses().contains((Object)BoxesRunTime.boxToInteger((int)r.statusCode()))) {
                zIO = MODULE$.write(r.data(), download.dest());
            } else {
                String body2 = (String)Try$.MODULE$.apply((Function0 & Serializable)() -> new StringBuilder(7).append("; body:").append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(new String(r.bytes())), 200)).toString()).getOrElse((Function0 & Serializable)() -> "");
                IllegalStateException err = new IllegalStateException(new StringBuilder(47).append("Download '").append(download.url()).append("' returned unexpected status code '").append(r.statusCode()).append("' ").append(r.statusMessage()).append(body2).toString());
                zIO = Task$.MODULE$.fail((Function0 & Serializable)() -> err);
            }
            return zIO;
        });
    }

    private ZIO<Object, Throwable, Seq<Download.Action>> plan(Download.Download download) {
        return Task$.MODULE$.effect(() -> Download$.$anonfun$plan$1(download));
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Seq $anonfun$plan$1(Download.Download download$2) {
        block9: {
            block8: {
                if (!package$.MODULE$.asRichPath(download$2.dest()).exists((Seq)Nil$.MODULE$)) break block8;
                if (package$.MODULE$.asRichPath(download$2.dest()).isFile()) {
                    var2_1 = new Download.Log(new StringBuilder(36).append("# ").append(download$2.dest()).append(" already exists, skipping download").toString());
                    v0 = Nil$.MODULE$.$colon$colon((Object)var2_1);
                } else {
                    var3_2 = new Download.Fail(new StringBuilder(30).append(download$2.dest()).append(" exists but is not a directory").toString());
                    v0 = Nil$.MODULE$.$colon$colon((Object)var3_2);
                }
                break block9;
            }
            var4_3 = false;
            var5_4 = null;
            var6_5 = package$.MODULE$.asRichPath(download$2.dest()).parent();
            if (!(var6_5 instanceof Some)) ** GOTO lbl-1000
            var4_3 = true;
            var5_4 = (Some)var6_5;
            p = (Path)var5_4.value();
            if (package$.MODULE$.asRichPath(p).isDir()) {
                var8_7 = new Download.Log(new StringBuilder(28).append("# downloading ").append(download$2.url()).append(" to directory ").append(p).toString());
                var9_8 = download$2;
                var1_9 = Nil$.MODULE$.$colon$colon((Object)var9_8).$colon$colon((Object)var8_7);
            } else if (var4_3 && package$.MODULE$.asRichPath(p = (Path)var5_4.value()).isFile()) {
                var11_11 = new Download.Fail(new StringBuilder(21).append(download$2.dest()).append(" exists but is a file").toString());
                var1_9 = Nil$.MODULE$.$colon$colon((Object)var11_11);
            } else if (var4_3 && !package$.MODULE$.asRichPath(p = (Path)var5_4.value()).exists((Seq)Nil$.MODULE$)) {
                var13_13 = new Download.MkDir(p);
                var14_14 = download$2;
                var1_9 = Nil$.MODULE$.$colon$colon((Object)var14_14).$colon$colon((Object)var13_13);
            } else {
                var15_15 = new Download.Fail(new StringBuilder(28).append(download$2.dest()).append(" is an invalid download path").toString());
                var1_9 = Nil$.MODULE$.$colon$colon((Object)var15_15);
            }
            v0 = var1_9;
        }
        return v0;
    }

    private Download$() {
    }
}

