/*
 * Decompiled with CFR 0.152.
 */
package migration;

import eie.io.package$;
import java.io.Serializable;
import java.nio.file.Path;
import migration.Download$;
import migration.Extract;
import migration.HttpRequestSettings;
import migration.ParsedConfig;
import migration.RegexResolve$;
import migration.Unzip$;
import migration.ValidateXml$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import zio.CanFail$;
import zio.Fiber;
import zio.Has;
import zio.Task$;
import zio.ZIO;
import zio.ZIO$;
import zio.console.package;

public final class Extract$ {
    public static final Extract$ MODULE$ = new Extract$();

    public ZIO<Has<package.Console.Service>, Throwable, BoxedUnit> apply(ParsedConfig config) {
        return this.extractAndValidate(config).either(CanFail$.MODULE$.canFail()).flatMap((Function1 & Serializable)either -> MODULE$.prepareFinalReport((Either<Throwable, List<Extract.ZipEntryResult>>)either));
    }

    private ZIO<Has<package.Console.Service>, Throwable, BoxedUnit> prepareFinalReport(Either<Throwable, List<Extract.ZipEntryResult>> either) {
        ZIO zIO;
        Either<Throwable, List<Extract.ZipEntryResult>> either2 = either;
        if (either2 instanceof Left) {
            Left left = (Left)either2;
            Throwable err = (Throwable)left.value();
            ZIO result2 = zio.console.package$.MODULE$.putStrLn((Function0 & Serializable)() -> new StringBuilder(23).append("Extraction failed with ").append(err).toString()).$times$greater((Function0 & Serializable)() -> Task$.MODULE$.fail((Function0 & Serializable)() -> err));
            zIO = result2.unit();
        } else if (either2 instanceof Right) {
            Right right = (Right)either2;
            List results = (List)right.value();
            ZIO outputs = ZIO$.MODULE$.foreach((Iterable)results, (Function1 & Serializable)result -> zio.console.package$.MODULE$.putStrLn((Function0 & Serializable)() -> result.desc()), BuildFrom$.MODULE$.buildFromIterableOps()).unit();
            ZIO isSuccess = ZIO$.MODULE$.foreach((Iterable)results, (Function1 & Serializable)result -> ZIO$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> result.success()), BuildFrom$.MODULE$.buildFromIterableOps());
            ZIO finalTask = isSuccess.flatMap((Function1 & Serializable)successes -> {
                ZIO zIO;
                int n = successes.count((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Extract$.$anonfun$prepareFinalReport$9(BoxesRunTime.unboxToBoolean((Object)x$3))));
                switch (n) {
                    case 0: {
                        zIO = ZIO$.MODULE$.unit();
                        break;
                    }
                    case 1: {
                        zIO = Task$.MODULE$.fail((Function0 & Serializable)() -> new Exception("One of the tasks failed"));
                        break;
                    }
                    default: {
                        zIO = Task$.MODULE$.fail((Function0 & Serializable)() -> new Exception(new StringBuilder(13).append(n).append(" tasks failed").toString()));
                        break;
                    }
                }
                return zIO;
            });
            zIO = outputs.$times$greater((Function0 & Serializable)() -> finalTask);
        } else {
            throw new MatchError(either2);
        }
        return zIO;
    }

    public ZIO<Has<package.Console.Service>, Throwable, List<Extract.ZipEntryResult>> extractAndValidate(ParsedConfig config) {
        Function1<String, Try<String>> fileNameForEntry = RegexResolve$.MODULE$.apply(config.fileNameRegex().trim(), config.fileNamePattern().trim());
        return Download$.MODULE$.indexFile(config.indexURL(), config.downloadDirectory().resolve(config.indexFileName()), config.httpSettings()).flatMap((Function1 & Serializable)zipFilesNames -> ZIO$.MODULE$.foreach((Iterable)zipFilesNames.zipWithIndex(), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String zipEntry = (String)tuple2._1();
            int index = tuple2._2$mcI$sp();
            ZIO forked = MODULE$.extractAndValidateEntry(config.url(), config.downloadDirectory(), config.dataDirectory(), index, zipEntry, config.httpSettings(), fileNameForEntry).either(CanFail$.MODULE$.canFail()).fork();
            ZIO zIO = forked.map((Function1 & Serializable)fiber -> new Tuple3((Object)zipEntry, (Object)BoxesRunTime.boxToInteger((int)index), fiber));
            return zIO;
        }, BuildFrom$.MODULE$.buildFromIterableOps()).flatMap((Function1 & Serializable)forks -> ZIO$.MODULE$.foreach((Iterable)forks.map((Function1 & Serializable)x0$2 -> {
            Tuple3 tuple3 = x0$2;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String zipEntry = (String)tuple3._1();
            int index = BoxesRunTime.unboxToInt((Object)tuple3._2());
            Fiber.Runtime fiber = (Fiber.Runtime)tuple3._3();
            ZIO zIO = fiber.join().map((Function1 & Serializable)result -> new Extract.ZipEntryResult(zipEntry, index, (Either<Throwable, Extract.ValidationResult>)result));
            return zIO;
        }), (Function1 & Serializable)x -> (ZIO)Predef$.MODULE$.identity(x), BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1 & Serializable)result -> (List)result.sortBy((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.index()), (Ordering)Ordering.Int$.MODULE$))));
    }

    private ZIO<Has<package.Console.Service>, Throwable, Extract.ValidationResult> extractAndValidateEntry(String url, Path downloadDirectory, Path dataDirectory, int index, String zipFileName, HttpRequestSettings settings, Function1<String, Try<String>> fileNameForEntry) {
        zio.console.package$.MODULE$.putStr((Function0 & Serializable)() -> new StringBuilder(20).append("Processing ").append(index).append(": ").append(url).append(" into ").append(dataDirectory).append(" ").toString());
        String zipUrl = url.endsWith("/") ? new StringBuilder(0).append(url).append(zipFileName).toString() : new StringBuilder(1).append(url).append("/").append(zipFileName).toString();
        return Download$.MODULE$.toFile(zipUrl, downloadDirectory.resolve(zipFileName), settings).flatMap((Function1 & Serializable)zipFile -> Extract$.unzip$1(zipFile, index, dataDirectory, zipFileName, fileNameForEntry).flatMap((Function1 & Serializable)dataDir -> ValidateXml$.MODULE$.apply((Path)dataDir).map((Function1 & Serializable)errorMessages -> new Extract.ValidationResult((Path)zipFile, (Seq<String>)errorMessages))));
    }

    public static final /* synthetic */ boolean $anonfun$prepareFinalReport$9(boolean x$3) {
        return !x$3;
    }

    private static final ZIO unzip$1(Path zipFile, int index$3, Path dataDirectory$1, String zipFileName$1, Function1 fileNameForEntry$2) {
        String paddedIndex = StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.padTo$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(((Object)BoxesRunTime.boxToInteger((int)index$3)).toString()))), 4, '0')));
        return Task$.MODULE$.fromTry((Function0 & Serializable)() -> Unzip$.MODULE$.to(zipFile, package$.MODULE$.asRichPath(dataDirectory$1.resolve(new StringBuilder(1).append(paddedIndex).append("-").append(zipFileName$1).toString())).mkDirs((Seq)Nil$.MODULE$), (Function1<String, String>)fileNameForEntry$2.andThen((Function1 & Serializable)x$5 -> (String)x$5.get())));
    }

    private Extract$() {
    }
}

