/*
 * Decompiled with CFR 0.152.
 */
package acavailhez.html.utils;

import acavailhez.html.utils.OptGetMap;
import java.util.Map;

public interface OptGet {
    public void onMissingKey(Object var1, Class var2);

    public Object opt(Object var1);

    default public <T> T opt(String key, Class<T> classToCast) {
        return this.opt(key, classToCast, null);
    }

    default public <T> T opt(String key, Class<T> classToCast, T defaultValue) {
        Object nonCast = this.recursiveOpt(key);
        if (nonCast == null) {
            return defaultValue;
        }
        if (classToCast == String.class) {
            return (T)nonCast.toString();
        }
        if (classToCast == Integer.class) {
            if (nonCast instanceof Integer) {
                return (T)nonCast;
            }
            if (nonCast instanceof String) {
                return (T)Integer.valueOf((String)nonCast);
            }
        } else if (classToCast == Long.class) {
            if (nonCast instanceof Long) {
                return (T)nonCast;
            }
            if (nonCast instanceof String) {
                return (T)Long.valueOf((String)nonCast);
            }
        } else if (classToCast.isEnum()) {
            for (T enumValue : classToCast.getEnumConstants()) {
                if (!enumValue.toString().toLowerCase().equals(nonCast.toString().toLowerCase())) continue;
                return enumValue;
            }
        } else if (OptGet.class.isAssignableFrom(classToCast)) {
            if (nonCast instanceof OptGet) {
                return (T)nonCast;
            }
            if (nonCast instanceof Map) {
                return (T)new OptGetMap((Map)nonCast);
            }
        }
        return (T)nonCast;
    }

    default public Object recursiveOpt(Object key) {
        Object value = this.opt(key);
        if (value != null) {
            return value;
        }
        String stringKey = key.toString();
        String[] subkeys = stringKey.split("\\.");
        OptGet optGet = this;
        for (int i = 0; i < subkeys.length - 1; ++i) {
            if ((optGet = optGet.opt(subkeys[i], OptGet.class)) != null) continue;
            return null;
        }
        return optGet.opt(subkeys[subkeys.length - 1]);
    }

    default public Object get(String key) {
        return this.get(key, Object.class);
    }

    default public <T> T get(String key, Class<T> classToCast) throws IllegalArgumentException {
        T value = this.opt(key, classToCast);
        if (value == null) {
            this.onMissingKey(key, classToCast);
        }
        return value;
    }
}

