/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.common.enums;

import com.adrninistrator.javacg.exceptions.JavaCGRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public enum JavaCGCallTypeEnum {
    CTE_RAW_INVOKE_VIRTUAL("VIR", false, false, false, false, false, "JVM\u7684\u539f\u59cb\u65b9\u6cd5\u6307\u4ee4: INVOKEVIRTUAL"),
    CTE_RAW_INVOKE_INTERFACE("INT", false, false, false, false, false, "JVM\u7684\u539f\u59cb\u65b9\u6cd5\u6307\u4ee4: INVOKEINTERFACE"),
    CTE_RAW_INVOKE_SPECIAL("SPE", false, false, false, false, false, "JVM\u7684\u539f\u59cb\u65b9\u6cd5\u6307\u4ee4: INVOKESPECIAL"),
    CTE_RAW_INVOKE_STATIC("STA", false, false, false, false, false, "JVM\u7684\u539f\u59cb\u65b9\u6cd5\u6307\u4ee4: INVOKESTATIC"),
    CTE_RAW_INVOKE_DYNAMIC("DYN", false, false, false, false, false, "JVM\u7684\u539f\u59cb\u65b9\u6cd5\u6307\u4ee4: INVOKEDYNAMIC"),
    CTE_SPRING_BEAN_ACTUAL_INTERFACE("_SPR_ACT_I", false, false, false, false, false, "\u88ab\u8c03\u7528\u63a5\u53e3\u4e3a Spring Bean \uff0c\u66ff\u6362\u4e3a\u5b9e\u9645\u7684\u5b9e\u73b0\u7c7b\u7c7b\u578b"),
    CTE_SPRING_BEAN_ACTUAL_CLASS("_SPR_ACT_C", false, false, false, false, false, "\u88ab\u8c03\u7528\u7c7b\u4e3a Spring Bean \uff0c\u66ff\u6362\u4e3a\u5b9e\u9645\u7684\u5b50\u7c7b\u7c7b\u578b"),
    CTE_ACTUAL_INTERFACE("_ACT_I", false, false, false, false, false, "\u88ab\u8c03\u7528\u63a5\u53e3\u66ff\u6362\u4e3a\u5b9e\u9645\u7684\u5b9e\u73b0\u7c7b\u7c7b\u578b"),
    CTE_ACTUAL_CLASS("_ACT_C", false, false, false, false, false, "\u88ab\u8c03\u7528\u7c7b\u66ff\u6362\u4e3a\u5b9e\u9645\u7684\u5b50\u7c7b\u7c7b\u578b"),
    CTE_INTERFACE_CALL_IMPL_CLASS("_ITF", true, false, false, false, false, "\u63a5\u53e3\u8c03\u7528\u5b9e\u73b0\u7c7b\u5bf9\u5e94\u7684\u65b9\u6cd5"),
    CTE_LAMBDA("_LM", false, false, false, false, false, "Lambda\u8868\u8fbe\u5f0f"),
    CTE_RUNNABLE_INIT_RUN1("_RIR1", false, false, true, false, false, "\u5176\u4ed6\u65b9\u6cd5\u8c03\u7528Runnable \u6784\u9020\u51fd\u6570"),
    CTE_RUNNABLE_INIT_RUN2("_RIR2", false, false, true, true, false, "Runnable \u6784\u9020\u51fd\u6570\u8c03\u7528 run() \u65b9\u6cd5"),
    CTE_CALLABLE_INIT_CALL1("_CIC1", false, false, true, false, false, "\u5176\u4ed6\u65b9\u6cd5\u8c03\u7528Callable \u6784\u9020\u51fd\u6570"),
    CTE_CALLABLE_INIT_CALL2("_CIC2", false, false, true, true, false, "Callable \u6784\u9020\u51fd\u6570\u8c03\u7528 call() \u65b9\u6cd5"),
    CTE_TX_CALLBACK_INIT_CALL1("_TCID1", false, false, true, false, false, "\u5176\u4ed6\u65b9\u6cd5\u8c03\u7528 TransactionCallback \u6784\u9020\u51fd\u6570"),
    CTE_TX_CALLBACK_INIT_CALL2("_TCID2", false, false, true, false, true, "TransactionCallback \u6784\u9020\u51fd\u6570\u8c03\u7528 doInTransaction() \u65b9\u6cd5"),
    CTE_TX_CALLBACK_WR_INIT_CALL1("_TCWRID1", false, false, true, false, false, "\u5176\u4ed6\u65b9\u6cd5\u8c03\u7528 TransactionCallbackWithoutResult \u6784\u9020\u51fd\u6570"),
    CTE_TX_CALLBACK_WR_INIT_CALL2("_TCWRID2", false, false, true, false, true, "TransactionCallbackWithoutResult \u6784\u9020\u51fd\u6570\u8c03\u7528 doInTransactionWithoutResult() \u65b9\u6cd5"),
    CTE_THREAD_START_RUN("_TSR", false, false, false, true, false, "Thread start() \u65b9\u6cd5\u8c03\u7528 run() \u65b9\u6cd5"),
    CTE_SUPER_CALL_CHILD("_SCC", true, false, false, false, false, "\u7236\u7c7b\u8c03\u7528\u5b50\u7c7b\u5bf9\u5e94\u7684\u65b9\u6cd5"),
    CTE_CHILD_CALL_SUPER("_CCS", true, true, false, false, false, "\u5b50\u7c7b\u8c03\u7528\u7236\u7c7b\u5bf9\u5e94\u7684\u65b9\u6cd5"),
    CTE_CHILD_CALL_SUPER_SPECIAL("_CCS_SPE", false, true, false, false, false, "\u5b50\u7c7b\u901a\u8fc7super.\u8c03\u7528\u7236\u7c7b\u65b9\u6cd5"),
    CTE_CHILD_CALL_SUPER_INTERFACE("_CCS_I", true, false, false, false, false, "\u5b50\u63a5\u53e3\u8c03\u7528\u7236\u63a5\u53e3\u5bf9\u5e94\u7684\u65b9\u6cd5"),
    CTE_CLASS_CALL_INTERFACE_DEFAULT("_CCID", true, true, false, false, false, "\u5b9e\u73b0\u7c7b\u8c03\u7528\u63a5\u53e3\u5bf9\u5e94\u7684default\u65b9\u6cd5"),
    CTE_INTERFACE_CALL_INTERFACE_DEFAULT("_ICID", true, true, false, false, false, "\u5b50\u63a5\u53e3\u8c03\u7528\u7236\u63a5\u53e3\u5bf9\u5e94\u7684default\u65b9\u6cd5"),
    CTE_MANUAL_ADDED("_MA", false, false, false, false, false, "\u4eba\u5de5\u6dfb\u52a0\u7684\u65b9\u6cd5\u8c03\u7528"),
    CTE_METHOD_ANNOTATION_ADDED("_MAA", false, false, false, false, false, "\u901a\u8fc7\u65b9\u6cd5\u6ce8\u89e3\u6dfb\u52a0\u7684\u8c03\u7528\u5173\u7cfb"),
    CTE_ILLEGAL("ILLEGAL", false, false, false, false, false, "ILLEGAL");

    private final String type;
    private final boolean noInstructionExtendsImpl;
    private final boolean childCallSuper;
    private final boolean initMethodCall;
    private final boolean runInOtherThread;
    private final boolean runInSpringTx;
    private final String desc;
    private static final List<String> NO_INSTRUCTION_EXTENDS_IMPL_LIST;
    private static final List<String> CHILD_CALL_SUPER_LIST;
    private static final List<String> INIT_METHOD_CALL_LIST;
    private static final List<String> RUN_IN_OTHER_THREAD_LIST;
    private static final List<String> RUN_IN_SPRING_TX_LIST;

    private JavaCGCallTypeEnum(String type, boolean noInstructionExtendsImpl, boolean childCallSuper, boolean initMethodCall, boolean runInOtherThread, boolean runInSpringTx, String desc) {
        this.type = type;
        this.noInstructionExtendsImpl = noInstructionExtendsImpl;
        this.childCallSuper = childCallSuper;
        this.initMethodCall = initMethodCall;
        this.runInOtherThread = runInOtherThread;
        this.runInSpringTx = runInSpringTx;
        this.desc = desc;
    }

    public String getType() {
        return this.type;
    }

    public boolean isNoInstructionExtendsImpl() {
        return this.noInstructionExtendsImpl;
    }

    public boolean isChildCallSuper() {
        return this.childCallSuper;
    }

    public boolean isInitMethodCall() {
        return this.initMethodCall;
    }

    public boolean isRunInOtherThread() {
        return this.runInOtherThread;
    }

    public boolean isRunInSpringTx() {
        return this.runInSpringTx;
    }

    public String getDesc() {
        return this.desc;
    }

    public String toString() {
        return this.type + "-" + this.desc;
    }

    public static JavaCGCallTypeEnum getFromType(String type) {
        for (JavaCGCallTypeEnum callTypeEnum : JavaCGCallTypeEnum.values()) {
            if (!callTypeEnum.getType().equals(type)) continue;
            return callTypeEnum;
        }
        return CTE_ILLEGAL;
    }

    public static void checkRepeat() {
        HashMap<String, List> enumInfoMap = new HashMap<String, List>();
        for (JavaCGCallTypeEnum callTypeEnum : JavaCGCallTypeEnum.values()) {
            List enumNameList = enumInfoMap.computeIfAbsent(callTypeEnum.getType(), k -> new ArrayList());
            enumNameList.add(callTypeEnum.name());
            if (enumNameList.size() <= 1) continue;
            String repeatedEnumTypes = StringUtils.join((Iterable)enumNameList, (String)" ");
            throw new JavaCGRuntimeException(JavaCGCallTypeEnum.class.getSimpleName() + " \u7c7b\u5b9a\u4e49\u7684\u679a\u4e3e\u7c7b\u578b\u5b58\u5728\u91cd\u590d" + callTypeEnum.getType() + " " + repeatedEnumTypes);
        }
    }

    public static List<String> getNoInstructionExtendsImplList() {
        return NO_INSTRUCTION_EXTENDS_IMPL_LIST;
    }

    public static List<String> getChildCallSuperList() {
        return CHILD_CALL_SUPER_LIST;
    }

    public static List<String> getInitMethodCallList() {
        return INIT_METHOD_CALL_LIST;
    }

    public static List<String> getRunInOtherThreadList() {
        return RUN_IN_OTHER_THREAD_LIST;
    }

    public static List<String> getRunInSpringTxList() {
        return RUN_IN_SPRING_TX_LIST;
    }

    public static boolean isInitMethodCallType(String callType) {
        return callType != null && INIT_METHOD_CALL_LIST.contains(callType);
    }

    public static boolean isChildCallSuperType(String callType) {
        return callType != null && CHILD_CALL_SUPER_LIST.contains(callType);
    }

    public static boolean isRunInOtherThreadType(String callType) {
        return callType != null && RUN_IN_OTHER_THREAD_LIST.contains(callType);
    }

    public static boolean isRunInSpringTxType(String callType) {
        return callType != null && RUN_IN_SPRING_TX_LIST.contains(callType);
    }

    static {
        ArrayList<String> noInstructionExtendsImplList = new ArrayList<String>();
        ArrayList<String> childCallSuperList = new ArrayList<String>();
        ArrayList<String> initMethodCallList = new ArrayList<String>();
        ArrayList<String> runInOtherThreadList = new ArrayList<String>();
        ArrayList<String> runInSpringTxList = new ArrayList<String>();
        for (JavaCGCallTypeEnum callTypeEnum : JavaCGCallTypeEnum.values()) {
            if (callTypeEnum.isNoInstructionExtendsImpl()) {
                noInstructionExtendsImplList.add(callTypeEnum.getType());
            }
            if (callTypeEnum.isChildCallSuper()) {
                childCallSuperList.add(callTypeEnum.getType());
            }
            if (callTypeEnum.isInitMethodCall()) {
                initMethodCallList.add(callTypeEnum.getType());
            }
            if (callTypeEnum.isRunInOtherThread()) {
                runInOtherThreadList.add(callTypeEnum.getType());
            }
            if (!callTypeEnum.isRunInSpringTx()) continue;
            runInSpringTxList.add(callTypeEnum.getType());
        }
        NO_INSTRUCTION_EXTENDS_IMPL_LIST = Collections.unmodifiableList(noInstructionExtendsImplList);
        CHILD_CALL_SUPER_LIST = Collections.unmodifiableList(childCallSuperList);
        INIT_METHOD_CALL_LIST = Collections.unmodifiableList(initMethodCallList);
        RUN_IN_OTHER_THREAD_LIST = Collections.unmodifiableList(runInOtherThreadList);
        RUN_IN_SPRING_TX_LIST = Collections.unmodifiableList(runInSpringTxList);
    }
}

