/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.common.enums;

import com.adrninistrator.javacg.common.JavaCGCommonNameConstants;

public enum JavaCGConstantTypeEnum {
    CONSTTE_NULL("null", false),
    CONSTTE_INT("int", true),
    CONSTTE_LONG("long", true),
    CONSTTE_FLOAT("float", true),
    CONSTTE_DOUBLE("double", true),
    CONSTTE_BYTE("byte", true),
    CONSTTE_CHAR("char", true),
    CONSTTE_SHORT("short", true),
    CONSTTE_STRING(JavaCGCommonNameConstants.CLASS_NAME_STRING, false),
    CONSTTE_BOOLEAN("boolean", true),
    CONSTTE_ILLEGAL("ILLEGAL", false);

    private final String type;
    private final boolean primitive;

    private JavaCGConstantTypeEnum(String type, boolean primitive) {
        this.type = type;
        this.primitive = primitive;
    }

    public String getType() {
        return this.type;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public static JavaCGConstantTypeEnum getFromType(String type) {
        for (JavaCGConstantTypeEnum constantTypeEnum : JavaCGConstantTypeEnum.values()) {
            if (!constantTypeEnum.getType().equals(type)) continue;
            return constantTypeEnum;
        }
        return CONSTTE_ILLEGAL;
    }

    public static boolean isConstantType(String type) {
        return CONSTTE_ILLEGAL != JavaCGConstantTypeEnum.getFromType(type);
    }

    public static boolean isPrimitiveType(String type) {
        return JavaCGConstantTypeEnum.getFromType(type).isPrimitive();
    }

    public String toString() {
        return this.type;
    }
}

