/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.conf;

import com.adrninistrator.javacg.common.enums.JavaCGConfigKeyEnum;
import com.adrninistrator.javacg.common.enums.JavaCGOtherConfigFileUseListEnum;
import com.adrninistrator.javacg.common.enums.JavaCGOtherConfigFileUseSetEnum;
import com.adrninistrator.javacg.conf.JavaCGConfInfo;
import com.adrninistrator.javacg.conf.JavaCGConfigureWrapper;
import com.adrninistrator.javacg.util.JavaCGFileUtil;
import com.adrninistrator.javacg.util.JavaCGUtil;
import java.io.BufferedReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaCGConfManager {
    private static final Logger logger = LoggerFactory.getLogger(JavaCGConfManager.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JavaCGConfInfo getConfInfo(JavaCGConfigureWrapper javaCGConfigureWrapper) {
        String configFileName = "_javacg_config/config.properties";
        JavaCGConfInfo confInfo = new JavaCGConfInfo();
        String configFilePath = JavaCGConfManager.getInputRootPath() + configFileName;
        try (BufferedReader br = JavaCGFileUtil.genBufferedReader(JavaCGFileUtil.getFileInputStream(configFilePath));){
            Properties properties = new Properties();
            properties.load(br);
            boolean parseMethodCallTypeValue = Boolean.parseBoolean(javaCGConfigureWrapper.getConfig(properties, JavaCGConfigKeyEnum.CKE_PARSE_METHOD_CALL_TYPE_VALUE, true));
            boolean firstParseInitMethodType = Boolean.parseBoolean(javaCGConfigureWrapper.getConfig(properties, JavaCGConfigKeyEnum.CKE_FIRST_PARSE_INIT_METHOD_TYPE, true));
            boolean analyseFieldRelationship = Boolean.parseBoolean(javaCGConfigureWrapper.getConfig(properties, JavaCGConfigKeyEnum.CKE_ANALYSE_FIELD_RELATIONSHIP, true));
            if (!parseMethodCallTypeValue) {
                if (firstParseInitMethodType) {
                    logger.error("\u914d\u7f6e\u6587\u4ef6 {} \u4e2d\u7684 {} \u53c2\u6570\u503c\u4e3atrue\u65f6\uff0c {} \u53c2\u6570\u503c\u4e5f\u9700\u8981\u4e3atrue", new Object[]{configFileName, JavaCGConfigKeyEnum.CKE_FIRST_PARSE_INIT_METHOD_TYPE.getKey(), JavaCGConfigKeyEnum.CKE_PARSE_METHOD_CALL_TYPE_VALUE.getKey()});
                    JavaCGConfInfo javaCGConfInfo = null;
                    return javaCGConfInfo;
                }
                if (analyseFieldRelationship) {
                    logger.error("\u914d\u7f6e\u6587\u4ef6 {} \u4e2d\u7684 {} \u53c2\u6570\u503c\u4e3atrue\u65f6\uff0c {} \u53c2\u6570\u503c\u4e5f\u9700\u8981\u4e3atrue", new Object[]{configFileName, JavaCGConfigKeyEnum.CKE_ANALYSE_FIELD_RELATIONSHIP.getKey(), JavaCGConfigKeyEnum.CKE_PARSE_METHOD_CALL_TYPE_VALUE.getKey()});
                    JavaCGConfInfo javaCGConfInfo = null;
                    return javaCGConfInfo;
                }
            }
            confInfo.setParseMethodCallTypeValue(parseMethodCallTypeValue);
            confInfo.setFirstParseInitMethodType(firstParseInitMethodType);
            confInfo.setAnalyseFieldRelationship(analyseFieldRelationship);
            confInfo.setContinueWhenError(Boolean.parseBoolean(javaCGConfigureWrapper.getConfig(properties, JavaCGConfigKeyEnum.CKE_CONTINUE_WHEN_ERROR, true)));
            confInfo.setLogMethodSpendTime(Boolean.parseBoolean(javaCGConfigureWrapper.getConfig(properties, JavaCGConfigKeyEnum.CKE_LOG_METHOD_SPEND_TIME, true)));
            String outputRootPath = javaCGConfigureWrapper.getConfig(properties, JavaCGConfigKeyEnum.CKE_OUTPUT_ROOT_PATH, true);
            confInfo.setOutputRootPath(outputRootPath);
            String outputFileExt = javaCGConfigureWrapper.getConfig(properties, JavaCGConfigKeyEnum.CKE_OUTPUT_FILE_EXT, true);
            if (StringUtils.isBlank((CharSequence)outputFileExt)) {
                confInfo.setOutputFileExt(".txt");
            } else {
                confInfo.setOutputFileExt(outputFileExt);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u914d\u7f6e\u53c2\u6570\u51fa\u73b0\u5f02\u5e38 ", (Throwable)e);
            return null;
        }
        List<String> jarDirList = javaCGConfigureWrapper.getOtherConfigList(JavaCGOtherConfigFileUseListEnum.OCFULE_JAR_DIR, true);
        confInfo.setJarDirList(jarDirList);
        Set<String> needHandlePackageSet = javaCGConfigureWrapper.getOtherConfigSet(JavaCGOtherConfigFileUseSetEnum.OCFUSE_PACKAGES, true);
        confInfo.setNeedHandlePackageSet(needHandlePackageSet);
        Set<String> tmpJarDirMergeFileTypeSet = javaCGConfigureWrapper.getOtherConfigSet(JavaCGOtherConfigFileUseSetEnum.OCFUSE_JAR_DIR_MERGE_FILE_TYPE, true);
        HashSet<String> jarDirMergeFileTypeSet = new HashSet<String>(tmpJarDirMergeFileTypeSet.size());
        Iterator<String> firstParseInitMethodType = tmpJarDirMergeFileTypeSet.iterator();
        while (true) {
            if (!firstParseInitMethodType.hasNext()) {
                confInfo.setJarDirMergeFileTypeSet(jarDirMergeFileTypeSet);
                Set<String> ignoreJarFileKeywordSet = javaCGConfigureWrapper.getOtherConfigSet(JavaCGOtherConfigFileUseSetEnum.OCFUSE_IGNORE_JAR_FILE_KEYWORD, true);
                confInfo.setIgnoreJarFileKeywordSet(ignoreJarFileKeywordSet);
                Set<String> ignoreJarFileNameSet = javaCGConfigureWrapper.getOtherConfigSet(JavaCGOtherConfigFileUseSetEnum.OCFUSE_IGNORE_JAR_FILE_NAME, true);
                confInfo.setIgnoreJarFileNameSet(ignoreJarFileNameSet);
                if (JavaCGConfManager.handleFrEqConversionMethod(javaCGConfigureWrapper, confInfo)) return confInfo;
                return null;
            }
            String tmpJarDirMergeFileType = firstParseInitMethodType.next();
            jarDirMergeFileTypeSet.add(tmpJarDirMergeFileType.toLowerCase());
        }
    }

    private static boolean handleFrEqConversionMethod(JavaCGConfigureWrapper javaCGConfigureWrapper, JavaCGConfInfo confInfo) {
        HashMap<String, Map<String, Integer>> frEqConversionMethodMap = new HashMap<String, Map<String, Integer>>();
        confInfo.setFrEqConversionMethodMap(frEqConversionMethodMap);
        Set<String> frEqConversionMethodSet = javaCGConfigureWrapper.getOtherConfigSet(JavaCGOtherConfigFileUseSetEnum.OCFUSE_FR_EQ_CONVERSION_METHOD, true);
        if (JavaCGUtil.isCollectionEmpty(frEqConversionMethodSet)) {
            return true;
        }
        for (String frEqConversionMethod : frEqConversionMethodSet) {
            String[] data1 = StringUtils.splitPreserveAllTokens((String)frEqConversionMethod, (String)"=");
            if (data1.length != 2) {
                logger.error("\u914d\u7f6e\u6587\u4ef6\u5185\u5bb9\u4e0d\u662f\u5408\u6cd5\u7684properties\u53c2\u6570 {} {}", (Object)JavaCGOtherConfigFileUseSetEnum.OCFUSE_FR_EQ_CONVERSION_METHOD.getFileName(), (Object)frEqConversionMethod);
                return false;
            }
            String classAndMethod = data1[0];
            int argObjSeq = Integer.parseInt(data1[1]);
            if (argObjSeq < 0) {
                logger.error("\u914d\u7f6e\u6587\u4ef6\u88ab\u8c03\u7528\u5bf9\u8c61\uff08\u4f7f\u75280\u8868\u793a\uff09\u6216\u65b9\u6cd5\u53c2\u6570\uff08\u4ece1\u5f00\u59cb\uff09\u5e8f\u53f7\u975e\u6cd5 {} {}", (Object)JavaCGOtherConfigFileUseSetEnum.OCFUSE_FR_EQ_CONVERSION_METHOD.getFileName(), (Object)frEqConversionMethod);
                return false;
            }
            String[] data2 = StringUtils.splitPreserveAllTokens((String)classAndMethod, (String)":");
            if (data2.length != 2) {
                logger.error("\u914d\u7f6e\u6587\u4ef6\u5185\u5bb9\u4e0d\u662f\u5408\u6cd5\u7684\u7c7b\u540d\u4e0e\u65b9\u6cd5\u540d {} {}", (Object)JavaCGOtherConfigFileUseSetEnum.OCFUSE_FR_EQ_CONVERSION_METHOD.getFileName(), (Object)frEqConversionMethod);
                return false;
            }
            String className = data2[0];
            String methodName = data2[1];
            Map methodMap = frEqConversionMethodMap.computeIfAbsent(className, k -> new HashMap());
            methodMap.put(methodName, argObjSeq);
        }
        return true;
    }

    public static String getInputRootPath() {
        return JavaCGUtil.getDirPathInJvmOptions("input.root.path");
    }

    private JavaCGConfManager() {
        throw new IllegalStateException("illegal");
    }
}

