/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.dto.call;

import com.adrninistrator.javacg.dto.call.MethodCallPossibleEntry;
import com.adrninistrator.javacg.dto.element.BaseElement;
import com.adrninistrator.javacg.dto.element.variable.FieldElement;
import com.adrninistrator.javacg.dto.element.variable.LocalVariableElement;
import com.adrninistrator.javacg.dto.element.variable.StaticFieldElement;
import com.adrninistrator.javacg.dto.element.variable.StaticFieldMethodCallElement;
import com.adrninistrator.javacg.dto.element.variable.VariableElement;
import com.adrninistrator.javacg.dto.field.FieldTypeAndName;
import com.adrninistrator.javacg.dto.field.StaticFieldTypeAndName;
import com.adrninistrator.javacg.dto.variabledatasource.AbstractVariableDataSource;
import com.adrninistrator.javacg.dto.variabledatasource.VariableDataSourceMethodArg;
import com.adrninistrator.javacg.dto.variabledatasource.VariableDataSourceMethodCallReturn;
import com.adrninistrator.javacg.util.JavaCGByteCodeUtil;
import com.adrninistrator.javacg.util.JavaCGClassMethodUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodCallPossibleList {
    private static final Logger logger = LoggerFactory.getLogger(MethodCallPossibleList.class);
    private List<MethodCallPossibleEntry> methodCallPossibleEntryList;
    private int nonStaticFieldNum;
    private int typeNum;
    private boolean arrayElement;

    public void addPossibleInfo(BaseElement baseElement, String definedType, List<BaseElement> handledElementList) {
        Object value;
        if (baseElement == null) {
            return;
        }
        handledElementList.add(baseElement);
        String type = baseElement.getType();
        MethodCallPossibleEntry addedMethodCallPossibleEntry = new MethodCallPossibleEntry();
        if (baseElement instanceof StaticFieldMethodCallElement) {
            String staticFieldMethodCallInfo = ((StaticFieldMethodCallElement)baseElement).getInfo();
            addedMethodCallPossibleEntry.setStaticFieldMethodCall(staticFieldMethodCallInfo);
        } else if (baseElement instanceof StaticFieldElement) {
            StaticFieldElement staticFieldElement = (StaticFieldElement)baseElement;
            StaticFieldTypeAndName staticField = new StaticFieldTypeAndName(type, staticFieldElement.getName(), staticFieldElement.getClassName());
            addedMethodCallPossibleEntry.setStaticField(staticField);
        } else if (baseElement instanceof FieldElement) {
            FieldElement fieldElement = (FieldElement)baseElement;
            FieldTypeAndName fieldTypeAndName = new FieldTypeAndName(fieldElement.getType(), fieldElement.getName());
            addedMethodCallPossibleEntry.setNonStaticField(fieldTypeAndName);
        } else if (baseElement instanceof LocalVariableElement) {
            addedMethodCallPossibleEntry.setNameOfVariable(((LocalVariableElement)baseElement).getName());
        }
        if (baseElement instanceof VariableElement) {
            VariableElement variableElement = (VariableElement)baseElement;
            AbstractVariableDataSource variableDataSource = variableElement.getVariableDataSource();
            if (variableDataSource instanceof VariableDataSourceMethodCallReturn) {
                VariableDataSourceMethodCallReturn variableDataSourceMethodCallReturn = (VariableDataSourceMethodCallReturn)variableDataSource;
                String calleeFullMethod = JavaCGClassMethodUtil.formatFullMethod(variableDataSourceMethodCallReturn.getCalleeClassName(), variableDataSourceMethodCallReturn.getCalleeMethodName(), variableDataSourceMethodCallReturn.getCalleeArgTypeStr());
                addedMethodCallPossibleEntry.setMethodCallReturnFullMethod(calleeFullMethod);
                addedMethodCallPossibleEntry.setMethodCallReturnInstructionPosition(variableDataSourceMethodCallReturn.getInvokeInstructionPosition());
            } else if (variableDataSource instanceof VariableDataSourceMethodArg) {
                VariableDataSourceMethodArg variableDataSourceMethodArg = (VariableDataSourceMethodArg)variableDataSource;
                addedMethodCallPossibleEntry.setMethodArgSeq(variableDataSourceMethodArg.getArgSeq());
            }
            AbstractVariableDataSource variableDataSourceEQC = variableElement.getVariableDataSourceEQC();
            if (variableDataSourceEQC instanceof VariableDataSourceMethodCallReturn) {
                VariableDataSourceMethodCallReturn variableDataSourceMethodCallEQC = (VariableDataSourceMethodCallReturn)variableDataSourceEQC;
                String calleeFullMethod = JavaCGClassMethodUtil.formatFullMethod(variableDataSourceMethodCallEQC.getCalleeClassName(), variableDataSourceMethodCallEQC.getCalleeMethodName(), variableDataSourceMethodCallEQC.getCalleeArgTypeStr());
                addedMethodCallPossibleEntry.setMethodCallReturnFullMethodEQC(calleeFullMethod);
                addedMethodCallPossibleEntry.setMethodCallReturnInstructionPositionEQC(variableDataSourceMethodCallEQC.getInvokeInstructionPosition());
            } else if (variableDataSourceEQC instanceof VariableDataSourceMethodArg) {
                VariableDataSourceMethodArg variableDataSourceMethodArgEQC = (VariableDataSourceMethodArg)variableDataSourceEQC;
                addedMethodCallPossibleEntry.setMethodArgSeqEQC(variableDataSourceMethodArgEQC.getArgSeq());
            }
            Integer catchExceptionStartPosition = variableElement.getCatchExceptionStartPosition();
            if (catchExceptionStartPosition != null) {
                addedMethodCallPossibleEntry.setCatchExceptionStartPosition(catchExceptionStartPosition);
            }
        }
        if (!(JavaCGByteCodeUtil.isNullType(type) || type.equals(definedType) || JavaCGByteCodeUtil.compareIntType(type, definedType) || JavaCGByteCodeUtil.compareByteBooleanType(type, definedType))) {
            addedMethodCallPossibleEntry.setType(type);
        }
        if ((value = baseElement.getValue()) != null) {
            addedMethodCallPossibleEntry.setValueType(type);
            addedMethodCallPossibleEntry.setValue(value);
        }
        if (addedMethodCallPossibleEntry.hasContent()) {
            if (this.methodCallPossibleEntryList == null) {
                this.methodCallPossibleEntryList = new ArrayList<MethodCallPossibleEntry>();
            }
            boolean existed = false;
            for (MethodCallPossibleEntry existedMethodCallPossibleEntry : this.methodCallPossibleEntryList) {
                if (!existedMethodCallPossibleEntry.compare(addedMethodCallPossibleEntry)) continue;
                existed = true;
                break;
            }
            if (!existed) {
                this.addEntry(addedMethodCallPossibleEntry);
            }
        }
        if (baseElement.isArrayElement()) {
            this.arrayElement = true;
            Map<Integer, BaseElement> map = baseElement.getArrayValueMap();
            if (!map.isEmpty()) {
                ArrayList<Integer> keyList = new ArrayList<Integer>(map.keySet());
                Collections.sort(keyList);
                for (Integer key : keyList) {
                    BaseElement arrayElement = map.get(key);
                    if (handledElementList.contains(arrayElement)) {
                        logger.warn("\u51fa\u73b0\u6570\u7ec4\u5143\u7d20\u7684\u5faa\u73af\u5f15\u7528 {}", (Object)arrayElement.getType());
                        continue;
                    }
                    String arrayElementType = JavaCGByteCodeUtil.isArrayType(definedType) ? JavaCGByteCodeUtil.removeArrayFlag(definedType) : definedType;
                    this.addPossibleInfo(arrayElement, arrayElementType, handledElementList);
                }
            }
        }
    }

    private void addEntry(MethodCallPossibleEntry addedMethodCallPossibleEntry) {
        this.methodCallPossibleEntryList.add(addedMethodCallPossibleEntry);
        if (addedMethodCallPossibleEntry.getNonStaticField() != null) {
            ++this.nonStaticFieldNum;
        }
        if (addedMethodCallPossibleEntry.getType() != null) {
            ++this.typeNum;
        }
    }

    public boolean hasNonStaticField() {
        return this.nonStaticFieldNum > 0;
    }

    public boolean hasType() {
        return this.typeNum > 0;
    }

    public List<MethodCallPossibleEntry> getMethodCallPossibleEntryList() {
        return this.methodCallPossibleEntryList;
    }

    public boolean isArrayElement() {
        return this.arrayElement;
    }
}

