/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.dto.frame;

import com.adrninistrator.javacg.util.JavaCGInstructionUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public class InstructionStepList {
    private List<Integer> positionList = new ArrayList<Integer>();
    private List<String> instructionPrintInfoList = new ArrayList<String>();

    public void add(InstructionHandle ih, int lineNumber) {
        String instructionInfo4Print = JavaCGInstructionUtil.getInstructionHandlePrintInfo(ih) + " (" + lineNumber + ")";
        this.positionList.add(ih.getPosition());
        this.instructionPrintInfoList.add(instructionInfo4Print);
    }

    public void clear() {
        this.positionList.clear();
        this.instructionPrintInfoList.clear();
    }

    public InstructionStepList copy() {
        InstructionStepList instructionStepCopy = new InstructionStepList();
        instructionStepCopy.positionList = new ArrayList<Integer>(this.positionList);
        instructionStepCopy.instructionPrintInfoList = new ArrayList<String>(this.instructionPrintInfoList);
        return instructionStepCopy;
    }

    public String genInstructionStepHash() {
        String instructionPositionStr = StringUtils.join(this.positionList, (String)" ");
        return DigestUtils.md5Hex((String)instructionPositionStr);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String instructionPrintInfo : this.instructionPrintInfoList) {
            stringBuilder.append(instructionPrintInfo).append("\n");
        }
        return stringBuilder.toString();
    }
}

