/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.dto.frame;

import com.adrninistrator.javacg.dto.element.BaseElement;
import com.adrninistrator.javacg.exceptions.JavaCGRuntimeException;
import com.adrninistrator.javacg.util.JavaCGElementUtil;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaCGOperandStack {
    private static final Logger logger = LoggerFactory.getLogger(JavaCGOperandStack.class);
    private final BaseElement[] elements;
    private int head = 0;
    private final int capacity;

    public JavaCGOperandStack(int capacity) {
        this.elements = new BaseElement[capacity];
        this.capacity = capacity;
    }

    public int size() {
        return this.head;
    }

    public boolean isEmpty() {
        return this.head == 0;
    }

    public void push(BaseElement element) {
        if (element == null) {
            logger.error("push\u7684\u5143\u7d20\u4e3anull {}", (Object)this.head);
            throw new JavaCGRuntimeException("push\u7684\u5143\u7d20\u4e3anull");
        }
        if (this.head >= this.capacity) {
            logger.error("\u6808\u5df2\u6ee1 {} {}", (Object)this.head, (Object)element);
            throw new JavaCGRuntimeException("\u6808\u5df2\u6ee1");
        }
        this.elements[this.head++] = element;
        logger.debug("\u5165\u64cd\u4f5c\u6570\u6808\u540e size: {} {}", (Object)this.head, (Object)element);
    }

    public BaseElement pop() {
        if (this.head == 0) {
            logger.error("\u6808\u4e3a\u7a7a\uff0c\u4e0d\u652f\u6301pop");
            throw new JavaCGRuntimeException("\u6808\u4e3a\u7a7a\uff0c\u4e0d\u652f\u6301pop");
        }
        BaseElement element = this.elements[--this.head];
        logger.debug("\u51fa\u64cd\u4f5c\u6570\u6808\u540e size: {} {}", (Object)this.head, (Object)element);
        this.elements[this.head] = null;
        return element;
    }

    public BaseElement peek() {
        if (this.head == 0) {
            logger.error("\u6808\u4e3a\u7a7a\uff0c\u4e0d\u652f\u6301peek");
            throw new JavaCGRuntimeException("\u6808\u4e3a\u7a7a\uff0c\u4e0d\u652f\u6301peek");
        }
        return this.elements[this.head - 1];
    }

    public BaseElement getFromTop(int interval) {
        int index = this.head - 1 - interval;
        if (index < 0) {
            return null;
        }
        return this.elements[index];
    }

    public void clear() {
        for (int i = 0; i < this.head; ++i) {
            this.elements[i] = null;
        }
        this.head = 0;
    }

    public JavaCGOperandStack copy() {
        JavaCGOperandStack javaCGOperandStackCopy = new JavaCGOperandStack(this.capacity);
        for (int i = 0; i < this.head; ++i) {
            javaCGOperandStackCopy.elements[i] = this.elements[i].copyElement();
        }
        javaCGOperandStackCopy.head = this.head;
        return javaCGOperandStackCopy;
    }

    public static void compareLooseMode(JavaCGOperandStack existed, JavaCGOperandStack added, Set<Integer> sameStackSeqSet) {
        if (existed.head != added.head) {
            return;
        }
        for (int i = 0; i < existed.head; ++i) {
            if (added.elements[i] != null && (existed.elements[i] == null || !JavaCGElementUtil.compare(existed.elements[i], added.elements[i]))) continue;
            sameStackSeqSet.add(i);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("head: ").append(this.head).append("\n");
        for (int i = 0; i < this.head; ++i) {
            BaseElement baseElement = this.elements[i];
            stringBuilder.append(i).append(" ");
            if (baseElement != null) {
                stringBuilder.append(baseElement);
            } else {
                stringBuilder.append("null");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

