/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.handler;

import com.adrninistrator.javacg.common.enums.JavaCGConfigKeyEnum;
import com.adrninistrator.javacg.conf.JavaCGConfInfo;
import com.adrninistrator.javacg.dto.counter.JavaCGCounter;
import com.adrninistrator.javacg.dto.field.FieldPossibleTypes;
import com.adrninistrator.javacg.dto.fieldrelationship.GetSetFieldRelationship;
import com.adrninistrator.javacg.dto.instruction.InvokeInstructionPosAndCallee;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMethodHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMethodHandler.class);
    protected final String callerClassName;
    protected final String callerMethodName;
    protected final Type[] callerArgTypes;
    protected final String callerFullMethod;
    protected final Method method;
    protected final MethodGen mg;
    protected final JavaClass javaClass;
    protected final JavaCGConfInfo javaCGConfInfo;
    protected final ConstantPoolGen cpg;
    protected final LineNumberTable lineNumberTable;
    protected final boolean continueWhenError;
    protected InstructionHandle ih;
    protected boolean parseMethodCallTypeValueFlag;
    protected boolean inClinitMethod;
    protected Set<String> recordedSetMethodSet;
    protected JavaCGCounter failCounter;
    protected Writer getMethodWriter;
    protected Writer setMethodWriter;
    protected Writer fieldGenericsTypeWriter;
    protected FieldPossibleTypes nonStaticFieldPossibleTypes;
    protected Map<String, String> nonStaticFieldNameTypeMap;
    protected Map<String, List<String>> nonStaticFieldNameGenericsTypeMap;
    protected Map<String, List<InvokeInstructionPosAndCallee>> sfFieldInvokeInstructionMap;
    protected Set<String> recordedFieldWithGenericsTypeSet;
    protected List<Integer> methodReturnArgSeqList;
    protected List<Integer> methodReturnPositionList;
    protected List<Integer> methodReturnArgSeqEQCList;
    protected List<Integer> methodReturnPositionEQCList;
    protected List<GetSetFieldRelationship> getSetFieldRelationshipList;
    protected JavaCGCounter fieldRelationshipCounter;
    protected String methodReturnType;

    protected AbstractMethodHandler(Method method, MethodGen mg, JavaClass javaClass, String callerFullMethod, JavaCGConfInfo javaCGConfInfo) {
        this.method = method;
        this.mg = mg;
        this.javaClass = javaClass;
        this.callerFullMethod = callerFullMethod;
        this.javaCGConfInfo = javaCGConfInfo;
        this.callerClassName = javaClass.getClassName();
        this.callerMethodName = mg.getName();
        this.callerArgTypes = mg.getArgumentTypes();
        this.cpg = mg.getConstantPool();
        this.lineNumberTable = mg.getLineNumberTable(this.cpg);
        this.methodReturnType = mg.getReturnType().toString();
        this.continueWhenError = javaCGConfInfo != null && javaCGConfInfo.isContinueWhenError();
    }

    protected void init() {
    }

    protected abstract boolean preHandleMethod() throws IOException;

    protected abstract boolean doHandleMethod() throws IOException;

    protected boolean lastStep() throws IOException {
        return true;
    }

    public boolean handleMethod() {
        try {
            this.init();
            if (this.preHandleMethod() && !this.doHandleMethod()) {
                this.failCounter.addAndGet();
                return this.continueWhenError;
            }
            boolean success = this.lastStep();
            if (!success) {
                this.failCounter.addAndGet();
            }
            return success;
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u9700\u8981\u5206\u6790\u539f\u56e0 {} {}", new Object[]{this.callerClassName, this.callerMethodName, e});
            this.failCounter.addAndGet();
            if (this.continueWhenError) {
                return true;
            }
            logger.info("\u5047\u5982\u5728\u5904\u7406\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\u65f6\u9700\u8981\u7ee7\u7eed\u6267\u884c\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6 {} \u4e2d\u6307\u5b9a\u53c2\u6570 {}", (Object)"config.properties", (Object)(JavaCGConfigKeyEnum.CKE_CONTINUE_WHEN_ERROR.getKey() + "=" + Boolean.TRUE));
            return false;
        }
    }

    protected int getSourceLine() {
        return this.getSourceLine(this.ih.getPosition());
    }

    protected int getSourceLine(int instructionPosition) {
        if (this.lineNumberTable == null) {
            return 0;
        }
        int sourceLine = this.lineNumberTable.getSourceLine(instructionPosition);
        return Math.max(sourceLine, 0);
    }

    public void setParseMethodCallTypeValueFlag(boolean parseMethodCallTypeValueFlag) {
        this.parseMethodCallTypeValueFlag = parseMethodCallTypeValueFlag;
    }

    public void setInClinitMethod(boolean inClinitMethod) {
        this.inClinitMethod = inClinitMethod;
    }

    public void setRecordedSetMethodSet(Set<String> recordedSetMethodSet) {
        this.recordedSetMethodSet = recordedSetMethodSet;
    }

    public void setFailCounter(JavaCGCounter failCounter) {
        this.failCounter = failCounter;
    }

    public void setGetMethodWriter(Writer getMethodWriter) {
        this.getMethodWriter = getMethodWriter;
    }

    public void setSetMethodWriter(Writer setMethodWriter) {
        this.setMethodWriter = setMethodWriter;
    }

    public void setFieldGenericsTypeWriter(Writer fieldGenericsTypeWriter) {
        this.fieldGenericsTypeWriter = fieldGenericsTypeWriter;
    }

    public void setNonStaticFieldPossibleTypes(FieldPossibleTypes nonStaticFieldPossibleTypes) {
        this.nonStaticFieldPossibleTypes = nonStaticFieldPossibleTypes;
    }

    public void setNonStaticFieldNameTypeMap(Map<String, String> nonStaticFieldNameTypeMap) {
        this.nonStaticFieldNameTypeMap = nonStaticFieldNameTypeMap;
    }

    public void setNonStaticFieldNameGenericsTypeMap(Map<String, List<String>> nonStaticFieldNameGenericsTypeMap) {
        this.nonStaticFieldNameGenericsTypeMap = nonStaticFieldNameGenericsTypeMap;
    }

    public void setSfFieldInvokeInstructionMap(Map<String, List<InvokeInstructionPosAndCallee>> sfFieldInvokeInstructionMap) {
        this.sfFieldInvokeInstructionMap = sfFieldInvokeInstructionMap;
    }

    public void setRecordedFieldWithGenericsTypeSet(Set<String> recordedFieldWithGenericsTypeSet) {
        this.recordedFieldWithGenericsTypeSet = recordedFieldWithGenericsTypeSet;
    }

    public void setMethodReturnArgSeqList(List<Integer> methodReturnArgSeqList) {
        this.methodReturnArgSeqList = methodReturnArgSeqList;
    }

    public void setMethodReturnPositionList(List<Integer> methodReturnPositionList) {
        this.methodReturnPositionList = methodReturnPositionList;
    }

    public void setMethodReturnArgSeqEQCList(List<Integer> methodReturnArgSeqEQCList) {
        this.methodReturnArgSeqEQCList = methodReturnArgSeqEQCList;
    }

    public void setMethodReturnPositionEQCList(List<Integer> methodReturnPositionEQCList) {
        this.methodReturnPositionEQCList = methodReturnPositionEQCList;
    }

    public void setGetSetFieldRelationshipList(List<GetSetFieldRelationship> getSetFieldRelationshipList) {
        this.getSetFieldRelationshipList = getSetFieldRelationshipList;
    }

    public void setFieldRelationshipCounter(JavaCGCounter fieldRelationshipCounter) {
        this.fieldRelationshipCounter = fieldRelationshipCounter;
    }
}

