/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.handler;

import com.adrninistrator.javacg.common.enums.JavaCGConstantTypeEnum;
import com.adrninistrator.javacg.common.enums.JavaCGYesNoEnum;
import com.adrninistrator.javacg.conf.JavaCGConfInfo;
import com.adrninistrator.javacg.dto.counter.JavaCGCounter;
import com.adrninistrator.javacg.dto.field.FieldPossibleTypes;
import com.adrninistrator.javacg.dto.instruction.InvokeInstructionPosAndCallee;
import com.adrninistrator.javacg.dto.jar.ClassAndJarNum;
import com.adrninistrator.javacg.extensions.annotationattributes.AnnotationAttributesFormatterInterface;
import com.adrninistrator.javacg.extensions.manager.ExtensionsManager;
import com.adrninistrator.javacg.handler.MethodHandler4Invoke;
import com.adrninistrator.javacg.handler.MethodHandler4TypeAndValue;
import com.adrninistrator.javacg.spring.UseSpringBeanByAnnotationHandler;
import com.adrninistrator.javacg.util.JavaCGAnnotationUtil;
import com.adrninistrator.javacg.util.JavaCGByteCodeUtil;
import com.adrninistrator.javacg.util.JavaCGClassMethodUtil;
import com.adrninistrator.javacg.util.JavaCGFileUtil;
import com.adrninistrator.javacg.util.JavaCGSignatureUtil;
import com.adrninistrator.javacg.util.JavaCGUtil;
import com.adrninistrator.javacg.writer.WriterSupportSkip;
import copy.javassist.bytecode.BadBytecode;
import copy.javassist.bytecode.SignatureAttribute;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.MethodParameter;
import org.apache.bcel.classfile.MethodParameters;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Type;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassHandler {
    private static final Logger logger = LoggerFactory.getLogger(ClassHandler.class);
    private final JavaClass javaClass;
    private final String classFileName;
    private final ConstantPoolGen cpg;
    private final Set<String> handledMethodNameAndArgs;
    private final String className;
    private final JavaCGConfInfo javaCGConfInfo;
    private final String classJarNum;
    private UseSpringBeanByAnnotationHandler useSpringBeanByAnnotationHandler;
    private Map<String, Boolean> runnableImplClassMap;
    private Map<String, Boolean> callableImplClassMap;
    private Map<String, Boolean> transactionCallbackImplClassMap;
    private Map<String, Boolean> transactionCallbackWithoutResultChildClassMap;
    private Map<String, Boolean> threadChildClassMap;
    private ExtensionsManager extensionsManager;
    private JavaCGCounter callIdCounter;
    private JavaCGCounter methodNumCounter;
    private JavaCGCounter failCounter;
    private JavaCGCounter fieldRelationshipCounter;
    private Writer classReferenceWriter;
    private Writer methodCallWriter;
    private Writer lambdaMethodInfoWriter;
    private Writer classAnnotationWriter;
    private Writer methodAnnotationWriter;
    private Writer fieldAnnotationWriter;
    private Writer fieldInfoWriter;
    private Writer methodLineNumberWriter;
    private Writer methodCallInfoWriter;
    private Writer methodCallMethodCallReturnWriter;
    private Writer methodCallStaticFieldWriter;
    private Writer methodReturnArgSeqWriter;
    private Writer methodReturnCallIdWriter;
    private Writer methodInfoWriter;
    private Writer methodArgumentWriter;
    private Writer methodArgAnnotationWriter;
    private Writer methodArgGenericsTypeWriter;
    private Writer methodReturnGenericsTypeWriter;
    private Writer methodCatchWriter;
    private Writer methodFinallyWriter;
    private Writer methodThrowWriter;
    private Writer getMethodWriter;
    private Writer setMethodWriter;
    private Writer fieldGenericsTypeWriter;
    private Writer fieldRelationshipWriter;
    private Writer staticFinalFieldMethodCallIdWriter;
    private WriterSupportSkip logMethodSpendTimeWriter;
    private AnnotationAttributesFormatterInterface annotationAttributesFormatter;
    private int lastJarNum;
    private ClassAndJarNum classAndJarNum;
    private FieldPossibleTypes nonStaticFieldPossibleTypes;
    private Set<String> recordedSetMethodSet;

    public ClassHandler(JavaClass javaClass, String classFileName, JavaCGConfInfo javaCGConfInfo, String classJarNum) {
        this.javaClass = javaClass;
        this.classFileName = classFileName;
        this.javaCGConfInfo = javaCGConfInfo;
        this.classJarNum = classJarNum;
        this.className = javaClass.getClassName();
        this.cpg = new ConstantPoolGen(javaClass.getConstantPool());
        this.handledMethodNameAndArgs = new HashSet<String>();
        if (javaCGConfInfo.isParseMethodCallTypeValue()) {
            this.recordedSetMethodSet = new HashSet<String>();
        }
        if (javaCGConfInfo.isFirstParseInitMethodType()) {
            this.nonStaticFieldPossibleTypes = new FieldPossibleTypes();
        }
    }

    private void recordReferencedClass() throws IOException {
        ConstantPool constantPool = this.javaClass.getConstantPool();
        HashSet<String> referencedClassSet = new HashSet<String>();
        for (int i = 0; i < constantPool.getLength(); ++i) {
            String referencedClass;
            Constant constant = null;
            try {
                constant = constantPool.getConstant(i);
            }
            catch (ClassFormatException classFormatException) {
                // empty catch block
            }
            if (constant == null || constant.getTag() != 7 || JavaCGClassMethodUtil.isObjectClass(referencedClass = constantPool.constantToString(constant))) continue;
            referencedClass = JavaCGByteCodeUtil.removeArrayInClassName(referencedClass);
            referencedClassSet.add(referencedClass);
        }
        ArrayList referencedClassList = new ArrayList(referencedClassSet);
        Collections.sort(referencedClassList);
        for (String referencedClass : referencedClassList) {
            if (JavaCGUtil.checkSkipClass(referencedClass, this.javaCGConfInfo.getNeedHandlePackageSet())) continue;
            JavaCGFileUtil.write2FileWithTab(this.classReferenceWriter, this.className, referencedClass);
        }
        if (referencedClassList.isEmpty()) {
            JavaCGFileUtil.write2FileWithTab(this.classReferenceWriter, this.className, this.className);
        }
    }

    public boolean handleClass() throws IOException {
        this.recordReferencedClass();
        JavaCGAnnotationUtil.writeAnnotationInfo(this.classAnnotationWriter, this.javaClass.getAnnotationEntries(), this.annotationAttributesFormatter, this.className);
        if (this.javaCGConfInfo.isFirstParseInitMethodType()) {
            for (Method method : this.javaClass.getMethods()) {
                if (!JavaCGClassMethodUtil.isInitMethod(method.getName()) || this.parseInitMethod(method)) continue;
                return false;
            }
        }
        HashMap<String, String> nonStaticFieldNameTypeMap = new HashMap<String, String>();
        HashMap<String, List<String>> nonStaticFieldNameGenericsTypeMap = new HashMap<String, List<String>>();
        HashMap<String, List<InvokeInstructionPosAndCallee>> sfFieldInvokeInstructionMap = new HashMap<String, List<InvokeInstructionPosAndCallee>>();
        HashMap<String, String> staticFinalFieldNameTypeMap = new HashMap<String, String>();
        HashSet<String> recordedFieldWithGenericsTypeSet = new HashSet<String>();
        for (Field field : this.javaClass.getFields()) {
            this.handleField(field, nonStaticFieldNameTypeMap, nonStaticFieldNameGenericsTypeMap, sfFieldInvokeInstructionMap, staticFinalFieldNameTypeMap);
        }
        for (Field field : this.javaClass.getMethods()) {
            if (this.handleMethod((Method)field, nonStaticFieldNameTypeMap, nonStaticFieldNameGenericsTypeMap, sfFieldInvokeInstructionMap, staticFinalFieldNameTypeMap, recordedFieldWithGenericsTypeSet)) continue;
            return false;
        }
        return true;
    }

    private boolean parseInitMethod(Method method) {
        MethodGen mg = new MethodGen(method, this.className, this.cpg);
        String callerFullMethod = JavaCGClassMethodUtil.formatFullMethod(this.className, method.getName(), method.getArgumentTypes());
        MethodHandler4TypeAndValue methodHandler4TypeAndValue = new MethodHandler4TypeAndValue(method, mg, this.javaClass, callerFullMethod, this.javaCGConfInfo);
        methodHandler4TypeAndValue.setFailCounter(this.failCounter);
        methodHandler4TypeAndValue.setRecordFieldPossibleTypeFlag(true);
        methodHandler4TypeAndValue.setUseFieldPossibleTypeFlag(false);
        methodHandler4TypeAndValue.setAnalyseFieldRelationshipFlag(false);
        methodHandler4TypeAndValue.setOnlyAnalyseReturnTypeFlag(false);
        methodHandler4TypeAndValue.setNonStaticFieldPossibleTypes(this.nonStaticFieldPossibleTypes);
        return methodHandler4TypeAndValue.handleMethod();
    }

    private void handleField(Field field, Map<String, String> nonStaticFieldNameTypeMap, Map<String, List<String>> nonStaticFieldNameGenericsTypeMap, Map<String, List<InvokeInstructionPosAndCallee>> sfFieldInvokeInstructionMap, Map<String, String> staticFinalFieldNameTypeMap) throws IOException {
        String fieldName = field.getName();
        String fieldTypeStr = field.getType().toString();
        String fieldModifiers = JavaCGByteCodeUtil.getModifiersString(field.getAccessFlags());
        String primitiveType = JavaCGYesNoEnum.parseStrValue(JavaCGConstantTypeEnum.isPrimitiveType(fieldTypeStr));
        String staticFlag = JavaCGYesNoEnum.parseStrValue(field.isStatic());
        String finalFlag = JavaCGYesNoEnum.parseStrValue(field.isFinal());
        JavaCGFileUtil.write2FileWithTab(this.fieldInfoWriter, this.className, fieldName, fieldTypeStr, fieldModifiers, primitiveType, staticFlag, finalFlag);
        JavaCGAnnotationUtil.writeAnnotationInfo(this.fieldAnnotationWriter, field.getAnnotationEntries(), this.annotationAttributesFormatter, this.className, fieldName);
        if (this.javaCGConfInfo.isParseMethodCallTypeValue() && field.isStatic() && field.isFinal()) {
            sfFieldInvokeInstructionMap.put(fieldName, new ArrayList(1));
            staticFinalFieldNameTypeMap.put(fieldName, field.getType().toString());
        }
        if (!field.isStatic()) {
            try {
                String fieldGenericSignature = field.getGenericSignature();
                if (fieldGenericSignature != null) {
                    ArrayList<String> fieldGenericsTypeList = new ArrayList<String>();
                    SignatureAttribute.ObjectType fieldType = SignatureAttribute.toFieldSignature(fieldGenericSignature);
                    JavaCGSignatureUtil.parseTypeDefineGenericsType(fieldType, true, fieldGenericsTypeList);
                    if (!fieldGenericsTypeList.isEmpty()) {
                        nonStaticFieldNameGenericsTypeMap.put(fieldName, fieldGenericsTypeList);
                    }
                }
            }
            catch (BadBytecode e) {
                logger.error("\u5904\u7406\u5b57\u6bb5\u51fa\u73b0\u5f02\u5e38 {} {}", new Object[]{this.className, fieldName, e});
            }
            nonStaticFieldNameTypeMap.put(fieldName, field.getType().toString());
        }
    }

    private boolean handleMethod(Method method, Map<String, String> nonStaticFieldNameTypeMap, Map<String, List<String>> nonStaticFieldNameGenericsTypeMap, Map<String, List<InvokeInstructionPosAndCallee>> sfFieldInvokeInstructionMap, Map<String, String> staticFinalFieldNameTypeMap, Set<String> recordedFieldWithGenericsTypeSet) throws IOException {
        this.methodNumCounter.addAndGet();
        boolean existsSameMethodNameAndArgs = false;
        String methodArgTypes = JavaCGClassMethodUtil.getArgTypeStr(method.getArgumentTypes());
        String fullMethod = JavaCGClassMethodUtil.formatFullMethod(this.className, method.getName(), methodArgTypes);
        long startTime = 0L;
        if (this.javaCGConfInfo.isLogMethodSpendTime()) {
            startTime = System.currentTimeMillis();
            this.logMethodSpendTimeWriter.write(this.classFileName + "\t" + fullMethod);
        }
        logger.debug("\u5904\u7406Method: {}", (Object)fullMethod);
        String returnType = method.getReturnType().toString();
        String methodNameAndArgs = method.getName() + methodArgTypes;
        if (this.handledMethodNameAndArgs.add(methodNameAndArgs)) {
            Code code = method.getCode();
            String methodHash = "";
            if (code != null) {
                String methodCode = Utility.codeToString((byte[])code.getCode(), (ConstantPool)method.getConstantPool(), (int)0, (int)-1, (boolean)false);
                methodHash = DigestUtils.md5Hex((String)methodCode);
            }
            JavaCGFileUtil.write2FileWithTab(this.methodInfoWriter, fullMethod, String.valueOf(method.getAccessFlags()), returnType, methodHash, this.classJarNum);
        } else {
            existsSameMethodNameAndArgs = true;
            if (!JavaCGByteCodeUtil.isBridgeFlag(method.getAccessFlags())) {
                logger.error("\u51fa\u73b0\u65b9\u6cd5\u540d+\u53c2\u6570\u7c7b\u578b\u5747\u76f8\u540c\u7684\u65b9\u6cd5\uff0c\u4f46\u65b9\u6cd5\u6ca1\u6709ACC_BRIDGE\u6807\u5fd7\uff0c\u4e0e\u9884\u671f\u4e0d\u7b26 {} {}", (Object)this.className, (Object)methodNameAndArgs);
            }
        }
        String methodGenericSignature = method.getGenericSignature();
        if (methodGenericSignature != null) {
            try {
                SignatureAttribute.MethodSignature methodSignature = SignatureAttribute.toMethodSignature(methodGenericSignature);
                this.recordMethodReturnGenericsType(fullMethod, methodSignature);
                this.recordMethodArgsGenericsType(fullMethod, methodSignature);
            }
            catch (BadBytecode e) {
                logger.error("\u5904\u7406\u65b9\u6cd5\u7b7e\u540d\u51fa\u73b0\u5f02\u5e38 {}", (Object)fullMethod, (Object)e);
            }
        }
        MethodGen mg = new MethodGen(method, this.className, this.cpg);
        if (!existsSameMethodNameAndArgs) {
            this.recordMethodArgument(fullMethod, mg);
        }
        MethodHandler4Invoke methodHandler4Invoke = new MethodHandler4Invoke(method, mg, this.javaClass, this.javaCGConfInfo, methodArgTypes, fullMethod, this.useSpringBeanByAnnotationHandler, this.callIdCounter);
        methodHandler4Invoke.setFailCounter(this.failCounter);
        methodHandler4Invoke.setRunnableImplClassMap(this.runnableImplClassMap);
        methodHandler4Invoke.setCallableImplClassMap(this.callableImplClassMap);
        methodHandler4Invoke.setTransactionCallbackImplClassMap(this.transactionCallbackImplClassMap);
        methodHandler4Invoke.setTransactionCallbackWithoutResultChildClassMap(this.transactionCallbackWithoutResultChildClassMap);
        methodHandler4Invoke.setThreadChildClassMap(this.threadChildClassMap);
        methodHandler4Invoke.setExtensionsManager(this.extensionsManager);
        methodHandler4Invoke.setMethodCallWriter(this.methodCallWriter);
        methodHandler4Invoke.setLambdaMethodInfoWriter(this.lambdaMethodInfoWriter);
        methodHandler4Invoke.setMethodAnnotationWriter(this.methodAnnotationWriter);
        methodHandler4Invoke.setMethodArgAnnotationWriter(this.methodArgAnnotationWriter);
        methodHandler4Invoke.setMethodLineNumberWriter(this.methodLineNumberWriter);
        methodHandler4Invoke.setLastJarNum(this.lastJarNum);
        methodHandler4Invoke.setExistsSameMethodNameAndArgs(existsSameMethodNameAndArgs);
        methodHandler4Invoke.setClassAndJarNum(this.classAndJarNum);
        if (this.javaCGConfInfo.isParseMethodCallTypeValue()) {
            methodHandler4Invoke.setParseMethodCallTypeValueFlag(true);
            methodHandler4Invoke.setMethodCallInfoWriter(this.methodCallInfoWriter);
            methodHandler4Invoke.setMethodCallMethodCallReturnWriter(this.methodCallMethodCallReturnWriter);
            methodHandler4Invoke.setMethodCallStaticFieldWriter(this.methodCallStaticFieldWriter);
            methodHandler4Invoke.setMethodReturnArgSeqWriter(this.methodReturnArgSeqWriter);
            methodHandler4Invoke.setMethodReturnCallIdWriter(this.methodReturnCallIdWriter);
            methodHandler4Invoke.setMethodCatchWriter(this.methodCatchWriter);
            methodHandler4Invoke.setMethodFinallyWriter(this.methodFinallyWriter);
            methodHandler4Invoke.setMethodThrowWriter(this.methodThrowWriter);
            methodHandler4Invoke.setStaticFinalFieldMethodCallIdWriter(this.staticFinalFieldMethodCallIdWriter);
            methodHandler4Invoke.setGetMethodWriter(this.getMethodWriter);
            methodHandler4Invoke.setSetMethodWriter(this.setMethodWriter);
            methodHandler4Invoke.setFieldGenericsTypeWriter(this.fieldGenericsTypeWriter);
            methodHandler4Invoke.setRecordedSetMethodSet(this.recordedSetMethodSet);
            methodHandler4Invoke.setNonStaticFieldNameTypeMap(nonStaticFieldNameTypeMap);
            methodHandler4Invoke.setNonStaticFieldNameGenericsTypeMap(nonStaticFieldNameGenericsTypeMap);
            methodHandler4Invoke.setRecordedFieldWithGenericsTypeSet(recordedFieldWithGenericsTypeSet);
            if ("<clinit>".equals(method.getName())) {
                methodHandler4Invoke.setInClinitMethod(true);
                methodHandler4Invoke.setSfFieldInvokeInstructionMap(sfFieldInvokeInstructionMap);
                methodHandler4Invoke.setStaticFinalFieldNameTypeMap(staticFinalFieldNameTypeMap);
            }
            if (this.javaCGConfInfo.isFirstParseInitMethodType()) {
                methodHandler4Invoke.setNonStaticFieldPossibleTypes(this.nonStaticFieldPossibleTypes);
            }
            if (this.javaCGConfInfo.isAnalyseFieldRelationship()) {
                methodHandler4Invoke.setFieldRelationshipWriter(this.fieldRelationshipWriter);
                methodHandler4Invoke.setFieldRelationshipCounter(this.fieldRelationshipCounter);
            }
        }
        boolean success = methodHandler4Invoke.handleMethod();
        if (this.javaCGConfInfo.isLogMethodSpendTime()) {
            long spendTime = System.currentTimeMillis() - startTime;
            this.logMethodSpendTimeWriter.write("\t" + spendTime + "\n");
        }
        return success;
    }

    private void recordMethodReturnGenericsType(String fullMethod, SignatureAttribute.MethodSignature methodSignature) {
        try {
            SignatureAttribute.Type returnType = methodSignature.getReturnType();
            if (!(returnType instanceof SignatureAttribute.ClassType)) {
                return;
            }
            SignatureAttribute.ClassType classType = (SignatureAttribute.ClassType)returnType;
            ArrayList<String> methodReturnGenericsTypeList = new ArrayList<String>();
            JavaCGSignatureUtil.parseTypeDefineGenericsType(classType, true, methodReturnGenericsTypeList);
            if (methodReturnGenericsTypeList.isEmpty()) {
                return;
            }
            JavaCGFileUtil.write2FileWithTab(this.methodReturnGenericsTypeWriter, fullMethod, "t", "0", JavaCGSignatureUtil.getClassName(classType));
            for (int i = 0; i < methodReturnGenericsTypeList.size(); ++i) {
                JavaCGFileUtil.write2FileWithTab(this.methodReturnGenericsTypeWriter, fullMethod, "gt", String.valueOf(i), (String)methodReturnGenericsTypeList.get(i));
            }
        }
        catch (Exception e) {
            logger.error("error ", (Throwable)e);
        }
    }

    private void recordMethodArgsGenericsType(String fullMethod, SignatureAttribute.MethodSignature methodSignature) throws IOException {
        Object[] parameterTypes = methodSignature.getParameterTypes();
        if (ArrayUtils.isEmpty((Object[])parameterTypes)) {
            return;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Object argType = parameterTypes[i];
            if (!(argType instanceof SignatureAttribute.ClassType)) continue;
            SignatureAttribute.ClassType classType = (SignatureAttribute.ClassType)argType;
            ArrayList<String> methodArgsGenericsTypeList = new ArrayList<String>();
            JavaCGSignatureUtil.parseTypeDefineGenericsType(classType, true, methodArgsGenericsTypeList);
            if (methodArgsGenericsTypeList.isEmpty()) continue;
            JavaCGFileUtil.write2FileWithTab(this.methodArgGenericsTypeWriter, fullMethod, String.valueOf(i), "t", "0", JavaCGSignatureUtil.getClassName(classType));
            for (int j = 0; j < methodArgsGenericsTypeList.size(); ++j) {
                JavaCGFileUtil.write2FileWithTab(this.methodArgGenericsTypeWriter, fullMethod, String.valueOf(i), "gt", String.valueOf(j), (String)methodArgsGenericsTypeList.get(j));
            }
        }
    }

    private void recordMethodArgument(String fullMethod, MethodGen mg) throws IOException {
        Type[] argTypes = mg.getArgumentTypes();
        for (Attribute attribute : mg.getAttributes()) {
            if (!(attribute instanceof MethodParameters)) continue;
            ConstantPool constantPool = mg.getConstantPool().getConstantPool();
            MethodParameters methodParameters = (MethodParameters)attribute;
            MethodParameter[] parameters = methodParameters.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                String argName = parameters[i].getParameterName(constantPool);
                JavaCGFileUtil.write2FileWithTab(this.methodArgumentWriter, fullMethod, String.valueOf(i), argTypes[i].toString(), argName);
            }
            return;
        }
        LocalVariableTable localVariableTable = mg.getLocalVariableTable(mg.getConstantPool());
        for (int i = 0; i < argTypes.length; ++i) {
            int argIndex = JavaCGByteCodeUtil.getLocalVariableTableIndex(mg, i);
            LocalVariable localVariable = localVariableTable.getLocalVariable(argIndex, 0);
            String argName = localVariable == null ? "" : localVariable.getName();
            JavaCGFileUtil.write2FileWithTab(this.methodArgumentWriter, fullMethod, String.valueOf(i), argTypes[i].toString(), argName);
        }
    }

    public void setUseSpringBeanByAnnotationHandler(UseSpringBeanByAnnotationHandler useSpringBeanByAnnotationHandler) {
        this.useSpringBeanByAnnotationHandler = useSpringBeanByAnnotationHandler;
    }

    public void setRunnableImplClassMap(Map<String, Boolean> runnableImplClassMap) {
        this.runnableImplClassMap = runnableImplClassMap;
    }

    public void setCallableImplClassMap(Map<String, Boolean> callableImplClassMap) {
        this.callableImplClassMap = callableImplClassMap;
    }

    public void setTransactionCallbackImplClassMap(Map<String, Boolean> transactionCallbackImplClassMap) {
        this.transactionCallbackImplClassMap = transactionCallbackImplClassMap;
    }

    public void setTransactionCallbackWithoutResultChildClassMap(Map<String, Boolean> transactionCallbackWithoutResultChildClassMap) {
        this.transactionCallbackWithoutResultChildClassMap = transactionCallbackWithoutResultChildClassMap;
    }

    public void setThreadChildClassMap(Map<String, Boolean> threadChildClassMap) {
        this.threadChildClassMap = threadChildClassMap;
    }

    public void setExtensionsManager(ExtensionsManager extensionsManager) {
        this.extensionsManager = extensionsManager;
        this.annotationAttributesFormatter = extensionsManager.getAnnotationAttributesFormatter();
    }

    public void setCallIdCounter(JavaCGCounter callIdCounter) {
        this.callIdCounter = callIdCounter;
    }

    public void setClassReferenceWriter(Writer classReferenceWriter) {
        this.classReferenceWriter = classReferenceWriter;
    }

    public void setMethodCallWriter(Writer methodCallWriter) {
        this.methodCallWriter = methodCallWriter;
    }

    public void setLambdaMethodInfoWriter(Writer lambdaMethodInfoWriter) {
        this.lambdaMethodInfoWriter = lambdaMethodInfoWriter;
    }

    public void setClassAnnotationWriter(Writer classAnnotationWriter) {
        this.classAnnotationWriter = classAnnotationWriter;
    }

    public void setMethodAnnotationWriter(Writer methodAnnotationWriter) {
        this.methodAnnotationWriter = methodAnnotationWriter;
    }

    public void setFieldAnnotationWriter(Writer fieldAnnotationWriter) {
        this.fieldAnnotationWriter = fieldAnnotationWriter;
    }

    public void setFieldInfoWriter(Writer fieldInfoWriter) {
        this.fieldInfoWriter = fieldInfoWriter;
    }

    public void setMethodLineNumberWriter(Writer methodLineNumberWriter) {
        this.methodLineNumberWriter = methodLineNumberWriter;
    }

    public void setMethodCallInfoWriter(Writer methodCallInfoWriter) {
        this.methodCallInfoWriter = methodCallInfoWriter;
    }

    public void setMethodCallMethodCallReturnWriter(Writer methodCallMethodCallReturnWriter) {
        this.methodCallMethodCallReturnWriter = methodCallMethodCallReturnWriter;
    }

    public void setMethodCallStaticFieldWriter(Writer methodCallStaticFieldWriter) {
        this.methodCallStaticFieldWriter = methodCallStaticFieldWriter;
    }

    public void setMethodReturnArgSeqWriter(Writer methodReturnArgSeqWriter) {
        this.methodReturnArgSeqWriter = methodReturnArgSeqWriter;
    }

    public void setMethodReturnCallIdWriter(Writer methodReturnCallIdWriter) {
        this.methodReturnCallIdWriter = methodReturnCallIdWriter;
    }

    public void setMethodInfoWriter(Writer methodInfoWriter) {
        this.methodInfoWriter = methodInfoWriter;
    }

    public void setMethodArgumentWriter(Writer methodArgumentWriter) {
        this.methodArgumentWriter = methodArgumentWriter;
    }

    public void setMethodArgAnnotationWriter(Writer methodArgAnnotationWriter) {
        this.methodArgAnnotationWriter = methodArgAnnotationWriter;
    }

    public void setMethodArgGenericsTypeWriter(Writer methodArgGenericsTypeWriter) {
        this.methodArgGenericsTypeWriter = methodArgGenericsTypeWriter;
    }

    public void setMethodReturnGenericsTypeWriter(Writer methodReturnGenericsTypeWriter) {
        this.methodReturnGenericsTypeWriter = methodReturnGenericsTypeWriter;
    }

    public void setMethodCatchWriter(Writer methodCatchWriter) {
        this.methodCatchWriter = methodCatchWriter;
    }

    public void setMethodFinallyWriter(Writer methodFinallyWriter) {
        this.methodFinallyWriter = methodFinallyWriter;
    }

    public void setMethodThrowWriter(Writer methodThrowWriter) {
        this.methodThrowWriter = methodThrowWriter;
    }

    public void setGetMethodWriter(Writer getMethodWriter) {
        this.getMethodWriter = getMethodWriter;
    }

    public void setSetMethodWriter(Writer setMethodWriter) {
        this.setMethodWriter = setMethodWriter;
    }

    public void setFieldGenericsTypeWriter(Writer fieldGenericsTypeWriter) {
        this.fieldGenericsTypeWriter = fieldGenericsTypeWriter;
    }

    public void setFieldRelationshipWriter(Writer fieldRelationshipWriter) {
        this.fieldRelationshipWriter = fieldRelationshipWriter;
    }

    public void setStaticFinalFieldMethodCallIdWriter(Writer staticFinalFieldMethodCallIdWriter) {
        this.staticFinalFieldMethodCallIdWriter = staticFinalFieldMethodCallIdWriter;
    }

    public void setLogMethodSpendTimeWriter(WriterSupportSkip logMethodSpendTimeWriter) {
        this.logMethodSpendTimeWriter = logMethodSpendTimeWriter;
    }

    public void setMethodNumCounter(JavaCGCounter methodNumCounter) {
        this.methodNumCounter = methodNumCounter;
    }

    public void setFailCounter(JavaCGCounter failCounter) {
        this.failCounter = failCounter;
    }

    public void setFieldRelationshipCounter(JavaCGCounter fieldRelationshipCounter) {
        this.fieldRelationshipCounter = fieldRelationshipCounter;
    }

    public void setLastJarNum(int lastJarNum) {
        this.lastJarNum = lastJarNum;
    }

    public void setClassAndJarNum(ClassAndJarNum classAndJarNum) {
        this.classAndJarNum = classAndJarNum;
    }
}

