/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.handler;

import com.adrninistrator.javacg.common.enums.JavaCGCallTypeEnum;
import com.adrninistrator.javacg.comparator.MethodArgReturnTypesComparator;
import com.adrninistrator.javacg.conf.JavaCGConfInfo;
import com.adrninistrator.javacg.dto.accessflag.JavaCGAccessFlags;
import com.adrninistrator.javacg.dto.call.MethodCall;
import com.adrninistrator.javacg.dto.classes.ClassExtendsInfo;
import com.adrninistrator.javacg.dto.classes.Node4ClassExtendsMethod;
import com.adrninistrator.javacg.dto.counter.JavaCGCounter;
import com.adrninistrator.javacg.dto.jar.ClassAndJarNum;
import com.adrninistrator.javacg.dto.method.MethodArgReturnTypes;
import com.adrninistrator.javacg.dto.stack.ListAsStack;
import com.adrninistrator.javacg.util.JavaCGByteCodeUtil;
import com.adrninistrator.javacg.util.JavaCGClassMethodUtil;
import com.adrninistrator.javacg.util.JavaCGFileUtil;
import com.adrninistrator.javacg.util.JavaCGUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendsImplHandler {
    private static final Logger logger = LoggerFactory.getLogger(ExtendsImplHandler.class);
    private JavaCGConfInfo javaCGConfInfo;
    private JavaCGCounter callIdCounter;
    private Map<String, Map<MethodArgReturnTypes, Integer>> interfaceMethodWithArgTypesMap;
    private Map<String, Map<MethodArgReturnTypes, Integer>> classExtendsImplMethodWithArgTypesMap;
    private Map<String, List<String>> childrenClassMap;
    private Map<String, List<String>> interfaceExtendsInfoMap;
    private Map<String, List<String>> childrenInterfaceMap;
    private Map<String, List<String>> classImplementsInfoMap;
    private Map<String, ClassExtendsInfo> classExtendsInfoMap;
    private Set<String> allClassNameSet;
    private ClassAndJarNum classAndJarNum;

    public void handle(Writer methodCallWriter) throws IOException {
        this.addSuperInterfaceMethod4ChildrenInterface(methodCallWriter);
        this.addInterfaceMethod4SuperAbstractClass();
        this.addSuperMethod2ImplClass();
        this.recordInterfaceDefaultMethod4ImplClass(methodCallWriter);
        this.recordClassExtendsMethod(methodCallWriter);
        this.recordInterfaceCallClassMethod(methodCallWriter);
    }

    private void addSuperInterfaceMethod4ChildrenInterface(Writer methodCallWriter) throws IOException {
        HashSet<String> topSuperInterfaceSet = new HashSet<String>();
        for (Map.Entry<String, List<String>> entry : this.interfaceExtendsInfoMap.entrySet()) {
            for (String superInterface : entry.getValue()) {
                List<String> superInterfaceListOfSuper = this.interfaceExtendsInfoMap.get(superInterface);
                if (!JavaCGUtil.isCollectionEmpty(superInterfaceListOfSuper) || !topSuperInterfaceSet.add(superInterface)) continue;
                logger.debug("\u5904\u7406\u4e00\u4e2a\u9876\u5c42\u7236\u63a5\u53e3: {}", (Object)superInterface);
            }
        }
        ArrayList topSuperInterfaceSetList = new ArrayList(topSuperInterfaceSet);
        Collections.sort(topSuperInterfaceSetList);
        for (String topSuperInterface : topSuperInterfaceSetList) {
            this.handleOneSuperInterface(topSuperInterface, methodCallWriter);
        }
    }

    private void handleOneSuperInterface(String superInterface, Writer methodCallWriter) throws IOException {
        List<String> childrenInterfaceList = this.childrenInterfaceMap.get(superInterface);
        if (childrenInterfaceList == null) {
            return;
        }
        for (String childrenInterface : childrenInterfaceList) {
            this.handleSuperAndChildInterface(superInterface, childrenInterface, methodCallWriter);
            this.handleOneSuperInterface(childrenInterface, methodCallWriter);
        }
    }

    private void handleSuperAndChildInterface(String superInterface, String childInterface, Writer methodCallWriter) throws IOException {
        List<String> superInterfaceList = this.interfaceExtendsInfoMap.get(superInterface);
        if (superInterfaceList == null) {
            return;
        }
        Map<MethodArgReturnTypes, Integer> superInterfaceMethodAndArgsMap = this.interfaceMethodWithArgTypesMap.get(superInterface);
        if (JavaCGUtil.isMapEmpty(superInterfaceMethodAndArgsMap)) {
            return;
        }
        Map childInterfaceMethodAndArgsMap = this.interfaceMethodWithArgTypesMap.computeIfAbsent(childInterface, k -> new HashMap());
        ArrayList<MethodArgReturnTypes> superInterfaceMethodAndArgsList = new ArrayList<MethodArgReturnTypes>(superInterfaceMethodAndArgsMap.keySet());
        superInterfaceMethodAndArgsList.sort(MethodArgReturnTypesComparator.getInstance());
        for (MethodArgReturnTypes superMethodAndArgs : superInterfaceMethodAndArgsList) {
            if (childInterfaceMethodAndArgsMap.containsKey(superMethodAndArgs)) continue;
            Integer superMethodAccessFlags = superInterfaceMethodAndArgsMap.get(superMethodAndArgs);
            childInterfaceMethodAndArgsMap.put(superMethodAndArgs, superMethodAccessFlags);
            JavaCGCallTypeEnum callTypeEnum = JavaCGByteCodeUtil.isAbstractFlag(superMethodAccessFlags) ? JavaCGCallTypeEnum.CTE_CHILD_CALL_SUPER_INTERFACE : JavaCGCallTypeEnum.CTE_INTERFACE_CALL_INTERFACE_DEFAULT;
            this.addExtraMethodCall(methodCallWriter, childInterface, superMethodAndArgs.getMethodName(), superMethodAndArgs.getMethodArgTypes(), superMethodAndArgs.getMethodReturnType(), callTypeEnum, superInterface, superMethodAndArgs.getMethodName(), superMethodAndArgs.getMethodArgTypes(), superMethodAndArgs.getMethodReturnType());
        }
    }

    private void addInterfaceMethod4SuperAbstractClass() {
        for (Map.Entry<String, List<String>> childrenClassEntry : this.childrenClassMap.entrySet()) {
            List<String> classImplementsInterfaceList;
            String superClassName = childrenClassEntry.getKey();
            ClassExtendsInfo classExtendsInfo = this.classExtendsInfoMap.get(superClassName);
            if (classExtendsInfo == null || !JavaCGByteCodeUtil.isAbstractFlag(classExtendsInfo.getAccessFlags()) || (classImplementsInterfaceList = this.classImplementsInfoMap.get(superClassName)) == null) continue;
            Map superCLassMethodWithArgTypesMap = this.classExtendsImplMethodWithArgTypesMap.computeIfAbsent(superClassName, k -> new HashMap());
            int accessFlags = 0;
            accessFlags = JavaCGByteCodeUtil.setAbstractFlag(accessFlags, true);
            accessFlags = JavaCGByteCodeUtil.setPublicFlag(accessFlags, true);
            accessFlags = JavaCGByteCodeUtil.setProtectedFlag(accessFlags, false);
            for (String interfaceName : classImplementsInterfaceList) {
                Map<MethodArgReturnTypes, Integer> currentInterfaceMethodWithArgTypesMap = this.interfaceMethodWithArgTypesMap.get(interfaceName);
                if (JavaCGUtil.isMapEmpty(currentInterfaceMethodWithArgTypesMap)) continue;
                for (Map.Entry<MethodArgReturnTypes, Integer> entry : currentInterfaceMethodWithArgTypesMap.entrySet()) {
                    if (!JavaCGByteCodeUtil.isAbstractFlag(entry.getValue())) continue;
                    superCLassMethodWithArgTypesMap.putIfAbsent(entry.getKey(), accessFlags);
                }
            }
        }
    }

    private void addSuperMethod2ImplClass() {
        if (this.classImplementsInfoMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, List<String>> classImplementsEntry : this.classImplementsInfoMap.entrySet()) {
            String className = classImplementsEntry.getKey();
            ClassExtendsInfo classExtendsInfo = this.classExtendsInfoMap.get(className);
            if (classExtendsInfo == null) {
                return;
            }
            Map<MethodArgReturnTypes, Integer> methodWithArgTypesMapExtends = this.classExtendsImplMethodWithArgTypesMap.get(className);
            if (methodWithArgTypesMapExtends == null) {
                return;
            }
            Map methodWithArgTypesMap = this.classExtendsImplMethodWithArgTypesMap.computeIfAbsent(className, k -> new HashMap());
            for (Map.Entry<MethodArgReturnTypes, Integer> entry : methodWithArgTypesMapExtends.entrySet()) {
                JavaCGAccessFlags methodAccessFlags;
                String methodName;
                MethodArgReturnTypes methodAndArgTypes = entry.getKey();
                if (methodWithArgTypesMap.containsKey(methodAndArgTypes) || !JavaCGByteCodeUtil.checkImplMethod(methodName = methodAndArgTypes.getMethodName(), methodAccessFlags = new JavaCGAccessFlags(entry.getValue()))) continue;
                methodWithArgTypesMap.put(methodAndArgTypes, entry.getValue());
            }
        }
    }

    private void recordInterfaceDefaultMethod4ImplClass(Writer methodCallWriter) throws IOException {
        if (this.classImplementsInfoMap.isEmpty() || this.interfaceMethodWithArgTypesMap.isEmpty()) {
            return;
        }
        ArrayList<String> classNameList = new ArrayList<String>(this.classImplementsInfoMap.keySet());
        Collections.sort(classNameList);
        for (String className : classNameList) {
            List<String> interfaceNameList = this.classImplementsInfoMap.get(className);
            for (String interfaceName : interfaceNameList) {
                Map<MethodArgReturnTypes, Integer> currentInterfaceMethodWithArgTypesMap = this.interfaceMethodWithArgTypesMap.get(interfaceName);
                if (JavaCGUtil.isMapEmpty(currentInterfaceMethodWithArgTypesMap)) continue;
                ArrayList<MethodArgReturnTypes> interfaceMethodArgReturnTypesList = new ArrayList<MethodArgReturnTypes>(currentInterfaceMethodWithArgTypesMap.keySet());
                interfaceMethodArgReturnTypesList.sort(MethodArgReturnTypesComparator.getInstance());
                for (MethodArgReturnTypes interfaceMethodArgReturnTypes : interfaceMethodArgReturnTypesList) {
                    Map classMethodArgReturnTypesMap;
                    Integer interfaceMethodAccessFlags = currentInterfaceMethodWithArgTypesMap.get(interfaceMethodArgReturnTypes);
                    if (JavaCGByteCodeUtil.isAbstractFlag(interfaceMethodAccessFlags) || (classMethodArgReturnTypesMap = this.classExtendsImplMethodWithArgTypesMap.computeIfAbsent(className, k -> new HashMap())).containsKey(interfaceMethodArgReturnTypes)) continue;
                    classMethodArgReturnTypesMap.putIfAbsent(interfaceMethodArgReturnTypes, interfaceMethodAccessFlags);
                    this.addExtraMethodCall(methodCallWriter, className, interfaceMethodArgReturnTypes.getMethodName(), interfaceMethodArgReturnTypes.getMethodArgTypes(), interfaceMethodArgReturnTypes.getMethodReturnType(), JavaCGCallTypeEnum.CTE_CLASS_CALL_INTERFACE_DEFAULT, interfaceName, interfaceMethodArgReturnTypes.getMethodName(), interfaceMethodArgReturnTypes.getMethodArgTypes(), interfaceMethodArgReturnTypes.getMethodReturnType());
                }
            }
        }
    }

    private void recordClassExtendsMethod(Writer methodCallWriter) throws IOException {
        if (this.classExtendsInfoMap.isEmpty()) {
            return;
        }
        HashSet<String> topSuperClassNameSet = new HashSet<String>();
        for (Map.Entry<String, ClassExtendsInfo> classExtendsMethodInfoEntry : this.classExtendsInfoMap.entrySet()) {
            ClassExtendsInfo classExtendsInfo;
            String superClassName;
            String className = classExtendsMethodInfoEntry.getKey();
            if (!this.checkTopSuperClass(className, superClassName = (classExtendsInfo = classExtendsMethodInfoEntry.getValue()).getSuperClassName())) continue;
            topSuperClassNameSet.add(className);
        }
        ArrayList topSuperClassNameList = new ArrayList(topSuperClassNameSet);
        Collections.sort(topSuperClassNameList);
        for (String topSuperClassName : topSuperClassNameList) {
            this.handleOneTopSuperClass(topSuperClassName, methodCallWriter);
        }
    }

    private boolean checkTopSuperClass(String className, String superClassName) {
        if (!JavaCGClassMethodUtil.isClassInJdk(className) && JavaCGClassMethodUtil.isClassInJdk(superClassName)) {
            return true;
        }
        return JavaCGClassMethodUtil.isClassInJdk(className) && !this.allClassNameSet.contains(superClassName);
    }

    private void handleOneTopSuperClass(String topSuperClassName, Writer methodCallWriter) throws IOException {
        logger.debug("\u5904\u7406\u4e00\u4e2a\u9876\u5c42\u7236\u7c7b: {}", (Object)topSuperClassName);
        ListAsStack<Node4ClassExtendsMethod> nodeStack = new ListAsStack<Node4ClassExtendsMethod>();
        nodeStack.push(new Node4ClassExtendsMethod(topSuperClassName, -1));
        while (true) {
            Node4ClassExtendsMethod currentNode;
            List<String> childrenClassList;
            if ((childrenClassList = this.childrenClassMap.get((currentNode = (Node4ClassExtendsMethod)nodeStack.peek()).getSuperClassName())) == null) {
                logger.debug("\u672a\u627e\u5230\u9876\u5c42\u7236\u7c7b\u7684\u5b50\u7c7b: {}", (Object)currentNode.getSuperClassName());
                return;
            }
            Collections.sort(childrenClassList);
            int currentChildClassIndex = currentNode.getChildClassIndex() + 1;
            if (currentChildClassIndex >= childrenClassList.size()) {
                if (nodeStack.atBottom()) {
                    return;
                }
                nodeStack.removeTop();
                continue;
            }
            String childClassName = childrenClassList.get(currentChildClassIndex);
            this.handleSuperAndChildClass(currentNode.getSuperClassName(), childClassName, methodCallWriter);
            currentNode.setChildClassIndex(currentChildClassIndex);
            List<String> nextChildClassList = this.childrenClassMap.get(childClassName);
            if (nextChildClassList == null) continue;
            nodeStack.push(new Node4ClassExtendsMethod(childClassName, -1));
        }
    }

    private void handleSuperAndChildClass(String superClassName, String childClassName, Writer methodCallWriter) throws IOException {
        Map<MethodArgReturnTypes, Integer> superMethodWithArgTypesMap = this.classExtendsImplMethodWithArgTypesMap.get(superClassName);
        if (JavaCGUtil.isMapEmpty(superMethodWithArgTypesMap)) {
            return;
        }
        Map childMethodWithArgTypesMap = this.classExtendsImplMethodWithArgTypesMap.computeIfAbsent(childClassName, k -> new HashMap());
        ArrayList<MethodArgReturnTypes> superMethodAndArgTypesList = new ArrayList<MethodArgReturnTypes>(superMethodWithArgTypesMap.keySet());
        superMethodAndArgTypesList.sort(MethodArgReturnTypesComparator.getInstance());
        for (MethodArgReturnTypes superMethodWithArgTypes : superMethodAndArgTypesList) {
            Integer superMethodAccessFlags = superMethodWithArgTypesMap.get(superMethodWithArgTypes);
            if (JavaCGByteCodeUtil.isAbstractFlag(superMethodAccessFlags)) {
                childMethodWithArgTypesMap.putIfAbsent(superMethodWithArgTypes, superMethodAccessFlags);
                this.addExtraMethodCall(methodCallWriter, superClassName, superMethodWithArgTypes.getMethodName(), superMethodWithArgTypes.getMethodArgTypes(), superMethodWithArgTypes.getMethodReturnType(), JavaCGCallTypeEnum.CTE_SUPER_CALL_CHILD, childClassName, superMethodWithArgTypes.getMethodName(), superMethodWithArgTypes.getMethodArgTypes(), superMethodWithArgTypes.getMethodReturnType());
                continue;
            }
            if (!JavaCGByteCodeUtil.isPublicFlag(superMethodAccessFlags) && !JavaCGByteCodeUtil.isProtectedMethod(superMethodAccessFlags) && (JavaCGByteCodeUtil.isPrivateMethod(superMethodAccessFlags) || !JavaCGClassMethodUtil.checkSamePackage(superClassName, childClassName)) || childMethodWithArgTypesMap.get(superMethodWithArgTypes) != null) continue;
            childMethodWithArgTypesMap.put(superMethodWithArgTypes, superMethodAccessFlags);
            this.addExtraMethodCall(methodCallWriter, childClassName, superMethodWithArgTypes.getMethodName(), superMethodWithArgTypes.getMethodArgTypes(), superMethodWithArgTypes.getMethodReturnType(), JavaCGCallTypeEnum.CTE_CHILD_CALL_SUPER, superClassName, superMethodWithArgTypes.getMethodName(), superMethodWithArgTypes.getMethodArgTypes(), superMethodWithArgTypes.getMethodReturnType());
        }
    }

    private void recordInterfaceCallClassMethod(Writer methodCallWriter) throws IOException {
        if (this.classImplementsInfoMap.isEmpty() || this.interfaceMethodWithArgTypesMap.isEmpty()) {
            return;
        }
        ArrayList<String> classNameList = new ArrayList<String>(this.classImplementsInfoMap.keySet());
        Collections.sort(classNameList);
        for (String className : classNameList) {
            List<String> interfaceNameList = this.classImplementsInfoMap.get(className);
            Collections.sort(interfaceNameList);
            Map<MethodArgReturnTypes, Integer> classMethodWithArgTypesMap = this.classExtendsImplMethodWithArgTypesMap.get(className);
            if (JavaCGUtil.isMapEmpty(classMethodWithArgTypesMap)) continue;
            ArrayList<MethodArgReturnTypes> methodWithArgTypesList = new ArrayList<MethodArgReturnTypes>(classMethodWithArgTypesMap.keySet());
            methodWithArgTypesList.sort(MethodArgReturnTypesComparator.getInstance());
            for (String interfaceName : interfaceNameList) {
                Map<MethodArgReturnTypes, Integer> currentInterfaceMethodWithArgTypesMap = this.interfaceMethodWithArgTypesMap.get(interfaceName);
                if (JavaCGUtil.isMapEmpty(currentInterfaceMethodWithArgTypesMap)) continue;
                for (MethodArgReturnTypes methodWithArgTypes : methodWithArgTypesList) {
                    Integer currentInterfaceMethodAccessFlags = currentInterfaceMethodWithArgTypesMap.get(methodWithArgTypes);
                    if (currentInterfaceMethodAccessFlags == null || !JavaCGByteCodeUtil.isAbstractFlag(currentInterfaceMethodAccessFlags)) continue;
                    this.addExtraMethodCall(methodCallWriter, interfaceName, methodWithArgTypes.getMethodName(), methodWithArgTypes.getMethodArgTypes(), methodWithArgTypes.getMethodReturnType(), JavaCGCallTypeEnum.CTE_INTERFACE_CALL_IMPL_CLASS, className, methodWithArgTypes.getMethodName(), methodWithArgTypes.getMethodArgTypes(), methodWithArgTypes.getMethodReturnType());
                }
            }
        }
    }

    private void addExtraMethodCall(Writer methodCallWriter, String callerClassName, String callerMethodName, String callerMethodArgTypes, String callerMethodReturnType, JavaCGCallTypeEnum methodCallType, String calleeClassName, String calleeMethodName, String calleeMethodArgTypes, String calleeMethodReturnType) throws IOException {
        if (JavaCGUtil.checkSkipClass(callerClassName, this.javaCGConfInfo.getNeedHandlePackageSet()) || JavaCGUtil.checkSkipClass(calleeClassName, this.javaCGConfInfo.getNeedHandlePackageSet())) {
            return;
        }
        String callerClassJarNum = this.classAndJarNum.getJarNum(callerClassName);
        String calleeClassJarNum = this.classAndJarNum.getJarNum(calleeClassName);
        MethodCall methodCall = new MethodCall();
        methodCall.setCallId(this.callIdCounter.addAndGet());
        methodCall.setCallerClassName(callerClassName);
        methodCall.setCallerMethodName(callerMethodName);
        methodCall.setCallerMethodArgTypes(callerMethodArgTypes);
        methodCall.setCallerReturnType(callerMethodReturnType);
        methodCall.setCallerSourceLine(0);
        methodCall.setMethodCallType(methodCallType);
        methodCall.setCalleeClassName(calleeClassName);
        methodCall.setCalleeMethodName(calleeMethodName);
        methodCall.setCalleeMethodArgTypes(calleeMethodArgTypes);
        methodCall.setRawReturnType(calleeMethodReturnType);
        JavaCGFileUtil.write2FileWithTab(methodCallWriter, methodCall.genMethodCallContent(callerClassJarNum, calleeClassJarNum));
    }

    public void setJavaCGConfInfo(JavaCGConfInfo javaCGConfInfo) {
        this.javaCGConfInfo = javaCGConfInfo;
    }

    public void setCallIdCounter(JavaCGCounter callIdCounter) {
        this.callIdCounter = callIdCounter;
    }

    public void setInterfaceMethodWithArgTypesMap(Map<String, Map<MethodArgReturnTypes, Integer>> interfaceMethodWithArgTypesMap) {
        this.interfaceMethodWithArgTypesMap = interfaceMethodWithArgTypesMap;
    }

    public void setChildrenClassMap(Map<String, List<String>> childrenClassMap) {
        this.childrenClassMap = childrenClassMap;
    }

    public void setChildrenInterfaceMap(Map<String, List<String>> childrenInterfaceMap) {
        this.childrenInterfaceMap = childrenInterfaceMap;
    }

    public void setAllClassNameSet(Set<String> allClassNameSet) {
        this.allClassNameSet = allClassNameSet;
    }

    public void setClassAndJarNum(ClassAndJarNum classAndJarNum) {
        this.classAndJarNum = classAndJarNum;
    }

    public void setClassExtendsImplMethodWithArgTypesMap(Map<String, Map<MethodArgReturnTypes, Integer>> classExtendsImplMethodWithArgTypesMap) {
        this.classExtendsImplMethodWithArgTypesMap = classExtendsImplMethodWithArgTypesMap;
    }

    public void setInterfaceExtendsInfoMap(Map<String, List<String>> interfaceExtendsInfoMap) {
        this.interfaceExtendsInfoMap = interfaceExtendsInfoMap;
    }

    public void setClassImplementsInfoMap(Map<String, List<String>> classImplementsInfoMap) {
        this.classImplementsInfoMap = classImplementsInfoMap;
    }

    public void setClassExtendsInfoMap(Map<String, ClassExtendsInfo> classExtendsInfoMap) {
        this.classExtendsInfoMap = classExtendsInfoMap;
    }
}

