/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.handler;

import com.adrninistrator.javacg.common.JavaCGCommonNameConstants;
import com.adrninistrator.javacg.common.enums.JavaCGArithmeticOperationTypeEnum;
import com.adrninistrator.javacg.common.enums.JavaCGConstantTypeEnum;
import com.adrninistrator.javacg.conf.JavaCGConfInfo;
import com.adrninistrator.javacg.dto.element.BaseElement;
import com.adrninistrator.javacg.dto.element.constant.ConstElementDouble;
import com.adrninistrator.javacg.dto.element.constant.ConstElementFloat;
import com.adrninistrator.javacg.dto.element.constant.ConstElementInt;
import com.adrninistrator.javacg.dto.element.constant.ConstElementLong;
import com.adrninistrator.javacg.dto.element.constant.ConstElementNull;
import com.adrninistrator.javacg.dto.element.constant.ConstElementString;
import com.adrninistrator.javacg.dto.element.variable.FieldElement;
import com.adrninistrator.javacg.dto.element.variable.JSRElement;
import com.adrninistrator.javacg.dto.element.variable.LocalVariableElement;
import com.adrninistrator.javacg.dto.element.variable.StaticFieldElement;
import com.adrninistrator.javacg.dto.element.variable.StaticFieldMethodCallElement;
import com.adrninistrator.javacg.dto.element.variable.VariableElement;
import com.adrninistrator.javacg.dto.field.FieldPossibleTypes;
import com.adrninistrator.javacg.dto.frame.FieldInformationMap;
import com.adrninistrator.javacg.dto.frame.JavaCGLocalVariables;
import com.adrninistrator.javacg.dto.frame.JavaCGOperandStack;
import com.adrninistrator.javacg.dto.instruction.parseresult.AThrowNullParseResult;
import com.adrninistrator.javacg.dto.instruction.parseresult.AThrowParseResult;
import com.adrninistrator.javacg.dto.instruction.parseresult.BaseInstructionParseResult;
import com.adrninistrator.javacg.dto.instruction.parseresult.MethodCallParseResult;
import com.adrninistrator.javacg.dto.instruction.parseresult.PutFieldParseResult;
import com.adrninistrator.javacg.dto.instruction.parseresult.PutStaticParseResult;
import com.adrninistrator.javacg.dto.instruction.parseresult.RetParseResult;
import com.adrninistrator.javacg.dto.instruction.parseresult.ReturnParseResult;
import com.adrninistrator.javacg.dto.variabledatasource.VariableDataSourceArithmeticOperation;
import com.adrninistrator.javacg.dto.variabledatasource.VariableDataSourceField;
import com.adrninistrator.javacg.dto.variabledatasource.VariableDataSourceMethodArg;
import com.adrninistrator.javacg.dto.variabledatasource.VariableDataSourceMethodCallReturn;
import com.adrninistrator.javacg.exceptions.JavaCGRuntimeException;
import com.adrninistrator.javacg.util.JavaCGByteCodeUtil;
import com.adrninistrator.javacg.util.JavaCGClassMethodUtil;
import com.adrninistrator.javacg.util.JavaCGElementUtil;
import com.adrninistrator.javacg.util.JavaCGInstructionUtil;
import com.adrninistrator.javacg.util.JavaCGUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BIPUSH;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.INVOKEDYNAMIC;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.MULTIANEWARRAY;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.PUTSTATIC;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.SIPUSH;
import org.apache.bcel.generic.StoreInstruction;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.TypedInstruction;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstructionHandler {
    private static final Logger logger = LoggerFactory.getLogger(InstructionHandler.class);
    private final Map<String, Map<String, Integer>> frEqConversionMethodMap;
    private final MethodGen mg;
    private final ConstantPoolGen cpg;
    private final LocalVariableTable localVariableTable;
    private JavaCGOperandStack stack;
    private JavaCGLocalVariables locals;
    private FieldInformationMap nonStaticFieldInfoMap;
    private FieldInformationMap staticFieldInfoMap;
    protected boolean parseMethodCallTypeValueFlag;
    private boolean recordFieldPossibleTypeFlag;
    private boolean useFieldPossibleTypeFlag;
    private FieldPossibleTypes nonStaticFieldPossibleTypes;
    private boolean maybeSetMethod;
    private boolean inClinitMethod;

    public InstructionHandler(JavaCGConfInfo javaCGConfInfo, MethodGen mg, LocalVariableTable localVariableTable, JavaCGOperandStack stack, JavaCGLocalVariables locals, FieldInformationMap nonStaticFieldInfoMap, FieldInformationMap staticFieldInfoMap) {
        this.frEqConversionMethodMap = javaCGConfInfo.getFrEqConversionMethodMap();
        this.mg = mg;
        this.cpg = mg.getConstantPool();
        this.localVariableTable = localVariableTable;
        this.stack = stack;
        this.locals = locals;
        this.nonStaticFieldInfoMap = nonStaticFieldInfoMap;
        this.staticFieldInfoMap = staticFieldInfoMap;
    }

    public BaseInstructionParseResult parse(InstructionHandle ih) {
        Instruction i = ih.getInstruction();
        short opCode = i.getOpcode();
        BaseInstructionParseResult instructionParseResult = null;
        switch (opCode) {
            case 0: {
                break;
            }
            case 1: {
                this.stack.push(new ConstElementNull());
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.stack.push(new ConstElementInt(opCode - 2 - 1));
                break;
            }
            case 9: 
            case 10: {
                this.stack.push(new ConstElementLong(opCode - 9));
                break;
            }
            case 11: {
                this.stack.push(new ConstElementFloat(Float.valueOf(0.0f)));
                break;
            }
            case 12: {
                this.stack.push(new ConstElementFloat(Float.valueOf(1.0f)));
                break;
            }
            case 13: {
                this.stack.push(new ConstElementFloat(Float.valueOf(2.0f)));
                break;
            }
            case 14: {
                this.stack.push(new ConstElementDouble(0.0));
                break;
            }
            case 15: {
                this.stack.push(new ConstElementDouble(1.0));
                break;
            }
            case 16: {
                this.stack.push(new ConstElementInt(((BIPUSH)i).getValue()));
                break;
            }
            case 17: {
                this.stack.push(new ConstElementInt(((SIPUSH)i).getValue()));
                break;
            }
            case 18: 
            case 19: {
                this.handleLDC((LDC)i);
                break;
            }
            case 20: {
                this.handleLDC2W((LDC2_W)i);
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.handleLoad((LoadInstruction)i);
                break;
            }
            case 46: {
                this.handleArrayLoad(JavaCGConstantTypeEnum.CONSTTE_INT);
                break;
            }
            case 47: {
                this.handleArrayLoad(JavaCGConstantTypeEnum.CONSTTE_LONG);
                break;
            }
            case 48: {
                this.handleArrayLoad(JavaCGConstantTypeEnum.CONSTTE_FLOAT);
                break;
            }
            case 49: {
                this.handleArrayLoad(JavaCGConstantTypeEnum.CONSTTE_DOUBLE);
                break;
            }
            case 50: {
                this.handleArrayLoad(null, true);
                break;
            }
            case 51: {
                this.handleArrayLoad(JavaCGConstantTypeEnum.CONSTTE_BYTE);
                break;
            }
            case 52: {
                this.handleArrayLoad(JavaCGConstantTypeEnum.CONSTTE_CHAR);
                break;
            }
            case 53: {
                this.handleArrayLoad(JavaCGConstantTypeEnum.CONSTTE_SHORT);
                break;
            }
            case 54: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                this.handleStore((StoreInstruction)i, JavaCGConstantTypeEnum.CONSTTE_INT, ih);
                break;
            }
            case 55: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                this.handleStore((StoreInstruction)i, JavaCGConstantTypeEnum.CONSTTE_LONG, ih);
                break;
            }
            case 56: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                this.handleStore((StoreInstruction)i, JavaCGConstantTypeEnum.CONSTTE_FLOAT, ih);
                break;
            }
            case 57: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                this.handleStore((StoreInstruction)i, JavaCGConstantTypeEnum.CONSTTE_DOUBLE, ih);
                break;
            }
            case 58: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                this.handleStore((StoreInstruction)i, null, ih);
                break;
            }
            case 79: {
                this.handleArrayStore(JavaCGConstantTypeEnum.CONSTTE_INT);
                break;
            }
            case 80: {
                this.handleArrayStore(JavaCGConstantTypeEnum.CONSTTE_LONG);
                break;
            }
            case 81: {
                this.handleArrayStore(JavaCGConstantTypeEnum.CONSTTE_FLOAT);
                break;
            }
            case 82: {
                this.handleArrayStore(JavaCGConstantTypeEnum.CONSTTE_DOUBLE);
                break;
            }
            case 83: {
                this.handleArrayStore(null, true);
                break;
            }
            case 84: {
                this.handleArrayStore(JavaCGConstantTypeEnum.CONSTTE_BYTE);
                break;
            }
            case 85: {
                this.handleArrayStore(JavaCGConstantTypeEnum.CONSTTE_CHAR);
                break;
            }
            case 86: {
                this.handleArrayStore(JavaCGConstantTypeEnum.CONSTTE_SHORT);
                break;
            }
            case 87: {
                this.stack.pop();
                break;
            }
            case 88: {
                this.handlePOP2();
                break;
            }
            case 89: {
                this.handleDUP();
                break;
            }
            case 90: {
                this.handleDUPX1();
                break;
            }
            case 91: {
                this.handleDUPX2();
                break;
            }
            case 92: {
                this.handleDUP2();
                break;
            }
            case 93: {
                this.handleDUP2X1();
                break;
            }
            case 94: {
                this.handleDUP2X2();
                break;
            }
            case 95: {
                this.handleSWAP();
                break;
            }
            case 96: {
                this.handleArithmeticOperation2(ih, JavaCGConstantTypeEnum.CONSTTE_INT, JavaCGArithmeticOperationTypeEnum.AOTE_ADD);
                break;
            }
            case 100: {
                this.handleArithmeticOperation2(ih, JavaCGConstantTypeEnum.CONSTTE_INT, JavaCGArithmeticOperationTypeEnum.AOTE_SUB);
                break;
            }
            case 104: {
                this.handleArithmeticOperation2(ih, JavaCGConstantTypeEnum.CONSTTE_INT, JavaCGArithmeticOperationTypeEnum.AOTE_MUL);
                break;
            }
            case 108: {
                this.handleArithmeticOperation2(ih, JavaCGConstantTypeEnum.CONSTTE_INT, JavaCGArithmeticOperationTypeEnum.AOTE_DIV);
                break;
            }
            case 112: 
            case 126: 
            case 128: 
            case 130: {
                this.handleArithmeticOperation2(ih, JavaCGConstantTypeEnum.CONSTTE_INT, null);
                break;
            }
            case 97: {
                this.handleArithmeticOperation2(ih, JavaCGConstantTypeEnum.CONSTTE_LONG, JavaCGArithmeticOperationTypeEnum.AOTE_ADD);
                break;
            }
            case 101: {
                this.handleArithmeticOperation2(ih, JavaCGConstantTypeEnum.CONSTTE_LONG, JavaCGArithmeticOperationTypeEnum.AOTE_SUB);
                break;
            }
            case 105: {
                this.handleArithmeticOperation2(ih, JavaCGConstantTypeEnum.CONSTTE_LONG, JavaCGArithmeticOperationTypeEnum.AOTE_MUL);
                break;
            }
            case 109: {
                this.handleArithmeticOperation2(ih, JavaCGConstantTypeEnum.CONSTTE_LONG, JavaCGArithmeticOperationTypeEnum.AOTE_DIV);
                break;
            }
            case 113: 
            case 127: 
            case 129: 
            case 131: {
                this.handleArithmeticOperation2(ih, JavaCGConstantTypeEnum.CONSTTE_LONG, null);
                break;
            }
            case 98: {
                this.handleArithmeticOperation2(ih, JavaCGConstantTypeEnum.CONSTTE_FLOAT, JavaCGArithmeticOperationTypeEnum.AOTE_ADD);
                break;
            }
            case 102: {
                this.handleArithmeticOperation2(ih, JavaCGConstantTypeEnum.CONSTTE_FLOAT, JavaCGArithmeticOperationTypeEnum.AOTE_SUB);
                break;
            }
            case 106: {
                this.handleArithmeticOperation2(ih, JavaCGConstantTypeEnum.CONSTTE_FLOAT, JavaCGArithmeticOperationTypeEnum.AOTE_MUL);
                break;
            }
            case 110: {
                this.handleArithmeticOperation2(ih, JavaCGConstantTypeEnum.CONSTTE_FLOAT, JavaCGArithmeticOperationTypeEnum.AOTE_DIV);
                break;
            }
            case 114: {
                this.handleArithmeticOperation2(ih, JavaCGConstantTypeEnum.CONSTTE_FLOAT, null);
                break;
            }
            case 99: {
                this.handleArithmeticOperation2(ih, JavaCGConstantTypeEnum.CONSTTE_DOUBLE, JavaCGArithmeticOperationTypeEnum.AOTE_ADD);
                break;
            }
            case 103: {
                this.handleArithmeticOperation2(ih, JavaCGConstantTypeEnum.CONSTTE_DOUBLE, JavaCGArithmeticOperationTypeEnum.AOTE_SUB);
                break;
            }
            case 107: {
                this.handleArithmeticOperation2(ih, JavaCGConstantTypeEnum.CONSTTE_DOUBLE, JavaCGArithmeticOperationTypeEnum.AOTE_MUL);
                break;
            }
            case 111: {
                this.handleArithmeticOperation2(ih, JavaCGConstantTypeEnum.CONSTTE_DOUBLE, JavaCGArithmeticOperationTypeEnum.AOTE_DIV);
                break;
            }
            case 115: {
                this.handleArithmeticOperation2(ih, JavaCGConstantTypeEnum.CONSTTE_DOUBLE, null);
                break;
            }
            case 116: {
                this.handleArithmeticOperation1(JavaCGConstantTypeEnum.CONSTTE_INT);
                break;
            }
            case 117: {
                this.handleArithmeticOperation1(JavaCGConstantTypeEnum.CONSTTE_LONG);
                break;
            }
            case 118: {
                this.handleArithmeticOperation1(JavaCGConstantTypeEnum.CONSTTE_FLOAT);
                break;
            }
            case 119: {
                this.handleArithmeticOperation1(JavaCGConstantTypeEnum.CONSTTE_DOUBLE);
                break;
            }
            case 120: 
            case 122: 
            case 124: {
                this.handleBitOperator(JavaCGConstantTypeEnum.CONSTTE_INT);
                break;
            }
            case 121: 
            case 123: 
            case 125: {
                this.handleBitOperator(JavaCGConstantTypeEnum.CONSTTE_LONG);
                break;
            }
            case 132: {
                this.handleIinc((IINC)i);
                break;
            }
            case 133: {
                this.handleTypeConversion(JavaCGConstantTypeEnum.CONSTTE_INT, JavaCGConstantTypeEnum.CONSTTE_LONG);
                break;
            }
            case 134: {
                this.handleTypeConversion(JavaCGConstantTypeEnum.CONSTTE_INT, JavaCGConstantTypeEnum.CONSTTE_FLOAT);
                break;
            }
            case 135: {
                this.handleTypeConversion(JavaCGConstantTypeEnum.CONSTTE_INT, JavaCGConstantTypeEnum.CONSTTE_DOUBLE);
                break;
            }
            case 136: {
                this.handleTypeConversion(JavaCGConstantTypeEnum.CONSTTE_LONG, JavaCGConstantTypeEnum.CONSTTE_INT);
                break;
            }
            case 137: {
                this.handleTypeConversion(JavaCGConstantTypeEnum.CONSTTE_LONG, JavaCGConstantTypeEnum.CONSTTE_FLOAT);
                break;
            }
            case 138: {
                this.handleTypeConversion(JavaCGConstantTypeEnum.CONSTTE_LONG, JavaCGConstantTypeEnum.CONSTTE_DOUBLE);
                break;
            }
            case 139: {
                this.handleTypeConversion(JavaCGConstantTypeEnum.CONSTTE_FLOAT, JavaCGConstantTypeEnum.CONSTTE_INT);
                break;
            }
            case 140: {
                this.handleTypeConversion(JavaCGConstantTypeEnum.CONSTTE_FLOAT, JavaCGConstantTypeEnum.CONSTTE_LONG);
                break;
            }
            case 141: {
                this.handleTypeConversion(JavaCGConstantTypeEnum.CONSTTE_FLOAT, JavaCGConstantTypeEnum.CONSTTE_DOUBLE);
                break;
            }
            case 142: {
                this.handleTypeConversion(JavaCGConstantTypeEnum.CONSTTE_DOUBLE, JavaCGConstantTypeEnum.CONSTTE_INT);
                break;
            }
            case 143: {
                this.handleTypeConversion(JavaCGConstantTypeEnum.CONSTTE_DOUBLE, JavaCGConstantTypeEnum.CONSTTE_LONG);
                break;
            }
            case 144: {
                this.handleTypeConversion(JavaCGConstantTypeEnum.CONSTTE_DOUBLE, JavaCGConstantTypeEnum.CONSTTE_FLOAT);
                break;
            }
            case 145: 
            case 146: 
            case 147: {
                this.handleTypeConversion(JavaCGConstantTypeEnum.CONSTTE_INT, JavaCGConstantTypeEnum.CONSTTE_INT);
                break;
            }
            case 148: {
                this.handleCompare(JavaCGConstantTypeEnum.CONSTTE_LONG);
                break;
            }
            case 149: 
            case 150: {
                this.handleCompare(JavaCGConstantTypeEnum.CONSTTE_FLOAT);
                break;
            }
            case 151: 
            case 152: {
                this.handleCompare(JavaCGConstantTypeEnum.CONSTTE_DOUBLE);
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                this.handleIf1();
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: {
                this.handleIf2();
                break;
            }
            case 165: 
            case 166: {
                this.stack.pop();
                this.stack.pop();
                break;
            }
            case 167: {
                break;
            }
            case 168: {
                this.handleJSR(ih);
                break;
            }
            case 169: {
                instructionParseResult = this.handleRET((RET)i);
                break;
            }
            case 170: 
            case 171: {
                this.stack.pop();
                break;
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                instructionParseResult = this.handleReturn();
                break;
            }
            case 177: {
                break;
            }
            case 178: {
                this.handleGETSTATIC((GETSTATIC)i);
                break;
            }
            case 179: {
                instructionParseResult = this.handlePUTSTATIC((PUTSTATIC)i);
                break;
            }
            case 180: {
                this.handleGETFIELD((GETFIELD)i);
                break;
            }
            case 181: {
                instructionParseResult = this.handlePUTFIELD((PUTFIELD)i);
                break;
            }
            case 182: {
                instructionParseResult = this.handleMethodInvoke((InvokeInstruction)((INVOKEVIRTUAL)i), ih, true);
                break;
            }
            case 183: {
                instructionParseResult = this.handleMethodInvoke((InvokeInstruction)((INVOKESPECIAL)i), ih, true);
                break;
            }
            case 184: {
                instructionParseResult = this.handleMethodInvoke((InvokeInstruction)((INVOKESTATIC)i), ih, false);
                break;
            }
            case 185: {
                instructionParseResult = this.handleMethodInvoke((InvokeInstruction)((INVOKEINTERFACE)i), ih, true);
                break;
            }
            case 186: {
                instructionParseResult = this.handleMethodInvoke((InvokeInstruction)((INVOKEDYNAMIC)i), ih, false);
                break;
            }
            case 187: {
                this.stack.push(new VariableElement(JavaCGInstructionUtil.getTypeString((TypedInstruction)((NEW)i), this.cpg)));
                break;
            }
            case 188: {
                this.handleNEWARRAY((NEWARRAY)i);
                break;
            }
            case 189: {
                this.handleANEWARRAY((ANEWARRAY)i);
                break;
            }
            case 190: {
                this.stack.pop();
                this.stack.push(new VariableElement(JavaCGConstantTypeEnum.CONSTTE_INT.getType()));
                break;
            }
            case 191: {
                instructionParseResult = this.handleATHROW();
                break;
            }
            case 192: {
                this.handleCHECKCAST((CHECKCAST)i);
                break;
            }
            case 193: {
                this.stack.pop();
                this.stack.push(new VariableElement(JavaCGConstantTypeEnum.CONSTTE_INT.getType()));
                break;
            }
            case 194: 
            case 195: {
                this.stack.pop();
                break;
            }
            case 196: {
                break;
            }
            case 197: {
                this.handleMULTIANEWARRAY((MULTIANEWARRAY)i);
                break;
            }
            case 198: 
            case 199: {
                this.stack.pop();
                break;
            }
            case 200: {
                break;
            }
            case 201: {
                this.handleJSR(ih);
                break;
            }
            default: {
                logger.error("\u672a\u5904\u7406\u7684\u6307\u4ee4 {} {}", (Object)opCode, (Object)i.getClass().getName());
            }
        }
        return instructionParseResult;
    }

    private void handleLDC(LDC ldc) {
        String typeString = JavaCGInstructionUtil.getTypeString((TypedInstruction)ldc, this.cpg);
        Object value = ldc.getValue(this.cpg);
        if (JavaCGConstantTypeEnum.CONSTTE_INT.getType().equals(typeString)) {
            this.stack.push(new ConstElementInt(value));
        } else if (JavaCGConstantTypeEnum.CONSTTE_FLOAT.getType().equals(typeString)) {
            this.stack.push(new ConstElementFloat(value));
        } else if (JavaCGCommonNameConstants.CLASS_NAME_STRING.equals(typeString)) {
            this.stack.push(new ConstElementString(value));
        } else if (JavaCGCommonNameConstants.CLASS_NAME_CLASS.equals(typeString)) {
            ObjectType objectType = (ObjectType)value;
            this.stack.push(new VariableElement(objectType.getClassName()));
        } else {
            logger.error("LDC \u6682\u4e0d\u652f\u6301\u7684\u60c5\u51b5 {} {}", (Object)typeString, value);
        }
    }

    private void handleLDC2W(LDC2_W ldc2W) {
        String typeString = JavaCGInstructionUtil.getTypeString((TypedInstruction)ldc2W, this.cpg);
        Number value = ldc2W.getValue(this.cpg);
        if (JavaCGConstantTypeEnum.CONSTTE_LONG.getType().equals(typeString)) {
            this.stack.push(new ConstElementLong(value));
        } else if (JavaCGConstantTypeEnum.CONSTTE_DOUBLE.getType().equals(typeString)) {
            this.stack.push(new ConstElementDouble(value));
        } else {
            logger.error("LDC2_W \u6682\u4e0d\u652f\u6301\u7684\u60c5\u51b5 {} {}", (Object)typeString, (Object)value);
        }
    }

    private void handleLoad(LoadInstruction loadInstruction) {
        int loadIndex = loadInstruction.getIndex();
        if (this.locals.size() > loadIndex) {
            LocalVariableElement local = this.locals.get(loadIndex);
            int argIndex = JavaCGByteCodeUtil.getArgIndexInMethod(this.mg, loadIndex);
            if (argIndex >= 0) {
                VariableDataSourceMethodArg variableDataSourceMethodArg = new VariableDataSourceMethodArg(1 + argIndex, local.getType());
                local.recordVariableDataSource(variableDataSourceMethodArg, this.frEqConversionMethodMap);
            }
            this.stack.push(local);
            return;
        }
        throw new JavaCGRuntimeException("\u672c\u5730\u53d8\u91cf\u4e0d\u5b58\u5728 " + loadIndex);
    }

    private void handleArrayLoad(JavaCGConstantTypeEnum typeEnum) {
        this.handleArrayLoad(typeEnum.getType(), false);
    }

    private void handleArrayLoad(String elementType, boolean isAaload) {
        String usedElementType;
        BaseElement indexVariable = this.stack.pop();
        BaseElement arrayVariable = this.stack.pop();
        if (!isAaload) {
            usedElementType = elementType;
        } else {
            String arrayType = arrayVariable.getType();
            if (!JavaCGByteCodeUtil.isNullType(arrayType) && !JavaCGByteCodeUtil.isArrayType(arrayType)) {
                throw new JavaCGRuntimeException("\u5f53\u524d\u7c7b\u578b\u4e0d\u662f\u6570\u7ec4 " + arrayType);
            }
            usedElementType = JavaCGByteCodeUtil.removeArrayFlag(arrayType);
        }
        this.stack.push(new VariableElement(usedElementType, true));
        indexVariable.checkTypeString(JavaCGConstantTypeEnum.CONSTTE_INT.getType());
        if (!isAaload) {
            arrayVariable.checkTypeString(JavaCGByteCodeUtil.addArrayFlag(usedElementType));
        }
    }

    private void handleStore(StoreInstruction storeInstruction, JavaCGConstantTypeEnum typeEnum, InstructionHandle ih) {
        String variableName;
        int index = storeInstruction.getIndex();
        BaseElement baseElement = this.stack.pop();
        String poppedElementType = baseElement.getType();
        LocalVariable localVariable = this.localVariableTable.getLocalVariable(index, ih.getNext().getPosition());
        String string = variableName = localVariable != null ? localVariable.getName() : null;
        if (typeEnum == null && !JavaCGByteCodeUtil.isNullType(poppedElementType)) {
            this.locals.add(poppedElementType, baseElement, index, variableName);
            return;
        }
        String actualType = localVariable != null ? Utility.typeSignatureToString((String)localVariable.getSignature(), (boolean)false) : (typeEnum != null ? typeEnum.getType() : poppedElementType);
        this.locals.add(actualType, baseElement, index, variableName);
    }

    private void handleArrayStore(JavaCGConstantTypeEnum typeEnum) {
        this.handleArrayStore(typeEnum.getType(), false);
    }

    private void handleArrayStore(String arrayType, boolean isAastore) {
        BaseElement valueVariable = this.stack.pop();
        BaseElement indexVariable = this.stack.pop();
        BaseElement arrayVariable = this.stack.pop();
        indexVariable.checkTypeString(JavaCGConstantTypeEnum.CONSTTE_INT.getType());
        if (!isAastore) {
            valueVariable.checkTypeString(arrayType);
            arrayVariable.checkTypeString(JavaCGByteCodeUtil.addArrayFlag(arrayType));
        }
        if (!arrayVariable.isArrayElement()) {
            logger.error("\u4e0d\u662f\u6570\u7ec4\u7c7b\u578b {}", (Object)arrayVariable.getClass().getName());
            return;
        }
        Object indexObj = indexVariable.getValue();
        if (indexObj instanceof Integer) {
            Integer index = (Integer)indexObj;
            arrayVariable.setElement(index, valueVariable);
        }
    }

    private void handlePOP2() {
        BaseElement element = this.stack.pop();
        if (element.getElementSize() == 1) {
            this.stack.pop();
        }
    }

    private void handleDUP() {
        BaseElement element = this.stack.pop();
        this.stack.push(element);
        this.stack.push(element);
    }

    private void handleDUPX1() {
        BaseElement element1 = this.stack.pop();
        BaseElement element2 = this.stack.pop();
        this.stack.push(element1);
        this.stack.push(element2);
        this.stack.push(element1);
    }

    private void handleDUPX2() {
        BaseElement element1 = this.stack.pop();
        BaseElement element2 = this.stack.pop();
        if (element2.getElementSize() == 2) {
            this.stack.push(element1);
            this.stack.push(element2);
            this.stack.push(element1);
            return;
        }
        BaseElement element3 = this.stack.pop();
        this.stack.push(element1);
        this.stack.push(element3);
        this.stack.push(element2);
        this.stack.push(element1);
    }

    private void handleDUP2() {
        BaseElement element1 = this.stack.pop();
        if (element1.getElementSize() == 2) {
            this.stack.push(element1);
            this.stack.push(element1);
            return;
        }
        BaseElement element2 = this.stack.pop();
        this.stack.push(element2);
        this.stack.push(element1);
        this.stack.push(element2);
        this.stack.push(element1);
    }

    private void handleDUP2X1() {
        BaseElement element1 = this.stack.pop();
        BaseElement element2 = this.stack.pop();
        if (element1.getElementSize() == 2) {
            this.stack.push(element1);
            this.stack.push(element2);
            this.stack.push(element1);
            return;
        }
        BaseElement element3 = this.stack.pop();
        this.stack.push(element2);
        this.stack.push(element1);
        this.stack.push(element3);
        this.stack.push(element2);
        this.stack.push(element1);
    }

    private void handleDUP2X2() {
        BaseElement element1 = this.stack.pop();
        BaseElement element2 = this.stack.pop();
        if (element1.getElementSize() == 2) {
            if (element2.getElementSize() == 2) {
                this.stack.push(element1);
                this.stack.push(element2);
                this.stack.push(element1);
                return;
            }
            BaseElement element3 = this.stack.pop();
            this.stack.push(element1);
            this.stack.push(element3);
            this.stack.push(element2);
            this.stack.push(element1);
            return;
        }
        BaseElement element3 = this.stack.pop();
        if (element3.getElementSize() == 2) {
            this.stack.push(element2);
            this.stack.push(element1);
            this.stack.push(element3);
            this.stack.push(element2);
            this.stack.push(element1);
            return;
        }
        BaseElement element4 = this.stack.pop();
        this.stack.push(element2);
        this.stack.push(element1);
        this.stack.push(element4);
        this.stack.push(element3);
        this.stack.push(element2);
        this.stack.push(element1);
    }

    private void handleSWAP() {
        BaseElement element1 = this.stack.pop();
        BaseElement element2 = this.stack.pop();
        this.stack.push(element1);
        this.stack.push(element2);
    }

    private void handleArithmeticOperation2(InstructionHandle ih, JavaCGConstantTypeEnum constantTypeEnum, JavaCGArithmeticOperationTypeEnum arithmeticOperationTypeEnum) {
        BaseElement value2 = this.stack.pop();
        BaseElement value1 = this.stack.pop();
        value2.checkTypeString(constantTypeEnum.getType());
        value1.checkTypeString(constantTypeEnum.getType());
        VariableElement variableElement = new VariableElement(constantTypeEnum.getType());
        if (arithmeticOperationTypeEnum != null) {
            VariableDataSourceArithmeticOperation dataSourceArithmeticOperation = new VariableDataSourceArithmeticOperation(ih.getPosition(), arithmeticOperationTypeEnum, value1, value2);
            variableElement.setVariableDataSource(dataSourceArithmeticOperation);
        }
        this.stack.push(variableElement);
    }

    private void handleArithmeticOperation1(JavaCGConstantTypeEnum constantTypeEnum) {
        BaseElement value = this.stack.pop();
        this.stack.push(new VariableElement(constantTypeEnum.getType()));
        value.checkTypeString(constantTypeEnum.getType());
    }

    private void handleBitOperator(JavaCGConstantTypeEnum constantTypeEnum) {
        BaseElement value2 = this.stack.pop();
        BaseElement value1 = this.stack.pop();
        this.stack.push(new VariableElement(constantTypeEnum.getType()));
        value2.checkTypeString(JavaCGConstantTypeEnum.CONSTTE_INT.getType());
        value1.checkTypeString(constantTypeEnum.getType());
    }

    private void handleIinc(IINC iinc) {
        this.locals.setValue2Null(iinc.getIndex());
    }

    private void handleTypeConversion(JavaCGConstantTypeEnum oldTypeEnum, JavaCGConstantTypeEnum newTypeEnum) {
        BaseElement value = this.stack.pop();
        this.stack.push(new VariableElement(newTypeEnum.getType()));
        value.checkTypeString(oldTypeEnum.getType());
    }

    private void handleCompare(JavaCGConstantTypeEnum constantTypeEnum) {
        BaseElement value2 = this.stack.pop();
        BaseElement value1 = this.stack.pop();
        this.stack.push(new VariableElement(JavaCGConstantTypeEnum.CONSTTE_INT.getType()));
        value2.checkTypeString(constantTypeEnum.getType());
        value1.checkTypeString(constantTypeEnum.getType());
    }

    private void handleIf1() {
        BaseElement value = this.stack.pop();
        value.checkTypeString(JavaCGConstantTypeEnum.CONSTTE_INT.getType());
    }

    private void handleIf2() {
        BaseElement value2 = this.stack.pop();
        BaseElement value1 = this.stack.pop();
        value2.checkTypeString(JavaCGConstantTypeEnum.CONSTTE_INT.getType());
        value1.checkTypeString(JavaCGConstantTypeEnum.CONSTTE_INT.getType());
    }

    private void handleJSR(InstructionHandle ih) {
        this.stack.push(new JSRElement(ih.getNext()));
    }

    private RetParseResult handleRET(RET ret) {
        LocalVariableElement localVariableElement = this.locals.get(ret.getIndex());
        if (!"0jsr".equals(localVariableElement.getType()) || !(localVariableElement.getValue() instanceof InstructionHandle)) {
            throw new JavaCGRuntimeException("ret\u6307\u4ee4\u5bf9\u5e94\u7684\u672c\u5730\u53d8\u91cf\u975e\u6cd5 " + localVariableElement);
        }
        InstructionHandle jsrNextIh = (InstructionHandle)localVariableElement.getValue();
        return new RetParseResult(jsrNextIh);
    }

    private ReturnParseResult handleReturn() {
        BaseElement baseElement = this.stack.pop();
        if (this.parseMethodCallTypeValueFlag) {
            return new ReturnParseResult(baseElement);
        }
        return null;
    }

    private void handleGETSTATIC(GETSTATIC getstatic) {
        String fieldName = getstatic.getFieldName(this.cpg);
        ObjectType classType = getstatic.getLoadClassType(this.cpg);
        FieldElement fieldElement = this.staticFieldInfoMap.getStatic(classType.getClassName(), fieldName);
        if (fieldElement == null) {
            String fieldType = getstatic.getFieldType(this.cpg).toString();
            fieldElement = new StaticFieldElement(fieldType, false, null, fieldName, classType.getClassName());
        }
        this.stack.push(fieldElement);
    }

    private PutStaticParseResult handlePUTSTATIC(PUTSTATIC putstatic) {
        String fieldName = putstatic.getFieldName(this.cpg);
        ObjectType classType = putstatic.getLoadClassType(this.cpg);
        BaseElement value = this.stack.pop();
        String putStaticClassName = classType.getClassName();
        StaticFieldElement staticFieldElement = new StaticFieldElement(value.getType(), value.isArrayElement(), value.getValue(), fieldName, putStaticClassName);
        if (value.isArrayElement()) {
            staticFieldElement.setArrayValueMap(value.getArrayValueMap());
        }
        this.staticFieldInfoMap.putStatic(putStaticClassName, fieldName, staticFieldElement);
        if (this.inClinitMethod) {
            return new PutStaticParseResult(putStaticClassName, fieldName, putstatic.getFieldType(this.cpg).toString(), value);
        }
        return null;
    }

    private void handleGETFIELD(GETFIELD getfield) {
        FieldElement fieldElement;
        LocalVariableElement objectLocalVariableElement;
        String fieldName = getfield.getFieldName(this.cpg);
        BaseElement object = this.stack.pop();
        if (!(object instanceof VariableElement)) {
            throw new JavaCGRuntimeException("GETFIELD\u5bf9\u8c61\u7c7b\u578b\u4e0e\u9884\u671f\u4e0d\u4e00\u81f4: " + object.getClass().getName());
        }
        String objectClassName = JavaCGElementUtil.getVariableClassNameOrThis((VariableElement)object);
        VariableDataSourceField variableDataSourceField = new VariableDataSourceField();
        variableDataSourceField.setClassName(objectClassName);
        variableDataSourceField.setFieldName(fieldName);
        if (object instanceof LocalVariableElement && (objectLocalVariableElement = (LocalVariableElement)object).isThis()) {
            List<String> possibleTypeList;
            fieldElement = this.nonStaticFieldInfoMap.get(fieldName);
            if (fieldElement != null) {
                FieldElement newFieldElement = fieldElement.copyFieldElement();
                variableDataSourceField.setFieldType(newFieldElement.getType());
                newFieldElement.recordVariableDataSource(variableDataSourceField, this.frEqConversionMethodMap);
                this.stack.push(newFieldElement);
                return;
            }
            if (this.useFieldPossibleTypeFlag && !JavaCGUtil.isCollectionEmpty(possibleTypeList = this.nonStaticFieldPossibleTypes.getPossibleTypeList(fieldName))) {
                if (possibleTypeList.size() == 1) {
                    fieldElement = new FieldElement(possibleTypeList.get(0), false, null, fieldName, objectClassName);
                    variableDataSourceField.setFieldType(fieldElement.getType());
                    fieldElement.recordVariableDataSource(variableDataSourceField, this.frEqConversionMethodMap);
                    this.stack.push(fieldElement);
                    return;
                }
                logger.warn("{} \u7c7b\u7684\u6784\u9020\u51fd\u6570\u89e3\u6790\u540e {} \u975e\u9759\u6001\u5b57\u6bb5\u53ef\u80fd\u7684\u7c7b\u578b\u6570\u91cf\u5927\u4e8e1 {}", new Object[]{this.mg.getClassName(), fieldName, StringUtils.join(possibleTypeList, (String)" ")});
            }
        }
        String fieldType = getfield.getFieldType(this.cpg).toString();
        fieldElement = new FieldElement(fieldType, false, null, fieldName, objectClassName);
        variableDataSourceField.setFieldType(fieldElement.getType());
        fieldElement.recordVariableDataSource(variableDataSourceField, this.frEqConversionMethodMap);
        this.stack.push(fieldElement);
    }

    private PutFieldParseResult handlePUTFIELD(PUTFIELD putfield) {
        LocalVariableElement objectLocalVariableElement;
        String fieldName = putfield.getFieldName(this.cpg);
        BaseElement value = this.stack.pop();
        BaseElement object = this.stack.pop();
        if (!(object instanceof VariableElement)) {
            throw new JavaCGRuntimeException("PUTFIELD\u5bf9\u8c61\u7c7b\u578b\u4e0e\u9884\u671f\u4e0d\u4e00\u81f4: " + object.getClass().getName());
        }
        if (object instanceof LocalVariableElement && (objectLocalVariableElement = (LocalVariableElement)object).isThis()) {
            String rawFieldType;
            String objectClassName = JavaCGElementUtil.getVariableClassNameOrThis(objectLocalVariableElement);
            FieldElement fieldElement = new FieldElement(value.getType(), value.isArrayElement(), value.getValue(), fieldName, objectClassName);
            if (value.isArrayElement()) {
                fieldElement.setArrayValueMap(value.getArrayValueMap());
            }
            this.nonStaticFieldInfoMap.put(fieldName, fieldElement);
            if (this.recordFieldPossibleTypeFlag && !StringUtils.equals((CharSequence)(rawFieldType = putfield.getFieldType(this.cpg).toString()), (CharSequence)value.getType())) {
                this.nonStaticFieldPossibleTypes.addPossibleType(fieldName, value.getType());
            }
        }
        if (this.maybeSetMethod) {
            return new PutFieldParseResult(fieldName, putfield.getFieldType(this.cpg).toString(), value, object);
        }
        return null;
    }

    private MethodCallParseResult handleMethodInvoke(InvokeInstruction invokeInstruction, InstructionHandle ih, boolean userObjectReference) {
        BaseElement topElement;
        Type[] argTypes = invokeInstruction.getArgumentTypes(this.cpg);
        int argumentNumber = argTypes.length;
        ArrayList<BaseElement> argElementList = new ArrayList<BaseElement>(argumentNumber);
        for (int i = 0; i < argumentNumber; ++i) {
            argElementList.add(0, this.stack.pop());
        }
        BaseElement objectElement = null;
        if (userObjectReference) {
            objectElement = this.stack.pop();
        }
        Type returnType = invokeInstruction.getReturnType(this.cpg);
        String calleeClassName = invokeInstruction.getReferenceType(this.cpg).toString();
        String calleeMethodName = invokeInstruction.getMethodName(this.cpg);
        if (Type.VOID != returnType) {
            VariableElement variableElement;
            if (objectElement instanceof StaticFieldElement) {
                StaticFieldElement staticFieldElement = (StaticFieldElement)objectElement;
                variableElement = new StaticFieldMethodCallElement(returnType.toString(), returnType instanceof ArrayType, staticFieldElement.getClassName(), staticFieldElement.getName(), calleeMethodName);
            } else {
                variableElement = new VariableElement(returnType.toString());
            }
            VariableDataSourceMethodCallReturn variableDataSourceMethodCallReturn = new VariableDataSourceMethodCallReturn(ih.getPosition(), invokeInstruction.getClass().getSimpleName(), calleeClassName, calleeMethodName, JavaCGClassMethodUtil.getArgTypeStr(argTypes), returnType.toString(), objectElement, argElementList);
            variableElement.recordVariableDataSource(variableDataSourceMethodCallReturn, this.frEqConversionMethodMap);
            this.stack.push(variableElement);
        } else if (JavaCGClassMethodUtil.isInitMethod(calleeMethodName) && !JavaCGClassMethodUtil.isObjectClass(calleeClassName) && !this.stack.isEmpty() && (topElement = this.stack.peek()) instanceof VariableElement) {
            VariableElement topVariableElement = (VariableElement)topElement;
            VariableDataSourceMethodCallReturn variableDataSourceMethodCallReturn = new VariableDataSourceMethodCallReturn(ih.getPosition(), invokeInstruction.getClass().getSimpleName(), calleeClassName, calleeMethodName, JavaCGClassMethodUtil.getArgTypeStr(argTypes), calleeClassName, objectElement, argElementList);
            topVariableElement.recordVariableDataSource(variableDataSourceMethodCallReturn, this.frEqConversionMethodMap);
        }
        return new MethodCallParseResult(objectElement, argElementList);
    }

    private void handleNEWARRAY(NEWARRAY newarray) {
        BaseElement countVariable = this.stack.pop();
        VariableElement arrayElement = new VariableElement(newarray.getType().toString(), true);
        this.stack.push(arrayElement);
        countVariable.checkTypeString(JavaCGConstantTypeEnum.CONSTTE_INT.getType());
    }

    private void handleANEWARRAY(ANEWARRAY anewarray) {
        BaseElement countVariable = this.stack.pop();
        VariableElement arrayElement = new VariableElement(JavaCGByteCodeUtil.addArrayFlag(JavaCGInstructionUtil.getTypeString((TypedInstruction)anewarray, this.cpg)), true);
        this.stack.push(arrayElement);
        countVariable.checkTypeString(JavaCGConstantTypeEnum.CONSTTE_INT.getType());
    }

    private AThrowParseResult handleATHROW() {
        BaseElement throwElement = this.stack.pop();
        if (throwElement instanceof ConstElementNull) {
            return new AThrowNullParseResult();
        }
        if (!(throwElement instanceof VariableElement)) {
            throw new JavaCGRuntimeException("\u629b\u51fa\u5f02\u5e38\u7684\u5143\u7d20\u7c7b\u578b\u4e0d\u662f\u53d8\u91cf " + throwElement.getClass().getName());
        }
        VariableElement variableElement = (VariableElement)throwElement;
        this.stack.push(variableElement);
        return new AThrowParseResult(variableElement);
    }

    private void handleCHECKCAST(CHECKCAST checkcast) {
        BaseElement elementBefore = this.stack.pop();
        VariableElement variableElementAfter = new VariableElement(JavaCGInstructionUtil.getTypeString((TypedInstruction)checkcast, this.cpg));
        variableElementAfter.copyVariableDataSource(elementBefore);
        this.stack.push(variableElementAfter);
    }

    private void handleMULTIANEWARRAY(MULTIANEWARRAY multianewarray) {
        for (int i = 0; i < multianewarray.getDimensions(); ++i) {
            this.stack.pop();
        }
        VariableElement arrayElement = new VariableElement(JavaCGInstructionUtil.getTypeString((TypedInstruction)multianewarray, this.cpg), true);
        this.stack.push(arrayElement);
    }

    public void setStack(JavaCGOperandStack stack) {
        this.stack = stack;
    }

    public void setLocals(JavaCGLocalVariables locals) {
        this.locals = locals;
    }

    public void setNonStaticFieldInfoMap(FieldInformationMap nonStaticFieldInfoMap) {
        this.nonStaticFieldInfoMap = nonStaticFieldInfoMap;
    }

    public void setStaticFieldInfoMap(FieldInformationMap staticFieldInfoMap) {
        this.staticFieldInfoMap = staticFieldInfoMap;
    }

    public void setParseMethodCallTypeValueFlag(boolean parseMethodCallTypeValueFlag) {
        this.parseMethodCallTypeValueFlag = parseMethodCallTypeValueFlag;
    }

    public void setRecordFieldPossibleTypeFlag(boolean recordFieldPossibleTypeFlag) {
        this.recordFieldPossibleTypeFlag = recordFieldPossibleTypeFlag;
    }

    public void setUseFieldPossibleTypeFlag(boolean useFieldPossibleTypeFlag) {
        this.useFieldPossibleTypeFlag = useFieldPossibleTypeFlag;
    }

    public void setNonStaticFieldPossibleTypes(FieldPossibleTypes nonStaticFieldPossibleTypes) {
        this.nonStaticFieldPossibleTypes = nonStaticFieldPossibleTypes;
    }

    public void setMaybeSetMethod(boolean maybeSetMethod) {
        this.maybeSetMethod = maybeSetMethod;
    }

    public void setInClinitMethod(boolean inClinitMethod) {
        this.inClinitMethod = inClinitMethod;
    }
}

