/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.handler;

import com.adrninistrator.javacg.common.JavaCGCommonNameConstants;
import com.adrninistrator.javacg.common.TypeConstants;
import com.adrninistrator.javacg.common.enums.JavaCGCallTypeEnum;
import com.adrninistrator.javacg.common.enums.JavaCGCalleeObjTypeEnum;
import com.adrninistrator.javacg.common.enums.JavaCGMethodCallInfoTypeEnum;
import com.adrninistrator.javacg.common.enums.JavaCGYesNoEnum;
import com.adrninistrator.javacg.conf.JavaCGConfInfo;
import com.adrninistrator.javacg.dto.call.MethodCall;
import com.adrninistrator.javacg.dto.call.MethodCallList;
import com.adrninistrator.javacg.dto.call.MethodCallPossibleEntry;
import com.adrninistrator.javacg.dto.call.MethodCallPossibleInfo;
import com.adrninistrator.javacg.dto.call.MethodCallPossibleList;
import com.adrninistrator.javacg.dto.counter.JavaCGCounter;
import com.adrninistrator.javacg.dto.exception.CatchAndFinallyInfo;
import com.adrninistrator.javacg.dto.exception.CatchInfo;
import com.adrninistrator.javacg.dto.exception.FinallyInfo;
import com.adrninistrator.javacg.dto.exception.ThrowInfo;
import com.adrninistrator.javacg.dto.exception.ThrowInfoList;
import com.adrninistrator.javacg.dto.field.FieldTypeAndName;
import com.adrninistrator.javacg.dto.field.StaticFieldTypeAndName;
import com.adrninistrator.javacg.dto.fieldrelationship.GetSetFieldRelationship;
import com.adrninistrator.javacg.dto.instruction.InvokeInstructionPosAndCallee;
import com.adrninistrator.javacg.dto.jar.ClassAndJarNum;
import com.adrninistrator.javacg.dto.method.JavaCGMethodInfo;
import com.adrninistrator.javacg.exceptions.JavaCGRuntimeException;
import com.adrninistrator.javacg.extensions.annotationattributes.AnnotationAttributesFormatterInterface;
import com.adrninistrator.javacg.extensions.codeparser.MethodAnnotationParser;
import com.adrninistrator.javacg.extensions.manager.ExtensionsManager;
import com.adrninistrator.javacg.handler.AbstractMethodHandler;
import com.adrninistrator.javacg.handler.MethodHandler4TypeAndValue;
import com.adrninistrator.javacg.spring.UseSpringBeanByAnnotationHandler;
import com.adrninistrator.javacg.util.JavaCGAnnotationUtil;
import com.adrninistrator.javacg.util.JavaCGBootstrapMethodUtil;
import com.adrninistrator.javacg.util.JavaCGByteCodeUtil;
import com.adrninistrator.javacg.util.JavaCGClassMethodUtil;
import com.adrninistrator.javacg.util.JavaCGFileUtil;
import com.adrninistrator.javacg.util.JavaCGInstructionUtil;
import com.adrninistrator.javacg.util.JavaCGUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.BootstrapMethod;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantInvokeDynamic;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.GotoInstruction;
import org.apache.bcel.generic.INVOKEDYNAMIC;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.IfInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.TypedInstruction;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodHandler4Invoke
extends AbstractMethodHandler {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandler4Invoke.class);
    private final String callerMethodArgTypes;
    private final UseSpringBeanByAnnotationHandler useSpringBeanByAnnotationHandler;
    private final JavaCGCounter callIdCounter;
    protected final InstructionList instructionList;
    private final MethodCallList methodCallList;
    private final boolean innerAnonymousClassFlag;
    private final Map<Integer, MethodCallPossibleInfo> methodCallInfoMap = new HashMap<Integer, MethodCallPossibleInfo>(10);
    private MethodHandler4TypeAndValue methodHandler4TypeAndValue;
    private Map<String, Boolean> runnableImplClassMap;
    private Map<String, Boolean> callableImplClassMap;
    private Map<String, Boolean> transactionCallbackImplClassMap;
    private Map<String, Boolean> transactionCallbackWithoutResultChildClassMap;
    private Map<String, Boolean> threadChildClassMap;
    private ExtensionsManager extensionsManager;
    private AnnotationAttributesFormatterInterface annotationAttributesFormatter;
    private Writer methodCallWriter;
    private Writer lambdaMethodInfoWriter;
    private Writer methodAnnotationWriter;
    private Writer methodArgAnnotationWriter;
    private Writer methodLineNumberWriter;
    private Writer methodCallInfoWriter;
    private Writer methodCallMethodCallReturnWriter;
    private Writer methodCallStaticFieldWriter;
    private Writer methodReturnArgSeqWriter;
    private Writer methodReturnCallIdWriter;
    private Writer methodCatchWriter;
    private Writer methodFinallyWriter;
    private Writer methodThrowWriter;
    private Writer staticFinalFieldMethodCallIdWriter;
    private Writer fieldRelationshipWriter;
    private int lastJarNum;
    private boolean existsSameMethodNameAndArgs;
    private ClassAndJarNum classAndJarNum;
    private Map<Integer, Integer> invokeInstructionPositionCallIdMap;
    private Map<String, String> staticFinalFieldNameTypeMap;

    public MethodHandler4Invoke(Method method, MethodGen mg, JavaClass javaClass, JavaCGConfInfo javaCGConfInfo, String callerMethodArgTypes, String callerFullMethod, UseSpringBeanByAnnotationHandler useSpringBeanByAnnotationHandler, JavaCGCounter callIdCounter) {
        super(method, mg, javaClass, callerFullMethod, javaCGConfInfo);
        this.callerMethodArgTypes = callerMethodArgTypes;
        this.useSpringBeanByAnnotationHandler = useSpringBeanByAnnotationHandler;
        this.callIdCounter = callIdCounter;
        this.instructionList = mg.getInstructionList();
        this.methodCallList = new MethodCallList(callIdCounter);
        this.innerAnonymousClassFlag = JavaCGByteCodeUtil.checkInnerAnonymousClass(javaClass);
    }

    @Override
    protected void init() {
        if (this.parseMethodCallTypeValueFlag) {
            this.methodReturnArgSeqList = new ArrayList(1);
            this.methodReturnPositionList = new ArrayList(1);
            this.methodReturnArgSeqEQCList = new ArrayList(1);
            this.methodReturnPositionEQCList = new ArrayList(1);
            this.getSetFieldRelationshipList = new ArrayList();
        }
    }

    @Override
    protected boolean preHandleMethod() throws IOException {
        if (!this.existsSameMethodNameAndArgs) {
            JavaCGAnnotationUtil.writeAnnotationInfo(this.methodAnnotationWriter, this.method.getAnnotationEntries(), this.annotationAttributesFormatter, this.callerFullMethod);
            Object[] parameterAnnotationEntries = this.method.getParameterAnnotationEntries();
            if (ArrayUtils.isNotEmpty((Object[])parameterAnnotationEntries)) {
                for (int i = 0; i < parameterAnnotationEntries.length; ++i) {
                    Object parameterAnnotationEntry = parameterAnnotationEntries[i];
                    if (parameterAnnotationEntry == null) continue;
                    JavaCGAnnotationUtil.writeAnnotationInfo(this.methodArgAnnotationWriter, parameterAnnotationEntry.getAnnotationEntries(), this.annotationAttributesFormatter, this.callerFullMethod, String.valueOf(i));
                }
            }
            this.handleLineNumber(this.callerFullMethod);
        }
        this.handleMethodAnnotations();
        this.ih = JavaCGInstructionUtil.getFirstInstructionHandle(this.mg);
        return this.ih != null;
    }

    @Override
    protected boolean doHandleMethod() throws IOException {
        if (this.parseMethodCallTypeValueFlag) {
            this.methodHandler4TypeAndValue = new MethodHandler4TypeAndValue(this.method, this.mg, this.javaClass, this.callerFullMethod, this.javaCGConfInfo);
            this.methodHandler4TypeAndValue.setFailCounter(this.failCounter);
            this.methodHandler4TypeAndValue.setParseMethodCallTypeValueFlag(true);
            this.methodHandler4TypeAndValue.setGetMethodWriter(this.getMethodWriter);
            this.methodHandler4TypeAndValue.setSetMethodWriter(this.setMethodWriter);
            this.methodHandler4TypeAndValue.setFieldGenericsTypeWriter(this.fieldGenericsTypeWriter);
            this.methodHandler4TypeAndValue.setRecordedSetMethodSet(this.recordedSetMethodSet);
            this.methodHandler4TypeAndValue.setNonStaticFieldNameTypeMap(this.nonStaticFieldNameTypeMap);
            this.methodHandler4TypeAndValue.setNonStaticFieldNameGenericsTypeMap(this.nonStaticFieldNameGenericsTypeMap);
            this.methodHandler4TypeAndValue.setRecordedFieldWithGenericsTypeSet(this.recordedFieldWithGenericsTypeSet);
            this.methodHandler4TypeAndValue.setMethodReturnArgSeqList(this.methodReturnArgSeqList);
            this.methodHandler4TypeAndValue.setMethodReturnPositionList(this.methodReturnPositionList);
            this.methodHandler4TypeAndValue.setMethodReturnArgSeqEQCList(this.methodReturnArgSeqEQCList);
            this.methodHandler4TypeAndValue.setMethodReturnPositionEQCList(this.methodReturnPositionEQCList);
            this.methodHandler4TypeAndValue.setOnlyAnalyseReturnTypeFlag(false);
            if (this.inClinitMethod) {
                this.methodHandler4TypeAndValue.setInClinitMethod(true);
                this.methodHandler4TypeAndValue.setSfFieldInvokeInstructionMap(this.sfFieldInvokeInstructionMap);
            }
            if (this.javaCGConfInfo.isFirstParseInitMethodType()) {
                this.methodHandler4TypeAndValue.setRecordFieldPossibleTypeFlag(false);
                this.methodHandler4TypeAndValue.setUseFieldPossibleTypeFlag(true);
                this.methodHandler4TypeAndValue.setNonStaticFieldPossibleTypes(this.nonStaticFieldPossibleTypes);
            }
            if (this.javaCGConfInfo.isAnalyseFieldRelationship()) {
                this.methodHandler4TypeAndValue.setAnalyseFieldRelationshipFlag(true);
                this.methodHandler4TypeAndValue.setFieldRelationshipCounter(this.fieldRelationshipCounter);
                this.methodHandler4TypeAndValue.setGetSetFieldRelationshipList(this.getSetFieldRelationshipList);
            }
            if (!this.methodHandler4TypeAndValue.handleMethod()) {
                return false;
            }
            this.invokeInstructionPositionCallIdMap = new HashMap<Integer, Integer>();
        }
        do {
            ThrowInfoList throwInfoList;
            short opCode;
            if (JavaCGInstructionUtil.isMethodInvokeInstruction(opCode = this.ih.getInstruction().getOpcode())) {
                MethodCallPossibleInfo methodCallPossibleInfo = null;
                if (this.methodHandler4TypeAndValue != null) {
                    methodCallPossibleInfo = this.methodHandler4TypeAndValue.getMethodCallPossibleInfo(this.ih.getPosition());
                }
                this.handleInvokeInstruction(methodCallPossibleInfo);
            } else if (191 == opCode && this.methodHandler4TypeAndValue != null && (throwInfoList = this.methodHandler4TypeAndValue.getMethodThrowPossibleInfo(this.ih.getPosition())) != null) {
                this.handleATHROW(throwInfoList);
            }
            this.ih = this.ih.getNext();
        } while (this.ih != null);
        return true;
    }

    @Override
    protected boolean lastStep() throws IOException {
        for (MethodCall methodCall : this.methodCallList.getMethodCallList()) {
            String calleeClassJarNum = this.classAndJarNum.getJarNum(methodCall.getCalleeClassName());
            JavaCGFileUtil.write2FileWithTab(this.methodCallWriter, methodCall.genMethodCallContent(String.valueOf(this.lastJarNum), calleeClassJarNum));
            if (!this.parseMethodCallTypeValueFlag) continue;
            this.handleMethodCallPossibleInfo(methodCall, this.methodCallInfoMap.get(methodCall.getCallId()));
        }
        if (this.parseMethodCallTypeValueFlag) {
            for (Integer methodReturnArgSeq : this.methodReturnArgSeqList) {
                JavaCGFileUtil.write2FileWithTab(this.methodReturnArgSeqWriter, this.callerFullMethod, String.valueOf(methodReturnArgSeq), JavaCGYesNoEnum.NO.getStrValue());
            }
            for (Integer methodReturnPosition : this.methodReturnPositionList) {
                Integer methodReturnCallId = this.getInvokeInstructionCallId(methodReturnPosition);
                JavaCGFileUtil.write2FileWithTab(this.methodReturnCallIdWriter, this.callerFullMethod, String.valueOf(methodReturnCallId), JavaCGYesNoEnum.NO.getStrValue());
            }
            for (Integer methodReturnArgSeqEQC : this.methodReturnArgSeqEQCList) {
                if (this.methodReturnArgSeqList.contains(methodReturnArgSeqEQC)) continue;
                JavaCGFileUtil.write2FileWithTab(this.methodReturnArgSeqWriter, this.callerFullMethod, String.valueOf(methodReturnArgSeqEQC), JavaCGYesNoEnum.YES.getStrValue());
            }
            for (Object methodReturnPositionEQC : this.methodReturnPositionEQCList) {
                if (this.methodReturnPositionList.contains(methodReturnPositionEQC)) continue;
                Integer methodReturnCallIdEQC = this.getInvokeInstructionCallId((Integer)methodReturnPositionEQC);
                JavaCGFileUtil.write2FileWithTab(this.methodReturnCallIdWriter, this.callerFullMethod, String.valueOf(methodReturnCallIdEQC), JavaCGYesNoEnum.YES.getStrValue());
            }
            if (this.inClinitMethod && !this.sfFieldInvokeInstructionMap.isEmpty()) {
                ArrayList staticFinalFieldNameList = new ArrayList(this.sfFieldInvokeInstructionMap.keySet());
                Collections.sort(staticFinalFieldNameList);
                for (String staticFinalFieldName : staticFinalFieldNameList) {
                    String staticFinalFieldType = this.staticFinalFieldNameTypeMap.get(staticFinalFieldName);
                    if (JavaCGUtil.checkSkipClass(staticFinalFieldType, this.javaCGConfInfo.getNeedHandlePackageSet())) continue;
                    List invokeInstructionPosAndCalleeList = (List)this.sfFieldInvokeInstructionMap.get(staticFinalFieldName);
                    for (int i = 0; i < invokeInstructionPosAndCalleeList.size(); ++i) {
                        InvokeInstructionPosAndCallee invokeInstructionPosAndCallee = (InvokeInstructionPosAndCallee)invokeInstructionPosAndCalleeList.get(i);
                        if (JavaCGUtil.checkSkipClass(invokeInstructionPosAndCallee.getCalleeClassName(), this.javaCGConfInfo.getNeedHandlePackageSet())) continue;
                        Integer sffMethodCallId = this.getInvokeInstructionCallId(invokeInstructionPosAndCallee.getInvokeInstructionPosition());
                        JavaCGFileUtil.write2FileWithTab(this.staticFinalFieldMethodCallIdWriter, this.callerClassName, staticFinalFieldName, String.valueOf(i), String.valueOf(sffMethodCallId), staticFinalFieldType, invokeInstructionPosAndCallee.getCalleeClassName(), invokeInstructionPosAndCallee.getCalleeMethodName());
                    }
                }
            }
            for (GetSetFieldRelationship getSetFieldRelationship : this.getSetFieldRelationshipList) {
                int getMethodCallId = this.getInvokeInstructionCallId(getSetFieldRelationship.getGetInvokeInstructionPosition());
                int setMethodCallId = this.getInvokeInstructionCallId(getSetFieldRelationship.getSetInvokeInstructionPosition());
                JavaCGFileUtil.write2FileWithTab(this.fieldRelationshipWriter, String.valueOf(getSetFieldRelationship.getRecordId()), String.valueOf(getMethodCallId), String.valueOf(setMethodCallId), this.callerFullMethod, String.valueOf(getSetFieldRelationship.getCallerLineNumber()), getSetFieldRelationship.getGetClassName(), getSetFieldRelationship.getGetMethodName(), getSetFieldRelationship.getSetClassName(), getSetFieldRelationship.getSetMethodName(), getSetFieldRelationship.getValid(), getSetFieldRelationship.getType().getType());
            }
        }
        this.recordExceptionInfo();
        return true;
    }

    private void handleLineNumber(String callerFullMethod) throws IOException {
        int maxLineNumber;
        if (this.lineNumberTable == null) {
            return;
        }
        LineNumber[] lineNumbers = this.lineNumberTable.getLineNumberTable();
        if (lineNumbers == null || lineNumbers.length == 0) {
            return;
        }
        int minLineNumber = lineNumbers[0].getLineNumber();
        if (lineNumbers.length == 1) {
            maxLineNumber = minLineNumber;
        } else {
            maxLineNumber = lineNumbers[lineNumbers.length - 1].getLineNumber();
            for (LineNumber lineNumber : lineNumbers) {
                int sourceLineNumber = lineNumber.getLineNumber();
                if (maxLineNumber >= sourceLineNumber) continue;
                maxLineNumber = sourceLineNumber;
            }
        }
        JavaCGFileUtil.write2FileWithTab(this.methodLineNumberWriter, callerFullMethod, String.valueOf(minLineNumber), String.valueOf(maxLineNumber));
    }

    private void recordExceptionInfo() throws IOException {
        if (!this.parseMethodCallTypeValueFlag) {
            return;
        }
        CodeExceptionGen[] codeExceptionGens = this.mg.getExceptionHandlers();
        if (codeExceptionGens.length <= 0) {
            return;
        }
        ArrayList<CatchInfo> catchInfoList = new ArrayList<CatchInfo>();
        HashSet<Integer> catchFromPositionSet = new HashSet<Integer>();
        HashMap<Integer, CatchAndFinallyInfo> tryInfoMap = new HashMap<Integer, CatchAndFinallyInfo>();
        ArrayList<FinallyInfo> finallyInfoList = new ArrayList<FinallyInfo>();
        HashMap<Integer, FinallyInfo> catchFinallyInfoMap = new HashMap<Integer, FinallyInfo>();
        FinallyInfo lastCatchInfo = null;
        for (CodeExceptionGen codeExceptionGen : codeExceptionGens) {
            ObjectType catchExceptionType;
            int fromPosition = codeExceptionGen.getStartPC().getPosition();
            int toPosition = codeExceptionGen.getEndPC().getNext().getPosition();
            int endPosition = codeExceptionGen.getEndPC().getPosition();
            int targetPosition = codeExceptionGen.getHandlerPC().getPosition();
            if (fromPosition == targetPosition) continue;
            if (endPosition == targetPosition) {
                endPosition = codeExceptionGen.getEndPC().getPrev().getPosition();
            }
            boolean isFinally = (catchExceptionType = codeExceptionGen.getCatchType()) == null;
            CatchAndFinallyInfo catchAndFinallyInfo = tryInfoMap.computeIfAbsent(fromPosition, k -> new CatchAndFinallyInfo());
            if (!isFinally) {
                String catchExceptionTypeString = catchExceptionType.getClassName();
                if (lastCatchInfo != null && lastCatchInfo.getTargetPosition() == targetPosition) {
                    ((CatchInfo)lastCatchInfo).addCatchExceptionType(catchExceptionTypeString);
                    continue;
                }
                CatchInfo catchInfo = new CatchInfo(fromPosition, toPosition, endPosition, targetPosition, catchExceptionTypeString);
                catchInfoList.add(catchInfo);
                catchFromPositionSet.add(targetPosition);
                catchAndFinallyInfo.getCatchInfoList().add(catchInfo);
                lastCatchInfo = catchInfo;
                continue;
            }
            FinallyInfo finallyInfo = new FinallyInfo(fromPosition, toPosition, endPosition, targetPosition);
            finallyInfoList.add(finallyInfo);
            catchAndFinallyInfo.setFinallyInfo(finallyInfo);
            if (catchFromPositionSet.contains(fromPosition)) {
                catchFinallyInfoMap.put(fromPosition, finallyInfo);
            }
            lastCatchInfo = null;
        }
        for (CatchInfo catchInfo : catchInfoList) {
            int catchEndPosition = this.getCatchEndPosition(catchInfo, catchFinallyInfoMap, tryInfoMap);
            int tryStartLineNumber = this.getSourceLine(catchInfo.getFromPosition());
            int tryEndLineNumber = this.getSourceLine(catchInfo.getEndPosition());
            int tryMinCallId = this.getMinCallId(catchInfo.getFromPosition(), catchInfo.getEndPosition());
            int tryMaxCallId = this.getMaxCallId(catchInfo.getFromPosition(), catchInfo.getEndPosition());
            int catchStartLineNumber = this.getSourceLine(catchInfo.getTargetPosition());
            int catchEndLineNumber = this.getSourceLine(catchEndPosition);
            int catchMinCallId = this.getMinCallId(catchInfo.getTargetPosition(), catchEndPosition);
            int catchMaxCallId = this.getMaxCallId(catchInfo.getTargetPosition(), catchEndPosition);
            String flag = this.getCatchFlag(catchInfo, catchEndPosition, tryMinCallId, tryMaxCallId, catchMinCallId, catchMaxCallId);
            for (String catchExceptionType : catchInfo.getCatchExceptionTypeList()) {
                JavaCGFileUtil.write2FileWithTab(this.methodCatchWriter, this.callerFullMethod, catchExceptionType, flag, String.valueOf(tryStartLineNumber), String.valueOf(tryEndLineNumber), String.valueOf(tryMinCallId), String.valueOf(tryMaxCallId), String.valueOf(catchInfo.getTargetPosition()), String.valueOf(catchEndPosition), String.valueOf(catchStartLineNumber), String.valueOf(catchEndLineNumber), String.valueOf(catchMinCallId), String.valueOf(catchMaxCallId));
            }
        }
        for (FinallyInfo finallyInfo : finallyInfoList) {
            boolean isTryOrCatch = !catchFromPositionSet.contains(finallyInfo.getFromPosition());
            String tryCatchType = isTryOrCatch ? "try" : "catch";
            int tryCatchStartLineNumber = this.getSourceLine(finallyInfo.getFromPosition());
            int tryCatchEndLineNumber = this.getSourceLine(finallyInfo.getEndPosition());
            int tryCatchMinCallId = this.getMinCallId(finallyInfo.getFromPosition(), finallyInfo.getEndPosition());
            int tryCatchMaxCallId = this.getMaxCallId(finallyInfo.getFromPosition(), finallyInfo.getEndPosition());
            int finallyStartLineNumber = this.getSourceLine(finallyInfo.getTargetPosition());
            JavaCGFileUtil.write2FileWithTab(this.methodFinallyWriter, this.callerFullMethod, tryCatchType, String.valueOf(tryCatchStartLineNumber), String.valueOf(tryCatchEndLineNumber), String.valueOf(tryCatchMinCallId), String.valueOf(tryCatchMaxCallId), String.valueOf(finallyStartLineNumber));
        }
    }

    private String getCatchFlag(CatchInfo catchInfo, int catchEndPosition, int tryMinCallId, int tryMaxCallId, int catchMinCallId, int catchMaxCallId) {
        GETSTATIC getstatic;
        String getStaticFieldName;
        InstructionHandle tryStartIh;
        Instruction tryStartInstruction;
        if (this.innerAnonymousClassFlag && "<clinit>".equals(this.callerMethodName) && (tryStartInstruction = (tryStartIh = this.instructionList.findHandle(catchInfo.getFromPosition())).getInstruction()).getOpcode() == 178 && (getStaticFieldName = (getstatic = (GETSTATIC)tryStartInstruction).getFieldName(this.cpg)).startsWith("$SwitchMap$")) {
            return "switch";
        }
        if (tryMinCallId == tryMaxCallId && tryMinCallId >= 1 && catchMinCallId == catchMaxCallId && catchMinCallId >= 1) {
            InstructionHandle tryInvokeVirtualIh = JavaCGInstructionUtil.findFirstIhBetween(this.instructionList, catchInfo.getFromPosition(), catchInfo.getToPosition(), 182);
            if (tryInvokeVirtualIh == null) {
                return "";
            }
            INVOKEVIRTUAL tryInvokeVirtual = (INVOKEVIRTUAL)tryInvokeVirtualIh.getInstruction();
            String tryCalleeMethodName = tryInvokeVirtual.getMethodName(this.cpg);
            if (!"close".equals(tryCalleeMethodName)) {
                return "";
            }
            InstructionHandle catchInvokeVirtualIh = JavaCGInstructionUtil.findFirstIhBetween(this.instructionList, catchInfo.getTargetPosition(), catchEndPosition, 182);
            if (catchInvokeVirtualIh == null) {
                return "";
            }
            INVOKEVIRTUAL catchInvokeVirtual = (INVOKEVIRTUAL)catchInvokeVirtualIh.getInstruction();
            JavaCGMethodInfo catchCalleeInfo = JavaCGInstructionUtil.getCalleeMethodInfo((InvokeInstruction)catchInvokeVirtual, this.cpg);
            if (!(JavaCGCommonNameConstants.CLASS_NAME_THROWABLE.equals(catchCalleeInfo.getClassName()) && "addSuppressed".equals(catchCalleeInfo.getMethodName()) && catchCalleeInfo.getMethodArgumentTypes().length == 1 && JavaCGCommonNameConstants.CLASS_NAME_THROWABLE.equals(catchCalleeInfo.getMethodArgumentTypes()[0].toString()))) {
                return "";
            }
            MethodCallPossibleInfo catchMethodCallPossibleInfo = this.methodHandler4TypeAndValue.getMethodCallPossibleInfo(catchInvokeVirtualIh.getPosition());
            if (catchMethodCallPossibleInfo == null) {
                return "";
            }
            MethodCallPossibleList arg1PossibleList = catchMethodCallPossibleInfo.getPossibleInfo4Args(0);
            if (arg1PossibleList == null || arg1PossibleList.getMethodCallPossibleEntryList() == null) {
                return "";
            }
            for (MethodCallPossibleEntry arg1PossibleEntry : arg1PossibleList.getMethodCallPossibleEntryList()) {
                if (arg1PossibleEntry.getCatchExceptionStartPosition().intValue() != catchInfo.getTargetPosition()) continue;
                return "try-with-resource";
            }
        }
        return "";
    }

    private int getCatchEndPosition(CatchInfo catchInfo, Map<Integer, FinallyInfo> catchFinallyInfoMap, Map<Integer, CatchAndFinallyInfo> tryInfoMap) {
        GotoInstruction catchFirstGoto;
        int catchIndex;
        FinallyInfo finallyInfo = catchFinallyInfoMap.get(catchInfo.getTargetPosition());
        if (finallyInfo != null) {
            return finallyInfo.getEndPosition();
        }
        CatchAndFinallyInfo catchAndFinallyInfo = tryInfoMap.get(catchInfo.getFromPosition());
        List<CatchInfo> catchInfoListOfTry = catchAndFinallyInfo.getCatchInfoList();
        int catchInfoListOfTrySize = catchInfoListOfTry.size();
        if (catchInfoListOfTrySize > 1 && (catchIndex = this.findCatchInfoIndexInList(catchInfo, catchInfoListOfTry)) < catchInfoListOfTrySize - 1) {
            CatchInfo nextCatchInfo = catchInfoListOfTry.get(catchIndex + 1);
            return JavaCGInstructionUtil.getInstructionPositionBefore(this.instructionList, nextCatchInfo.getTargetPosition());
        }
        int tryEndPosition = catchInfo.getToPosition();
        InstructionHandle tryLastIh = this.instructionList.findHandle(catchInfo.getToPosition());
        InstructionHandle tryLastGotoReturnIh = JavaCGInstructionUtil.findLastIh(tryLastIh, JavaCGInstructionUtil.GOTO_RETURN_OPCODES);
        if (tryLastGotoReturnIh == null) {
            FinallyInfo tryFinallyInfo = catchAndFinallyInfo.getFinallyInfo();
            if (tryFinallyInfo != null) {
                return JavaCGInstructionUtil.getInstructionPositionBefore(this.instructionList, tryFinallyInfo.getTargetPosition());
            }
            return this.instructionList.getEnd().getPosition();
        }
        Instruction tryLastGotoReturnInstruction = tryLastGotoReturnIh.getInstruction();
        if (JavaCGInstructionUtil.isReturnInstruction(tryLastGotoReturnInstruction.getOpcode())) {
            return this.instructionList.getEnd().getPosition();
        }
        GotoInstruction tryLastGotoInstruction = (GotoInstruction)tryLastGotoReturnInstruction;
        int gotoTargetPosition = tryLastGotoInstruction.getTarget().getPosition();
        if (gotoTargetPosition < tryLastGotoReturnIh.getPosition()) {
            for (InstructionHandle findIfIh = this.instructionList.findHandle(gotoTargetPosition); findIfIh != null && findIfIh.getPosition() <= tryEndPosition; findIfIh = findIfIh.getNext()) {
                IfInstruction ifInstruction;
                Instruction currentInstruction = findIfIh.getInstruction();
                if (!(currentInstruction instanceof IfInstruction) || (ifInstruction = (IfInstruction)currentInstruction).getTarget().getPosition() <= tryEndPosition) continue;
                return ifInstruction.getTarget().getPrev().getPosition();
            }
            CatchInfo firstCatchInfo = catchInfoListOfTry.get(0);
            InstructionHandle gotoIh = JavaCGInstructionUtil.findFirstIhBetween(this.instructionList, firstCatchInfo.getTargetPosition(), Integer.MAX_VALUE, TypeConstants.GOTO_OPCODES);
            if (gotoIh == null) {
                return this.instructionList.getEnd().getPosition();
            }
            GotoInstruction gotoInstruction = (GotoInstruction)gotoIh.getInstruction();
            InstructionHandle gotoTargetPrevIh = gotoInstruction.getTarget().getPrev();
            if (gotoTargetPrevIh == null) {
                return gotoIh.getPrev().getPosition();
            }
            return gotoTargetPrevIh.getPosition();
        }
        InstructionHandle beforeTryLastGotoTargetIh = tryLastGotoInstruction.getTarget().getPrev();
        int tryLastGotoPosition = tryLastGotoInstruction.getTarget().getPosition();
        InstructionHandle catchFirstGotoIh = JavaCGInstructionUtil.findFirstIhBetween(this.instructionList, catchInfo.getTargetPosition(), tryLastGotoPosition, TypeConstants.GOTO_OPCODES);
        if (catchFirstGotoIh != null && (catchFirstGoto = (GotoInstruction)catchFirstGotoIh.getInstruction()).getTarget().getPosition() == tryLastGotoPosition) {
            return catchFirstGotoIh.getPrev().getPosition();
        }
        return beforeTryLastGotoTargetIh.getPosition();
    }

    private int getMinCallId(int startPosition, int endPosition) {
        Integer callId = this.invokeInstructionPositionCallIdMap.get(startPosition);
        if (callId != null) {
            return callId;
        }
        InstructionHandle instructionHandle = this.instructionList.findHandle(startPosition);
        do {
            if ((callId = this.invokeInstructionPositionCallIdMap.get(instructionHandle.getPosition())) == null) continue;
            return callId;
        } while ((instructionHandle = instructionHandle.getNext()) != null && instructionHandle.getPosition() <= endPosition);
        return 0;
    }

    private int getMaxCallId(int startPosition, int endPosition) {
        Integer callId = this.invokeInstructionPositionCallIdMap.get(endPosition);
        if (callId != null) {
            return callId;
        }
        InstructionHandle instructionHandle = this.instructionList.findHandle(endPosition);
        do {
            if ((callId = this.invokeInstructionPositionCallIdMap.get(instructionHandle.getPosition())) == null) continue;
            return callId;
        } while ((instructionHandle = instructionHandle.getPrev()) != null && instructionHandle.getPosition() >= startPosition);
        return 0;
    }

    private int findCatchInfoIndexInList(CatchInfo catchInfo, List<CatchInfo> catchInfoList) {
        for (int i = 0; i < catchInfoList.size(); ++i) {
            if (catchInfo.getTargetPosition() != catchInfoList.get(i).getTargetPosition()) continue;
            return i;
        }
        return -1;
    }

    private void handleMethodAnnotations() {
        for (AnnotationEntry annotationEntry : this.method.getAnnotationEntries()) {
            String annotationClassName = Utility.typeSignatureToString((String)annotationEntry.getAnnotationType(), (boolean)false);
            MethodAnnotationParser methodAnnotationParser = this.extensionsManager.getMethodAnnotationParser(annotationClassName);
            if (methodAnnotationParser == null) continue;
            methodAnnotationParser.parseMethodAnnotation(this.callerClassName, this.callerMethodName, this.callerMethodArgTypes, this.methodReturnType, annotationClassName, annotationEntry, this.methodCallList);
        }
    }

    private void handleInvokeInstruction(MethodCallPossibleInfo methodCallPossibleInfo) throws IOException {
        logger.debug("\u5904\u7406\u65b9\u6cd5\u8c03\u7528\u6307\u4ee4 {} ({})", (Object)JavaCGInstructionUtil.getInstructionHandlePrintInfo(this.ih), (Object)this.getSourceLine());
        Instruction invokeInstruction = this.ih.getInstruction();
        JavaCGMethodInfo calleeMethodInfo = JavaCGInstructionUtil.getCalleeMethodInfo((InvokeInstruction)invokeInstruction, this.cpg);
        switch (invokeInstruction.getOpcode()) {
            case 182: {
                this.handleINVOKEVIRTUAL((INVOKEVIRTUAL)invokeInstruction, calleeMethodInfo, methodCallPossibleInfo);
                break;
            }
            case 185: {
                this.handleINVOKEINTERFACE((INVOKEINTERFACE)invokeInstruction, calleeMethodInfo, methodCallPossibleInfo);
                break;
            }
            case 183: {
                this.handleINVOKESPECIAL((INVOKESPECIAL)invokeInstruction, calleeMethodInfo, methodCallPossibleInfo);
                break;
            }
            case 184: {
                this.handleINVOKESTATIC((INVOKESTATIC)invokeInstruction, calleeMethodInfo, methodCallPossibleInfo);
                break;
            }
            case 186: {
                this.handleINVOKEDYNAMIC((INVOKEDYNAMIC)invokeInstruction, calleeMethodInfo, methodCallPossibleInfo);
                break;
            }
            default: {
                logger.error("\u4e0d\u4f1a\u6267\u884c\u5230\u6b64: {}", (Object)invokeInstruction.getOpcode());
            }
        }
    }

    private void handleATHROW(ThrowInfoList throwInfoList) throws IOException {
        int position = this.ih.getPosition();
        int sourceLine = this.getSourceLine(position);
        for (int i = 0; i < throwInfoList.size(); ++i) {
            ThrowInfo throwInfo = throwInfoList.get(i);
            Integer methodThrowReturnCallId = null;
            Integer invokeInstructionPosition = throwInfo.getInvokeInstructionPosition();
            if (invokeInstructionPosition != null) {
                methodThrowReturnCallId = this.getInvokeInstructionCallId(invokeInstructionPosition);
            }
            JavaCGFileUtil.write2FileWithTab(this.methodThrowWriter, this.callerFullMethod, String.valueOf(position), String.valueOf(sourceLine), String.valueOf(i), throwInfo.getThrowExceptionType(), throwInfo.getThrowFlag(), JavaCGUtil.genStringFromInteger(throwInfo.getCatchStartPosition()), throwInfo.getCatchExceptionVariableName(), JavaCGUtil.genStringFromInteger(methodThrowReturnCallId));
        }
    }

    private void handleINVOKEVIRTUAL(INVOKEVIRTUAL invokevirtual, JavaCGMethodInfo calleeMethodInfo, MethodCallPossibleInfo methodCallPossibleInfo) {
        String calleeClassName = calleeMethodInfo.getClassName();
        String calleeMethodName = calleeMethodInfo.getMethodName();
        Type[] calleeArgTypes = calleeMethodInfo.getMethodArgumentTypes();
        this.addMethodCall4ThreadStart(calleeClassName, calleeMethodName, calleeArgTypes);
        if (methodCallPossibleInfo == null) {
            this.addCommonMethodCall((InvokeInstruction)invokevirtual, JavaCGCallTypeEnum.CTE_RAW_INVOKE_VIRTUAL, null, calleeClassName, calleeMethodName, calleeArgTypes, null, null);
            return;
        }
        this.handleChangeableCalleeType((InvokeInstruction)invokevirtual, false, calleeClassName, calleeMethodName, calleeArgTypes, methodCallPossibleInfo);
    }

    private void handleINVOKEINTERFACE(INVOKEINTERFACE invokeinterface, JavaCGMethodInfo calleeMethodInfo, MethodCallPossibleInfo methodCallPossibleInfo) {
        String calleeClassName = calleeMethodInfo.getClassName();
        String calleeMethodName = calleeMethodInfo.getMethodName();
        Type[] calleeArgTypes = calleeMethodInfo.getMethodArgumentTypes();
        if (methodCallPossibleInfo == null) {
            this.addCommonMethodCall((InvokeInstruction)invokeinterface, JavaCGCallTypeEnum.CTE_RAW_INVOKE_INTERFACE, null, calleeClassName, calleeMethodName, calleeArgTypes, null, null);
            return;
        }
        this.handleChangeableCalleeType((InvokeInstruction)invokeinterface, true, calleeClassName, calleeMethodName, calleeArgTypes, methodCallPossibleInfo);
    }

    private void handleINVOKESPECIAL(INVOKESPECIAL invokespecial, JavaCGMethodInfo calleeMethodInfo, MethodCallPossibleInfo methodCallPossibleInfo) {
        Type[] calleeArgTypes;
        String calleeMethodName;
        String calleeClassName = calleeMethodInfo.getClassName();
        boolean skipRawMethodCall = this.addMethodCall4SpecialInit(calleeClassName, calleeMethodName = calleeMethodInfo.getMethodName(), calleeArgTypes = calleeMethodInfo.getMethodArgumentTypes());
        if (skipRawMethodCall) {
            return;
        }
        JavaCGCallTypeEnum callTypeEnum = JavaCGCallTypeEnum.CTE_RAW_INVOKE_SPECIAL;
        if (!JavaCGClassMethodUtil.isInitMethod(calleeMethodName) && calleeClassName.equals(this.javaClass.getSuperclassName()) && methodCallPossibleInfo != null && JavaCGCalleeObjTypeEnum.COTE_THIS == methodCallPossibleInfo.getObjTypeEnum()) {
            callTypeEnum = JavaCGCallTypeEnum.CTE_CHILD_CALL_SUPER_SPECIAL;
        }
        this.addCommonMethodCallWithInfo((InvokeInstruction)invokespecial, callTypeEnum, null, calleeClassName, calleeMethodName, calleeArgTypes, methodCallPossibleInfo);
    }

    private void handleINVOKESTATIC(INVOKESTATIC invokestatic, JavaCGMethodInfo calleeMethodInfo, MethodCallPossibleInfo methodCallPossibleInfo) {
        String calleeClassName = calleeMethodInfo.getClassName();
        String calleeMethodName = calleeMethodInfo.getMethodName();
        Type[] calleeArgTypes = calleeMethodInfo.getMethodArgumentTypes();
        this.addCommonMethodCallWithInfo((InvokeInstruction)invokestatic, JavaCGCallTypeEnum.CTE_RAW_INVOKE_STATIC, null, calleeClassName, calleeMethodName, calleeArgTypes, methodCallPossibleInfo);
    }

    private void handleINVOKEDYNAMIC(INVOKEDYNAMIC invokedynamic, JavaCGMethodInfo calleeMethodInfo, MethodCallPossibleInfo methodCallPossibleInfo) throws IOException {
        Instruction nextInstruction;
        short nextOpcode;
        String calleeClassName = calleeMethodInfo.getClassName();
        String calleeMethodName = calleeMethodInfo.getMethodName();
        Type[] calleeArgTypes = calleeMethodInfo.getMethodArgumentTypes();
        this.addCommonMethodCallWithInfo((InvokeInstruction)invokedynamic, JavaCGCallTypeEnum.CTE_RAW_INVOKE_DYNAMIC, null, calleeClassName, calleeMethodName, calleeArgTypes, methodCallPossibleInfo);
        Constant constant = this.cpg.getConstant(invokedynamic.getIndex());
        if (!(constant instanceof ConstantInvokeDynamic)) {
            return;
        }
        ConstantInvokeDynamic cid = (ConstantInvokeDynamic)constant;
        BootstrapMethod bootstrapMethod = JavaCGBootstrapMethodUtil.getBootstrapMethod(this.javaClass, cid.getBootstrapMethodAttrIndex());
        if (bootstrapMethod == null) {
            logger.warn("\u65e0\u6cd5\u627e\u5230bootstrapMethod {} {}", (Object)this.callerClassName, (Object)cid.getBootstrapMethodAttrIndex());
            return;
        }
        JavaCGMethodInfo bootstrapMethodInfo = JavaCGBootstrapMethodUtil.getBootstrapMethodInfo(bootstrapMethod, this.javaClass);
        if (bootstrapMethodInfo == null) {
            logger.warn("\u65e0\u6cd5\u627e\u5230bootstrapMethod\u7684\u65b9\u6cd5\u4fe1\u606f {} {}", (Object)this.callerClassName, (Object)bootstrapMethod);
            return;
        }
        MethodCall methodCall = this.addCommonMethodCall((InvokeInstruction)invokedynamic, JavaCGCallTypeEnum.CTE_LAMBDA, null, bootstrapMethodInfo.getClassName(), bootstrapMethodInfo.getMethodName(), bootstrapMethodInfo.getMethodArgumentTypes(), bootstrapMethodInfo.getMethodReturnType(), null);
        if (methodCall == null) {
            return;
        }
        String nextCalleeFullMethod = null;
        for (InstructionHandle nextIh = this.ih.getNext(); nextIh != null && JavaCGInstructionUtil.isMethodInvokeInstruction(nextOpcode = (nextInstruction = nextIh.getInstruction()).getOpcode()); nextIh = nextIh.getNext()) {
            if (!JavaCGInstructionUtil.isMethodInvokeInstructionExcludeDynamic(nextOpcode)) continue;
            JavaCGMethodInfo nextCalleeMethodInfo = JavaCGInstructionUtil.getCalleeMethodInfo((InvokeInstruction)nextInstruction, this.cpg);
            nextCalleeFullMethod = JavaCGClassMethodUtil.formatFullMethod(nextCalleeMethodInfo);
            break;
        }
        String calleeFullMethod = JavaCGClassMethodUtil.formatFullMethod(calleeClassName, calleeMethodName, calleeArgTypes);
        if (nextCalleeFullMethod == null) {
            JavaCGFileUtil.write2FileWithTab(this.lambdaMethodInfoWriter, String.valueOf(methodCall.getCallId()), calleeFullMethod);
        } else {
            JavaCGFileUtil.write2FileWithTab(this.lambdaMethodInfoWriter, String.valueOf(methodCall.getCallId()), calleeFullMethod, nextCalleeFullMethod);
        }
    }

    private void handleChangeableCalleeType(InvokeInstruction invokeInstruction, boolean isInterface, String calleeClassName, String calleeMethodName, Type[] argTypes, MethodCallPossibleInfo methodCallPossibleInfo) {
        HashSet<String> handledCalleeTypeSet = new HashSet<String>();
        MethodCallPossibleList methodCallPossibleList4Object = methodCallPossibleInfo.getPossibleInfo4Object();
        if (methodCallPossibleList4Object != null) {
            if (this.useSpringBeanByAnnotationHandler.hasUseSpringBean() && methodCallPossibleList4Object.hasNonStaticField()) {
                for (MethodCallPossibleEntry methodCallPossibleEntry : methodCallPossibleList4Object.getMethodCallPossibleEntryList()) {
                    List<String> springBeanFieldTypeList;
                    FieldTypeAndName nonStaticField = methodCallPossibleEntry.getNonStaticField();
                    if (nonStaticField == null || JavaCGUtil.isCollectionEmpty(springBeanFieldTypeList = this.useSpringBeanByAnnotationHandler.getSpringBeanTypeList(this.callerClassName, nonStaticField.getFieldName()))) continue;
                    for (String springBeanFieldType : springBeanFieldTypeList) {
                        this.tryAddMethodCallWithType(invokeInstruction, isInterface, true, handledCalleeTypeSet, calleeClassName, springBeanFieldType, calleeMethodName, argTypes, methodCallPossibleInfo);
                    }
                }
            }
            if (methodCallPossibleList4Object.hasType()) {
                for (MethodCallPossibleEntry methodCallPossibleEntry : methodCallPossibleList4Object.getMethodCallPossibleEntryList()) {
                    String type = methodCallPossibleEntry.getType();
                    if (type == null) continue;
                    this.tryAddMethodCallWithType(invokeInstruction, isInterface, false, handledCalleeTypeSet, calleeClassName, type, calleeMethodName, argTypes, methodCallPossibleInfo);
                }
            }
        }
        if (handledCalleeTypeSet.isEmpty()) {
            JavaCGCallTypeEnum callTypeEnum = isInterface ? JavaCGCallTypeEnum.CTE_RAW_INVOKE_INTERFACE : JavaCGCallTypeEnum.CTE_RAW_INVOKE_VIRTUAL;
            this.addCommonMethodCallWithInfo(invokeInstruction, callTypeEnum, null, calleeClassName, calleeMethodName, argTypes, methodCallPossibleInfo);
        }
    }

    private JavaCGCallTypeEnum chooseActualCallType(boolean isInterface, boolean isSpringBean) {
        if (isSpringBean) {
            return isInterface ? JavaCGCallTypeEnum.CTE_SPRING_BEAN_ACTUAL_INTERFACE : JavaCGCallTypeEnum.CTE_SPRING_BEAN_ACTUAL_CLASS;
        }
        return isInterface ? JavaCGCallTypeEnum.CTE_ACTUAL_INTERFACE : JavaCGCallTypeEnum.CTE_ACTUAL_CLASS;
    }

    private void tryAddMethodCallWithType(InvokeInstruction invokeInstruction, boolean isInterface, boolean isSpringBean, Set<String> handledCalleeTypeSet, String calleeClassName, String calleeTypeRuntime, String calleeMethodName, Type[] argTypes, MethodCallPossibleInfo methodCallPossibleInfo) {
        if (handledCalleeTypeSet.contains(calleeTypeRuntime) || StringUtils.equals((CharSequence)calleeClassName, (CharSequence)calleeTypeRuntime) || JavaCGByteCodeUtil.isNullType(calleeTypeRuntime) || JavaCGClassMethodUtil.isObjectClass(calleeTypeRuntime)) {
            return;
        }
        JavaCGCallTypeEnum callTypeEnum = this.chooseActualCallType(isInterface, isSpringBean);
        this.addCommonMethodCallWithInfo(invokeInstruction, callTypeEnum, calleeTypeRuntime, calleeClassName, calleeMethodName, argTypes, methodCallPossibleInfo);
        handledCalleeTypeSet.add(calleeTypeRuntime);
    }

    private void addCommonMethodCallWithInfo(InvokeInstruction invokeInstruction, JavaCGCallTypeEnum callTypeEnum, String calleeTypeRuntime, String calleeClassName, String calleeMethodName, Type[] argTypes, MethodCallPossibleInfo methodCallPossibleInfo) {
        if (methodCallPossibleInfo == null) {
            this.addCommonMethodCall(invokeInstruction, callTypeEnum, calleeTypeRuntime, calleeClassName, calleeMethodName, argTypes, null, null);
            return;
        }
        MethodCall methodCall = this.addCommonMethodCall(invokeInstruction, callTypeEnum, calleeTypeRuntime, calleeClassName, calleeMethodName, argTypes, null, methodCallPossibleInfo.getObjTypeEnum());
        if (methodCall == null) {
            return;
        }
        this.methodCallInfoMap.put(methodCall.getCallId(), methodCallPossibleInfo);
    }

    private MethodCall addCommonMethodCall(InvokeInstruction invokeInstruction, JavaCGCallTypeEnum callTypeEnum, String calleeTypeRuntime, String calleeClassName, String calleeMethodName, Type[] calleeArgTypes, Type calleeReturnType, JavaCGCalleeObjTypeEnum objTypeEnum) {
        if (JavaCGUtil.checkSkipClass(calleeClassName, this.javaCGConfInfo.getNeedHandlePackageSet())) {
            return null;
        }
        String rawReturnType = "";
        String actualReturnType = "";
        if (invokeInstruction != null) {
            Instruction nextI;
            InstructionHandle nextIh;
            Type returnType = invokeInstruction.getReturnType(this.cpg);
            rawReturnType = returnType.toString();
            if (Type.VOID != returnType && (nextIh = this.ih.getNext()) != null && (nextI = nextIh.getInstruction()) instanceof CHECKCAST) {
                CHECKCAST checkcast = (CHECKCAST)nextI;
                actualReturnType = JavaCGInstructionUtil.getTypeString((TypedInstruction)checkcast, this.cpg);
            }
        }
        MethodCall methodCall = new MethodCall();
        methodCall.setCallId(this.genNewCallId());
        methodCall.setCallerClassName(this.callerClassName);
        methodCall.setCallerMethodName(this.callerMethodName);
        methodCall.setCallerMethodArgTypes(this.callerMethodArgTypes);
        methodCall.setCallerReturnType(this.methodReturnType);
        methodCall.setMethodCallType(callTypeEnum);
        methodCall.setCalleeClassName(calleeTypeRuntime != null ? calleeTypeRuntime : calleeClassName);
        methodCall.setCalleeMethodName(calleeMethodName);
        methodCall.setCalleeMethodArgTypes(JavaCGClassMethodUtil.getArgTypeStr(calleeArgTypes));
        methodCall.setCallerSourceLine(this.getSourceLine());
        methodCall.setObjTypeEnum(objTypeEnum);
        methodCall.setRawReturnType(calleeReturnType != null ? calleeReturnType.toString() : rawReturnType);
        methodCall.setActualReturnType(actualReturnType);
        methodCall.setArgTypes(calleeArgTypes);
        this.methodCallList.addMethodCall(methodCall);
        return methodCall;
    }

    private void addOtherMethodCall(String callerClassName, String callerMethodName, String callerMethodArgTypes, String callerReturnType, JavaCGCallTypeEnum methodCallType, String calleeClassName, String calleeMethodName, String calleeMethodArgTypes, String calleeReturnType, int callerSourceLine) {
        if (JavaCGUtil.checkSkipClass(calleeClassName, this.javaCGConfInfo.getNeedHandlePackageSet())) {
            return;
        }
        MethodCall methodCall = new MethodCall();
        methodCall.setCallId(this.genNewCallId());
        methodCall.setCallerClassName(callerClassName);
        methodCall.setCallerMethodName(callerMethodName);
        methodCall.setCallerMethodArgTypes(callerMethodArgTypes);
        methodCall.setCallerSourceLine(callerSourceLine);
        methodCall.setCallerReturnType(callerReturnType);
        methodCall.setMethodCallType(methodCallType);
        methodCall.setCalleeClassName(calleeClassName);
        methodCall.setCalleeMethodName(calleeMethodName);
        methodCall.setCalleeMethodArgTypes(calleeMethodArgTypes);
        methodCall.setRawReturnType(calleeReturnType);
        this.methodCallList.addMethodCall(methodCall);
    }

    private boolean addMethodCall4SpecialInit(String calleeClassName, String calleeMethodName, Type[] argTypes) {
        if (!JavaCGClassMethodUtil.isInitMethod(calleeMethodName)) {
            return false;
        }
        boolean skipRawMethodCall = false;
        String calleeMethodArgTypes = JavaCGClassMethodUtil.getArgTypeStr(argTypes);
        if (this.handleSpecialInitMethod(this.runnableImplClassMap, calleeClassName, calleeMethodName, calleeMethodArgTypes, JavaCGCallTypeEnum.CTE_RUNNABLE_INIT_RUN1, JavaCGCallTypeEnum.CTE_RUNNABLE_INIT_RUN2, "run", "()", "void")) {
            skipRawMethodCall = true;
        }
        if (this.handleSpecialInitMethod(this.callableImplClassMap, calleeClassName, calleeMethodName, calleeMethodArgTypes, JavaCGCallTypeEnum.CTE_CALLABLE_INIT_CALL1, JavaCGCallTypeEnum.CTE_CALLABLE_INIT_CALL2, "call", "()", "")) {
            skipRawMethodCall = true;
        }
        if (this.handleSpecialInitMethod(this.transactionCallbackImplClassMap, calleeClassName, calleeMethodName, calleeMethodArgTypes, JavaCGCallTypeEnum.CTE_TX_CALLBACK_INIT_CALL1, JavaCGCallTypeEnum.CTE_TX_CALLBACK_INIT_CALL2, "doInTransaction", "(org.springframework.transaction.TransactionStatus)", "")) {
            skipRawMethodCall = true;
        }
        if (this.handleSpecialInitMethod(this.transactionCallbackWithoutResultChildClassMap, calleeClassName, calleeMethodName, calleeMethodArgTypes, JavaCGCallTypeEnum.CTE_TX_CALLBACK_WR_INIT_CALL1, JavaCGCallTypeEnum.CTE_TX_CALLBACK_WR_INIT_CALL2, "doInTransactionWithoutResult", "(org.springframework.transaction.TransactionStatus)", "void")) {
            skipRawMethodCall = true;
        }
        return skipRawMethodCall;
    }

    private boolean handleSpecialInitMethod(Map<String, Boolean> map, String calleeClassName, String calleeMethodName, String calleeMethodArgTypes, JavaCGCallTypeEnum callTypeEnum1, JavaCGCallTypeEnum callTypeEnum2, String addedCalleeMethodName, String addedCalleeMethodArgTypes, String addedCalleeReturnType) {
        Boolean recorded = map.get(calleeClassName);
        if (recorded == null) {
            return false;
        }
        this.addOtherMethodCall(this.callerClassName, this.callerMethodName, this.callerMethodArgTypes, this.methodReturnType, callTypeEnum1, calleeClassName, calleeMethodName, calleeMethodArgTypes, "void", this.getSourceLine());
        if (Boolean.FALSE.equals(recorded)) {
            this.addOtherMethodCall(calleeClassName, calleeMethodName, calleeMethodArgTypes, "void", callTypeEnum2, calleeClassName, addedCalleeMethodName, addedCalleeMethodArgTypes, addedCalleeReturnType, 0);
            map.put(calleeClassName, Boolean.TRUE);
        }
        return true;
    }

    private void addMethodCall4ThreadStart(String calleeClassName, String calleeMethodName, Type[] argTypes) {
        if (!"start".equals(calleeMethodName) || argTypes.length > 0) {
            return;
        }
        if (!Boolean.FALSE.equals(this.threadChildClassMap.get(calleeClassName))) {
            return;
        }
        String calleeMethodArgTypes = JavaCGClassMethodUtil.getArgTypeStr(argTypes);
        this.addOtherMethodCall(calleeClassName, calleeMethodName, calleeMethodArgTypes, "void", JavaCGCallTypeEnum.CTE_THREAD_START_RUN, calleeClassName, "run", "()", "void", 0);
        this.threadChildClassMap.put(calleeClassName, Boolean.TRUE);
    }

    private void handleMethodCallPossibleInfo(MethodCall methodCall, MethodCallPossibleInfo methodCallPossibleInfo) throws IOException {
        if (methodCallPossibleInfo == null) {
            return;
        }
        this.recordMethodCallPossibleInfo(methodCall.getCallId(), 0, null, methodCallPossibleInfo.getPossibleInfo4Object());
        Type[] argTypes = methodCall.getArgTypes();
        for (int i = 0; i < methodCallPossibleInfo.getPossibleInfoNum4Args(); ++i) {
            String argType = argTypes[i].toString();
            this.recordMethodCallPossibleInfo(methodCall.getCallId(), 1 + i, argType, methodCallPossibleInfo.getPossibleInfo4Args(i));
        }
    }

    private void recordMethodCallPossibleInfo(int methodCallId, int argSeq, String argType, MethodCallPossibleList methodCallPossibleList) throws IOException {
        if (methodCallPossibleList == null) {
            return;
        }
        List<MethodCallPossibleEntry> methodCallPossibleEntryList = methodCallPossibleList.getMethodCallPossibleEntryList();
        if (JavaCGUtil.isCollectionEmpty(methodCallPossibleEntryList)) {
            return;
        }
        String arrayElementFlag = JavaCGYesNoEnum.parseStrValue(methodCallPossibleList.isArrayElement());
        StringBuilder stringBuilder = new StringBuilder();
        JavaCGCounter typeCounter = new JavaCGCounter(-1);
        for (int seq = 0; seq < methodCallPossibleEntryList.size(); ++seq) {
            Integer catchExceptionStartPosition;
            Integer methodArgSeqEQC;
            Integer methodCallReturnCallIdEQC;
            Integer methodCallReturnInstructionPositionEQC;
            String methodCallReturnFullMethodEQC;
            Integer methodArgSeq;
            Integer methodCallReturnCallId;
            Integer methodCallReturnInstructionPosition;
            MethodCallPossibleEntry methodCallPossibleEntry = methodCallPossibleEntryList.get(seq);
            this.recordStringMethodCallPossibleType(stringBuilder, methodCallPossibleEntry, methodCallId, argSeq, typeCounter, arrayElementFlag);
            this.recordStringMethodCallPossibleValue(stringBuilder, methodCallPossibleEntry, methodCallId, argSeq, argType, seq, arrayElementFlag);
            StaticFieldTypeAndName staticField = methodCallPossibleEntry.getStaticField();
            if (staticField != null) {
                this.recordStringMethodCallPossibleInfo(stringBuilder, staticField.getClassAndFieldName(), methodCallId, argSeq, JavaCGMethodCallInfoTypeEnum.MCIT_STATIC_FIELD, seq, arrayElementFlag, "");
                JavaCGFileUtil.write2FileWithTab(this.methodCallStaticFieldWriter, String.valueOf(methodCallId), String.valueOf(argSeq), String.valueOf(seq), staticField.getClassName(), staticField.getFieldName(), staticField.getFieldType(), this.callerFullMethod);
            }
            this.recordStringMethodCallPossibleInfo(stringBuilder, methodCallPossibleEntry.getStaticFieldMethodCall(), methodCallId, argSeq, JavaCGMethodCallInfoTypeEnum.MCIT_STATIC_FIELD_METHOD_CALL, seq, arrayElementFlag, "");
            FieldTypeAndName nonStaticField = methodCallPossibleEntry.getNonStaticField();
            if (nonStaticField != null) {
                this.recordStringMethodCallPossibleInfo(stringBuilder, nonStaticField.getFieldName(), methodCallId, argSeq, JavaCGMethodCallInfoTypeEnum.MCIT_NAME_OF_FIELD, seq, arrayElementFlag, "");
            }
            this.recordStringMethodCallPossibleInfo(stringBuilder, methodCallPossibleEntry.getNameOfVariable(), methodCallId, argSeq, JavaCGMethodCallInfoTypeEnum.MCIT_NAME_OF_VARIABLE, seq, arrayElementFlag, "");
            String methodCallReturnFullMethod = methodCallPossibleEntry.getMethodCallReturnFullMethod();
            if (StringUtils.isNotBlank((CharSequence)methodCallReturnFullMethod) && !JavaCGUtil.checkSkipClass(methodCallReturnFullMethod, this.javaCGConfInfo.getNeedHandlePackageSet()) && (methodCallReturnInstructionPosition = methodCallPossibleEntry.getMethodCallReturnInstructionPosition()) != null && (methodCallReturnCallId = this.getInvokeInstructionCallId(methodCallReturnInstructionPosition)) != methodCallId) {
                this.recordStringMethodCallPossibleInfo(stringBuilder, String.valueOf(methodCallReturnCallId), methodCallId, argSeq, JavaCGMethodCallInfoTypeEnum.MCIT_METHOD_CALL_RETURN_CALL_ID, seq, arrayElementFlag, "");
                JavaCGFileUtil.write2FileWithTab(this.methodCallMethodCallReturnWriter, String.valueOf(methodCallId), String.valueOf(argSeq), String.valueOf(seq), String.valueOf(arrayElementFlag), String.valueOf(methodCallReturnCallId), methodCallReturnFullMethod);
            }
            if ((methodArgSeq = methodCallPossibleEntry.getMethodArgSeq()) != null) {
                this.recordStringMethodCallPossibleInfo(stringBuilder, String.valueOf(methodArgSeq), methodCallId, argSeq, JavaCGMethodCallInfoTypeEnum.MCIT_METHOD_ARG_SEQ, seq, arrayElementFlag, "");
            }
            if (StringUtils.isNotBlank((CharSequence)(methodCallReturnFullMethodEQC = methodCallPossibleEntry.getMethodCallReturnFullMethodEQC())) && !JavaCGUtil.checkSkipClass(methodCallReturnFullMethodEQC, this.javaCGConfInfo.getNeedHandlePackageSet()) && (methodCallReturnInstructionPositionEQC = methodCallPossibleEntry.getMethodCallReturnInstructionPositionEQC()) != null && (methodCallReturnCallIdEQC = this.getInvokeInstructionCallId(methodCallReturnInstructionPositionEQC)) != methodCallId) {
                this.recordStringMethodCallPossibleInfo(stringBuilder, String.valueOf(methodCallReturnCallIdEQC), methodCallId, argSeq, JavaCGMethodCallInfoTypeEnum.MCIT_METHOD_CALL_RETURN_CALL_ID_EQC, seq, arrayElementFlag, "");
            }
            if ((methodArgSeqEQC = methodCallPossibleEntry.getMethodArgSeqEQC()) != null) {
                this.recordStringMethodCallPossibleInfo(stringBuilder, String.valueOf(methodArgSeqEQC), methodCallId, argSeq, JavaCGMethodCallInfoTypeEnum.MCIT_METHOD_ARG_SEQ_EQC, seq, arrayElementFlag, "");
            }
            if ((catchExceptionStartPosition = methodCallPossibleEntry.getCatchExceptionStartPosition()) == null) continue;
            this.recordStringMethodCallPossibleInfo(stringBuilder, String.valueOf(catchExceptionStartPosition), methodCallId, argSeq, JavaCGMethodCallInfoTypeEnum.MCIT_METHOD_CATCH_EXCEPTION_FROM_OFFSET, seq, arrayElementFlag, "");
        }
        JavaCGFileUtil.write2FileNoLF(this.methodCallInfoWriter, stringBuilder.toString());
    }

    private void recordStringMethodCallPossibleType(StringBuilder stringBuilder, MethodCallPossibleEntry methodCallPossibleEntry, int methodCallId, int argSeq, JavaCGCounter typeCounter, String arrayElementFlag) {
        List<String> springBeanFieldTypeList;
        FieldTypeAndName nonStaticField;
        if (this.useSpringBeanByAnnotationHandler.hasUseSpringBean() && (nonStaticField = methodCallPossibleEntry.getNonStaticField()) != null && !JavaCGUtil.isCollectionEmpty(springBeanFieldTypeList = this.useSpringBeanByAnnotationHandler.getSpringBeanTypeList(this.callerClassName, nonStaticField.getFieldName()))) {
            for (String springBeanFieldType : springBeanFieldTypeList) {
                this.recordStringMethodCallPossibleInfo(stringBuilder, springBeanFieldType, methodCallId, argSeq, JavaCGMethodCallInfoTypeEnum.MCIT_TYPE, typeCounter.addAndGet(), arrayElementFlag, "");
            }
            return;
        }
        String type = methodCallPossibleEntry.getType();
        if (type != null) {
            this.recordStringMethodCallPossibleInfo(stringBuilder, type, methodCallId, argSeq, JavaCGMethodCallInfoTypeEnum.MCIT_TYPE, typeCounter.addAndGet(), arrayElementFlag, "");
        }
    }

    private void recordStringMethodCallPossibleInfo(StringBuilder stringBuilder, String data, int methodCallId, int argSeq, JavaCGMethodCallInfoTypeEnum type, int seq, String arrayElementFlag, String valueType) {
        if (data == null) {
            return;
        }
        String appendedData = JavaCGFileUtil.appendFileColumn(String.valueOf(methodCallId), String.valueOf(argSeq), String.valueOf(seq), type.getType(), arrayElementFlag, valueType, data, this.callerFullMethod);
        stringBuilder.append(appendedData).append("\n");
    }

    private void recordStringMethodCallPossibleValue(StringBuilder stringBuilder, MethodCallPossibleEntry methodCallPossibleEntry, int methodCallId, int argSeq, String argType, int seq, String arrayElementFlag) {
        Object value = methodCallPossibleEntry.getValue();
        if (value == null) {
            return;
        }
        JavaCGMethodCallInfoTypeEnum type = JavaCGMethodCallInfoTypeEnum.MCIT_VALUE;
        String strValue = value instanceof String ? (String)value : value.toString();
        if (StringUtils.containsAny((CharSequence)strValue, (CharSequence[])new CharSequence[]{"\r", "\n", "\t"})) {
            strValue = JavaCGUtil.base64Encode(strValue);
            type = JavaCGMethodCallInfoTypeEnum.MCIT_BASE64_VALUE;
        }
        String valueType = StringUtils.equalsAny((CharSequence)argType, (CharSequence[])new CharSequence[]{JavaCGCommonNameConstants.CLASS_NAME_OBJECT, JavaCGCommonNameConstants.CLASS_NAME_CHAR_SEQUENCE}) ? methodCallPossibleEntry.getValueType() : argType;
        this.recordStringMethodCallPossibleInfo(stringBuilder, strValue, methodCallId, argSeq, type, seq, arrayElementFlag, valueType);
    }

    private int genNewCallId() {
        int newCallId = this.callIdCounter.addAndGet();
        if (this.parseMethodCallTypeValueFlag) {
            this.invokeInstructionPositionCallIdMap.put(this.ih.getPosition(), newCallId);
        }
        return newCallId;
    }

    private Integer getInvokeInstructionCallId(Integer invokeInstructionPosition) {
        Integer callId = this.invokeInstructionPositionCallIdMap.get(invokeInstructionPosition);
        if (callId == null) {
            throw new JavaCGRuntimeException("\u6839\u636e\u65b9\u6cd5\u8c03\u7528\u6307\u4ee4\u4f4d\u7f6e\u672a\u67e5\u627e\u5230\u5bf9\u5e94\u7684call_id: " + invokeInstructionPosition);
        }
        return callId;
    }

    public void setRunnableImplClassMap(Map<String, Boolean> runnableImplClassMap) {
        this.runnableImplClassMap = runnableImplClassMap;
    }

    public void setCallableImplClassMap(Map<String, Boolean> callableImplClassMap) {
        this.callableImplClassMap = callableImplClassMap;
    }

    public void setTransactionCallbackImplClassMap(Map<String, Boolean> transactionCallbackImplClassMap) {
        this.transactionCallbackImplClassMap = transactionCallbackImplClassMap;
    }

    public void setTransactionCallbackWithoutResultChildClassMap(Map<String, Boolean> transactionCallbackWithoutResultChildClassMap) {
        this.transactionCallbackWithoutResultChildClassMap = transactionCallbackWithoutResultChildClassMap;
    }

    public void setThreadChildClassMap(Map<String, Boolean> threadChildClassMap) {
        this.threadChildClassMap = threadChildClassMap;
    }

    public void setExtensionsManager(ExtensionsManager extensionsManager) {
        this.extensionsManager = extensionsManager;
        this.annotationAttributesFormatter = extensionsManager.getAnnotationAttributesFormatter();
    }

    public void setMethodCallWriter(Writer methodCallWriter) {
        this.methodCallWriter = methodCallWriter;
    }

    public void setLambdaMethodInfoWriter(Writer lambdaMethodInfoWriter) {
        this.lambdaMethodInfoWriter = lambdaMethodInfoWriter;
    }

    public void setMethodAnnotationWriter(Writer methodAnnotationWriter) {
        this.methodAnnotationWriter = methodAnnotationWriter;
    }

    public void setMethodArgAnnotationWriter(Writer methodArgAnnotationWriter) {
        this.methodArgAnnotationWriter = methodArgAnnotationWriter;
    }

    public void setMethodLineNumberWriter(Writer methodLineNumberWriter) {
        this.methodLineNumberWriter = methodLineNumberWriter;
    }

    public void setMethodCallInfoWriter(Writer methodCallInfoWriter) {
        this.methodCallInfoWriter = methodCallInfoWriter;
    }

    public void setMethodCallMethodCallReturnWriter(Writer methodCallMethodCallReturnWriter) {
        this.methodCallMethodCallReturnWriter = methodCallMethodCallReturnWriter;
    }

    public void setMethodCallStaticFieldWriter(Writer methodCallStaticFieldWriter) {
        this.methodCallStaticFieldWriter = methodCallStaticFieldWriter;
    }

    public void setMethodReturnArgSeqWriter(Writer methodReturnArgSeqWriter) {
        this.methodReturnArgSeqWriter = methodReturnArgSeqWriter;
    }

    public void setMethodReturnCallIdWriter(Writer methodReturnCallIdWriter) {
        this.methodReturnCallIdWriter = methodReturnCallIdWriter;
    }

    public void setMethodCatchWriter(Writer methodCatchWriter) {
        this.methodCatchWriter = methodCatchWriter;
    }

    public void setMethodFinallyWriter(Writer methodFinallyWriter) {
        this.methodFinallyWriter = methodFinallyWriter;
    }

    public void setMethodThrowWriter(Writer methodThrowWriter) {
        this.methodThrowWriter = methodThrowWriter;
    }

    public void setStaticFinalFieldMethodCallIdWriter(Writer staticFinalFieldMethodCallIdWriter) {
        this.staticFinalFieldMethodCallIdWriter = staticFinalFieldMethodCallIdWriter;
    }

    public void setFieldRelationshipWriter(Writer fieldRelationshipWriter) {
        this.fieldRelationshipWriter = fieldRelationshipWriter;
    }

    public void setLastJarNum(int lastJarNum) {
        this.lastJarNum = lastJarNum;
    }

    public void setExistsSameMethodNameAndArgs(boolean existsSameMethodNameAndArgs) {
        this.existsSameMethodNameAndArgs = existsSameMethodNameAndArgs;
    }

    public void setClassAndJarNum(ClassAndJarNum classAndJarNum) {
        this.classAndJarNum = classAndJarNum;
    }

    public void setStaticFinalFieldNameTypeMap(Map<String, String> staticFinalFieldNameTypeMap) {
        this.staticFinalFieldNameTypeMap = staticFinalFieldNameTypeMap;
    }
}

