/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.parser;

import com.adrninistrator.javacg.conf.JavaCGConfInfo;
import com.adrninistrator.javacg.dto.jar.JarInfo;
import com.adrninistrator.javacg.util.JavaCGFileUtil;
import com.adrninistrator.javacg.util.JavaCGJarUtil;
import com.adrninistrator.javacg.util.JavaCGUtil;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import net.lingala.zip4j.io.inputstream.ZipInputStream;
import net.lingala.zip4j.model.LocalFileHeader;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJarEntryParser {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJarEntryParser.class);
    protected String simpleClassName = this.getClass().getSimpleName();
    protected JavaCGConfInfo javaCGConfInfo;
    protected Map<String, JarInfo> jarInfoMap;
    protected String lastFirstDirName;
    protected JarInfo lastJarInfo;

    protected AbstractJarEntryParser(JavaCGConfInfo javaCGConfInfo, Map<String, JarInfo> jarInfoMap) {
        this.javaCGConfInfo = javaCGConfInfo;
        this.jarInfoMap = jarInfoMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean parse(String jarFilePath) {
        this.init();
        String jarEntryPath = null;
        try (ZipInputStream zipInputStream = new ZipInputStream((InputStream)new BufferedInputStream(new FileInputStream(jarFilePath), 8192));){
            LocalFileHeader fileHeader;
            while ((fileHeader = zipInputStream.getNextEntry()) != null) {
                if (fileHeader.isDirectory()) continue;
                jarEntryPath = fileHeader.getFileName();
                logger.debug("{} \u5904\u7406\u6587\u4ef6: {}", (Object)this.simpleClassName, (Object)jarEntryPath);
                if (!this.handleCurrentJarInfo(jarEntryPath)) {
                    boolean bl = false;
                    return bl;
                }
                if (this.ignoreCurrentFile(jarEntryPath) || this.handleEntry(zipInputStream, jarEntryPath)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error("{} \u5904\u7406jar\u5305\u4e2d\u7684\u6587\u4ef6\u51fa\u73b0\u95ee\u9898 {}", new Object[]{this.simpleClassName, jarEntryPath, e});
            return false;
        }
    }

    public void init() {
    }

    protected abstract boolean handleEntry(ZipInputStream var1, String var2) throws IOException;

    protected boolean tryHandleClassEntry(InputStream inputStream, String jarEntryPath) throws IOException {
        if (!JavaCGFileUtil.isClassFile(jarEntryPath)) {
            return false;
        }
        JavaClass javaClass = new ClassParser(inputStream, jarEntryPath).parse();
        if (this.ignoreCurrentClass(javaClass.getClassName())) {
            return true;
        }
        this.handleClassEntry(javaClass, jarEntryPath);
        return true;
    }

    protected boolean handleClassEntry(JavaClass javaClass, String jarEntryPath) throws IOException {
        return true;
    }

    private boolean handleCurrentJarInfo(String jarEntryPath) {
        if (this.jarInfoMap.size() == 1) {
            Iterator<Map.Entry<String, JarInfo>> iterator;
            if (this.lastJarInfo == null && (iterator = this.jarInfoMap.entrySet().iterator()).hasNext()) {
                Map.Entry<String, JarInfo> entry = iterator.next();
                this.lastJarInfo = entry.getValue();
                return true;
            }
            return true;
        }
        int index = jarEntryPath.indexOf("/");
        if (index == -1) {
            logger.error("JarEntry\u540d\u79f0\u4e2d\u4e0d\u5305\u542b/ {}", (Object)jarEntryPath);
            return false;
        }
        String firstDirName = jarEntryPath.substring(0, index);
        if (this.lastFirstDirName != null && this.lastFirstDirName.equals(firstDirName)) {
            return true;
        }
        this.lastFirstDirName = firstDirName;
        this.lastJarInfo = this.jarInfoMap.get(firstDirName);
        if (this.lastJarInfo == null) {
            logger.error("\u5408\u5e76\u540e\u7684jar\u5305\u4e2d\u51fa\u73b0\u7684\u540d\u79f0\u672a\u8bb0\u5f55\u8fc7: {}", (Object)jarEntryPath);
        }
        return true;
    }

    private boolean ignoreCurrentFile(String jarEntryPath) {
        for (String ignoreJarFileKeyword : this.javaCGConfInfo.getIgnoreJarFileKeywordSet()) {
            if (!jarEntryPath.contains(ignoreJarFileKeyword)) continue;
            logger.info("jar\u5305\u4e2d\u7684\u5f53\u524d\u6587\u4ef6\u8def\u5f84\u5305\u542b\u6307\u5b9a\u5173\u952e\u5b57\uff0c\u9700\u8981\u8df3\u8fc7 [{}] [{}]", (Object)jarEntryPath, (Object)ignoreJarFileKeyword);
            return true;
        }
        String jarEntryName = JavaCGJarUtil.getJarEntryNameFromPath(jarEntryPath);
        for (String ignoreJarFileName : this.javaCGConfInfo.getIgnoreJarFileNameSet()) {
            if (!jarEntryName.equals(ignoreJarFileName)) continue;
            logger.info("jar\u5305\u4e2d\u7684\u5f53\u524d\u6587\u4ef6\u540d\u5df2\u8bbe\u7f6e\u4e3a\u9700\u8981\u8df3\u8fc7 [{}] [{}]", (Object)jarEntryPath, (Object)ignoreJarFileName);
            return true;
        }
        return false;
    }

    protected boolean ignoreCurrentClass(String className) {
        if (JavaCGUtil.checkSkipClass(className, this.javaCGConfInfo.getNeedHandlePackageSet())) {
            logger.debug("\u8df3\u8fc7\u4e0d\u9700\u8981\u5904\u7406\u7684\u7c7b: {}", (Object)className);
            return true;
        }
        return false;
    }
}

