/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.parser;

import com.adrninistrator.javacg.common.enums.JavaCGYesNoEnum;
import com.adrninistrator.javacg.conf.JavaCGConfInfo;
import com.adrninistrator.javacg.dto.classes.ClassSignatureGenericsInfo;
import com.adrninistrator.javacg.dto.classes.InnerClassInfo;
import com.adrninistrator.javacg.dto.counter.JavaCGCounter;
import com.adrninistrator.javacg.dto.jar.ClassAndJarNum;
import com.adrninistrator.javacg.dto.jar.JarInfo;
import com.adrninistrator.javacg.extensions.manager.ExtensionsManager;
import com.adrninistrator.javacg.handler.ClassHandler;
import com.adrninistrator.javacg.parser.AbstractJarEntryParser;
import com.adrninistrator.javacg.spring.UseSpringBeanByAnnotationHandler;
import com.adrninistrator.javacg.util.JavaCGByteCodeUtil;
import com.adrninistrator.javacg.util.JavaCGClassMethodUtil;
import com.adrninistrator.javacg.util.JavaCGFileUtil;
import com.adrninistrator.javacg.util.JavaCGSignatureUtil;
import com.adrninistrator.javacg.writer.WriterSupportSkip;
import copy.javassist.bytecode.BadBytecode;
import copy.javassist.bytecode.SignatureAttribute;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.lingala.zip4j.io.inputstream.ZipInputStream;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Signature;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarEntryHandleParser
extends AbstractJarEntryParser {
    private static final Logger logger = LoggerFactory.getLogger(JarEntryHandleParser.class);
    private UseSpringBeanByAnnotationHandler useSpringBeanByAnnotationHandler;
    private Map<String, Boolean> runnableImplClassMap;
    private Map<String, Boolean> callableImplClassMap;
    private Map<String, Boolean> transactionCallbackImplClassMap;
    private Map<String, Boolean> transactionCallbackWithoutResultChildClassMap;
    private Map<String, Boolean> threadChildClassMap;
    private Writer jarInfoWriter;
    private Writer classReferenceWriter;
    private Writer methodCallWriter;
    private Writer lambdaMethodInfoWriter;
    private Writer classAnnotationWriter;
    private Writer methodAnnotationWriter;
    private Writer fieldAnnotationWriter;
    private Writer fieldInfoWriter;
    private Writer methodLineNumberWriter;
    private Writer methodCallInfoWriter;
    private Writer methodCallMethodCallReturnWriter;
    private Writer methodCallStaticFieldWriter;
    private Writer methodReturnArgSeqWriter;
    private Writer methodReturnCallIdWriter;
    private Writer classInfoWriter;
    private Writer methodInfoWriter;
    private Writer extendsImplWriter;
    private Writer classSignatureEI1Writer;
    private Writer classSignatureGenericsWriter;
    private Writer classSigExtImplGenericsWriter;
    private Writer methodArgumentWriter;
    private Writer methodArgAnnotationWriter;
    private Writer methodArgGenericsTypeWriter;
    private Writer methodReturnGenericsTypeWriter;
    private Writer methodCatchWriter;
    private Writer methodFinallyWriter;
    private Writer methodThrowWriter;
    private Writer innerClassWriter;
    private Writer getMethodWriter;
    private Writer setMethodWriter;
    private Writer fieldGenericsTypeWriter;
    private Writer fieldRelationshipWriter;
    private Writer staticFinalFieldMethodCallIdWriter;
    private WriterSupportSkip logMethodSpendTimeWriter;
    private ExtensionsManager extensionsManager;
    private final Set<Integer> recordedJarNum = new HashSet<Integer>();
    private final Map<String, List<String>> handledClassNameMap = new HashMap<String, List<String>>();
    private final Map<String, List<String>> duplicateClassNameMap = new HashMap<String, List<String>>();
    private JavaCGCounter callIdCounter;
    private JavaCGCounter classNumCounter;
    private JavaCGCounter methodNumCounter;
    private JavaCGCounter failCounter;
    private JavaCGCounter fieldRelationshipCounter;
    private ClassAndJarNum classAndJarNum;

    public JarEntryHandleParser(JavaCGConfInfo javaCGConfInfo, Map<String, JarInfo> jarInfoMap) {
        super(javaCGConfInfo, jarInfoMap);
    }

    @Override
    protected boolean handleEntry(ZipInputStream zipInputStream, String jarEntryPath) throws IOException {
        this.tryRecordJarInfo();
        if (!JavaCGFileUtil.isClassFile(jarEntryPath)) {
            return true;
        }
        JavaClass javaClass = new ClassParser((InputStream)zipInputStream, jarEntryPath).parse();
        if (this.ignoreCurrentClass(javaClass.getClassName())) {
            return true;
        }
        return this.handleClassEntry(javaClass, jarEntryPath);
    }

    @Override
    protected boolean handleClassEntry(JavaClass javaClass, String jarEntryPath) throws IOException {
        return this.handleJavaClass(javaClass, jarEntryPath);
    }

    private void tryRecordJarInfo() throws IOException {
        int lastJarNum = this.lastJarInfo.getJarNum();
        if (this.recordedJarNum.add(lastJarNum)) {
            JavaCGFileUtil.write2FileWithTab(this.jarInfoWriter, this.lastJarInfo.getJarType(), String.valueOf(lastJarNum), this.lastJarInfo.getJarPath());
        }
    }

    private boolean handleJavaClass(JavaClass javaClass, String jarEntryPath) throws IOException {
        String className = javaClass.getClassName();
        List<String> classFilePathList = this.handledClassNameMap.get(className);
        if (classFilePathList != null) {
            classFilePathList.add(jarEntryPath);
            this.duplicateClassNameMap.put(className, classFilePathList);
            logger.debug("\u8df3\u8fc7\u5904\u7406\u91cd\u590d\u540c\u540dClass: {}", (Object)className);
            return true;
        }
        classFilePathList = new ArrayList<String>();
        classFilePathList.add(jarEntryPath);
        this.handledClassNameMap.put(className, classFilePathList);
        logger.debug("\u5904\u7406Class: {}", (Object)className);
        String classJarNum = this.classAndJarNum.getJarNum(className);
        ClassHandler classHandler = new ClassHandler(javaClass, jarEntryPath, this.javaCGConfInfo, classJarNum);
        classHandler.setUseSpringBeanByAnnotationHandler(this.useSpringBeanByAnnotationHandler);
        classHandler.setRunnableImplClassMap(this.runnableImplClassMap);
        classHandler.setCallableImplClassMap(this.callableImplClassMap);
        classHandler.setTransactionCallbackImplClassMap(this.transactionCallbackImplClassMap);
        classHandler.setTransactionCallbackWithoutResultChildClassMap(this.transactionCallbackWithoutResultChildClassMap);
        classHandler.setThreadChildClassMap(this.threadChildClassMap);
        classHandler.setCallIdCounter(this.callIdCounter);
        classHandler.setClassReferenceWriter(this.classReferenceWriter);
        classHandler.setClassAnnotationWriter(this.classAnnotationWriter);
        classHandler.setMethodAnnotationWriter(this.methodAnnotationWriter);
        classHandler.setFieldAnnotationWriter(this.fieldAnnotationWriter);
        classHandler.setFieldInfoWriter(this.fieldInfoWriter);
        classHandler.setMethodLineNumberWriter(this.methodLineNumberWriter);
        classHandler.setMethodCallWriter(this.methodCallWriter);
        classHandler.setGetMethodWriter(this.getMethodWriter);
        classHandler.setSetMethodWriter(this.setMethodWriter);
        classHandler.setFieldGenericsTypeWriter(this.fieldGenericsTypeWriter);
        classHandler.setFieldRelationshipWriter(this.fieldRelationshipWriter);
        classHandler.setStaticFinalFieldMethodCallIdWriter(this.staticFinalFieldMethodCallIdWriter);
        classHandler.setLambdaMethodInfoWriter(this.lambdaMethodInfoWriter);
        classHandler.setMethodCallInfoWriter(this.methodCallInfoWriter);
        classHandler.setMethodCallMethodCallReturnWriter(this.methodCallMethodCallReturnWriter);
        classHandler.setMethodCallStaticFieldWriter(this.methodCallStaticFieldWriter);
        classHandler.setMethodReturnArgSeqWriter(this.methodReturnArgSeqWriter);
        classHandler.setMethodReturnCallIdWriter(this.methodReturnCallIdWriter);
        classHandler.setMethodInfoWriter(this.methodInfoWriter);
        classHandler.setMethodArgumentWriter(this.methodArgumentWriter);
        classHandler.setMethodArgAnnotationWriter(this.methodArgAnnotationWriter);
        classHandler.setMethodArgGenericsTypeWriter(this.methodArgGenericsTypeWriter);
        classHandler.setMethodReturnGenericsTypeWriter(this.methodReturnGenericsTypeWriter);
        classHandler.setMethodCatchWriter(this.methodCatchWriter);
        classHandler.setMethodFinallyWriter(this.methodFinallyWriter);
        classHandler.setMethodThrowWriter(this.methodThrowWriter);
        classHandler.setLogMethodSpendTimeWriter(this.logMethodSpendTimeWriter);
        classHandler.setExtensionsManager(this.extensionsManager);
        classHandler.setMethodNumCounter(this.methodNumCounter);
        classHandler.setFailCounter(this.failCounter);
        classHandler.setFieldRelationshipCounter(this.fieldRelationshipCounter);
        classHandler.setLastJarNum(this.lastJarInfo.getJarNum());
        classHandler.setClassAndJarNum(this.classAndJarNum);
        this.classNumCounter.addAndGet();
        int failCountBefore = this.failCounter.getCount();
        boolean success = classHandler.handleClass();
        if (this.failCounter.getCount() > failCountBefore) {
            this.saveHandleFailClass(javaClass);
        }
        if (!success) {
            return false;
        }
        String classMd5 = DigestUtils.md5Hex((byte[])javaClass.getBytes());
        JavaCGFileUtil.write2FileWithTab(this.classInfoWriter, className, String.valueOf(javaClass.getAccessFlags()), classMd5, classJarNum);
        this.recordExtendsAndImplInfo(javaClass, className);
        this.handleClassSignature(javaClass, className);
        this.handleInnerClass(javaClass);
        return true;
    }

    private void saveHandleFailClass(JavaClass javaClass) {
        String saveClassFilePath = this.javaCGConfInfo.getUsedOutputDirPath() + "javacg_fail_classes" + File.separator + javaClass.getClassName() + ".class";
        File saveClassFile = new File(saveClassFilePath);
        logger.info("\u5c06\u5904\u7406\u5931\u8d25\u7684class\u6587\u4ef6\u4fdd\u5b58\u5230\u6587\u4ef6 {}", (Object)saveClassFile.getAbsolutePath());
        try {
            javaClass.dump(saveClassFile);
        }
        catch (Exception e) {
            logger.error("error ", (Throwable)e);
        }
    }

    private void recordExtendsAndImplInfo(JavaClass javaClass, String className) throws IOException {
        String superClassName = javaClass.getSuperclassName();
        String accessFlagsStr = String.valueOf(javaClass.getAccessFlags());
        if (!JavaCGClassMethodUtil.isObjectClass(superClassName)) {
            JavaCGFileUtil.write2FileWithTab(this.extendsImplWriter, className, accessFlagsStr, "e", superClassName);
        }
        for (String interfaceName : javaClass.getInterfaceNames()) {
            JavaCGFileUtil.write2FileWithTab(this.extendsImplWriter, className, accessFlagsStr, "i", interfaceName);
        }
    }

    private void handleClassSignature(JavaClass javaClass, String className) throws IOException {
        if (javaClass.isAnnotation()) {
            return;
        }
        Signature signature = JavaCGByteCodeUtil.getSignatureOfClass(javaClass);
        if (signature == null) {
            return;
        }
        try {
            SignatureAttribute.ClassType[] interfaceClassTypes;
            SignatureAttribute.ClassType superClassType;
            SignatureAttribute.ClassSignature signatureAttribute = SignatureAttribute.toClassSignature(signature.getSignature());
            HashMap<String, ClassSignatureGenericsInfo> signatureInfoMap = new HashMap<String, ClassSignatureGenericsInfo>();
            Object[] params = signatureAttribute.getParameters();
            if (ArrayUtils.isNotEmpty((Object[])params)) {
                int seq = -1;
                for (Object param : params) {
                    ++seq;
                    String paramName = ((SignatureAttribute.TypeParameter)param).getName();
                    SignatureAttribute.ObjectType paramClassBound = ((SignatureAttribute.TypeParameter)param).getClassBound();
                    if (paramClassBound != null) {
                        String extendsClassName = paramClassBound.jvmTypeName();
                        JavaCGFileUtil.write2FileWithTab(this.classSignatureGenericsWriter, className, String.valueOf(seq), paramName, extendsClassName);
                        signatureInfoMap.put(paramName, new ClassSignatureGenericsInfo(extendsClassName, seq));
                        continue;
                    }
                    Object[] paramInterfaceBounds = ((SignatureAttribute.TypeParameter)param).getInterfaceBound();
                    if (!ArrayUtils.isNotEmpty((Object[])paramInterfaceBounds)) continue;
                    String extendsClassName = ((SignatureAttribute.Type)paramInterfaceBounds[0]).jvmTypeName();
                    JavaCGFileUtil.write2FileWithTab(this.classSignatureGenericsWriter, className, String.valueOf(seq), paramName, extendsClassName);
                    signatureInfoMap.put(paramName, new ClassSignatureGenericsInfo(extendsClassName, seq));
                }
            }
            if ((superClassType = signatureAttribute.getSuperClass()) != null) {
                String superClassName = JavaCGSignatureUtil.getClassName(superClassType);
                this.recordSignatureArgumentInfo(true, className, "e", superClassName, superClassType, signatureInfoMap);
            }
            if ((interfaceClassTypes = signatureAttribute.getInterfaces()) != null) {
                for (SignatureAttribute.ClassType interfaceClassType : interfaceClassTypes) {
                    String interfaceClassName = JavaCGSignatureUtil.getClassName(interfaceClassType);
                    this.recordSignatureArgumentInfo(false, className, "i", interfaceClassName, interfaceClassType, signatureInfoMap);
                }
            }
        }
        catch (BadBytecode e) {
            logger.error("\u5904\u7406\u7c7b\u7684\u7b7e\u540d\u51fa\u73b0\u5f02\u5e38 {} ", (Object)className, (Object)e);
        }
    }

    private void handleInnerClass(JavaClass javaClass) throws IOException {
        List<InnerClassInfo> innerClassInfoList = JavaCGByteCodeUtil.getInnerClassInfo(javaClass);
        for (InnerClassInfo innerClassInfo : innerClassInfoList) {
            JavaCGFileUtil.write2FileWithTab(this.innerClassWriter, innerClassInfo.getInnerClassName(), innerClassInfo.getOuterClassName(), JavaCGYesNoEnum.parseStrValue(innerClassInfo.isAnonymousClass()));
        }
    }

    private void recordSignatureArgumentInfo(boolean extendsOrImpl, String className, String type, String superOrInterfaceName, SignatureAttribute.ClassType classType, Map<String, ClassSignatureGenericsInfo> signatureInfoMap) throws IOException {
        SignatureAttribute.TypeArgument[] arguments = classType.getTypeArguments();
        if (arguments == null) {
            return;
        }
        int seq = 0;
        for (SignatureAttribute.TypeArgument typeArgument : arguments) {
            ClassSignatureGenericsInfo genericsInfo;
            SignatureAttribute.ObjectType objectType = typeArgument.getType();
            String genericsName = null;
            if (objectType instanceof SignatureAttribute.ClassType) {
                SignatureAttribute.ClassType argumentClassType = (SignatureAttribute.ClassType)objectType;
                JavaCGFileUtil.write2FileWithTab(this.classSignatureEI1Writer, className, type, superOrInterfaceName, String.valueOf(seq), JavaCGSignatureUtil.getClassName(argumentClassType), "");
            } else if (objectType instanceof SignatureAttribute.TypeVariable) {
                SignatureAttribute.TypeVariable typeVariable = (SignatureAttribute.TypeVariable)objectType;
                JavaCGFileUtil.write2FileWithTab(this.classSignatureEI1Writer, className, type, superOrInterfaceName, String.valueOf(seq), "", typeVariable.getName());
                genericsName = typeVariable.getName();
            } else if (objectType instanceof SignatureAttribute.ArrayType) {
                SignatureAttribute.ArrayType argumentArrayType = (SignatureAttribute.ArrayType)objectType;
                JavaCGFileUtil.write2FileWithTab(this.classSignatureEI1Writer, className, type, superOrInterfaceName, String.valueOf(seq), argumentArrayType.toString(), "");
                genericsName = argumentArrayType.toString();
            }
            if (StringUtils.isNotBlank(genericsName) && (genericsInfo = signatureInfoMap.get(genericsName)) != null) {
                JavaCGFileUtil.write2FileWithTab(this.classSigExtImplGenericsWriter, className, genericsName, String.valueOf(genericsInfo.getSeq()), extendsOrImpl ? "e" : "i", superOrInterfaceName, genericsInfo.getExtendsClassName(), String.valueOf(seq));
            }
            ++seq;
        }
    }

    public Map<String, List<String>> getDuplicateClassNameMap() {
        return this.duplicateClassNameMap;
    }

    public void setUseSpringBeanByAnnotationHandler(UseSpringBeanByAnnotationHandler useSpringBeanByAnnotationHandler) {
        this.useSpringBeanByAnnotationHandler = useSpringBeanByAnnotationHandler;
    }

    public void setRunnableImplClassMap(Map<String, Boolean> runnableImplClassMap) {
        this.runnableImplClassMap = runnableImplClassMap;
    }

    public void setCallableImplClassMap(Map<String, Boolean> callableImplClassMap) {
        this.callableImplClassMap = callableImplClassMap;
    }

    public void setTransactionCallbackImplClassMap(Map<String, Boolean> transactionCallbackImplClassMap) {
        this.transactionCallbackImplClassMap = transactionCallbackImplClassMap;
    }

    public void setTransactionCallbackWithoutResultChildClassMap(Map<String, Boolean> transactionCallbackWithoutResultChildClassMap) {
        this.transactionCallbackWithoutResultChildClassMap = transactionCallbackWithoutResultChildClassMap;
    }

    public void setThreadChildClassMap(Map<String, Boolean> threadChildClassMap) {
        this.threadChildClassMap = threadChildClassMap;
    }

    public void setJarInfoWriter(Writer jarInfoWriter) {
        this.jarInfoWriter = jarInfoWriter;
    }

    public void setClassReferenceWriter(Writer classReferenceWriter) {
        this.classReferenceWriter = classReferenceWriter;
    }

    public void setMethodCallWriter(Writer methodCallWriter) {
        this.methodCallWriter = methodCallWriter;
    }

    public void setLambdaMethodInfoWriter(Writer lambdaMethodInfoWriter) {
        this.lambdaMethodInfoWriter = lambdaMethodInfoWriter;
    }

    public void setClassAnnotationWriter(Writer classAnnotationWriter) {
        this.classAnnotationWriter = classAnnotationWriter;
    }

    public void setMethodAnnotationWriter(Writer methodAnnotationWriter) {
        this.methodAnnotationWriter = methodAnnotationWriter;
    }

    public void setFieldAnnotationWriter(Writer fieldAnnotationWriter) {
        this.fieldAnnotationWriter = fieldAnnotationWriter;
    }

    public void setFieldInfoWriter(Writer fieldInfoWriter) {
        this.fieldInfoWriter = fieldInfoWriter;
    }

    public void setMethodLineNumberWriter(Writer methodLineNumberWriter) {
        this.methodLineNumberWriter = methodLineNumberWriter;
    }

    public void setMethodCallInfoWriter(Writer methodCallInfoWriter) {
        this.methodCallInfoWriter = methodCallInfoWriter;
    }

    public void setMethodCallMethodCallReturnWriter(Writer methodCallMethodCallReturnWriter) {
        this.methodCallMethodCallReturnWriter = methodCallMethodCallReturnWriter;
    }

    public void setMethodCallStaticFieldWriter(Writer methodCallStaticFieldWriter) {
        this.methodCallStaticFieldWriter = methodCallStaticFieldWriter;
    }

    public void setMethodReturnArgSeqWriter(Writer methodReturnArgSeqWriter) {
        this.methodReturnArgSeqWriter = methodReturnArgSeqWriter;
    }

    public void setMethodReturnCallIdWriter(Writer methodReturnCallIdWriter) {
        this.methodReturnCallIdWriter = methodReturnCallIdWriter;
    }

    public void setClassInfoWriter(Writer classInfoWriter) {
        this.classInfoWriter = classInfoWriter;
    }

    public void setMethodInfoWriter(Writer methodInfoWriter) {
        this.methodInfoWriter = methodInfoWriter;
    }

    public void setExtendsImplWriter(Writer extendsImplWriter) {
        this.extendsImplWriter = extendsImplWriter;
    }

    public void setClassSignatureEI1Writer(Writer classSignatureEI1Writer) {
        this.classSignatureEI1Writer = classSignatureEI1Writer;
    }

    public void setClassSignatureGenericsWriter(Writer classSignatureGenericsWriter) {
        this.classSignatureGenericsWriter = classSignatureGenericsWriter;
    }

    public void setClassSigExtImplGenericsWriter(Writer classSigExtImplGenericsWriter) {
        this.classSigExtImplGenericsWriter = classSigExtImplGenericsWriter;
    }

    public void setMethodArgumentWriter(Writer methodArgumentWriter) {
        this.methodArgumentWriter = methodArgumentWriter;
    }

    public void setMethodArgAnnotationWriter(Writer methodArgAnnotationWriter) {
        this.methodArgAnnotationWriter = methodArgAnnotationWriter;
    }

    public void setMethodArgGenericsTypeWriter(Writer methodArgGenericsTypeWriter) {
        this.methodArgGenericsTypeWriter = methodArgGenericsTypeWriter;
    }

    public void setMethodReturnGenericsTypeWriter(Writer methodReturnGenericsTypeWriter) {
        this.methodReturnGenericsTypeWriter = methodReturnGenericsTypeWriter;
    }

    public void setMethodCatchWriter(Writer methodCatchWriter) {
        this.methodCatchWriter = methodCatchWriter;
    }

    public void setMethodFinallyWriter(Writer methodFinallyWriter) {
        this.methodFinallyWriter = methodFinallyWriter;
    }

    public void setMethodThrowWriter(Writer methodThrowWriter) {
        this.methodThrowWriter = methodThrowWriter;
    }

    public void setInnerClassWriter(Writer innerClassWriter) {
        this.innerClassWriter = innerClassWriter;
    }

    public void setGetMethodWriter(Writer getMethodWriter) {
        this.getMethodWriter = getMethodWriter;
    }

    public void setSetMethodWriter(Writer setMethodWriter) {
        this.setMethodWriter = setMethodWriter;
    }

    public void setFieldGenericsTypeWriter(Writer fieldGenericsTypeWriter) {
        this.fieldGenericsTypeWriter = fieldGenericsTypeWriter;
    }

    public void setFieldRelationshipWriter(Writer fieldRelationshipWriter) {
        this.fieldRelationshipWriter = fieldRelationshipWriter;
    }

    public void setStaticFinalFieldMethodCallIdWriter(Writer staticFinalFieldMethodCallIdWriter) {
        this.staticFinalFieldMethodCallIdWriter = staticFinalFieldMethodCallIdWriter;
    }

    public void setLogMethodSpendTimeWriter(WriterSupportSkip logMethodSpendTimeWriter) {
        this.logMethodSpendTimeWriter = logMethodSpendTimeWriter;
    }

    public void setExtensionsManager(ExtensionsManager extensionsManager) {
        this.extensionsManager = extensionsManager;
    }

    public void setCallIdCounter(JavaCGCounter callIdCounter) {
        this.callIdCounter = callIdCounter;
    }

    public void setClassNumCounter(JavaCGCounter classNumCounter) {
        this.classNumCounter = classNumCounter;
    }

    public void setMethodNumCounter(JavaCGCounter methodNumCounter) {
        this.methodNumCounter = methodNumCounter;
    }

    public void setFailCounter(JavaCGCounter failCounter) {
        this.failCounter = failCounter;
    }

    public void setFieldRelationshipCounter(JavaCGCounter fieldRelationshipCounter) {
        this.fieldRelationshipCounter = fieldRelationshipCounter;
    }

    public void setClassAndJarNum(ClassAndJarNum classAndJarNum) {
        this.classAndJarNum = classAndJarNum;
    }
}

