/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.parser;

import com.adrninistrator.javacg.common.JavaCGCommonNameConstants;
import com.adrninistrator.javacg.common.enums.JavaCGOtherConfigFileUseListEnum;
import com.adrninistrator.javacg.conf.JavaCGConfInfo;
import com.adrninistrator.javacg.dto.jar.ClassAndJarNum;
import com.adrninistrator.javacg.dto.jar.JarInfo;
import com.adrninistrator.javacg.dto.method.MethodArgReturnTypes;
import com.adrninistrator.javacg.extensions.codeparser.JarEntryOtherFileParser;
import com.adrninistrator.javacg.extensions.manager.ExtensionsManager;
import com.adrninistrator.javacg.parser.AbstractJarEntryParser;
import com.adrninistrator.javacg.spring.DefineSpringBeanByAnnotationHandler;
import com.adrninistrator.javacg.util.JavaCGByteCodeUtil;
import com.adrninistrator.javacg.util.JavaCGClassMethodUtil;
import com.adrninistrator.javacg.util.JavaCGUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.lingala.zip4j.io.inputstream.ZipInputStream;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarEntryPreHandle1Parser
extends AbstractJarEntryParser {
    private static final Logger logger = LoggerFactory.getLogger(JarEntryPreHandle1Parser.class);
    private Map<String, List<String>> classImplementsInfoMap;
    private Map<String, Map<MethodArgReturnTypes, Integer>> classExtendsImplMethodWithArgTypesMap;
    private Map<String, Map<MethodArgReturnTypes, Integer>> interfaceMethodWithArgTypesMap;
    private Map<String, Boolean> runnableImplClassMap;
    private Map<String, Boolean> callableImplClassMap;
    private Map<String, Boolean> transactionCallbackImplClassMap;
    private Map<String, Boolean> transactionCallbackWithoutResultChildClassMap;
    private Map<String, Boolean> threadChildClassMap;
    private Set<String> allClassNameSet;
    private Map<String, String> classAndSuperMap;
    private Set<String> interfaceExtendsSet;
    private ClassAndJarNum classAndJarNum;
    private final ExtensionsManager extensionsManager;
    private final DefineSpringBeanByAnnotationHandler defineSpringBeanByAnnotationHandler;

    public JarEntryPreHandle1Parser(JavaCGConfInfo javaCGConfInfo, Map<String, JarInfo> jarInfoMap, DefineSpringBeanByAnnotationHandler defineSpringBeanByAnnotationHandler, ExtensionsManager extensionsManager) {
        super(javaCGConfInfo, jarInfoMap);
        this.defineSpringBeanByAnnotationHandler = defineSpringBeanByAnnotationHandler;
        this.extensionsManager = extensionsManager;
    }

    @Override
    protected boolean handleEntry(ZipInputStream zipInputStream, String jarEntryPath) throws IOException {
        if (this.tryHandleClassEntry((InputStream)zipInputStream, jarEntryPath)) {
            return true;
        }
        String jarEntryFileExt = "." + StringUtils.substringAfterLast((String)jarEntryPath, (String)".");
        logger.debug("jar\u5305\u4e2d\u6587\u4ef6\u7684\u540e\u7f00: [{}] {}", (Object)jarEntryPath, (Object)jarEntryFileExt);
        List<JarEntryOtherFileParser> jarEntryOtherFileParserList = this.extensionsManager.getJarEntryOtherFileParserList(jarEntryFileExt);
        if (jarEntryOtherFileParserList == null) {
            logger.debug("\u5f53\u524d\u6587\u4ef6\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u6269\u5c55\u7c7b\uff0c\u4e0d\u5904\u7406 {}", (Object)jarEntryFileExt);
            return true;
        }
        InputStream cachedInputStream = JavaCGUtil.cacheInputStream((InputStream)zipInputStream);
        if (cachedInputStream == null) {
            return false;
        }
        for (JarEntryOtherFileParser jarEntryOtherFileParser : jarEntryOtherFileParserList) {
            jarEntryOtherFileParser.parseJarEntryOtherFile(cachedInputStream, jarEntryPath);
            cachedInputStream.reset();
        }
        return true;
    }

    @Override
    protected boolean handleClassEntry(JavaClass javaClass, String jarEntryPath) {
        this.classAndJarNum.put(javaClass.getClassName(), this.lastJarInfo.getJarNum());
        if (javaClass.isInterface()) {
            this.preHandle1Interface(javaClass);
            return true;
        }
        this.preHandle1Class(javaClass);
        if (this.javaCGConfInfo.isParseMethodCallTypeValue()) {
            return this.defineSpringBeanByAnnotationHandler.recordSpringBeanInfo(javaClass);
        }
        return true;
    }

    private void preHandle1Interface(JavaClass interfaceClass) {
        String[] superInterfaceNames;
        if (interfaceClass.isAnnotation()) {
            return;
        }
        String interfaceName = interfaceClass.getClassName();
        Object[] methods = interfaceClass.getMethods();
        if (ArrayUtils.isNotEmpty((Object[])methods) && !this.interfaceMethodWithArgTypesMap.containsKey(interfaceName)) {
            Map<MethodArgReturnTypes, Integer> currentInterfaceMethodWithArgTypesMap = JavaCGByteCodeUtil.genInterfaceMethodWithArgTypes((Method[])methods);
            this.interfaceMethodWithArgTypesMap.put(interfaceName, currentInterfaceMethodWithArgTypesMap);
        }
        if ((superInterfaceNames = interfaceClass.getInterfaceNames()).length > 0) {
            this.interfaceExtendsSet.add(interfaceName);
            this.interfaceExtendsSet.addAll(Arrays.asList(superInterfaceNames));
        }
    }

    private boolean preHandle1Class(JavaClass javaClass) {
        String superClassName;
        String className = javaClass.getClassName();
        if (JavaCGClassMethodUtil.isObjectClass(className)) {
            logger.error("Object\u7c7b\u6240\u5728jar\u5305\u4e0d\u9700\u8981\u6dfb\u52a0\u5230\u9700\u8981\u5206\u6790\u7684jar\u5305\u53c2\u6570\u4e2d\uff0c\u5047\u5982\u9700\u8981\u6dfb\u52a0JDK\u4e2d\u7684\u7c7b\uff0c\u53ef\u4ee5\u89e3\u538b\u76f8\u5173\u7684class\u6587\u4ef6\u5230\u76ee\u5f55\u4e2d\u5e76\u5728 {} \u4e2d\u6307\u5b9a", (Object)JavaCGOtherConfigFileUseListEnum.OCFULE_JAR_DIR.getFileName());
            return false;
        }
        this.allClassNameSet.add(className);
        String[] interfaceNames = javaClass.getInterfaceNames();
        if (interfaceNames.length > 0 && !this.classImplementsInfoMap.containsKey(className)) {
            ArrayList<String> interfaceNameList = new ArrayList<String>(interfaceNames.length);
            interfaceNameList.addAll(Arrays.asList(interfaceNames));
            this.classImplementsInfoMap.put(className, interfaceNameList);
            Object[] methods = javaClass.getMethods();
            if (ArrayUtils.isNotEmpty((Object[])methods)) {
                Map<MethodArgReturnTypes, Integer> implClassMethodWithArgTypesMap = JavaCGByteCodeUtil.genImplClassMethodWithArgTypes((Method[])methods);
                JavaCGClassMethodUtil.copyClassMethodMap(this.classExtendsImplMethodWithArgTypesMap, className, implClassMethodWithArgTypesMap);
            }
            if (!javaClass.isAbstract()) {
                if (interfaceNameList.contains(JavaCGCommonNameConstants.CLASS_NAME_RUNNABLE)) {
                    this.runnableImplClassMap.put(className, Boolean.FALSE);
                }
                if (interfaceNameList.contains(JavaCGCommonNameConstants.CLASS_NAME_CALLABLE)) {
                    this.callableImplClassMap.put(className, Boolean.FALSE);
                }
                if (interfaceNameList.contains("org.springframework.transaction.support.TransactionCallback")) {
                    this.transactionCallbackImplClassMap.put(className, Boolean.FALSE);
                }
            }
        }
        if (JavaCGCommonNameConstants.CLASS_NAME_THREAD.equals(superClassName = javaClass.getSuperclassName())) {
            this.threadChildClassMap.put(className, Boolean.FALSE);
        } else if (JavaCGCommonNameConstants.CLASS_NAME_TIMER_TASK.equals(superClassName)) {
            this.runnableImplClassMap.put(className, Boolean.FALSE);
        } else if ("org.springframework.transaction.support.TransactionCallbackWithoutResult".equals(superClassName)) {
            this.transactionCallbackWithoutResultChildClassMap.put(className, Boolean.FALSE);
        }
        if (!JavaCGClassMethodUtil.isObjectClass(superClassName)) {
            this.classAndSuperMap.put(className, superClassName);
        }
        return true;
    }

    public void setClassImplementsInfoMap(Map<String, List<String>> classImplementsInfoMap) {
        this.classImplementsInfoMap = classImplementsInfoMap;
    }

    public void setClassExtendsImplMethodWithArgTypesMap(Map<String, Map<MethodArgReturnTypes, Integer>> classExtendsImplMethodWithArgTypesMap) {
        this.classExtendsImplMethodWithArgTypesMap = classExtendsImplMethodWithArgTypesMap;
    }

    public void setInterfaceMethodWithArgTypesMap(Map<String, Map<MethodArgReturnTypes, Integer>> interfaceMethodWithArgTypesMap) {
        this.interfaceMethodWithArgTypesMap = interfaceMethodWithArgTypesMap;
    }

    public void setRunnableImplClassMap(Map<String, Boolean> runnableImplClassMap) {
        this.runnableImplClassMap = runnableImplClassMap;
    }

    public void setCallableImplClassMap(Map<String, Boolean> callableImplClassMap) {
        this.callableImplClassMap = callableImplClassMap;
    }

    public void setTransactionCallbackImplClassMap(Map<String, Boolean> transactionCallbackImplClassMap) {
        this.transactionCallbackImplClassMap = transactionCallbackImplClassMap;
    }

    public void setTransactionCallbackWithoutResultChildClassMap(Map<String, Boolean> transactionCallbackWithoutResultChildClassMap) {
        this.transactionCallbackWithoutResultChildClassMap = transactionCallbackWithoutResultChildClassMap;
    }

    public void setThreadChildClassMap(Map<String, Boolean> threadChildClassMap) {
        this.threadChildClassMap = threadChildClassMap;
    }

    public void setAllClassNameSet(Set<String> allClassNameSet) {
        this.allClassNameSet = allClassNameSet;
    }

    public void setClassAndSuperMap(Map<String, String> classAndSuperMap) {
        this.classAndSuperMap = classAndSuperMap;
    }

    public void setInterfaceExtendsSet(Set<String> interfaceExtendsSet) {
        this.interfaceExtendsSet = interfaceExtendsSet;
    }

    public void setClassAndJarNum(ClassAndJarNum classAndJarNum) {
        this.classAndJarNum = classAndJarNum;
    }
}

