/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.parser;

import com.adrninistrator.javacg.conf.JavaCGConfInfo;
import com.adrninistrator.javacg.dto.classes.ClassExtendsInfo;
import com.adrninistrator.javacg.dto.jar.JarInfo;
import com.adrninistrator.javacg.dto.method.MethodArgReturnTypes;
import com.adrninistrator.javacg.parser.AbstractJarEntryParser;
import com.adrninistrator.javacg.spring.UseSpringBeanByAnnotationHandler;
import com.adrninistrator.javacg.util.JavaCGByteCodeUtil;
import com.adrninistrator.javacg.util.JavaCGClassMethodUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.lingala.zip4j.io.inputstream.ZipInputStream;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.commons.lang3.ArrayUtils;

public class JarEntryPreHandle2Parser
extends AbstractJarEntryParser {
    private final Set<String> classExtendsSet = new HashSet<String>(100);
    private Map<String, Map<MethodArgReturnTypes, Integer>> classExtendsImplMethodWithArgTypesMap;
    private Map<String, Map<MethodArgReturnTypes, Integer>> interfaceMethodWithArgTypesMap;
    private Map<String, String> classAndSuperMap;
    private Map<String, ClassExtendsInfo> classExtendsInfoMap;
    private Map<String, List<String>> childrenClassMap;
    private Set<String> interfaceExtendsSet;
    private Map<String, List<String>> interfaceExtendsInfoMap;
    private Map<String, List<String>> childrenInterfaceMap;
    private Set<String> allClassNameSet;
    private final UseSpringBeanByAnnotationHandler useSpringBeanByAnnotationHandler;

    public JarEntryPreHandle2Parser(JavaCGConfInfo javaCGConfInfo, Map<String, JarInfo> jarInfoMap, UseSpringBeanByAnnotationHandler useSpringBeanByAnnotationHandler) {
        super(javaCGConfInfo, jarInfoMap);
        this.useSpringBeanByAnnotationHandler = useSpringBeanByAnnotationHandler;
    }

    @Override
    public void init() {
        for (Map.Entry<String, String> entry : this.classAndSuperMap.entrySet()) {
            String superClassName = entry.getValue();
            if (JavaCGClassMethodUtil.isClassInJdk(superClassName) && !this.allClassNameSet.contains(superClassName)) continue;
            String className = entry.getKey();
            this.classExtendsSet.add(className);
            this.classExtendsSet.add(superClassName);
        }
    }

    @Override
    protected boolean handleEntry(ZipInputStream zipInputStream, String jarEntryPath) throws IOException {
        this.tryHandleClassEntry((InputStream)zipInputStream, jarEntryPath);
        return true;
    }

    @Override
    protected boolean handleClassEntry(JavaClass javaClass, String jarEntryPath) {
        if (javaClass.isClass()) {
            this.findClassExtendsInfo(javaClass);
            if (this.javaCGConfInfo.isParseMethodCallTypeValue()) {
                this.useSpringBeanByAnnotationHandler.recordClassFieldsWithSpringAnnotation(javaClass);
            }
            return true;
        }
        this.findInterfaceExtendsInfo(javaClass);
        return true;
    }

    private void findClassExtendsInfo(JavaClass javaClass) {
        String className = javaClass.getClassName();
        if (!this.classExtendsSet.contains(className) || this.classExtendsInfoMap.containsKey(className)) {
            return;
        }
        String superClassName = javaClass.getSuperclassName();
        List childrenClassList = this.childrenClassMap.computeIfAbsent(superClassName, k -> new ArrayList());
        childrenClassList.add(className);
        this.classExtendsInfoMap.put(className, new ClassExtendsInfo(javaClass.getAccessFlags(), superClassName));
        Object[] methods = javaClass.getMethods();
        if (ArrayUtils.isNotEmpty((Object[])methods)) {
            Map<MethodArgReturnTypes, Integer> methodArgReturnTypesMap = JavaCGByteCodeUtil.genExtendsClassMethodWithArgTypes(javaClass.getMethods());
            JavaCGClassMethodUtil.copyClassMethodMap(this.classExtendsImplMethodWithArgTypesMap, className, methodArgReturnTypesMap);
        }
    }

    private void findInterfaceExtendsInfo(JavaClass interfaceClass) {
        String[] superInterfaceNames;
        String interfaceName = interfaceClass.getClassName();
        if (interfaceClass.isAnnotation() || !this.interfaceExtendsSet.contains(interfaceName) || this.interfaceExtendsInfoMap.containsKey(interfaceName)) {
            return;
        }
        for (String superInterfaceName : superInterfaceNames = interfaceClass.getInterfaceNames()) {
            List childrenInterfaceList = this.childrenInterfaceMap.computeIfAbsent(superInterfaceName, k -> new ArrayList());
            childrenInterfaceList.add(interfaceName);
        }
        HashMap<MethodArgReturnTypes, Integer> methodAttributeMap = new HashMap<MethodArgReturnTypes, Integer>();
        for (Method method : interfaceClass.getMethods()) {
            methodAttributeMap.put(new MethodArgReturnTypes(method.getName(), method.getArgumentTypes(), method.getReturnType()), method.getAccessFlags());
        }
        this.interfaceExtendsInfoMap.put(interfaceName, Arrays.asList(superInterfaceNames));
        this.interfaceMethodWithArgTypesMap.put(interfaceName, methodAttributeMap);
    }

    public void setClassExtendsImplMethodWithArgTypesMap(Map<String, Map<MethodArgReturnTypes, Integer>> classExtendsImplMethodWithArgTypesMap) {
        this.classExtendsImplMethodWithArgTypesMap = classExtendsImplMethodWithArgTypesMap;
    }

    public void setInterfaceMethodWithArgTypesMap(Map<String, Map<MethodArgReturnTypes, Integer>> interfaceMethodWithArgTypesMap) {
        this.interfaceMethodWithArgTypesMap = interfaceMethodWithArgTypesMap;
    }

    public void setClassAndSuperMap(Map<String, String> classAndSuperMap) {
        this.classAndSuperMap = classAndSuperMap;
    }

    public void setClassExtendsInfoMap(Map<String, ClassExtendsInfo> classExtendsInfoMap) {
        this.classExtendsInfoMap = classExtendsInfoMap;
    }

    public void setChildrenClassMap(Map<String, List<String>> childrenClassMap) {
        this.childrenClassMap = childrenClassMap;
    }

    public void setInterfaceExtendsSet(Set<String> interfaceExtendsSet) {
        this.interfaceExtendsSet = interfaceExtendsSet;
    }

    public void setInterfaceExtendsInfoMap(Map<String, List<String>> interfaceExtendsInfoMap) {
        this.interfaceExtendsInfoMap = interfaceExtendsInfoMap;
    }

    public void setChildrenInterfaceMap(Map<String, List<String>> childrenInterfaceMap) {
        this.childrenInterfaceMap = childrenInterfaceMap;
    }

    public void setAllClassNameSet(Set<String> allClassNameSet) {
        this.allClassNameSet = allClassNameSet;
    }
}

