/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.spring;

import com.adrninistrator.javacg.dto.classes.ClassExtendsInfo;
import com.adrninistrator.javacg.extensions.codeparser.SpringXmlBeanParserInterface;
import com.adrninistrator.javacg.spring.DefineSpringBeanByAnnotationHandler;
import com.adrninistrator.javacg.util.JavaCGAnnotationUtil;
import com.adrninistrator.javacg.util.JavaCGClassMethodUtil;
import com.adrninistrator.javacg.util.JavaCGUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UseSpringBeanByAnnotationHandler {
    private static final Logger logger = LoggerFactory.getLogger(UseSpringBeanByAnnotationHandler.class);
    private final Map<String, ClassExtendsInfo> classExtendsInfoMap;
    private final Map<String, List<String>> classImplementsInfoMap;
    private final Map<String, List<String>> interfaceExtendsInfoMap;
    private final DefineSpringBeanByAnnotationHandler defineSpringBeanByAnnotationHandler;
    private final SpringXmlBeanParserInterface springXmlBeanParser;
    private final Map<String, Map<String, String>> classFieldSpringBeanNameMap = new HashMap<String, Map<String, String>>(100);
    private final Map<String, Map<String, String>> classFieldSpringBeanTypeMap = new HashMap<String, Map<String, String>>();
    private final Map<String, Map<String, String>> classAutowiredFieldInfoMap = new HashMap<String, Map<String, String>>(100);
    private final Map<String, Map<String, List<String>>> classAutowiredFieldMatchedTypeMap = new HashMap<String, Map<String, List<String>>>(100);
    private boolean useSpringBean = false;

    public UseSpringBeanByAnnotationHandler(Map<String, ClassExtendsInfo> classExtendsInfoMap, Map<String, List<String>> classImplementsInfoMap, Map<String, List<String>> interfaceExtendsInfoMap, DefineSpringBeanByAnnotationHandler defineSpringBeanByAnnotationHandler, SpringXmlBeanParserInterface springXmlBeanParser) {
        this.classExtendsInfoMap = classExtendsInfoMap;
        this.classImplementsInfoMap = classImplementsInfoMap;
        this.interfaceExtendsInfoMap = interfaceExtendsInfoMap;
        this.defineSpringBeanByAnnotationHandler = defineSpringBeanByAnnotationHandler;
        this.springXmlBeanParser = springXmlBeanParser;
        if (springXmlBeanParser != null) {
            logger.info("\u6307\u5b9a {} \u5b9e\u4f8b {}", (Object)SpringXmlBeanParserInterface.class.getSimpleName(), (Object)springXmlBeanParser.getClass().getName());
        } else {
            logger.info("\u672a\u6307\u5b9a {} \u5b9e\u4f8b", (Object)SpringXmlBeanParserInterface.class.getSimpleName());
        }
    }

    public void recordClassFieldsWithSpringAnnotation(JavaClass javaClass) {
        String className = javaClass.getClassName();
        HashMap<String, String> fieldSpringBeanNameMap = new HashMap<String, String>(10);
        HashMap<String, String> fieldSpringBeanTypeMap = new HashMap<String, String>(2);
        for (Field field : javaClass.getFields()) {
            this.handleFieldWithSpringAnnotation(className, field, fieldSpringBeanNameMap, fieldSpringBeanTypeMap);
        }
        if (!fieldSpringBeanNameMap.isEmpty()) {
            this.useSpringBean = true;
            this.classFieldSpringBeanNameMap.put(className, fieldSpringBeanNameMap);
        }
        if (!fieldSpringBeanTypeMap.isEmpty()) {
            this.useSpringBean = true;
            this.classFieldSpringBeanTypeMap.put(className, fieldSpringBeanTypeMap);
        }
    }

    private void handleFieldWithSpringAnnotation(String className, Field field, Map<String, String> fieldSpringBeanNameMap, Map<String, String> fieldSpringBeanTypeMap) {
        String typeAttributeValue;
        String fieldName = field.getName();
        AnnotationEntry resourceAnnotationEntry = null;
        AnnotationEntry autowiredAnnotationEntry = null;
        AnnotationEntry qualifierAnnotationEntry = null;
        AnnotationEntry namedAnnotationEntry = null;
        AnnotationEntry injectAnnotationEntry = null;
        for (AnnotationEntry annotationEntry : field.getAnnotationEntries()) {
            if ("Ljavax/annotation/Resource;".equals(annotationEntry.getAnnotationType())) {
                resourceAnnotationEntry = annotationEntry;
                continue;
            }
            if ("Lorg/springframework/beans/factory/annotation/Autowired;".equals(annotationEntry.getAnnotationType())) {
                autowiredAnnotationEntry = annotationEntry;
                continue;
            }
            if ("Lorg/springframework/beans/factory/annotation/Qualifier;".equals(annotationEntry.getAnnotationType())) {
                qualifierAnnotationEntry = annotationEntry;
                continue;
            }
            if ("Ljavax/inject/Named;".equals(annotationEntry.getAnnotationType())) {
                namedAnnotationEntry = annotationEntry;
                continue;
            }
            if (!"Ljavax/inject/Inject;".equals(annotationEntry.getAnnotationType())) continue;
            injectAnnotationEntry = annotationEntry;
        }
        if (resourceAnnotationEntry != null && (typeAttributeValue = JavaCGAnnotationUtil.getAnnotationAttributeStringValue(resourceAnnotationEntry, "type")) != null) {
            fieldSpringBeanTypeMap.put(fieldName, typeAttributeValue);
            return;
        }
        String beanName = this.getSpringBeanNameOfField(resourceAnnotationEntry, autowiredAnnotationEntry, qualifierAnnotationEntry, namedAnnotationEntry, injectAnnotationEntry, fieldName);
        if (beanName == null) {
            return;
        }
        if (autowiredAnnotationEntry != null && qualifierAnnotationEntry == null || injectAnnotationEntry != null) {
            Map autowiredFieldInfoMap = this.classAutowiredFieldInfoMap.computeIfAbsent(className, k -> new HashMap());
            autowiredFieldInfoMap.put(fieldName, field.getType().toString());
        }
        fieldSpringBeanNameMap.put(fieldName, beanName);
    }

    private String getSpringBeanNameOfField(AnnotationEntry resourceAnnotationEntry, AnnotationEntry autowiredAnnotationEntry, AnnotationEntry qualifierAnnotationEntry, AnnotationEntry namedAnnotationEntry, AnnotationEntry injectAnnotationEntry, String fieldName) {
        if (resourceAnnotationEntry == null && autowiredAnnotationEntry == null && injectAnnotationEntry == null) {
            return null;
        }
        if (resourceAnnotationEntry != null) {
            String nameOfResource = JavaCGAnnotationUtil.getAnnotationAttributeStringValue(resourceAnnotationEntry, "name");
            if (nameOfResource == null) {
                return fieldName;
            }
            return nameOfResource;
        }
        if (injectAnnotationEntry != null) {
            if (namedAnnotationEntry == null) {
                return fieldName;
            }
            String valueOfNamed = JavaCGAnnotationUtil.getAnnotationAttributeStringValue(namedAnnotationEntry, "value");
            if (StringUtils.isBlank((CharSequence)valueOfNamed)) {
                return fieldName;
            }
            return valueOfNamed;
        }
        if (qualifierAnnotationEntry == null) {
            return fieldName;
        }
        String valueOfQualifier = JavaCGAnnotationUtil.getAnnotationAttributeStringValue(qualifierAnnotationEntry, "value");
        if (StringUtils.isBlank((CharSequence)valueOfQualifier)) {
            return fieldName;
        }
        return valueOfQualifier;
    }

    public List<String> getSpringBeanTypeList(String className, String fieldName) {
        String springBeanTypeInXml;
        String springBeanType = this.getSpringBeanTypeByAnnotationType(className, fieldName);
        if (springBeanType != null) {
            return Collections.singletonList(springBeanType);
        }
        String springBeanName = this.getSpringBeanName(className, fieldName);
        if (springBeanName == null) {
            return Collections.emptyList();
        }
        List<String> springBeanTypeList = this.defineSpringBeanByAnnotationHandler.getSpringBeanTypeList(springBeanName);
        if (!JavaCGUtil.isCollectionEmpty(springBeanTypeList)) {
            return this.checkAutowiredTypeMatches(className, fieldName, springBeanTypeList);
        }
        if (this.springXmlBeanParser != null && (springBeanTypeInXml = this.springXmlBeanParser.getBeanClass(springBeanName)) != null) {
            return Collections.singletonList(springBeanTypeInXml);
        }
        return Collections.emptyList();
    }

    private List<String> checkAutowiredTypeMatches(String className, String fieldName, List<String> springBeanTypeList) {
        Map<String, String> autowiredFieldInfoMap = this.classAutowiredFieldInfoMap.get(className);
        if (autowiredFieldInfoMap == null) {
            return springBeanTypeList;
        }
        String fieldType = autowiredFieldInfoMap.get(fieldName);
        if (fieldType == null) {
            return springBeanTypeList;
        }
        Map autowiredFieldMatchedTypeMap = this.classAutowiredFieldMatchedTypeMap.computeIfAbsent(className, k -> new HashMap());
        List cachedMatchedTypeList = (List)autowiredFieldMatchedTypeMap.get(fieldName);
        if (cachedMatchedTypeList != null) {
            return cachedMatchedTypeList;
        }
        ArrayList<String> matchedSpringBeanTypeList = new ArrayList<String>(springBeanTypeList.size());
        for (String springBeanType : springBeanTypeList) {
            if (springBeanType.equals(fieldType) || JavaCGClassMethodUtil.isChildOf(springBeanType, fieldType, this.classExtendsInfoMap) || JavaCGClassMethodUtil.isImplementationOf(springBeanType, fieldType, this.classExtendsInfoMap, this.classImplementsInfoMap, this.interfaceExtendsInfoMap)) {
                matchedSpringBeanTypeList.add(springBeanType);
                continue;
            }
            logger.warn("\u4ee5\u4e0b\u7c7b\u83b7\u53d6\u5230\u7684\u5b57\u6bb5\u7684Spring Bean\u7c7b\u578b\u4e0e\u5b57\u6bb5\u7c7b\u578b\u4e0d\u5339\u914d {} {} {} {}", new Object[]{className, fieldName, springBeanType, fieldType});
        }
        autowiredFieldMatchedTypeMap.put(fieldName, matchedSpringBeanTypeList);
        return matchedSpringBeanTypeList;
    }

    private String getSpringBeanTypeByAnnotationType(String className, String fieldName) {
        ClassExtendsInfo classExtendsInfo;
        String springBeanFieldType = this.doGetSpringBeanTypeByAnnotationType(className, fieldName);
        if (springBeanFieldType != null) {
            return springBeanFieldType;
        }
        String currentClassName = className;
        while ((classExtendsInfo = this.classExtendsInfoMap.get(currentClassName)) != null && !JavaCGClassMethodUtil.isClassInJdk(currentClassName = classExtendsInfo.getSuperClassName())) {
            springBeanFieldType = this.doGetSpringBeanTypeByAnnotationType(currentClassName, fieldName);
            if (springBeanFieldType == null) continue;
            Map fieldSpringBeanTypeMap = this.classFieldSpringBeanTypeMap.computeIfAbsent(className, k -> new HashMap());
            fieldSpringBeanTypeMap.put(fieldName, springBeanFieldType);
            break;
        }
        return springBeanFieldType;
    }

    private String doGetSpringBeanTypeByAnnotationType(String className, String fieldName) {
        Map<String, String> fieldSpringBeanTypeMap = this.classFieldSpringBeanTypeMap.get(className);
        if (fieldSpringBeanTypeMap == null) {
            return null;
        }
        return fieldSpringBeanTypeMap.get(fieldName);
    }

    private String getSpringBeanName(String className, String fieldName) {
        ClassExtendsInfo ClassExtendsInfo2;
        String springBeanFieldName = this.doGetSpringBeanName(className, fieldName);
        if (springBeanFieldName != null) {
            return springBeanFieldName;
        }
        String currentClassName = className;
        while ((ClassExtendsInfo2 = this.classExtendsInfoMap.get(currentClassName)) != null && !JavaCGClassMethodUtil.isClassInJdk(currentClassName = ClassExtendsInfo2.getSuperClassName())) {
            springBeanFieldName = this.doGetSpringBeanName(currentClassName, fieldName);
            if (springBeanFieldName == null) continue;
            Map fieldSpringBeanNameMap = this.classFieldSpringBeanNameMap.computeIfAbsent(className, k -> new HashMap());
            fieldSpringBeanNameMap.put(fieldName, springBeanFieldName);
            break;
        }
        return springBeanFieldName;
    }

    private String doGetSpringBeanName(String className, String fieldName) {
        Map<String, String> fieldSpringBeanNameMap = this.classFieldSpringBeanNameMap.get(className);
        if (fieldSpringBeanNameMap == null) {
            return null;
        }
        return fieldSpringBeanNameMap.get(fieldName);
    }

    public boolean hasUseSpringBean() {
        return this.useSpringBean;
    }
}

