/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.util;

import com.adrninistrator.javacg.exceptions.JavaCGRuntimeException;
import com.adrninistrator.javacg.extensions.annotationattributes.AnnotationAttributesFormatterInterface;
import com.adrninistrator.javacg.util.JavaCGFileUtil;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.ArrayElementValue;
import org.apache.bcel.classfile.ClassElementValue;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.classfile.SimpleElementValue;
import org.apache.bcel.classfile.Utility;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaCGAnnotationUtil {
    private static final Logger logger = LoggerFactory.getLogger(JavaCGAnnotationUtil.class);

    public static String getAnnotationAttributeStringValue(AnnotationEntry annotationEntry, String ... annotationAttributeNames) {
        for (ElementValuePair elementValuePair : annotationEntry.getElementValuePairs()) {
            ElementValue elementValue = elementValuePair.getValue();
            if (!StringUtils.equalsAny((CharSequence)elementValuePair.getNameString(), (CharSequence[])annotationAttributeNames)) continue;
            if (elementValue instanceof SimpleElementValue) {
                return elementValue.toString();
            }
            if (elementValue instanceof ClassElementValue) {
                ClassElementValue classElementValue = (ClassElementValue)elementValue;
                return Utility.typeSignatureToString((String)classElementValue.getClassString(), (boolean)false);
            }
            throw new JavaCGRuntimeException("\u6ce8\u89e3\u5c5e\u6027\u7c7b\u578b\u4e0d\u7b26\u5408\u9884\u671f " + elementValuePair.getNameString() + " " + elementValue.getClass().getName());
        }
        return null;
    }

    public static List<String> getAnnotationAttributeStringArrayValue(AnnotationEntry annotationEntry, String ... annotationAttributeNames) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (ElementValuePair elementValuePair : annotationEntry.getElementValuePairs()) {
            if (!StringUtils.equalsAny((CharSequence)elementValuePair.getNameString(), (CharSequence[])annotationAttributeNames)) continue;
            ElementValue elementValue = elementValuePair.getValue();
            if (!(elementValue instanceof ArrayElementValue)) {
                throw new JavaCGRuntimeException("\u6ce8\u89e3\u5c5e\u6027\u7c7b\u578b\u4e0d\u7b26\u5408\u9884\u671f " + elementValuePair.getNameString() + " " + elementValue.getClass().getName());
            }
            ArrayElementValue arrayElementValue = (ArrayElementValue)elementValue;
            for (ElementValue elementValueOfArray : arrayElementValue.getElementValuesArray()) {
                if (!(elementValueOfArray instanceof SimpleElementValue)) {
                    throw new JavaCGRuntimeException("\u6ce8\u89e3\u5c5e\u6027\u7c7b\u578b\u4e0d\u7b26\u5408\u9884\u671f " + elementValuePair.getNameString() + " " + elementValue.getClass().getName());
                }
                SimpleElementValue simpleElementValue = (SimpleElementValue)elementValueOfArray;
                stringList.add(simpleElementValue.toString());
            }
            return stringList;
        }
        return stringList;
    }

    public static void writeAnnotationInfo(Writer writer, AnnotationEntry[] annotationEntries, AnnotationAttributesFormatterInterface annotationAttributesFormatter, String ... objectInfo) {
        if (annotationEntries == null || annotationEntries.length == 0) {
            return;
        }
        String objectInfoStr = JavaCGFileUtil.appendFileColumn(objectInfo);
        try {
            for (AnnotationEntry annotationEntry : annotationEntries) {
                String annotationClassName = Utility.typeSignatureToString((String)annotationEntry.getAnnotationType(), (boolean)false);
                if (annotationEntry.getElementValuePairs() == null || annotationEntry.getElementValuePairs().length == 0) {
                    JavaCGFileUtil.write2FileWithTab(writer, objectInfoStr, annotationClassName);
                    continue;
                }
                for (ElementValuePair elementValuePair : annotationEntry.getElementValuePairs()) {
                    String formattedValue = annotationAttributesFormatter.format(elementValuePair);
                    JavaCGFileUtil.write2FileWithTab(writer, objectInfoStr, annotationClassName, elementValuePair.getNameString(), formattedValue);
                }
            }
        }
        catch (Exception e) {
            logger.error("error ", (Throwable)e);
        }
    }

    private JavaCGAnnotationUtil() {
        throw new IllegalStateException("illegal");
    }
}

