/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.util;

import com.adrninistrator.javacg.dto.method.JavaCGMethodInfo;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.BootstrapMethod;
import org.apache.bcel.classfile.BootstrapMethods;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantMethodHandle;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaCGBootstrapMethodUtil {
    private static final Logger logger = LoggerFactory.getLogger(JavaCGBootstrapMethodUtil.class);

    public static BootstrapMethod getBootstrapMethod(JavaClass javaClass, int index) {
        for (Attribute attribute : javaClass.getAttributes()) {
            BootstrapMethods bootstrapMethods;
            BootstrapMethod[] bootstrapMethodArray;
            if (!(attribute instanceof BootstrapMethods) || (bootstrapMethodArray = (bootstrapMethods = (BootstrapMethods)attribute).getBootstrapMethods()) == null || bootstrapMethodArray.length <= index) continue;
            return bootstrapMethodArray[index];
        }
        return null;
    }

    public static JavaCGMethodInfo getBootstrapMethodInfo(BootstrapMethod bootstrapMethod, JavaClass javaClass) {
        for (int argIndex : bootstrapMethod.getBootstrapArguments()) {
            JavaCGMethodInfo javaCGMethodInfo;
            Constant constantArg = javaClass.getConstantPool().getConstant(argIndex);
            if (!(constantArg instanceof ConstantMethodHandle) || (javaCGMethodInfo = JavaCGBootstrapMethodUtil.getMethodFromConstantMethodHandle((ConstantMethodHandle)constantArg, javaClass)) == null) continue;
            return javaCGMethodInfo;
        }
        return null;
    }

    public static JavaCGMethodInfo getMethodFromConstantMethodHandle(ConstantMethodHandle constantMethodHandle, JavaClass javaClass) {
        ConstantPool constantPool = javaClass.getConstantPool();
        Constant constantCP = constantPool.getConstant(constantMethodHandle.getReferenceIndex());
        if (!(constantCP instanceof ConstantCP)) {
            logger.error("\u4e0d\u6ee1\u8db3instanceof ConstantCP {}", (Object)constantCP.getClass().getName());
            return null;
        }
        if (constantCP instanceof ConstantFieldref) {
            return null;
        }
        ConstantCP constantClassAndMethod = (ConstantCP)constantCP;
        String className = constantPool.getConstantString(constantClassAndMethod.getClassIndex(), (byte)7);
        className = Utility.compactClassName((String)className, (boolean)false);
        Constant constantNAT = constantPool.getConstant(constantClassAndMethod.getNameAndTypeIndex());
        if (!(constantNAT instanceof ConstantNameAndType)) {
            logger.error("\u4e0d\u6ee1\u8db3instanceof ConstantNameAndType {}", (Object)constantNAT.getClass().getName());
            return null;
        }
        ConstantNameAndType constantNameAndType = (ConstantNameAndType)constantNAT;
        String methodName = constantPool.constantToString(constantNameAndType.getNameIndex(), (byte)1);
        String methodArgsReturn = constantPool.constantToString(constantNameAndType.getSignatureIndex(), (byte)1);
        if (methodName != null && methodArgsReturn != null) {
            try {
                Type[] methodArgTypes = Type.getArgumentTypes((String)methodArgsReturn);
                Type returnType = Type.getReturnType((String)methodArgsReturn);
                return new JavaCGMethodInfo(className, methodName, methodArgTypes, returnType);
            }
            catch (ClassFormatException e) {
                logger.error("\u65b9\u6cd5\u53c2\u6570\u4e0e\u8fd4\u56de\u7c7b\u578b\u4e0d\u7b26\u5408\u9884\u671f\uff0c\u4e0d\u5904\u7406 {} {}", (Object)methodArgsReturn, (Object)constantClassAndMethod.getClass().getName());
                return null;
            }
        }
        logger.error("\u83b7\u53d6\u65b9\u6cd5\u4fe1\u606f\u5931\u8d25 {} {} {} {}", new Object[]{javaClass.getClassName(), className, methodName, methodArgsReturn});
        return null;
    }

    private JavaCGBootstrapMethodUtil() {
        throw new IllegalStateException("illegal");
    }
}

