/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.util;

import com.adrninistrator.javacg.common.TypeConstants;
import com.adrninistrator.javacg.common.enums.JavaCGConstantTypeEnum;
import com.adrninistrator.javacg.dto.classes.InnerClassInfo;
import com.adrninistrator.javacg.dto.method.MethodArgReturnTypes;
import com.adrninistrator.javacg.util.JavaCGClassMethodUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.bcel.classfile.AccessFlags;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.InnerClass;
import org.apache.bcel.classfile.InnerClasses;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Signature;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.MethodGen;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaCGByteCodeUtil {
    private static final Logger logger = LoggerFactory.getLogger(JavaCGByteCodeUtil.class);

    public static boolean checkExtendsMethod(String methodName, AccessFlags accessFlags) {
        return !methodName.startsWith("<") && !accessFlags.isStatic() && (accessFlags.isAbstract() || accessFlags.isPublic() || accessFlags.isProtected() || !accessFlags.isPrivate());
    }

    public static boolean checkImplMethod(String methodName, AccessFlags accessFlags) {
        return !methodName.startsWith("<") && !accessFlags.isStatic() && !accessFlags.isAbstract() && accessFlags.isPublic();
    }

    public static Map<MethodArgReturnTypes, Integer> genExtendsClassMethodWithArgTypes(Method[] methods) {
        HashMap<MethodArgReturnTypes, Integer> methodArgReturnTypesMap = new HashMap<MethodArgReturnTypes, Integer>();
        for (Method method : methods) {
            String methodName = method.getName();
            if (!JavaCGByteCodeUtil.checkExtendsMethod(methodName, (AccessFlags)method)) continue;
            MethodArgReturnTypes methodArgReturnTypes = new MethodArgReturnTypes(methodName, method.getArgumentTypes(), method.getReturnType());
            methodArgReturnTypesMap.put(methodArgReturnTypes, method.getAccessFlags());
        }
        return methodArgReturnTypesMap;
    }

    public static Map<MethodArgReturnTypes, Integer> genImplClassMethodWithArgTypes(Method[] methods) {
        HashMap<MethodArgReturnTypes, Integer> methodInfoMap = new HashMap<MethodArgReturnTypes, Integer>(methods.length);
        for (Method method : methods) {
            String methodName = method.getName();
            if (!JavaCGByteCodeUtil.checkImplMethod(methodName, (AccessFlags)method)) continue;
            methodInfoMap.put(new MethodArgReturnTypes(methodName, method.getArgumentTypes(), method.getReturnType()), method.getAccessFlags());
        }
        return methodInfoMap;
    }

    public static Map<MethodArgReturnTypes, Integer> genInterfaceMethodWithArgTypes(Method[] methods) {
        HashMap<MethodArgReturnTypes, Integer> methodInfoMap = new HashMap<MethodArgReturnTypes, Integer>(methods.length);
        for (Method method : methods) {
            methodInfoMap.put(new MethodArgReturnTypes(method.getName(), method.getArgumentTypes(), method.getReturnType()), method.getAccessFlags());
        }
        return methodInfoMap;
    }

    public static int getFuncStartSourceLine(Method method) {
        LineNumberTable lineNumberTable = method.getLineNumberTable();
        if (lineNumberTable == null || lineNumberTable.getLineNumberTable() == null) {
            return 0;
        }
        return lineNumberTable.getLineNumberTable()[0].getLineNumber();
    }

    public static int getInitFuncStartSourceLine(JavaClass javaClass) {
        Method[] methods = javaClass.getMethods();
        if (methods == null) {
            return 0;
        }
        for (Method method : methods) {
            if (!JavaCGClassMethodUtil.isInitMethod(method.getName())) continue;
            return JavaCGByteCodeUtil.getFuncStartSourceLine(method);
        }
        return 0;
    }

    public static String removeArrayInClassName(String className) {
        if (!className.startsWith("[")) {
            return className;
        }
        String tmpClassName = Utility.typeSignatureToString((String)className, (boolean)false);
        return JavaCGByteCodeUtil.removeArrayFlag(tmpClassName);
    }

    public static String addArrayFlag(String className) {
        return className + "[]";
    }

    public static String removeArrayFlag(String arrayType) {
        if (arrayType == null) {
            return null;
        }
        if (!JavaCGByteCodeUtil.isArrayType(arrayType) && !JavaCGByteCodeUtil.isNullType(arrayType)) {
            logger.error("\u7c7b\u540d\u4e0d\u662f\u6570\u7ec4\u5f62\u5f0f {}", (Object)arrayType);
            return arrayType;
        }
        return arrayType.substring(0, arrayType.length() - "[]".length());
    }

    public static String removeAllArrayFlag(String type) {
        return StringUtils.replace((String)type, (String)"[]", (String)"");
    }

    public static boolean isArrayType(String type) {
        return type.endsWith("[]");
    }

    public static int getTypeSize(String typeString) {
        if (JavaCGConstantTypeEnum.CONSTTE_DOUBLE.getType().equals(typeString) || JavaCGConstantTypeEnum.CONSTTE_LONG.getType().equals(typeString)) {
            return 2;
        }
        return 1;
    }

    public static boolean checkCompatibleWithInt(String type) {
        for (String compatibleType : TypeConstants.COMPATIBLE_INT_TYPES) {
            if (!compatibleType.equals(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNullType(String type) {
        return type == null || JavaCGConstantTypeEnum.CONSTTE_NULL.getType().equals(type);
    }

    public static boolean compareType(String type1, String type2) {
        if (type1.equals(type2)) {
            return true;
        }
        if (JavaCGByteCodeUtil.compareIntType(type1, type2)) {
            return true;
        }
        return JavaCGByteCodeUtil.compareByteBooleanType(type1, type2);
    }

    public static boolean compareIntType(String type1, String type2) {
        if (JavaCGConstantTypeEnum.CONSTTE_INT.getType().equals(type1) && JavaCGByteCodeUtil.checkCompatibleWithInt(type2)) {
            return true;
        }
        return JavaCGConstantTypeEnum.CONSTTE_INT.getType().equals(type2) && JavaCGByteCodeUtil.checkCompatibleWithInt(type1);
    }

    public static boolean compareByteBooleanType(String type1, String type2) {
        if (JavaCGConstantTypeEnum.CONSTTE_BYTE.getType().equals(type1) && JavaCGConstantTypeEnum.CONSTTE_BOOLEAN.getType().equals(type2)) {
            return true;
        }
        if (JavaCGConstantTypeEnum.CONSTTE_BYTE.getType().equals(type2) && JavaCGConstantTypeEnum.CONSTTE_BOOLEAN.getType().equals(type1)) {
            return true;
        }
        if (TypeConstants.BYTE_ARRAY_TYPE.equals(type1) && TypeConstants.BOOLEAN_ARRAY_TYPE.equals(type2)) {
            return true;
        }
        return TypeConstants.BYTE_ARRAY_TYPE.equals(type2) && TypeConstants.BOOLEAN_ARRAY_TYPE.equals(type1);
    }

    public static boolean isPublicFlag(int accessFlags) {
        return (accessFlags & 1) != 0;
    }

    public static boolean isProtectedMethod(int accessFlags) {
        return (accessFlags & 4) != 0;
    }

    public static boolean isPrivateMethod(int accessFlags) {
        return (accessFlags & 2) != 0;
    }

    public static boolean isAbstractFlag(int accessFlags) {
        return (accessFlags & 0x400) != 0;
    }

    public static boolean isInterfaceFlag(int accessFlags) {
        return (accessFlags & 0x200) != 0;
    }

    public static boolean isBridgeFlag(int accessFlags) {
        return (accessFlags & 0x40) != 0;
    }

    public static boolean isEnumFlag(int accessFlags) {
        return (accessFlags & 0x4000) != 0;
    }

    public static int setPublicFlag(int accessFlags, boolean trueOrFalse) {
        return JavaCGByteCodeUtil.setFlag(accessFlags, 1, trueOrFalse);
    }

    public static int setProtectedFlag(int accessFlags, boolean trueOrFalse) {
        return JavaCGByteCodeUtil.setFlag(accessFlags, 4, trueOrFalse);
    }

    public static int setAbstractFlag(int accessFlags, boolean trueOrFalse) {
        return JavaCGByteCodeUtil.setFlag(accessFlags, 1024, trueOrFalse);
    }

    private static int setFlag(int accessFlags, int flag, boolean trueOrFalse) {
        if ((accessFlags & flag) != 0) {
            if (!trueOrFalse) {
                accessFlags ^= flag;
            }
        } else if (trueOrFalse) {
            accessFlags |= flag;
        }
        return accessFlags;
    }

    public static String getModifiersString(int accessFlags) {
        if (JavaCGByteCodeUtil.isPublicFlag(accessFlags)) {
            return "public";
        }
        if (JavaCGByteCodeUtil.isProtectedMethod(accessFlags)) {
            return "protected";
        }
        if (JavaCGByteCodeUtil.isPrivateMethod(accessFlags)) {
            return "private";
        }
        return "default";
    }

    public static Signature getSignatureOfClass(JavaClass javaClass) {
        for (Attribute attribute : javaClass.getAttributes()) {
            if (!(attribute instanceof Signature)) continue;
            return (Signature)attribute;
        }
        return null;
    }

    public static boolean checkInnerAnonymousClass(JavaClass javaClass) {
        if (!JavaCGClassMethodUtil.isInnerAnonymousClass(javaClass.getClassName())) {
            return false;
        }
        for (Attribute attribute : javaClass.getAttributes()) {
            if (!(attribute instanceof InnerClasses)) continue;
            InnerClasses innerClasses = (InnerClasses)attribute;
            for (InnerClass innerClass : innerClasses.getInnerClasses()) {
                int innerClassIndex = innerClass.getInnerClassIndex();
                if (innerClassIndex != javaClass.getClassNameIndex()) continue;
                return true;
            }
        }
        return false;
    }

    public static List<InnerClassInfo> getInnerClassInfo(JavaClass javaClass) {
        ArrayList<InnerClassInfo> innerClassInfoList = new ArrayList<InnerClassInfo>(0);
        String className = javaClass.getClassName();
        ConstantPool constantPool = javaClass.getConstantPool();
        for (Attribute attribute : javaClass.getAttributes()) {
            if (!(attribute instanceof InnerClasses)) continue;
            InnerClasses innerClasses = (InnerClasses)attribute;
            for (InnerClass innerClass : innerClasses.getInnerClasses()) {
                int innerClassIndex = innerClass.getInnerClassIndex();
                if (innerClassIndex == javaClass.getClassNameIndex()) continue;
                String innerClassName = constantPool.getConstantString(innerClassIndex, (byte)7);
                if (JavaCGClassMethodUtil.isClassInJdk(innerClassName = Utility.compactClassName((String)innerClassName, (boolean)false)) || !innerClassName.startsWith(className) || StringUtils.countMatches((CharSequence)innerClassName, (char)'$') < StringUtils.countMatches((CharSequence)className, (char)'$')) continue;
                InnerClassInfo innerClassInfo = new InnerClassInfo(innerClassName, className, JavaCGClassMethodUtil.isInnerAnonymousClass(innerClassName));
                innerClassInfoList.add(innerClassInfo);
            }
        }
        return innerClassInfoList;
    }

    public static int getArgIndexInMethod(MethodGen mg, int variableIndex) {
        int argIndex = variableIndex - (mg.isStatic() ? 0 : 1);
        return argIndex < mg.getArgumentTypes().length ? argIndex : -1;
    }

    public static int getLocalVariableTableIndex(MethodGen mg, int argIndex) {
        return argIndex + (mg.isStatic() ? 0 : 1);
    }

    private JavaCGByteCodeUtil() {
        throw new IllegalStateException("illegal");
    }
}

