/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.util;

import com.adrninistrator.javacg.common.JavaCGCommonNameConstants;
import com.adrninistrator.javacg.common.enums.JavaCGConstantTypeEnum;
import com.adrninistrator.javacg.dto.classes.ClassExtendsInfo;
import com.adrninistrator.javacg.dto.method.JavaCGMethodInfo;
import com.adrninistrator.javacg.dto.method.MethodArgReturnTypes;
import com.adrninistrator.javacg.exceptions.JavaCGRuntimeException;
import com.adrninistrator.javacg.util.JavaCGByteCodeUtil;
import com.adrninistrator.javacg.util.JavaCGUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Type;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class JavaCGClassMethodUtil {
    public static String formatFullMethod(JavaCGMethodInfo javaCGMethodInfo) {
        return JavaCGClassMethodUtil.formatFullMethod(javaCGMethodInfo.getClassName(), javaCGMethodInfo.getMethodName(), javaCGMethodInfo.getMethodArgumentTypes());
    }

    public static String formatFullMethod(MethodGen mg) {
        return JavaCGClassMethodUtil.formatFullMethod(mg.getClassName(), mg.getName(), mg.getArgumentTypes());
    }

    public static String formatFullMethodNoArgs(String className, String methodName) {
        return JavaCGClassMethodUtil.formatFullMethod(className, methodName, "()");
    }

    public static String formatFullMethod(String className, String methodName, Type[] argTypes) {
        return JavaCGClassMethodUtil.formatFullMethod(className, methodName, JavaCGClassMethodUtil.getArgTypeStr(argTypes));
    }

    public static String formatFullMethod(String className, String methodName, String argTypes) {
        return className + ":" + methodName + argTypes;
    }

    public static String formatFullMethod(String className, String methodName, Class<?> ... argTypes) {
        return JavaCGClassMethodUtil.formatFullMethodWithArgTypes(className, JavaCGClassMethodUtil.formatMethodWithArgTypes(methodName, argTypes));
    }

    public static String formatFullMethodStr(String className, String methodName, String ... argTypes) {
        return JavaCGClassMethodUtil.formatFullMethodWithArgTypes(className, JavaCGClassMethodUtil.formatMethodWithArgTypesStr(methodName, argTypes));
    }

    public static String getArgTypeStr(Type[] argTypes) {
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < argTypes.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(argTypes[i].toString());
        }
        sb.append(")");
        return sb.toString();
    }

    public static String formatFullMethodWithArgTypes(String className, String methodNameAndArgs) {
        return className + ":" + methodNameAndArgs;
    }

    public static String formatMethodWithArgTypes(String methodName, Class<?> ... argTypes) {
        StringBuilder sb = new StringBuilder(methodName).append("(");
        for (int i = 0; i < argTypes.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(argTypes[i].getName());
        }
        sb.append(")");
        return sb.toString();
    }

    public static String formatMethodWithArgTypesStr(String methodName, String ... argTypes) {
        if (ArrayUtils.isEmpty((Object[])argTypes)) {
            return methodName + "()";
        }
        StringBuilder sb = new StringBuilder(methodName).append("(");
        for (int i = 0; i < argTypes.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(argTypes[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    public static String genClassAndField(String className, String fieldName) {
        return className + "@" + fieldName;
    }

    public static String getFirstLetterLowerClassName(String simpleClassName) {
        if (simpleClassName == null) {
            return null;
        }
        if (simpleClassName.isEmpty()) {
            return "";
        }
        String firstLetterLower = simpleClassName.substring(0, 1).toLowerCase();
        if (simpleClassName.length() == 1) {
            return firstLetterLower;
        }
        return firstLetterLower + simpleClassName.substring(1);
    }

    public static String getSimpleClassNameFromFull(String className) {
        return JavaCGUtil.getSubStringAfterLast(className, ".");
    }

    public static boolean isChildOf(String childClassName, String superClassName, Map<String, ClassExtendsInfo> classExtendsInfoMap) {
        if (childClassName == null || superClassName == null || classExtendsInfoMap == null) {
            throw new JavaCGRuntimeException("\u4f20\u5165\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        String currentClassName = childClassName;
        ClassExtendsInfo classExtendsInfo;
        while ((classExtendsInfo = classExtendsInfoMap.get(currentClassName)) != null) {
            if (superClassName.equals(classExtendsInfo.getSuperClassName())) {
                return true;
            }
            currentClassName = classExtendsInfo.getSuperClassName();
        }
        return false;
    }

    public static boolean isImplementationOf(String className, String interfaceName, Map<String, ClassExtendsInfo> classExtendsInfoMap, Map<String, List<String>> classImplementsInfoMap, Map<String, List<String>> interfaceExtendsInfoMap) {
        if (className == null || interfaceName == null || classExtendsInfoMap == null || classImplementsInfoMap == null || interfaceExtendsInfoMap == null) {
            throw new JavaCGRuntimeException("\u4f20\u5165\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        String currentClassName = className;
        while (true) {
            ClassExtendsInfo classExtendsInfo;
            List<String> interfaceNameList;
            if ((interfaceNameList = classImplementsInfoMap.get(currentClassName)) != null) {
                if (interfaceNameList.contains(interfaceName)) {
                    return true;
                }
                for (String currentInterfaceName : interfaceNameList) {
                    if (!JavaCGClassMethodUtil.isSuperInterfaceOf(currentInterfaceName, interfaceName, interfaceExtendsInfoMap)) continue;
                    return true;
                }
            }
            if ((classExtendsInfo = classExtendsInfoMap.get(currentClassName)) == null) {
                return false;
            }
            currentClassName = classExtendsInfo.getSuperClassName();
        }
    }

    public static boolean isSuperInterfaceOf(String childInterfaceName, String superInterfaceName, Map<String, List<String>> interfaceExtendsInfoMap) {
        if (childInterfaceName == null || superInterfaceName == null || interfaceExtendsInfoMap == null) {
            throw new JavaCGRuntimeException("\u4f20\u5165\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        List<String> superInterfaceList = interfaceExtendsInfoMap.get(childInterfaceName);
        if (JavaCGUtil.isCollectionEmpty(superInterfaceList)) {
            return false;
        }
        if (superInterfaceList.contains(superInterfaceName)) {
            return true;
        }
        for (String currentSuperInterfaceName : superInterfaceList) {
            if (!JavaCGClassMethodUtil.isSuperInterfaceOf(currentSuperInterfaceName, superInterfaceName, interfaceExtendsInfoMap)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInitMethod(String methodName) {
        return "<init>".equals(methodName);
    }

    public static boolean isObjectClass(String className) {
        return JavaCGCommonNameConstants.CLASS_NAME_OBJECT.equals(className);
    }

    public static boolean isClassInJdk(String className) {
        return StringUtils.startsWith((CharSequence)className, (CharSequence)"java.");
    }

    public static boolean isCustomType(String type) {
        String typeWithoutArray = JavaCGByteCodeUtil.removeAllArrayFlag(type);
        return !JavaCGClassMethodUtil.isClassInJdk(typeWithoutArray) && !JavaCGConstantTypeEnum.isConstantType(typeWithoutArray);
    }

    public static String getPackageName(String className) {
        return StringUtils.substringBeforeLast((String)className, (String)".");
    }

    public static boolean checkSamePackage(String className1, String className2) {
        return StringUtils.equals((CharSequence)JavaCGClassMethodUtil.getPackageName(className1), (CharSequence)JavaCGClassMethodUtil.getPackageName(className2));
    }

    public static boolean isInnerClass(String className) {
        return StringUtils.contains((CharSequence)JavaCGClassMethodUtil.getSimpleClassNameFromFull(className), (CharSequence)"$");
    }

    public static boolean isInnerAnonymousClass(String className) {
        String tail = StringUtils.substringAfterLast((String)className, (String)"$");
        return JavaCGUtil.isNumStr(tail);
    }

    public static boolean matchesGetMethod(String methodName) {
        return StringUtils.startsWithAny((CharSequence)methodName, (CharSequence[])new CharSequence[]{"get", "is"});
    }

    public static boolean matchesSetMethod(String methodName) {
        return methodName.startsWith("set");
    }

    public static void copyClassMethodMap(Map<String, Map<MethodArgReturnTypes, Integer>> classMethodMap, String className, Map<MethodArgReturnTypes, Integer> methodArgReturnTypesMap) {
        if (JavaCGUtil.isMapEmpty(methodArgReturnTypesMap)) {
            return;
        }
        Map existedMethodMap = classMethodMap.computeIfAbsent(className, k -> new HashMap());
        for (Map.Entry<MethodArgReturnTypes, Integer> entry : methodArgReturnTypesMap.entrySet()) {
            existedMethodMap.putIfAbsent(entry.getKey(), entry.getValue());
        }
    }

    private JavaCGClassMethodUtil() {
        throw new IllegalStateException("illegal");
    }
}

