/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.util;

import com.adrninistrator.javacg.common.JavaCGCommonNameConstants;
import com.adrninistrator.javacg.common.enums.JavaCGCalleeObjTypeEnum;
import com.adrninistrator.javacg.dto.element.BaseElement;
import com.adrninistrator.javacg.dto.element.variable.FieldElement;
import com.adrninistrator.javacg.dto.element.variable.LocalVariableElement;
import com.adrninistrator.javacg.dto.element.variable.StaticFieldElement;
import com.adrninistrator.javacg.dto.element.variable.VariableElement;
import com.adrninistrator.javacg.dto.variabledatasource.AbstractVariableDataSource;
import com.adrninistrator.javacg.dto.variabledatasource.VariableDataSourceArithmeticOperation;
import com.adrninistrator.javacg.dto.variabledatasource.VariableDataSourceMethodArg;
import com.adrninistrator.javacg.dto.variabledatasource.VariableDataSourceMethodCallReturn;
import com.adrninistrator.javacg.util.JavaCGByteCodeUtil;
import com.adrninistrator.javacg.util.JavaCGClassMethodUtil;
import org.apache.commons.lang3.StringUtils;

public class JavaCGElementUtil {
    public static String getElementType(BaseElement baseElement) {
        if (baseElement == null) {
            return null;
        }
        return baseElement.getType();
    }

    public static boolean compare(BaseElement existed, BaseElement added) {
        AbstractVariableDataSource addedVariableDataSource;
        AbstractVariableDataSource existedVariableDataSource;
        String addedClassName;
        String addedType = added.getType();
        if (JavaCGByteCodeUtil.isNullType(addedType)) {
            return true;
        }
        String existedClassName = existed.getClass().getName();
        if (!existedClassName.equals(addedClassName = added.getClass().getName())) {
            return false;
        }
        String existedType = existed.getType();
        if (JavaCGByteCodeUtil.isNullType(existedType) || !JavaCGByteCodeUtil.compareType(addedType, existedType)) {
            return false;
        }
        Object addedValue = added.getValue();
        if (addedValue != null && !addedValue.equals(existed.getValue())) {
            return false;
        }
        if (existed instanceof VariableElement && added instanceof VariableElement && !JavaCGElementUtil.compareVariableDataSource(existedVariableDataSource = ((VariableElement)existed).getVariableDataSource(), addedVariableDataSource = ((VariableElement)added).getVariableDataSource())) {
            return false;
        }
        if (existed instanceof LocalVariableElement && added instanceof LocalVariableElement) {
            LocalVariableElement existedLocalVariableElement = (LocalVariableElement)existed;
            LocalVariableElement addedLocalVariableElement = (LocalVariableElement)added;
            if (addedLocalVariableElement.getName() != null && !StringUtils.equals((CharSequence)existedLocalVariableElement.getName(), (CharSequence)addedLocalVariableElement.getName())) {
                return false;
            }
        }
        if (existed instanceof FieldElement && added instanceof FieldElement) {
            FieldElement existedFieldElement = (FieldElement)existed;
            FieldElement addedFieldElement = (FieldElement)added;
            if (!StringUtils.equals((CharSequence)existedFieldElement.getClassName(), (CharSequence)addedFieldElement.getClassName())) {
                return false;
            }
        }
        return true;
    }

    public static String getVariableClassNameOrThis(VariableElement variableElement) {
        if (variableElement instanceof LocalVariableElement && ((LocalVariableElement)variableElement).isThis()) {
            return "this";
        }
        return variableElement.getType();
    }

    public static boolean compareVariableDataSource(AbstractVariableDataSource existed, AbstractVariableDataSource added) {
        String addedType;
        if (added == null) {
            return true;
        }
        if (existed == null) {
            return false;
        }
        String existedType = existed.getClass().getName();
        if (!existedType.equals(addedType = added.getClass().getName())) {
            return false;
        }
        if (existed instanceof VariableDataSourceArithmeticOperation) {
            VariableDataSourceArithmeticOperation existedVariableDataSourceArithmeticOperation = (VariableDataSourceArithmeticOperation)existed;
            VariableDataSourceArithmeticOperation addedVariableDataSourceArithmeticOperation = (VariableDataSourceArithmeticOperation)added;
            return existedVariableDataSourceArithmeticOperation.compare(addedVariableDataSourceArithmeticOperation);
        }
        if (existed instanceof VariableDataSourceMethodArg) {
            VariableDataSourceMethodArg existedVariableDataSourceMethodArg = (VariableDataSourceMethodArg)existed;
            VariableDataSourceMethodArg addedVariableDataSourceMethodArg = (VariableDataSourceMethodArg)added;
            return existedVariableDataSourceMethodArg.compare(addedVariableDataSourceMethodArg);
        }
        if (existed instanceof VariableDataSourceMethodCallReturn) {
            VariableDataSourceMethodCallReturn existedVariableDataSourceMethodCallReturn = (VariableDataSourceMethodCallReturn)existed;
            VariableDataSourceMethodCallReturn addedVariableDataSourceMethodCallReturn = (VariableDataSourceMethodCallReturn)added;
            return existedVariableDataSourceMethodCallReturn.compare(addedVariableDataSourceMethodCallReturn);
        }
        return true;
    }

    public static JavaCGCalleeObjTypeEnum getCalleeObjTypeEnum(BaseElement objectElement) {
        LocalVariableElement objLocalVariableElement;
        if (objectElement instanceof StaticFieldElement) {
            return JavaCGCalleeObjTypeEnum.COTE_STATIC_FIELD;
        }
        if (objectElement instanceof FieldElement) {
            return JavaCGCalleeObjTypeEnum.COTE_FIELD;
        }
        if (objectElement instanceof LocalVariableElement && (objLocalVariableElement = (LocalVariableElement)objectElement).isThis()) {
            return JavaCGCalleeObjTypeEnum.COTE_THIS;
        }
        if (objectElement instanceof VariableElement) {
            return JavaCGCalleeObjTypeEnum.COTE_VARIABLE;
        }
        return null;
    }

    public static boolean checkElementDataSourceGetArg(BaseElement baseElement) {
        if (!(baseElement instanceof VariableElement)) {
            return false;
        }
        VariableElement variableElement = (VariableElement)baseElement;
        return variableElement.getVariableDataSource() instanceof VariableDataSourceMethodArg;
    }

    public static boolean checkDataSourceMethodReturnGetMethod(VariableDataSourceMethodCallReturn variableDataSourceMethodCallReturn) {
        return !JavaCGCommonNameConstants.SIMPLE_CLASS_NAME_INVOKE_STATIC.equals(variableDataSourceMethodCallReturn.getInvokeInstructionType()) && JavaCGClassMethodUtil.matchesGetMethod(variableDataSourceMethodCallReturn.getCalleeMethodName()) && "()".equals(variableDataSourceMethodCallReturn.getCalleeArgTypeStr());
    }

    private JavaCGElementUtil() {
        throw new IllegalStateException("illegal");
    }
}

