/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.util;

import com.adrninistrator.javacg.exceptions.JavaCGRuntimeException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaCGFileUtil {
    private static final Logger logger = LoggerFactory.getLogger(JavaCGFileUtil.class);

    public static String getCanonicalPath(String filePath) {
        return JavaCGFileUtil.getCanonicalPath(new File(filePath));
    }

    public static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            logger.error("error ", (Throwable)e);
            return null;
        }
    }

    public static boolean deleteFile(File file) {
        try {
            Files.delete(file.toPath());
            return true;
        }
        catch (IOException e) {
            logger.error("error ", (Throwable)e);
            return false;
        }
    }

    public static String appendFileColumn(String ... data) {
        return StringUtils.join((Object[])data, (String)"\t");
    }

    public static void write2FileWithTab(Writer writer, String ... data) throws IOException {
        writer.write(JavaCGFileUtil.appendFileColumn(data) + "\n");
    }

    public static void write2FileNoLF(Writer writer, String data) throws IOException {
        writer.write(data);
    }

    public static boolean isClassFile(String fileName) {
        if (fileName == null) {
            return false;
        }
        return fileName.toLowerCase().endsWith(".class");
    }

    public static boolean isDirectoryExists(String dirPath) {
        return JavaCGFileUtil.isDirectoryExists(new File(dirPath), true);
    }

    public static boolean isDirectoryExists(String dirPath, boolean tryMake) {
        return JavaCGFileUtil.isDirectoryExists(new File(dirPath), tryMake);
    }

    public static boolean isDirectoryExists(File dirFile) {
        return JavaCGFileUtil.isDirectoryExists(dirFile, true);
    }

    public static boolean isDirectoryExists(File dirFile, boolean tryMake) {
        if (dirFile.exists()) {
            if (dirFile.isDirectory()) {
                logger.debug("\u76ee\u5f55\u5df2\u5b58\u5728: {}", (Object)dirFile.getAbsolutePath());
                return true;
            }
            logger.error("\u5df2\u5b58\u5728\u540c\u540d\u6587\u4ef6: {}", (Object)dirFile.getAbsolutePath());
            return false;
        }
        if (!tryMake) {
            logger.info("\u76ee\u5f55\u4e0d\u5b58\u5728 {}", (Object)dirFile.getAbsolutePath());
            return false;
        }
        try {
            Files.createDirectories(dirFile.toPath(), new FileAttribute[0]);
            logger.info("\u521b\u5efa\u76ee\u5f55: {}", (Object)dirFile.getAbsolutePath());
            return true;
        }
        catch (FileAlreadyExistsException e) {
            logger.warn("\u5c1d\u8bd5\u521b\u5efa\u76ee\u5f55\u4f46\u5df2\u5b58\u5728: {}", (Object)dirFile.getAbsolutePath());
            return true;
        }
        catch (IOException e) {
            logger.error("error {} ", (Object)dirFile.getAbsolutePath(), (Object)e);
            return false;
        }
    }

    public static BufferedWriter genBufferedWriter(String filePath) throws FileNotFoundException {
        return JavaCGFileUtil.genBufferedWriter(filePath, false);
    }

    public static BufferedWriter genBufferedWriter(String filePath, boolean append) throws FileNotFoundException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath, append), StandardCharsets.UTF_8));
    }

    public static File findFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            logger.info("\u901a\u8fc7\u6587\u4ef6\u8def\u5f84\u83b7\u53d6\u6587\u4ef6 {}", (Object)filePath);
            return file;
        }
        URL url = JavaCGFileUtil.class.getResource("/" + filePath);
        if (url != null && "file".equals(url.getProtocol())) {
            logger.info("\u4ececlasspath\u4e2d\u83b7\u53d6\u6587\u4ef6 {}", (Object)url);
            try {
                return new File(url.toURI());
            }
            catch (Exception e) {
                logger.error("error ", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static InputStream getFileInputStream(String filePath) throws FileNotFoundException {
        File file = JavaCGFileUtil.findFile(filePath);
        if (file != null) {
            return new FileInputStream(file);
        }
        InputStream inputStream = JavaCGFileUtil.class.getResourceAsStream("/" + filePath);
        if (inputStream == null) {
            logger.error("\u672a\u627e\u5230\u6587\u4ef6 {}", (Object)filePath);
            throw new JavaCGRuntimeException("\u672a\u627e\u5230\u6587\u4ef6 " + filePath);
        }
        logger.info("\u4ecejar\u5305\u4e2d\u83b7\u53d6\u6587\u4ef6 {}", (Object)JavaCGFileUtil.class.getResource("/" + filePath));
        return inputStream;
    }

    public static Set<String> readFile2Set(String filePath) {
        return JavaCGFileUtil.readFile2Set(filePath, "#");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<String> readFile2Set(String filePath, String ignorePrefix) {
        try (BufferedReader br = JavaCGFileUtil.genBufferedReader(JavaCGFileUtil.getFileInputStream(filePath));){
            String line;
            HashSet<String> set = new HashSet<String>();
            boolean checkIgnore = StringUtils.isNotBlank((CharSequence)ignorePrefix);
            while ((line = br.readLine()) != null) {
                if (!StringUtils.isNotBlank((CharSequence)line) || checkIgnore && line.startsWith(ignorePrefix)) continue;
                set.add(line);
            }
            HashSet<String> hashSet = set;
            return hashSet;
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38 {} ", (Object)filePath, (Object)e);
            return null;
        }
    }

    public static List<String> readFile2List(String filePath) {
        return JavaCGFileUtil.readFile2List(filePath, "#");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readFile2List(String filePath, String ignorePrefix) {
        try (BufferedReader br = JavaCGFileUtil.genBufferedReader(JavaCGFileUtil.getFileInputStream(filePath));){
            String line;
            ArrayList<String> list = new ArrayList<String>();
            boolean checkIgnore = StringUtils.isNotBlank((CharSequence)ignorePrefix);
            while ((line = br.readLine()) != null) {
                if (!StringUtils.isNotBlank((CharSequence)line) || checkIgnore && line.startsWith(ignorePrefix)) continue;
                list.add(line);
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38 {} ", (Object)filePath, (Object)e);
            return null;
        }
    }

    public static BufferedReader genBufferedReader(String filePath) throws FileNotFoundException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), StandardCharsets.UTF_8));
    }

    public static BufferedReader genBufferedReader(File file) throws FileNotFoundException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
    }

    public static BufferedReader genBufferedReader(InputStream input) {
        return new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
    }

    private JavaCGFileUtil() {
        throw new IllegalStateException("illegal");
    }
}

