/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.util;

import com.adrninistrator.javacg.dto.counter.JavaCGCounter;
import com.adrninistrator.javacg.dto.jar.JarInfo;
import com.adrninistrator.javacg.util.JavaCGFileUtil;
import com.adrninistrator.javacg.util.JavaCGUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.lingala.zip4j.io.inputstream.ZipInputStream;
import net.lingala.zip4j.io.outputstream.ZipOutputStream;
import net.lingala.zip4j.model.LocalFileHeader;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaCGJarUtil {
    private static final Logger logger = LoggerFactory.getLogger(JavaCGJarUtil.class);

    private static Set<String> getMergeClassInJarPackageSet(Set<String> needHandlePackageSet) {
        if (JavaCGUtil.isCollectionEmpty(needHandlePackageSet)) {
            return new HashSet<String>();
        }
        HashSet<String> mergeClassInJarPackageSet = new HashSet<String>(needHandlePackageSet.size());
        for (String mergeClassInJarPackage : needHandlePackageSet) {
            String newMergeClassInJarPackage;
            if (StringUtils.isBlank((CharSequence)mergeClassInJarPackage) || (newMergeClassInJarPackage = mergeClassInJarPackage.replace(".", "/")).startsWith("/") && StringUtils.isBlank((CharSequence)(newMergeClassInJarPackage = newMergeClassInJarPackage.substring(1)))) continue;
            if (!newMergeClassInJarPackage.endsWith("/")) {
                newMergeClassInJarPackage = newMergeClassInJarPackage + "/";
            }
            logger.info("\u5408\u5e76jar/war\u5305\u4e2d\u7684class\u6587\u4ef6\u65f6\uff0c\u9700\u8981\u5408\u5e76\u7684\u5305\u540d: {}", (Object)newMergeClassInJarPackage);
            mergeClassInJarPackageSet.add(newMergeClassInJarPackage);
        }
        return mergeClassInJarPackageSet;
    }

    public static File handleJar(List<String> jarOrDirPathList, Map<String, JarInfo> jarInfoMap, Set<String> needHandlePackageSet, Set<String> jarDirMergeFileTypeSet) {
        JavaCGCounter jarNumCounter = new JavaCGCounter(1);
        if (jarOrDirPathList.size() == 1) {
            File oneFile = new File(jarOrDirPathList.get(0));
            String oneFilePath = JavaCGFileUtil.getCanonicalPath(oneFile);
            if (!oneFile.exists()) {
                logger.error("\u6307\u5b9a\u7684jar\u5305\u6216\u76ee\u5f55\u4e0d\u5b58\u5728: {}", (Object)oneFilePath);
                return null;
            }
            if (oneFile.isFile()) {
                String oneFileNameLower = oneFile.getName().toLowerCase(Locale.ROOT);
                if (!StringUtils.endsWithAny((CharSequence)oneFileNameLower, (CharSequence[])new CharSequence[]{".jar", ".war"})) {
                    logger.error("\u5904\u7406\u5355\u4e2a\u6587\u4ef6\u65f6\u53ea\u652f\u6301\u6307\u5b9a {} \u6216 {} \u683c\u5f0f\uff0c\u5047\u5982\u9700\u8981\u5904\u7406 {} \u683c\u5f0f\u7684\u6587\u4ef6\uff0c\u5219\u9700\u8981\u6307\u5b9a\u5176\u6240\u5728\u76ee\u5f55", new Object[]{".jar", ".war", ".class"});
                    return null;
                }
                jarInfoMap.put(oneFile.getName(), new JarInfo(jarNumCounter.addAndGet(), "J", oneFilePath));
                return oneFile;
            }
        }
        return JavaCGJarUtil.mergeJar(jarOrDirPathList, jarInfoMap, needHandlePackageSet, jarDirMergeFileTypeSet, jarNumCounter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File mergeJar(List<String> jarOrDirPathList, Map<String, JarInfo> jarInfoMap, Set<String> needHandlePackageSet, Set<String> jarDirMergeFileTypeSet, JavaCGCounter jarNumCounter) {
        List<File> jarFileOrDirList = JavaCGJarUtil.getJarFileOrDirList(jarOrDirPathList, jarInfoMap, jarNumCounter);
        if (jarFileOrDirList == null) {
            return null;
        }
        File newJarFile = JavaCGJarUtil.getNewJarFile(jarFileOrDirList.get(0), jarOrDirPathList.get(0));
        if (newJarFile.exists()) {
            if (newJarFile.isDirectory()) {
                logger.error("\u65b0\u7684jar\u5305\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u4f46\u662f\u662f\u76ee\u5f55: {}", (Object)JavaCGFileUtil.getCanonicalPath(newJarFile));
                return null;
            }
            if (!JavaCGFileUtil.deleteFile(newJarFile)) {
                logger.error("\u65b0\u7684jar\u5305\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u5220\u9664\u5931\u8d25: {}", (Object)JavaCGFileUtil.getCanonicalPath(newJarFile));
                return null;
            }
        }
        HashSet<String> destJarDirNameSet = new HashSet<String>(jarOrDirPathList.size());
        ArrayList<File> jarFileInDirList = new ArrayList<File>();
        Set<String> mergeClassInJarPackageSet = JavaCGJarUtil.getMergeClassInJarPackageSet(needHandlePackageSet);
        try (ZipOutputStream zos = new ZipOutputStream((OutputStream)new FileOutputStream(newJarFile));){
            for (File jarFileOrDir : jarFileOrDirList) {
                String jarFileOrDirName = jarFileOrDir.getName();
                if (destJarDirNameSet.contains(jarFileOrDirName)) {
                    logger.error("\u6307\u5b9a\u7684jar/war\u5305\u6216\u76ee\u5f55\u5b58\u5728\u540c\u540d\uff0c\u4e0d\u5904\u7406: {} {}", (Object)jarFileOrDirName, (Object)JavaCGFileUtil.getCanonicalPath(jarFileOrDir));
                    continue;
                }
                destJarDirNameSet.add(jarFileOrDirName);
                if (jarFileOrDir.isFile()) {
                    JavaCGJarUtil.addJar2Jar(jarFileOrDir, zos, mergeClassInJarPackageSet, jarDirMergeFileTypeSet);
                    continue;
                }
                JavaCGJarUtil.addDir2Jar(jarFileOrDir, jarFileInDirList, zos, jarDirMergeFileTypeSet);
            }
            for (File jarFileInDir : jarFileInDirList) {
                String jarFileName = jarFileInDir.getName();
                String jarCanonicalPath = JavaCGFileUtil.getCanonicalPath(jarFileInDir);
                jarInfoMap.putIfAbsent(jarFileName, new JarInfo(jarNumCounter.addAndGet(), "J", jarCanonicalPath));
                if (destJarDirNameSet.contains(jarFileName)) {
                    logger.error("\u6307\u5b9a\u7684jar\u5305\u6216\u76ee\u5f55\u5b58\u5728\u540c\u540d\uff0c\u4e0d\u5904\u7406: {} {}", (Object)jarFileName, (Object)jarCanonicalPath);
                    continue;
                }
                destJarDirNameSet.add(jarFileName);
                logger.info("\u6dfb\u52a0\u76ee\u5f55\u4e2d\u7684jar/war\u5305: {}", (Object)jarCanonicalPath);
                JavaCGJarUtil.addJar2Jar(jarFileInDir, zos, mergeClassInJarPackageSet, jarDirMergeFileTypeSet);
            }
            File file = newJarFile;
            return file;
        }
        catch (Exception e) {
            logger.error("error ", (Throwable)e);
            return null;
        }
    }

    private static List<File> getJarFileOrDirList(List<String> jarOrDirPathList, Map<String, JarInfo> jarInfoMap, JavaCGCounter jarNumCounter) {
        ArrayList<File> jarFileOrDirList = new ArrayList<File>(jarOrDirPathList.size());
        for (String currentJarOrDirPath : jarOrDirPathList) {
            File jarFileOrDir = new File(currentJarOrDirPath);
            String jarCanonicalPath = JavaCGFileUtil.getCanonicalPath(jarFileOrDir);
            if (!jarFileOrDir.exists() || jarCanonicalPath == null) {
                logger.error("\u6307\u5b9a\u7684jar\u5305\u6216\u76ee\u5f55\u4e0d\u5b58\u5728: {}", (Object)jarCanonicalPath);
                return null;
            }
            if (jarCanonicalPath.endsWith("-javacg_merged.jar")) {
                logger.info("\u8df3\u8fc7\u5408\u5e76\u4ea7\u751f\u7684jar\u5305: {}", (Object)jarCanonicalPath);
                continue;
            }
            jarFileOrDirList.add(jarFileOrDir);
            String jarOrDirType = jarFileOrDir.isFile() ? "J" : "D";
            jarInfoMap.putIfAbsent(jarFileOrDir.getName(), new JarInfo(jarNumCounter.addAndGet(), jarOrDirType, jarCanonicalPath));
        }
        return jarFileOrDirList;
    }

    private static File getNewJarFile(File firstJarFile, String firstJarPath) {
        if (firstJarFile.isFile()) {
            return new File(firstJarPath + "-javacg_merged.jar");
        }
        return new File(firstJarPath + File.separator + firstJarFile.getName() + "-javacg_merged.jar");
    }

    private static void addJar2Jar(File sourceJarFile, ZipOutputStream targetZos, Set<String> mergeClassInJarPackageSet, Set<String> jarDirMergeFileTypeSet) throws IOException {
        String sourceJarName = sourceJarFile.getName();
        try (ZipInputStream zipInputStream = new ZipInputStream((InputStream)new BufferedInputStream(new FileInputStream(sourceJarFile), 8192));){
            LocalFileHeader fileHeader;
            while ((fileHeader = zipInputStream.getNextEntry()) != null) {
                if (fileHeader.isDirectory()) continue;
                String jarEntryPath = fileHeader.getFileName();
                if (StringUtils.endsWithIgnoreCase((CharSequence)jarEntryPath, (CharSequence)".class")) {
                    if (JavaCGJarUtil.skipClassEntry(jarEntryPath, mergeClassInJarPackageSet)) {
                        continue;
                    }
                } else if (!JavaCGUtil.checkMergeFileType(jarEntryPath, jarDirMergeFileTypeSet)) {
                    logger.debug("\u5f53\u524d\u6587\u4ef6\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u4e0d\u5408\u5e76 {}", (Object)jarEntryPath);
                    continue;
                }
                ZipParameters zipParameters = new ZipParameters();
                zipParameters.setFileNameInZip(sourceJarName + "/" + jarEntryPath);
                targetZos.putNextEntry(zipParameters);
                JavaCGJarUtil.addInput2Jar((InputStream)zipInputStream, targetZos);
            }
        }
    }

    private static boolean skipClassEntry(String jarEntryPath, Set<String> mergeClassInJarPackageSet) {
        if (mergeClassInJarPackageSet.isEmpty()) {
            return false;
        }
        for (String mergeClassInJarPackage : mergeClassInJarPackageSet) {
            if (!jarEntryPath.startsWith(mergeClassInJarPackage) && !jarEntryPath.startsWith("WEB-INF/classes/" + mergeClassInJarPackage) && !jarEntryPath.startsWith("BOOT-INF/classes/" + mergeClassInJarPackage)) continue;
            logger.debug("\u5f53\u524dclass\u6587\u4ef6\u5305\u540d\u5339\u914d\uff0c\u9700\u8981\u5408\u5e76 {} {}", (Object)jarEntryPath, (Object)mergeClassInJarPackage);
            return false;
        }
        logger.debug("\u5f53\u524dclass\u6587\u4ef6\u5305\u540d\u6216\u7c7b\u540d\u4e0d\u5339\u914d\uff0c\u4e0d\u5408\u5e76 {}", (Object)jarEntryPath);
        return true;
    }

    private static void addDir2Jar(File sourceDirFile, List<File> jarFileInDirList, ZipOutputStream targetZos, Set<String> jarDirMergeFileTypeSet) throws IOException {
        ArrayList<File> nonJarFileList = new ArrayList<File>();
        ArrayList<String> nonJarFileRelativelyPathList = new ArrayList<String>();
        JavaCGJarUtil.findFileInSubDir(sourceDirFile, null, nonJarFileList, nonJarFileRelativelyPathList, jarFileInDirList);
        if (nonJarFileList.isEmpty()) {
            return;
        }
        for (int i = 0; i < nonJarFileList.size(); ++i) {
            String filePath = (String)nonJarFileRelativelyPathList.get(i);
            if (!StringUtils.endsWithIgnoreCase((CharSequence)filePath, (CharSequence)".class") && !JavaCGUtil.checkMergeFileType(filePath, jarDirMergeFileTypeSet)) {
                logger.debug("\u5f53\u524d\u6587\u4ef6\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u4e0d\u5408\u5e76 {}", (Object)filePath);
                continue;
            }
            ZipParameters zipParameters = new ZipParameters();
            zipParameters.setFileNameInZip(filePath);
            targetZos.putNextEntry(zipParameters);
            try (FileInputStream inputStream = new FileInputStream((File)nonJarFileList.get(i));){
                JavaCGJarUtil.addInput2Jar(inputStream, targetZos);
                continue;
            }
        }
    }

    private static void findFileInSubDir(File dirFile, String dirPath, List<File> nonJarFileList, List<String> fileRelativelyPathList, List<File> jarFileInDirList) {
        File[] files = dirFile.listFiles();
        if (files == null) {
            return;
        }
        String dirPathHeader = dirPath == null ? dirFile.getName() : dirPath + "/" + dirFile.getName();
        for (File file : files) {
            if (file.isDirectory()) {
                JavaCGJarUtil.findFileInSubDir(file, dirPathHeader, nonJarFileList, fileRelativelyPathList, jarFileInDirList);
                continue;
            }
            String currentFileName = file.getName();
            if (StringUtils.endsWithAny((CharSequence)currentFileName.toLowerCase(), (CharSequence[])new CharSequence[]{".jar", ".war"})) {
                if (currentFileName.endsWith("-javacg_merged.jar")) continue;
                jarFileInDirList.add(file);
                continue;
            }
            if (currentFileName.contains("-javacg_merged.jar")) continue;
            nonJarFileList.add(file);
            fileRelativelyPathList.add(dirPathHeader + "/" + currentFileName);
        }
    }

    private static void addInput2Jar(InputStream inputStream, ZipOutputStream targetZos) throws IOException {
        int len;
        byte[] data = new byte[8192];
        while ((len = inputStream.read(data)) > 0) {
            targetZos.write(data, 0, len);
        }
        targetZos.closeEntry();
    }

    public static String getJarEntryNameFromPath(String jarEntryPath) {
        return JavaCGUtil.getSubStringAfterLast(jarEntryPath, "/");
    }

    private JavaCGJarUtil() {
        throw new IllegalStateException("illegal");
    }
}

