/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.util;

import copy.javassist.bytecode.SignatureAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class JavaCGSignatureUtil {
    public static void parseTypeDefineGenericsType(SignatureAttribute.Type type, boolean outer, List<String> genericsTypeList) {
        if (!(type instanceof SignatureAttribute.ClassType)) {
            return;
        }
        SignatureAttribute.ClassType classType = (SignatureAttribute.ClassType)type;
        Object[] typeArguments = classType.getTypeArguments();
        if (ArrayUtils.isEmpty((Object[])typeArguments)) {
            if (outer) {
                return;
            }
            genericsTypeList.add(JavaCGSignatureUtil.getClassName(classType));
            return;
        }
        if (!outer) {
            genericsTypeList.add(JavaCGSignatureUtil.getClassName(classType));
        }
        for (Object typeArgument : typeArguments) {
            JavaCGSignatureUtil.parseTypeDefineGenericsType(((SignatureAttribute.TypeArgument)typeArgument).getType(), false, genericsTypeList);
        }
    }

    public static String getClassName(SignatureAttribute.ClassType classType) {
        if (!(classType instanceof SignatureAttribute.NestedClassType)) {
            return classType.getName();
        }
        ArrayList<String> classNameList = new ArrayList<String>();
        SignatureAttribute.ClassType currentClassType = classType;
        while (true) {
            classNameList.add(0, currentClassType.getName());
            if (!(currentClassType instanceof SignatureAttribute.NestedClassType)) break;
            currentClassType = currentClassType.getDeclaringClass();
        }
        return StringUtils.join(classNameList, (String)"$");
    }

    private JavaCGSignatureUtil() {
        throw new IllegalStateException("illegal");
    }
}

