/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaCGUtil {
    private static final Logger logger = LoggerFactory.getLogger(JavaCGUtil.class);
    private static volatile Boolean DEBUG_MODE;

    public static boolean isNumStr(String str) {
        char[] charArray;
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        for (char ch : charArray = str.toCharArray()) {
            if (ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    public static InputStream cacheInputStream(InputStream inputStream) {
        try {
            int size;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] data = new byte[8192];
            while ((size = inputStream.read(data)) != -1) {
                baos.write(data, 0, size);
            }
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (Exception e) {
            logger.error("\u51fa\u73b0\u5f02\u5e38 ", (Throwable)e);
            return null;
        }
    }

    public static boolean isStringEndWithArrayIgnoreCase(String data, String[] array) {
        if (data == null || array == null || array.length == 0) {
            return false;
        }
        for (String arrayStr : array) {
            if (!StringUtils.endsWithIgnoreCase((CharSequence)data, (CharSequence)arrayStr)) continue;
            return true;
        }
        return false;
    }

    public static String currentTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss.SSS");
        return sdf.format(new Date());
    }

    public static boolean checkSkipClass(String className, Set<String> needHandlePackageSet) {
        if (JavaCGUtil.isCollectionEmpty(needHandlePackageSet)) {
            return false;
        }
        for (String needHandlePackage : needHandlePackageSet) {
            if (!StringUtils.startsWith((CharSequence)className, (CharSequence)needHandlePackage)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkMergeFileType(String fileName, Set<String> jarDirMergeFileTypeSet) {
        String fileNameLower = fileName.toLowerCase();
        for (String jarDirMergeFileType : jarDirMergeFileTypeSet) {
            if (!fileNameLower.endsWith(jarDirMergeFileType)) continue;
            return true;
        }
        return false;
    }

    public static String addSeparator4FilePath(String filePath) {
        if (StringUtils.endsWithAny((CharSequence)filePath, (CharSequence[])new CharSequence[]{"/", "\\"})) {
            return filePath;
        }
        return filePath + File.separator;
    }

    public static String getDirPathInJvmOptions(String jvmOptionKey) {
        String dirPath = System.getProperty(jvmOptionKey);
        if (dirPath == null) {
            return "";
        }
        return JavaCGUtil.addSeparator4FilePath(dirPath);
    }

    public static String base64Encode(String data) {
        return Base64.getEncoder().encodeToString(data.getBytes(StandardCharsets.UTF_8));
    }

    public static String base64Decode(String data) {
        return new String(Base64.getDecoder().decode(data), StandardCharsets.UTF_8);
    }

    public static <T> boolean isCollectionEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isMapEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    @SafeVarargs
    public static <T> Set<T> genSetFromArray(T ... array) {
        HashSet<T> set = new HashSet<T>();
        if (!ArrayUtils.isEmpty((Object[])array)) {
            set.addAll(Arrays.asList(array));
        }
        return set;
    }

    @SafeVarargs
    public static <T> List<T> genListFromArray(T ... array) {
        ArrayList<T> list = new ArrayList<T>();
        if (!ArrayUtils.isEmpty((Object[])array)) {
            list.addAll(Arrays.asList(array));
        }
        return list;
    }

    public static String getSubStringAfterLast(String str, String flag) {
        int lastIndex = StringUtils.lastIndexOf((CharSequence)str, (CharSequence)flag);
        if (lastIndex == -1) {
            return str;
        }
        return str.substring(lastIndex + flag.length());
    }

    public static String genStringFromInteger(Integer i) {
        if (i == null) {
            return "";
        }
        return String.valueOf(i);
    }

    public static Integer genIntegerFromString(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        return Integer.valueOf(s);
    }

    public static boolean checkInDebugMode() {
        if (DEBUG_MODE != null) {
            return DEBUG_MODE;
        }
        for (String arg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            if (!arg.startsWith("-Xrunjdwp") && !arg.startsWith("-agentlib:jdwp")) continue;
            logger.info("\u5f53\u524d\u662f\u8c03\u8bd5\u6a21\u5f0f");
            DEBUG_MODE = Boolean.TRUE;
            return true;
        }
        logger.info("\u5f53\u524d\u4e0d\u662f\u8c03\u8bd5\u6a21\u5f0f");
        DEBUG_MODE = Boolean.FALSE;
        return false;
    }

    private JavaCGUtil() {
        throw new IllegalStateException("illegal");
    }
}

