/*
 * Decompiled with CFR 0.152.
 */
package com.smartnews.jpa_entity_generator;

import com.smartnews.jpa_entity_generator.CodeRenderer;
import com.smartnews.jpa_entity_generator.config.CodeGeneratorConfig;
import com.smartnews.jpa_entity_generator.metadata.Column;
import com.smartnews.jpa_entity_generator.metadata.Table;
import com.smartnews.jpa_entity_generator.metadata.TableMetadataFetcher;
import com.smartnews.jpa_entity_generator.rule.AdditionalCodePosition;
import com.smartnews.jpa_entity_generator.rule.Annotation;
import com.smartnews.jpa_entity_generator.rule.AnnotationAttribute;
import com.smartnews.jpa_entity_generator.rule.ClassAdditionalCommentRule;
import com.smartnews.jpa_entity_generator.rule.ClassAnnotationRule;
import com.smartnews.jpa_entity_generator.rule.FieldAdditionalCommentRule;
import com.smartnews.jpa_entity_generator.rule.FieldDefaultValueRule;
import com.smartnews.jpa_entity_generator.rule.FieldTypeRule;
import com.smartnews.jpa_entity_generator.rule.ImportRule;
import com.smartnews.jpa_entity_generator.rule.Interface;
import com.smartnews.jpa_entity_generator.rule.TableScanRule;
import com.smartnews.jpa_entity_generator.util.NameConverter;
import com.smartnews.jpa_entity_generator.util.TypeConverter;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeGenerator {
    private static final Logger log = LoggerFactory.getLogger(CodeGenerator.class);
    private static final List<String> EXPECTED_ID_ANNOTATION_CLASS_NAMES = Arrays.asList("Id", "javax.persistence.Id");
    private static final Predicate<CodeRenderer.RenderingData.Field> hasIdAnnotation = f -> {
        boolean isPrimaryKey = f.isPrimaryKey();
        boolean hasIdAnnotation = f.getAnnotations().stream().anyMatch(a -> EXPECTED_ID_ANNOTATION_CLASS_NAMES.contains(a.getClassName()));
        return isPrimaryKey || hasIdAnnotation;
    };

    public static void generateAll(CodeGeneratorConfig originalConfig) throws SQLException, IOException, TemplateException {
        CodeGenerator.generateAll(originalConfig, false);
    }

    public static void generateAll(CodeGeneratorConfig originalConfig, boolean isJpa1) throws SQLException, IOException, TemplateException {
        Path dir = Paths.get(originalConfig.getOutputDirectory() + "/" + (isJpa1 ? originalConfig.getPackageNameForJpa1().replaceAll("\\.", "/") : originalConfig.getPackageName().replaceAll("\\.", "/")), new String[0]);
        Files.createDirectories(Paths.get(dir.toFile().getCanonicalPath(), new String[0]), new FileAttribute[0]);
        TableMetadataFetcher metadataFetcher = new TableMetadataFetcher();
        metadataFetcher.setOriginalConfig(originalConfig);
        List<String> allTableNames = metadataFetcher.getTableNames(originalConfig.getJdbcSettings());
        List<String> tableNames = CodeGenerator.filterTableNames(originalConfig, allTableNames);
        for (String tableName : tableNames) {
            List<CodeRenderer.RenderingData.Field> primaryKeyFields;
            boolean shouldExclude = originalConfig.getTableExclusionRules().stream().anyMatch(rule -> rule.matches(tableName));
            if (shouldExclude) {
                log.debug("Skipped to generate entity for {}", (Object)tableName);
                continue;
            }
            CodeGeneratorConfig config = (CodeGeneratorConfig)SerializationUtils.clone((Serializable)originalConfig);
            Table table = metadataFetcher.getTable(config.getJdbcSettings(), tableName);
            CodeRenderer.RenderingData data = new CodeRenderer.RenderingData();
            data.setJpa1Compatible(isJpa1);
            data.setRequireJSR305(config.isJsr305AnnotationsRequired());
            if (isJpa1) {
                data.setPackageName(config.getPackageNameForJpa1());
            } else {
                data.setPackageName(config.getPackageName());
            }
            String className = NameConverter.toClassName(table.getName(), config.getClassNameRules());
            data.setClassName(className);
            data.setTableName(table.getName());
            ClassAnnotationRule entityClassAnnotationRule = new ClassAnnotationRule();
            Annotation entityAnnotation = Annotation.fromClassName("javax.persistence.Entity");
            if (!originalConfig.isHideEntityAnnotationName()) {
                AnnotationAttribute entityAnnotationValueAttr = new AnnotationAttribute();
                entityAnnotationValueAttr.setName("name");
                entityAnnotationValueAttr.setValue("\"" + data.getPackageName() + "." + data.getClassName() + "\"");
                entityAnnotation.getAttributes().add(entityAnnotationValueAttr);
            }
            entityClassAnnotationRule.setAnnotations(Arrays.asList(entityAnnotation));
            entityClassAnnotationRule.setClassName(className);
            config.getClassAnnotationRules().add(entityClassAnnotationRule);
            data.setClassComment(CodeGenerator.buildClassComment(className, table, config.getClassAdditionalCommentRules()));
            data.setImportRules(config.getImportRules().stream().filter(r -> r.matches(className)).collect(Collectors.toList()));
            ArrayList allFieldNameList = new ArrayList();
            List<CodeRenderer.RenderingData.Field> fields = table.getColumns().stream().map(c -> {
                CodeRenderer.RenderingData.Field f = new CodeRenderer.RenderingData.Field();
                String fieldName = NameConverter.toFieldName(c.getName());
                allFieldNameList.add(fieldName);
                f.setName(fieldName);
                f.setColumnName(c.getName());
                f.setNullable(c.isNullable());
                f.setComment(CodeGenerator.buildFieldComment(className, f.getName(), c, config.getFieldAdditionalCommentRules()));
                f.setAnnotations(config.getFieldAnnotationRules().stream().filter(rule -> rule.matches(className, f.getName())).flatMap(rule -> rule.getAnnotations().stream()).peek(a -> a.setClassName(CodeGenerator.collectAndConvertFQDN(a.getClassName(), data.getImportRules()))).collect(Collectors.toList()));
                Optional<FieldTypeRule> fieldTypeRule = CodeGenerator.orEmptyListIfNull(config.getFieldTypeRules()).stream().filter(b -> b.matches(className, fieldName)).findFirst();
                if (fieldTypeRule.isPresent()) {
                    f.setType(fieldTypeRule.get().getTypeName());
                    f.setPrimitive(CodeGenerator.isPrimitive(f.getType()));
                } else {
                    String javaType = TypeConverter.toJavaType(c.getTypeCode());
                    if (originalConfig.isModifyType()) {
                        javaType = TypeConverter.modifyJavaType(c.getTypeCode(), javaType);
                    }
                    if (javaType.contains(".")) {
                        ImportRule newImportRule;
                        List<ImportRule> importRules = data.getImportRules();
                        if (!importRules.contains(newImportRule = ImportRule.createGlobal(javaType))) {
                            importRules.add(newImportRule);
                        }
                        String simpleClassName = StringUtils.substringAfterLast((String)javaType, (String)".");
                        f.setType(simpleClassName);
                    } else {
                        f.setType(javaType);
                    }
                    if (!c.isNullable() && config.isUsePrimitiveForNonNullField()) {
                        f.setType(TypeConverter.toPrimitiveTypeIfPossible(f.getType()));
                    }
                    f.setPrimitive(CodeGenerator.isPrimitive(f.getType()));
                }
                f.setLength(c.getLength());
                f.setPrecision(c.getPrecision());
                f.setDigits(c.getDigits());
                Optional<FieldDefaultValueRule> fieldDefaultValueRule = CodeGenerator.orEmptyListIfNull(config.getFieldDefaultValueRules()).stream().filter(r -> r.matches(className, fieldName)).findFirst();
                if (fieldDefaultValueRule.isPresent()) {
                    f.setDefaultValue(fieldDefaultValueRule.get().getDefaultValue());
                }
                if (StringUtils.isNotEmpty((CharSequence)config.getGeneratedValueStrategy())) {
                    f.setGeneratedValueStrategy(config.getGeneratedValueStrategy());
                }
                f.setAutoIncrement(c.isAutoIncrement());
                f.setPrimaryKey(c.isPrimaryKey());
                return f;
            }).collect(Collectors.toList());
            if (fields.stream().noneMatch(hasIdAnnotation)) {
                throw new IllegalStateException("Entity class " + data.getClassName() + " has no @Id field!");
            }
            data.setFields(fields);
            data.setPrimaryKeyFields(fields.stream().filter(CodeRenderer.RenderingData.Field::isPrimaryKey).collect(Collectors.toList()));
            if (originalConfig.isAddAllFieldsNameLineInComment()) {
                String allFieldsName = StringUtils.join(allFieldNameList, (String)", ");
                data.setAllFieldsName(allFieldsName);
            }
            if ((primaryKeyFields = data.getPrimaryKeyFields()) != null && primaryKeyFields.size() > 1) {
                data.getImportRules().addAll(CodeGeneratorConfig.SERIALIZABLE_IMPORTS);
            }
            data.setInterfaceNames(CodeGenerator.orEmptyListIfNull(config.getInterfaceRules()).stream().filter(r -> r.matches(className)).peek(rule -> {
                for (Interface i : rule.getInterfaces()) {
                    i.setName(CodeGenerator.collectAndConvertFQDN(i.getName(), data.getImportRules()));
                    i.setGenericsClassNames(i.getGenericsClassNames().stream().map(cn -> CodeGenerator.collectAndConvertFQDN(cn, data.getImportRules())).collect(Collectors.toList()));
                }
            }).flatMap(r -> r.getInterfaces().stream().map(i -> {
                String genericsPart = i.getGenericsClassNames().size() > 0 ? i.getGenericsClassNames().stream().map(n -> n.equals("{className}") ? className : n).collect(Collectors.joining(", ", "<", ">")) : "";
                return i.getName() + genericsPart;
            })).collect(Collectors.toList()));
            data.setClassAnnotationRules(CodeGenerator.orEmptyListIfNull(config.getClassAnnotationRules()).stream().filter(r -> r.matches(className)).peek(rule -> rule.getAnnotations().forEach(a -> a.setClassName(CodeGenerator.collectAndConvertFQDN(a.getClassName(), data.getImportRules())))).collect(Collectors.toList()));
            CodeGenerator.orEmptyListIfNull(config.getAdditionalCodeRules()).forEach(rule -> {
                if (rule.matches(className)) {
                    String code = null;
                    if (isJpa1 && rule.getJpa1Code() != null) {
                        code = rule.getJpa1Code();
                    } else if (rule.getCode() != null) {
                        code = rule.getCode();
                    }
                    if (code != null) {
                        StringJoiner joiner = new StringJoiner("\n  ", "  ", "");
                        for (String line : code.split("\\n")) {
                            joiner.add(line);
                        }
                        String optimizedCode = joiner.toString();
                        if (rule.getPosition() == AdditionalCodePosition.Top) {
                            data.getTopAdditionalCodeList().add(optimizedCode);
                        } else {
                            data.getBottomAdditionalCodeList().add(optimizedCode);
                        }
                    }
                }
            });
            CodeGenerator.orEmptyListIfNull(data.getImportRules()).sort(Comparator.comparing(ImportRule::getImportValue));
            data.setIndexInfoList(table.getIndexInfoList());
            String code = CodeRenderer.render("entityGen/entity.ftl", data);
            String filepath = config.getOutputDirectory() + "/" + data.getPackageName().replaceAll("\\.", "/") + "/" + className + ".java";
            Path path = Paths.get(new File(filepath).getCanonicalPath(), new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            Files.write(path, code.getBytes(), new OpenOption[0]);
            log.debug("path: {}, code: {}", (Object)path, (Object)code);
            System.out.println("generate file: " + path.toFile().getCanonicalPath());
        }
    }

    private static List<String> filterTableNames(CodeGeneratorConfig config, List<String> allTableNames) {
        String tableScanMode = config.getTableScanMode();
        if (tableScanMode == null) {
            return allTableNames;
        }
        String normalizedTableScanMode = tableScanMode.trim().toLowerCase(Locale.ENGLISH);
        if (normalizedTableScanMode.equals("all")) {
            return allTableNames;
        }
        if (normalizedTableScanMode.equals("rulebased")) {
            ArrayList<String> filteredTableNames = new ArrayList<String>();
            for (String tableName : allTableNames) {
                boolean isScanTarget = true;
                for (TableScanRule rule : config.getTableScanRules()) {
                    if (rule.matches(tableName)) continue;
                    isScanTarget = false;
                    break;
                }
                if (!isScanTarget) continue;
                filteredTableNames.add(tableName);
            }
            return filteredTableNames;
        }
        throw new IllegalStateException("Invalid value (" + tableScanMode + ") is specified for tableScanName");
    }

    private static String buildClassComment(String className, Table table, List<ClassAdditionalCommentRule> rules) {
        List comment = table.getDescription().map(c -> Arrays.stream(c.split("\n")).filter(l -> l != null && !l.isEmpty()).collect(Collectors.toList())).orElse(Collections.emptyList());
        List additionalComments = rules.stream().filter(r -> r.matches(className)).map(ClassAdditionalCommentRule::getComment).flatMap(c -> Arrays.stream(c.split("\n"))).collect(Collectors.toList());
        comment.addAll(additionalComments);
        if (comment.size() > 0) {
            return comment.stream().collect(Collectors.joining("\n * ", "/**\n * ", "\n */"));
        }
        return null;
    }

    private static String buildFieldComment(String className, String fieldName, Column column, List<FieldAdditionalCommentRule> rules) {
        List comment = column.getDescription().map(c -> Arrays.stream(c.split("\n")).filter(l -> l != null && !l.isEmpty()).collect(Collectors.toList())).orElse(Collections.emptyList());
        List additionalComments = rules.stream().filter(r -> r.matches(className, fieldName)).map(FieldAdditionalCommentRule::getComment).flatMap(c -> Arrays.stream(c.split("\n"))).collect(Collectors.toList());
        comment.addAll(additionalComments);
        if (comment.size() > 0) {
            return comment.stream().collect(Collectors.joining("\n   * ", "  /**\n   * ", "\n   */"));
        }
        return null;
    }

    private static <T> List<T> orEmptyListIfNull(List<T> list) {
        return Optional.ofNullable(list).orElse(Collections.emptyList());
    }

    private static String collectAndConvertFQDN(String fqdn, List<ImportRule> imports) {
        if (fqdn != null && fqdn.contains(".") && fqdn.matches("^[a-zA-Z0-9.]+$")) {
            if (imports.stream().noneMatch(i -> i.importValueContains(fqdn))) {
                ImportRule rule = new ImportRule();
                rule.setImportValue(fqdn);
                imports.add(rule);
            }
            String[] elements = fqdn.split("\\.");
            return elements[elements.length - 1];
        }
        return fqdn;
    }

    private static boolean isPrimitive(String type) {
        if (type == null) {
            return false;
        }
        if (type.contains(".")) {
            return false;
        }
        return Character.isLowerCase(type.charAt(0));
    }
}

