/*
 * Decompiled with CFR 0.152.
 */
package com.smartnews.jpa_entity_generator.rule;

import com.smartnews.jpa_entity_generator.rule.ClassMatcher;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ImportRule
implements Serializable,
ClassMatcher {
    private String className;
    private List<String> classNames = new ArrayList<String>();
    private String importValue;

    public boolean importValueContains(String className) {
        if (this.importValue.startsWith("static")) {
            return false;
        }
        if (this.importValue.endsWith(".*")) {
            return className.replaceFirst("\\.[^\\.]+$", ".*").equals(this.importValue);
        }
        return className.equals(this.importValue);
    }

    public static ImportRule createGlobal(String importValue) {
        ImportRule rule = new ImportRule();
        rule.setImportValue(importValue);
        return rule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportRule that = (ImportRule)o;
        return this.importValue.equals(that.importValue);
    }

    public int hashCode() {
        return Objects.hash(this.importValue);
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public List<String> getClassNames() {
        return this.classNames;
    }

    public String getImportValue() {
        return this.importValue;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setClassNames(List<String> classNames) {
        this.classNames = classNames;
    }

    public void setImportValue(String importValue) {
        this.importValue = importValue;
    }

    public String toString() {
        return "ImportRule(className=" + this.getClassName() + ", classNames=" + this.getClassNames() + ", importValue=" + this.getImportValue() + ")";
    }
}

