/*
 * Decompiled with CFR 0.152.
 */
package com.smartnews.jpa_entity_generator.util;

import com.smartnews.jpa_entity_generator.util.ResourceReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeConverter {
    private static final Logger log = LoggerFactory.getLogger(TypeConverter.class);
    private static Properties modifyTypeProperties;
    private static final String MODIFY_TYPE_PROPERTIES_FILE = "entityGen/jpa_modify_type.properties";

    public static void init(String modifyTypePropertiesFile) {
        modifyTypeProperties = new Properties();
        if (StringUtils.isNotBlank((CharSequence)modifyTypePropertiesFile)) {
            try (FileInputStream inputStream = new FileInputStream(new File(modifyTypePropertiesFile));){
                modifyTypeProperties.load(inputStream);
            }
            catch (Exception e) {
                log.error("error1: ", (Throwable)e);
            }
            return;
        }
        try (InputStream inputStream = ResourceReader.getResourceAsStream(MODIFY_TYPE_PROPERTIES_FILE);){
            modifyTypeProperties.load(inputStream);
        }
        catch (Exception e) {
            log.error("error2: ", (Throwable)e);
        }
    }

    private TypeConverter() {
    }

    public static String toJavaType(int typeCode) {
        switch (typeCode) {
            case 2003: {
                return "Array";
            }
            case -5: {
                return "Long";
            }
            case -7: {
                return "boolean";
            }
            case 2004: {
                return "Blob";
            }
            case 16: {
                return "Boolean";
            }
            case 1: {
                return "String";
            }
            case 2005: {
                return "Clob";
            }
            case 91: {
                return "Date";
            }
            case 3: {
                return "java.math.BigDecimal";
            }
            case 8: {
                return "Double";
            }
            case 6: {
                return "Float";
            }
            case 4: {
                return "Integer";
            }
            case -1: {
                return "String";
            }
            case 2: {
                return "java.math.BigDecimal";
            }
            case 7: {
                return "Float";
            }
            case 2006: {
                return "Ref";
            }
            case 5: {
                return "Short";
            }
            case 2002: {
                return "Struct";
            }
            case 92: {
                return "Time";
            }
            case 2013: {
                return "Time";
            }
            case 93: {
                return "Timestamp";
            }
            case 2014: {
                return "Timestamp";
            }
            case -6: {
                return "Byte";
            }
            case 12: {
                return "String";
            }
        }
        return "String";
    }

    public static String modifyJavaType(int typeCode, String javaType) {
        String key = String.valueOf(typeCode);
        String value = modifyTypeProperties.getProperty(key);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return javaType;
    }

    public static String toPrimitiveTypeIfPossible(String type) {
        switch (type) {
            case "Byte": {
                return "byte";
            }
            case "Short": {
                return "short";
            }
            case "Integer": {
                return "int";
            }
            case "Long": {
                return "long";
            }
            case "Double": {
                return "double";
            }
            case "Float": {
                return "float";
            }
            case "Boolean": {
                return "boolean";
            }
        }
        return type;
    }
}

