/*
 * Decompiled with CFR 0.152.
 */
package com.github.afarion1.command_handler.command;

import com.github.afarion1.command_handler.command.CommandArguments;
import com.github.afarion1.command_handler.command.CommandHandler;
import com.github.afarion1.command_handler.command.config.CommandArgumentConfig;
import com.github.afarion1.command_handler.command.config.CommandConfig;
import com.github.afarion1.command_handler.command.config.CommandListType;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.internal.utils.PermissionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommand {
    public static final String argumentsSeparator = " ";
    private static final Logger log = LoggerFactory.getLogger(AbstractCommand.class);
    private CommandConfig config;
    private CommandHandler handler;

    protected AbstractCommand(CommandHandler handler) {
        this.handler = handler;
        this.config = handler.getCommandConfig(this.getClass());
        if (this.config == null) {
            throw new RuntimeException("Command's config wasn't found. The command must be not registered on provided CommandHandler");
        }
    }

    public final CommandConfig getConfig() {
        return this.config;
    }

    public final CommandHandler getHandler() {
        return this.handler;
    }

    public final String getName() {
        return this.config.getNameAndAliases().get(0);
    }

    public final String getDescription() {
        return this.config.getDescription();
    }

    public final String getVerboseDesc() {
        return this.config.getVerboseDesc();
    }

    public final CommandListType getListType() {
        return this.config.getListType();
    }

    public final List<String> getNameAndAliases() {
        return Collections.unmodifiableList(this.config.getNameAndAliases());
    }

    public final List<CommandArgumentConfig> getCommandArguments() {
        return this.config.getArguments();
    }

    public final String getCmdWithArgsSignature() {
        return this.config.getCommandArgumentsSignature();
    }

    public final boolean isRawArgs() {
        return this.config.isRawArgs();
    }

    public final String getRawArgsDesc() {
        return this.config.getRawArgsDesc();
    }

    public final String getRawArgsName() {
        return this.config.getRawArgsName();
    }

    public boolean isExecuteInGuildOnly(MessageReceivedEvent event) {
        return this.config.isExecuteInGuildOnly();
    }

    public boolean hasUserCooldown(MessageReceivedEvent event) {
        return this.getUserCooldown(event) != null && !this.getUserCooldown(event).equals(Duration.ZERO);
    }

    public boolean hasGuildCooldown(MessageReceivedEvent event) {
        return this.getGuildCooldown(event) != null && !this.getGuildCooldown(event).equals(Duration.ZERO);
    }

    public final boolean hasAnyCooldown(MessageReceivedEvent event) {
        return this.hasUserCooldown(event) || this.hasGuildCooldown(event);
    }

    public boolean shouldExecuteIfCantCheckOrSaveCooldown(MessageReceivedEvent event) {
        return this.config.shouldExecuteIfCantCheckOrSaveCooldown();
    }

    public Duration getUserCooldown(MessageReceivedEvent event) {
        return this.config.getUserCooldown();
    }

    public Duration getGuildCooldown(MessageReceivedEvent event) {
        return this.config.getGuildCooldown();
    }

    public List<Permission> getRequiredDiscordPerms(MessageReceivedEvent event) {
        return this.config.getDiscordPerms();
    }

    public int chooseArgumentSymbols(MessageReceivedEvent event, String strArgs, int argumentId) {
        return 0;
    }

    public abstract void execute(MessageReceivedEvent var1, CommandArguments var2);

    List<Permission> getUnsatisfiedPermissions(MessageReceivedEvent event) {
        return this.getRequiredDiscordPerms(event).stream().filter(perm -> !PermissionUtil.checkPermission((GuildChannel)event.getTextChannel(), (Member)event.getMember(), (Permission[])new Permission[]{perm})).collect(Collectors.toList());
    }
}

