/*
 * Decompiled with CFR 0.152.
 */
package com.github.afarion1.command_handler.command;

import it.unimi.dsi.fastutil.ints.Int2DoubleMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntList;

public final class CommandArguments {
    private final String rawArgs;
    private IntList wrongArgsIds = null;
    private Int2ObjectMap<String> strArgValues = null;
    private Int2DoubleMap doubleArgValues = null;
    private boolean rawOnly = false;

    CommandArguments(IntList wrongArgsIds, Int2ObjectMap<String> strArgValues, Int2DoubleMap doubleArgValues, String rawArgs) {
        this.wrongArgsIds = wrongArgsIds;
        this.strArgValues = strArgValues;
        this.doubleArgValues = doubleArgValues;
        this.rawArgs = rawArgs;
    }

    CommandArguments(String rawArgs) {
        this.rawArgs = rawArgs;
        this.rawOnly = true;
    }

    private void validateNotRawOnly() {
        if (this.rawOnly) {
            throw new IllegalStateException("The command is declared as raw args only");
        }
    }

    public String getStringArgumentValue(int argId) {
        this.validateNotRawOnly();
        return (String)this.strArgValues.get(argId);
    }

    public double getDoubleArgumentValue(int argId) {
        this.validateNotRawOnly();
        return this.doubleArgValues.get(argId);
    }

    public boolean isArgumentPresent(int argId) {
        this.validateNotRawOnly();
        return this.strArgValues.get(argId) != null;
    }

    boolean areValid() {
        if (this.wrongArgsIds == null) {
            return true;
        }
        return this.wrongArgsIds.isEmpty();
    }

    IntList getWrongArgsIds() {
        this.validateNotRawOnly();
        return this.wrongArgsIds;
    }

    public String getRawArgs() {
        return this.rawArgs;
    }
}

