/*
 * Decompiled with CFR 0.152.
 */
package com.github.afarion1.command_handler.command;

import com.github.afarion1.command_handler.command.AbstractCommand;
import com.github.afarion1.command_handler.command.CommandArguments;
import com.github.afarion1.command_handler.command.config.CommandArgumentConfig;
import it.unimi.dsi.fastutil.ints.Int2DoubleLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.function.DoublePredicate;
import java.util.function.Predicate;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CommandArgumentsFactory {
    private static final Logger log = LoggerFactory.getLogger(CommandArgumentsFactory.class);

    CommandArgumentsFactory() {
    }

    static CommandArguments processRawArguments(String strArgs) {
        return new CommandArguments(strArgs);
    }

    static CommandArguments processArguments(AbstractCommand command, String strArgs, MessageReceivedEvent event) {
        List<CommandArgumentConfig> argumentConfigs = command.getCommandArguments();
        Int2ObjectOpenHashMap strArgValues = new Int2ObjectOpenHashMap();
        Int2DoubleLinkedOpenHashMap doubleArgValues = new Int2DoubleLinkedOpenHashMap();
        IntArrayList wrongArgsIds = new IntArrayList();
        StringUtils.substringBefore((String)strArgs, (String)" ");
        for (CommandArgumentConfig argCfg : argumentConfigs) {
            log.trace("Validating argument {}", (Object)argCfg.getArgumentName());
            strArgs = strArgs.trim();
            if (strArgs.length() > 0) {
                if (!argCfg.isMultiWordChoosingEnabled() && !argCfg.isInQuotes()) {
                    String rawArg = StringUtils.substringBefore((String)strArgs, (String)" ");
                    strArgs = StringUtils.substringAfter((String)strArgs, (String)" ").trim();
                    strArgValues.put(argCfg.getId(), (Object)rawArg);
                    CommandArgumentsFactory.validateOptions((IntList)wrongArgsIds, rawArg, argCfg);
                    CommandArgumentsFactory.testStringValidators((IntList)wrongArgsIds, rawArg, argCfg);
                    if (!argCfg.isParseToDouble()) continue;
                    CommandArgumentsFactory.parseToDouble((Int2DoubleMap)doubleArgValues, (IntList)wrongArgsIds, rawArg, argCfg);
                    continue;
                }
                int symbolsTaken = CommandArgumentsFactory.processCustomChoosingArg((IntList)wrongArgsIds, (Int2ObjectMap<String>)strArgValues, strArgs, argCfg, event, command);
                if (symbolsTaken > 0) {
                    strArgs = strArgs.substring(symbolsTaken);
                    continue;
                }
                symbolsTaken = CommandArgumentsFactory.processQuotesArg((IntList)wrongArgsIds, (Int2ObjectMap<String>)strArgValues, strArgs, argCfg);
                if (symbolsTaken <= 0) continue;
                strArgs = symbolsTaken < strArgs.length() ? strArgs.substring(symbolsTaken) : "";
                continue;
            }
            if (!argCfg.isOptional()) {
                wrongArgsIds.add(argCfg.getId());
                log.debug("Argument {} has no value and isn't optional", (Object)argCfg.getArgumentName());
                continue;
            }
            CommandArgumentsFactory.setDefaultValues((Int2ObjectMap<String>)strArgValues, (Int2DoubleMap)doubleArgValues, argCfg);
        }
        return new CommandArguments((IntList)wrongArgsIds, (Int2ObjectMap<String>)strArgValues, (Int2DoubleMap)doubleArgValues, strArgs);
    }

    private static int processQuotesArg(IntList wrongArgsIds, Int2ObjectMap<String> strArgValues, String strArgs, CommandArgumentConfig argCfg) {
        if (argCfg.isInQuotes()) {
            int openingQuoteIndex = strArgs.indexOf(34);
            if (openingQuoteIndex > -1 && strArgs.length() > 1) {
                int closingQuoteIndex = strArgs.substring(openingQuoteIndex + 1).indexOf(34) + openingQuoteIndex + 1;
                if (closingQuoteIndex > openingQuoteIndex) {
                    String betweenQuotes = strArgs.substring(openingQuoteIndex + 1, closingQuoteIndex);
                    log.trace("Found multi-word in quotes argument {}: {}", (Object)argCfg.getArgumentName(), (Object)betweenQuotes);
                    CommandArgumentsFactory.testStringValidators(wrongArgsIds, betweenQuotes, argCfg);
                    strArgValues.put(argCfg.getId(), (Object)betweenQuotes);
                    return closingQuoteIndex + 1;
                }
                log.debug("Closing quote wasn't found in argument {}", (Object)argCfg.getArgumentName());
            } else {
                log.debug("Opening quote wasn't in argument {}", (Object)argCfg.getArgumentName());
            }
        }
        log.debug("Argument {} is marked as in-quotes argument, but quotes weren't found", (Object)argCfg.getArgumentName());
        wrongArgsIds.add(argCfg.getId());
        return 0;
    }

    private static int processCustomChoosingArg(IntList wrongArgsIds, Int2ObjectMap<String> strArgValues, String strArgs, CommandArgumentConfig argCfg, MessageReceivedEvent event, AbstractCommand cmd) {
        if (argCfg.isMultiWordChoosingEnabled()) {
            int id = argCfg.getId();
            int symbolsChosen = cmd.chooseArgumentSymbols(event, strArgs, id);
            if (symbolsChosen < 0) {
                symbolsChosen = 0;
            }
            if (symbolsChosen > 0) {
                String chosenStr = strArgs.substring(0, symbolsChosen);
                log.trace("Multi words chooser has chosen {} in argument {}", (Object)chosenStr, (Object)argCfg.getArgumentName());
                strArgValues.put(id, (Object)chosenStr);
            } else {
                log.debug("Multi word chooser didn't choose any words in argument {}", (Object)argCfg.getArgumentName());
                wrongArgsIds.add(id);
            }
            return symbolsChosen;
        }
        return 0;
    }

    private static void setDefaultValues(Int2ObjectMap<String> strArgValues, Int2DoubleMap doubleArgValues, CommandArgumentConfig argCfg) {
        int id = argCfg.getId();
        if (argCfg.isParseToDouble()) {
            log.trace("Argument {} has no value, setting default value {}", (Object)argCfg.getArgumentName(), (Object)argCfg.getDefaultDoubleValue());
            doubleArgValues.put(id, argCfg.getDefaultDoubleValue());
        } else {
            String defaultStringValue = argCfg.getDefaultStringValue();
            log.trace("Argument {} has no value, setting default value {}", (Object)argCfg.getArgumentName(), (Object)defaultStringValue);
            strArgValues.put(id, (Object)defaultStringValue);
        }
    }

    private static void parseToDouble(Int2DoubleMap doubleArgValues, IntList wrongArgsIds, String rawArg, CommandArgumentConfig argCfg) {
        try {
            double num = Double.parseDouble(rawArg);
            doubleArgValues.put(argCfg.getId(), num);
            log.trace("Parsed argument {} to double: {}", (Object)argCfg.getArgumentName(), (Object)num);
            CommandArgumentsFactory.testDoubleValidators(wrongArgsIds, argCfg, num);
        }
        catch (NumberFormatException e) {
            wrongArgsIds.add(argCfg.getId());
            log.debug("Unable to parse argument {} to double", (Object)argCfg.getArgumentName());
        }
    }

    private static void testDoubleValidators(IntList wrongArgsIds, CommandArgumentConfig argCfg, double num) {
        for (DoublePredicate predicate : argCfg.getDoubleValidators()) {
            if (predicate.test(num)) continue;
            wrongArgsIds.add(argCfg.getId());
            log.debug("Argument {} with value {} doesn't match it's double predicate", (Object)argCfg.getArgumentName(), (Object)num);
            break;
        }
    }

    private static void testStringValidators(IntList wrongArgsIds, String rawArg, CommandArgumentConfig argCfg) {
        if (argCfg.isInQuotes()) {
            return;
        }
        for (Predicate<String> predicate : argCfg.getStringValidators()) {
            if (predicate.test(rawArg)) continue;
            log.debug("Argument {} with value {} doesn't match it's string validator", (Object)argCfg.getArgumentName(), (Object)rawArg);
            wrongArgsIds.add(argCfg.getId());
            break;
        }
    }

    private static void validateOptions(IntList wrongArgsIds, String rawArg, CommandArgumentConfig argCfg) {
        boolean correctOption = argCfg.getArgumentOptions().isEmpty();
        for (String option : argCfg.getArgumentOptions()) {
            if (!option.toLowerCase().equals(rawArg.toLowerCase())) continue;
            correctOption = true;
            break;
        }
        if (!correctOption && !argCfg.isOptional()) {
            log.debug("Argument {} with value {} doesn't match it's options - {}", new Object[]{argCfg.getArgumentName(), rawArg, argCfg.getArgumentOptions()});
            wrongArgsIds.add(argCfg.getId());
        }
    }
}

