/*
 * Decompiled with CFR 0.152.
 */
package com.github.afarion1.command_handler.command;

import com.github.afarion1.command_handler.annotations.Command;
import com.github.afarion1.command_handler.annotations.Config;
import com.github.afarion1.command_handler.command.AbstractCommand;
import com.github.afarion1.command_handler.command.CommandArguments;
import com.github.afarion1.command_handler.command.CommandArgumentsFactory;
import com.github.afarion1.command_handler.command.CommandHandlerBuilder;
import com.github.afarion1.command_handler.command.Database;
import com.github.afarion1.command_handler.command.MessageListener;
import com.github.afarion1.command_handler.command.config.CommandArgumentConfig;
import com.github.afarion1.command_handler.command.config.CommandConfig;
import com.github.afarion1.command_handler.command.config.CommandListType;
import com.github.afarion1.command_handler.internal_commands.CmdCommandList;
import com.github.afarion1.command_handler.internal_commands.CmdInspectCommand;
import it.unimi.dsi.fastutil.ints.IntList;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.jetbrains.annotations.NotNull;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommandHandler {
    private static final Logger log = LoggerFactory.getLogger(CommandHandler.class);
    private final Map<Class<? extends AbstractCommand>, CommandConfig> commandConfigMap = new HashMap<Class<? extends AbstractCommand>, CommandConfig>();
    private final Map<Class<? extends AbstractCommand>, Function<CommandHandler, ? extends AbstractCommand>> commandSupplierMap = new HashMap<Class<? extends AbstractCommand>, Function<CommandHandler, ? extends AbstractCommand>>();
    private final Map<String, Class<? extends AbstractCommand>> commandAliasesMap = new HashMap<String, Class<? extends AbstractCommand>>();
    private final List<CommandConfig> visibleCommandConfigList = new ArrayList<CommandConfig>();
    private final JDA jda;
    private final ExecutorService executor;
    private final String commandsPrefix;
    private final Color helpColor;
    private final Color errorColor;
    private final Color inspectCommandColor;
    private final boolean enableCommandList;
    private final boolean enableInspectCommand;
    private final boolean cleanDbOnStartup;
    private boolean started = false;

    CommandHandler(CommandHandlerBuilder cfg) {
        this.jda = cfg.jda;
        this.executor = cfg.executor;
        this.commandsPrefix = cfg.commandsPrefix;
        this.helpColor = cfg.commandListColor;
        this.errorColor = cfg.errorColor;
        this.inspectCommandColor = cfg.inspectCommandColor;
        this.enableCommandList = cfg.enableCommandList;
        this.enableInspectCommand = cfg.enableInspectCommand;
        this.cleanDbOnStartup = cfg.cleanDbOnStartup;
    }

    public void start() {
        if (this.started) {
            throw new IllegalStateException("The handler has already started");
        }
        if (this.isCommandListEnabled()) {
            log.info("Command list is enabled, registering the command");
            this.registerCommand(CmdCommandList.class);
        } else {
            log.info("Command list is disabled");
        }
        if (this.isInspectCommandEnabled()) {
            log.info("Inspect command is enabled, registering the command");
            this.registerCommand(CmdInspectCommand.class);
        } else {
            log.info("Inspect command is disabled");
        }
        this.registerAnnotatedCommands();
        Database.init();
        if (this.cleanDbOnStartup) {
            Database.deleteOutdatedEntries(this);
        }
        this.jda.addEventListener(new Object[]{new MessageListener(this)});
        this.started = true;
    }

    public <T extends AbstractCommand> void registerCommand(@NotNull Class<T> aClass, Function<CommandHandler, T> function, CommandConfig config) {
        if (this.started) {
            throw new IllegalStateException("The handler has already started. Command registration is only available before the start.");
        }
        if (function == null) {
            if (config == null) {
                this.registerCommand(aClass);
            } else {
                this.registerCommand(aClass, config);
            }
            return;
        }
        if (config == null) {
            this.registerCommand(aClass, function);
            return;
        }
        this.commandConfigMap.put(aClass, config);
        this.commandSupplierMap.put(aClass, function);
        for (String alias : config.getNameAndAliases()) {
            this.commandAliasesMap.put(alias, aClass);
        }
        if (config.getListType().equals((Object)CommandListType.LISTED)) {
            this.visibleCommandConfigList.add(config);
        }
        log.trace("Registered command {}", (Object)config.getName());
    }

    public <T extends AbstractCommand> void registerCommand(Class<T> aClass, Function<CommandHandler, T> supplier) {
        CommandConfig config = this.getAnnotatedCommandConfig(aClass);
        this.registerCommand(aClass, supplier, config);
    }

    public <T extends AbstractCommand> void registerCommand(Class<T> aClass, CommandConfig config) {
        Function<CommandHandler, T> supplier = this.commandConstructorSupplier(aClass);
        this.registerCommand(aClass, supplier, config);
    }

    public <T extends AbstractCommand> void registerCommand(Class<T> aClass) {
        Function<CommandHandler, T> supplier = this.commandConstructorSupplier(aClass);
        CommandConfig config = this.getAnnotatedCommandConfig(aClass);
        this.registerCommand(aClass, supplier, config);
    }

    public List<CommandConfig> getVisibleCommandConfigList() {
        return Collections.unmodifiableList(this.visibleCommandConfigList);
    }

    public Set<String> getAllCommandNamesAndAliases() {
        return Collections.unmodifiableSet(this.commandAliasesMap.keySet());
    }

    public CommandConfig findCommandAndGetConfig(String name) {
        return this.commandConfigMap.get(this.commandAliasesMap.get(name));
    }

    public JDA getJda() {
        return this.jda;
    }

    public String getCommandsPrefix() {
        return this.commandsPrefix;
    }

    public Color getCommandListColor() {
        return this.helpColor;
    }

    public Color getErrorColor() {
        return this.errorColor;
    }

    public Color getInspectCommandColor() {
        return this.inspectCommandColor;
    }

    public boolean isCommandListEnabled() {
        return this.enableCommandList;
    }

    public boolean isInspectCommandEnabled() {
        return this.enableInspectCommand;
    }

    CommandConfig getCommandConfig(Class<? extends AbstractCommand> aClass) {
        return this.commandConfigMap.get(aClass);
    }

    Collection<CommandConfig> getCommandConfigList() {
        return Collections.unmodifiableCollection(this.commandConfigMap.values());
    }

    ExecutorService getExecutor() {
        return this.executor;
    }

    private void registerAnnotatedCommands() {
        Reflections refl = new Reflections("", new Scanner[0]);
        Set annotated = refl.getTypesAnnotatedWith(Command.class);
        List commands = annotated.stream().filter(t -> t.getSuperclass() == AbstractCommand.class).map(t -> t).collect(Collectors.toList());
        for (Class cmd : commands) {
            this.registerCommand(cmd);
        }
    }

    Class<? extends AbstractCommand> findCommand(String name) {
        return this.commandAliasesMap.get(name);
    }

    <T extends AbstractCommand> T newCommandInstance(Class<T> aClass) {
        if (aClass == null) {
            return null;
        }
        AbstractCommand instance = this.commandSupplierMap.get(aClass).apply(this);
        return (T)instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private CommandConfig getAnnotatedCommandConfig(Class<? extends AbstractCommand> aClass) {
        Object fieldContent;
        Method configMethod = null;
        for (Method declaredMethod : aClass.getDeclaredMethods()) {
            if (!declaredMethod.isAnnotationPresent(Config.class)) continue;
            configMethod = declaredMethod;
            break;
        }
        if (configMethod != null) {
            Object methodResult;
            try {
                configMethod.setAccessible(true);
                methodResult = configMethod.invoke((Object)this, (Object[])null);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Unable to get CommandConfig", e);
            }
            if (!(methodResult instanceof CommandConfig)) throw new IllegalArgumentException("Method annotated with @Config is expected to return CommandConfig, but returned " + methodResult);
            return (CommandConfig)methodResult;
        }
        Field configField = null;
        for (Field declaredField : aClass.getDeclaredFields()) {
            if (!declaredField.isAnnotationPresent(Config.class)) continue;
            configField = declaredField;
            break;
        }
        if (configField == null) {
            throw new RuntimeException("Couldn't find any config method/field. Please create a method/field thatwill contain/return CommandConfig.");
        }
        try {
            configField.setAccessible(true);
            fieldContent = configField.get(this);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to get CommandConfig", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Unable to get CommandConfig. The config MUST be provided using STATIC field or STATIC method. Alternatively it could be provided using  CommandHandler::registerCommand.", e);
        }
        if (!(fieldContent instanceof CommandConfig)) throw new IllegalArgumentException("Field annotated with @Config is expected to contain CommandConfig, but contains " + fieldContent);
        return (CommandConfig)fieldContent;
    }

    @NotNull
    private <T extends AbstractCommand> Function<CommandHandler, T> commandConstructorSupplier(Class<T> aClass) {
        return ch -> {
            try {
                return (AbstractCommand)aClass.getConstructor(CommandHandler.class).newInstance(ch);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create an instance of command. A command registered using @Command annotation MUST have a PUBLIC constructor with SINGLE PARAMETER of type CommandHandler. Or you can use CommandHandler::registerCommand method, providing a function that would supply instances of the command.", e);
            }
        };
    }

    void processCommand(MessageReceivedEvent event) {
        CommandArguments cmdArgs;
        AbstractCommand command;
        block21: {
            boolean shouldExecuteIfCantCheckOrSaveCooldown;
            block20: {
                long cooledDownAfter;
                block19: {
                    String commandString = event.getMessage().getContentRaw().substring(this.commandsPrefix.length()).trim();
                    if (commandString.length() < 1) {
                        log.trace("Nothing after prefix");
                        return;
                    }
                    log.trace("Finding cmd name in the message");
                    log.trace("All commands names and aliases: {}", this.getAllCommandNamesAndAliases());
                    Optional<String> commandName = this.getAllCommandNamesAndAliases().stream().map(String::toLowerCase).filter(name -> commandString.toLowerCase().indexOf((String)name) == 0).max(Comparator.comparingInt(String::length));
                    if (!commandName.isPresent()) {
                        log.debug("Couldn't find command with given name");
                        return;
                    }
                    String cmdNameFoundBy = commandName.get();
                    Class<? extends AbstractCommand> aClass = this.findCommand(cmdNameFoundBy);
                    command = this.newCommandInstance(aClass);
                    if (command == null) {
                        return;
                    }
                    log.trace("Found command {} by name {}", (Object)command.getName(), (Object)cmdNameFoundBy);
                    if (command.isExecuteInGuildOnly(event) && !event.isFromGuild()) {
                        log.trace("The command could be executed only in server chat, aborting");
                        event.getChannel().sendMessage((CharSequence)"This command could be executed only in server chat.").queue();
                        return;
                    }
                    shouldExecuteIfCantCheckOrSaveCooldown = command.shouldExecuteIfCantCheckOrSaveCooldown(event);
                    if (Database.noConnection() && command.hasAnyCooldown(event) && !shouldExecuteIfCantCheckOrSaveCooldown) {
                        log.debug("Unable to execute the command due to DB issues.");
                        event.getChannel().sendMessage((CharSequence)"Unable to execute the command due to DB issues").queue();
                        return;
                    }
                    String argumentString = commandString.substring(cmdNameFoundBy.length());
                    log.trace("Processing arguments");
                    cmdArgs = command.isRawArgs() ? CommandArgumentsFactory.processRawArguments(argumentString) : CommandArgumentsFactory.processArguments(command, argumentString, event);
                    if (!cmdArgs.areValid()) {
                        log.trace("Arguments are invalid");
                        this.sendErrorMessage(event, command, cmdArgs);
                        return;
                    }
                    log.trace("Arguments are valid");
                    List<Permission> unsatisfiedPermissions = command.getUnsatisfiedPermissions(event);
                    if (!unsatisfiedPermissions.isEmpty()) {
                        this.sendNotEnoughPermsMessage(event, unsatisfiedPermissions);
                        return;
                    }
                    log.trace("Enough discord permissions");
                    try {
                        if (command.hasUserCooldown(event)) {
                            cooledDownAfter = Database.getUserCooledDownDate(event.getAuthor().getIdLong(), command.getName());
                            if (System.currentTimeMillis() < cooledDownAfter) {
                                event.getChannel().sendMessage((CharSequence)("The command is on cooldown: " + DurationFormatUtils.formatDurationWords((long)(cooledDownAfter - System.currentTimeMillis()), (boolean)true, (boolean)true))).queue();
                                log.debug("{} is on per user cooldown.", (Object)command.getName());
                                return;
                            }
                        }
                    }
                    catch (SQLException e) {
                        this.handleCooldownSQLException(event, e);
                        if (shouldExecuteIfCantCheckOrSaveCooldown) break block19;
                        return;
                    }
                }
                try {
                    if (command.hasGuildCooldown(event)) {
                        cooledDownAfter = Database.getGuildCooledDownDate(event.getGuild().getIdLong(), command.getName());
                        if (System.currentTimeMillis() < cooledDownAfter) {
                            event.getChannel().sendMessage((CharSequence)("The command is on cooldown: " + DurationFormatUtils.formatDurationWords((long)(cooledDownAfter - System.currentTimeMillis()), (boolean)true, (boolean)true))).queue();
                            log.debug("{} is on per user cooldown.", (Object)command.getName());
                            return;
                        }
                    }
                }
                catch (SQLException e) {
                    this.handleCooldownSQLException(event, e);
                    if (shouldExecuteIfCantCheckOrSaveCooldown) break block20;
                    return;
                }
            }
            try {
                if (command.hasUserCooldown(event)) {
                    long cooledDownAfter = System.currentTimeMillis() + command.getUserCooldown(event).toMillis();
                    Database.saveCommandUserCooldown(event.getAuthor().getIdLong(), command.getName(), cooledDownAfter);
                }
                if (command.hasGuildCooldown(event)) {
                    long cooledDownAfter = System.currentTimeMillis() + command.getGuildCooldown(event).toMillis();
                    Database.saveCommandGuildCooldown(event.getGuild().getIdLong(), command.getName(), cooledDownAfter);
                }
            }
            catch (SQLException e) {
                this.handleCooldownSQLException(event, e);
                if (shouldExecuteIfCantCheckOrSaveCooldown) break block21;
                return;
            }
        }
        this.executeCommand(event, command, cmdArgs);
    }

    private void handleCooldownSQLException(MessageReceivedEvent event, SQLException e) {
        log.error("Error while managing command's cooldown.", (Throwable)e);
        event.getChannel().sendMessage((CharSequence)"Something went wrong while trying to manage cooldown of the command. Aborting execution.").queue();
    }

    private void sendNotEnoughPermsMessage(MessageReceivedEvent event, List<Permission> unsatisfiedPermissions) {
        StringBuilder sb = new StringBuilder();
        sb.append("You don't have ");
        sb.append(unsatisfiedPermissions.get(0).getName());
        for (int i = 1; i < unsatisfiedPermissions.size(); ++i) {
            sb.append(", ");
            sb.append(unsatisfiedPermissions.get(i).getName());
        }
        sb.append(" permission");
        if (unsatisfiedPermissions.size() > 1) {
            sb.append("s");
        }
        sb.append("in order to execute this command.");
        event.getChannel().sendMessage((CharSequence)sb.toString()).queue();
        log.debug("Not enough discord permissions: {}", unsatisfiedPermissions);
    }

    private void sendErrorMessage(MessageReceivedEvent event, AbstractCommand command, CommandArguments cmdArgs) {
        EmbedBuilder eb = new EmbedBuilder();
        eb.setTitle("Wrong command usage");
        eb.setColor(this.getErrorColor());
        eb.setDescription((CharSequence)(command.getCmdWithArgsSignature() + "\n\nWrong arguments:"));
        CommandHandler.appendWrongArgs(command, cmdArgs, eb);
        event.getChannel().sendMessage(eb.build()).queue();
    }

    private void executeCommand(MessageReceivedEvent event, AbstractCommand command, CommandArguments cmdArgs) {
        try {
            log.debug("Executing command {} sent by {} in channel id {}", new Object[]{command.getName(), event.getAuthor().getAsMention(), event.getChannel().getId()});
            command.execute(event, cmdArgs);
            log.debug("Finished execution of command {} sent by {} in channel id {}", new Object[]{command.getName(), event.getAuthor().getAsMention(), event.getChannel().getId()});
        }
        catch (Exception e) {
            log.error("Error while executing command", (Throwable)e);
            event.getChannel().sendMessage((CharSequence)"Something went wrong while executing the command").queue();
        }
    }

    private static void appendWrongArgs(AbstractCommand cmd, CommandArguments args, EmbedBuilder eb) {
        IntList wrongArgsIds = args.getWrongArgsIds();
        for (CommandArgumentConfig arg : cmd.getCommandArguments()) {
            if (!wrongArgsIds.contains(arg.getId())) continue;
            String fieldName = arg.getArgumentName().toLowerCase();
            String errorMsg = arg.getErrorMsg().length() > 0 ? arg.getErrorMsg() : arg.getArgumentDesc();
            eb.addField(fieldName, errorMsg, true);
        }
    }
}

